
//
// vid_vesa.h : VESA extra modes
//

#include "../doomtype.h"
#include "../screen.h"

// all bytes to avoid problems with compiler field packing
typedef struct vbeinfoblock_s {
     byte    VbeSignature[4];
     byte    VbeVersion[2];
     byte    OemStringPtr[4];
     byte    Capabilities[4];
     byte    VideoModePtr[4];
     byte    TotalMemory[2];
     byte    OemSoftwareRev[2];
     byte    OemVendorNamePtr[4];
     byte    OemProductNamePtr[4];
     byte    OemProductRevPtr[4];
     byte    Reserved[222];
     byte    OemData[256];
} vbeinfoblock_t;


// video modes list (not all vesa), video mode 0 is standard VGA320x200.
typedef struct vmode_s {
    struct vmode_s  *pnext;
    char	*name;
    //char	  *header;
    unsigned int width;
    unsigned int height;
    unsigned int rowbytes;	 //bytes per scanline
    //float	  aspect;
    int 	planar; 	//always 0 for vesa modes (1=x-mode)
    int 	numpages;
    void	*pextradata;	//vesa mode extra data
    int 	(*setmode)(viddef_t *lvid, struct vmode_s *pcurrentmode);
} vmode_t;


// setup standard VGA + VESA modes list, activate the default video mode.
void VID_Init (void);
// setup a video mode, this is to be called from the menu
int  VID_SetMode (int modenum);
