
//
// vid_vesa.c : extended vesa vbe2.0 video modes i/o.
//		(c)Denis F. somewhat inspired...
//

#include <stdlib.h>

#include "i_dos.h"
#include "../i_system.h"	//I_Error()
#include "vid_vesa.h"
#include "../doomdef.h" 	//MAXVIDWIDTH, MAXVIDHEIGHT
#include "../screen.h"

#include "../st_stuff.h"	//added:26-01-98:ST_HEIGHT for alloc
#include <dpmi.h>


// PROTOS
int  VID_VesaGetModeInfo (int modenum);
void VID_VesaGetExtraModes (void);
int  VID_VesaInitMode (viddef_t *lvid, vmode_t *pcurrentmode);


#define MODE_SUPPORTED_IN_HW	0x0001
#define COLOR_MODE		0x0008
#define GRAPHICS_MODE		0x0010
#define VGA_INCOMPATIBLE	0x0020
#define LINEAR_FRAME_BUFFER	0x0080
#define LINEAR_MODE		0x4000


#define MAX_VESA_MODES		30  // we'll just take the first 30 if there

typedef struct {
    //int	  pages[3];	  // either 2 or 3 is valid
    int 	vesamode;	  // vesa mode number plus LINEAR_MODE bit
    void	*plinearmem;	  // linear address of start of frame buffer
    //qboolean	  vga_incompatible;
} vesa_extra_t;
				    //	are more
static int totalvidmem;

static vmode_t	    vesa_modes[MAX_VESA_MODES] = {{NULL, NULL}};
static vesa_extra_t vesa_extra[MAX_VESA_MODES];

//this is the only supported non-vesa mode : standard 320x200x256c.
#define NUMVGAVIDMODES	1
int VGA_InitMode (viddef_t *lvid, vmode_t *pcurrentmode);
static vmode_t	    vgavidmodes[NUMVGAVIDMODES] = {
  {
    NULL,
    "320x200",
    320, 200, //(200.0/320.0)*(320.0/240.0),
    320, 0, 1,
    NULL,
    VGA_InitMode,
    //VGA_SwapBuffers,
    //VGA_SetPalette,
    //VGA_BeginDirectRect,
    //VGA_EndDirectRect
  }
};

static char	    names[MAX_VESA_MODES][10];

//----------------------------i_video.c------------------------------------
// these ones should go to i_video.c, but I prefer keep them away from the
// doom sources until the vesa stuff is ok.
   int	   numvidmodes;   //total number of video modes, vga, vesa1, vesa2.
   vmode_t *pvidmodes;	  //start of videomodes list.
   vmode_t *pcurrentmode; // the current active videomode.
   int	   vid_modenum;   // vidmode num indexes videomodes list
//----------------------------i_video.c------------------------------------



// table des modes videos.
// seul le mode 320x200x256c standard VGA est support sans le VESA.
// ce mode est le mode numro 0 dans la liste.

typedef struct
{
    int modenum;	    // vesa vbe2.0 modenum
    int mode_attributes;
    int winasegment;
    int winbsegment;
    int bytes_per_scanline; // bytes per logical scanline (+16)
    int win;		    // window number (A=0, B=1)
    int win_size;	    // window size (+6)
    int granularity;	    // how finely i can set the window in vid mem (+4)
    int width, height;	    // displayed width and height (+18, +20)
    int bits_per_pixel;     // er, better be 8, 15, 16, 24, or 32 (+25)
    int bytes_per_pixel;    // er, better be 1, 2, or 4
    int memory_model;	    // and better be 4 or 6, packed or direct color (+27)
    int num_pages;	    // number of complete frame buffer pages (+29)
    int red_width;	    // the # of bits in the red component (+31)
    int red_pos;	    // the bit position of the red component (+32)
    int green_width;	    // etc.. (+33)
    int green_pos;	    // (+34)
    int blue_width;	    // (+35)
    int blue_pos;	    // (+36)
    int pptr;
    int pagesize;
    int numpages;
} modeinfo_t;

static modeinfo_t modeinfo; // filled up by VID_VesaGetModeInfo()


/* ======================================================================== */
// Add the standard VGA video modes (only one now) to the video modes list.
/* ======================================================================== */
void VGA_Init(void)
{
    vgavidmodes[NUMVGAVIDMODES-1].pnext = pvidmodes;
    pvidmodes = &vgavidmodes[0];
    numvidmodes += NUMVGAVIDMODES;
}


//added:30-01-98: return number of video modes in pvidmodes list
int VID_NumModes(void)
{
    return numvidmodes;
}


//added:03-02-98: return a video mode number from the dimensions
int VID_GetModeForSize( int w, int h)
{
    vmode_t *pv;
    int modenum;

    pv = pvidmodes;
    for(modenum=0; pv!=NULL; pv=pv->pnext,modenum++ )
    {
	if( pv->width==w && pv->height==h )
	    return modenum;
    }

    return 0;
}


/* ======================================================================== */
//
/* ======================================================================== */
void	VID_Init (void)
{
    //vid_mode = 0;
    //vid_wait = 0;
    //vid_nopageflip = 0;
    //vid_default_mode = 0;

    //Cmd_AddCommand ("vid_testmode", VID_TestMode_f);
    //Cmd_AddCommand ("vid_nummodes", VID_NumModes_f);
    //Cmd_AddCommand ("vid_describecurrentmode", VID_DescribeCurrentMode_f);
    //Cmd_AddCommand ("vid_describemode", VID_DescribeMode_f);
    //Cmd_AddCommand ("vid_describemodes", VID_DescribeModes_f);

    //setup the videmodes list,
    // note that mode 0 must always be VGA mode 0x13
    pvidmodes = NULL;
    pcurrentmode = NULL;
    numvidmodes = 0;
    // setup the vesa_modes list
    PRERR("VID_VesaGetExtraModes...\n");
    VID_VesaGetExtraModes ();
    // add the vga modes at the start of the modes list
    PRERR("VGA_Init\n");
    VGA_Init();

    //vid_testingmode = 0;

    //added:03-02-98: initial video mode : from cmd-line else from default
    if (scr_forcex && scr_forcey)
	vid_modenum = VID_GetModeForSize(scr_forcex,scr_forcey);
    else
	vid_modenum = VID_GetModeForSize(scr_width,scr_height);

#ifdef DEBUG
    printf("VID_SetMode(%d)\n",vid_modenum);
#endif
    VID_SetMode (vid_modenum);	//, palette);


#ifdef DEBUG
    printf("after VID_SetMode\n");
    printf("vid.width	 %d\n",vid.width);
    printf("vid.height	 %d\n",vid.height);
    printf("vid.buffer	 %x\n",vid.buffer);
    printf("vid.rowbytes %d\n",vid.rowbytes);
    printf("vid.numpages %d\n",vid.numpages);
    printf("vid.recalc	 %d\n",vid.recalc);
    printf("vid.direct	 %x\n",vid.direct);
#endif

    //vid_realmode = vid_modenum;
    //vid_menudrawfn = VID_MenuDraw;
    //vid_menukeyfn = VID_MenuKey;
}


/* ======================================================================== */
// Returns a vmode_t from the video modes list, given a video mode number.
/* ======================================================================== */
vmode_t *VID_GetModePtr (int modenum)
{
    vmode_t *pv;

    pv = pvidmodes;
    if (!pv)
	I_Error ("VID_GetModePtr: empty vid mode list\n");

    while (modenum--)
    {
	pv = pv->pnext;
	if (!pv)
	    I_Error ("VID_GetModePtr: corrupt vid mode list\n");
    }

    return pv;
}


//added:30-01-98:return the name of a video mode
char *VID_GetModeName (int modenum)
{
    return (VID_GetModePtr(modenum))->name;
}


/* ======================================================================== */
// Sets a video mode
/* ======================================================================== */
int VID_SetMode (int modenum)  //, unsigned char *palette)
{
    int     stat;
    vmode_t *pnewmode, *poldmode;

    if ((modenum >= numvidmodes) || (modenum < 0))
    {
	if (pcurrentmode == NULL)
	{
	    modenum = 0;    // mode hasn't been set yet, so initialize to base
			    //	mode since they gave us an invalid initial mode
	}
	else
	{
	    //nomodecheck = true;
	    I_Error ("Unknown video mode: %d\n", modenum);
	    //nomodecheck = false;
	    return 0;
	}
    }

    pnewmode = VID_GetModePtr (modenum);

    if (pnewmode == pcurrentmode)
	return 1;   // already in the desired mode

// initialize the new mode
    poldmode = pcurrentmode;
    pcurrentmode = pnewmode;

    // initialize vidbuffer size for setmode
    vid.width = pcurrentmode->width;
    vid.height = pcurrentmode->height;
    //vid.aspect = pcurrentmode->aspect;
    vid.rowbytes = pcurrentmode->rowbytes;

    //debug
    //if (vid.rowbytes != vid.width)
    //	  I_Error("vidrowbytes (%d) <> vidwidth(%d)\n",vid.rowbytes,vid.width);

    stat = (*pcurrentmode->setmode) (&vid, pcurrentmode);

    if (stat < 1)
    {
	if (stat == 0)
	{
	// real, hard failure that requires resetting the mode
	    if (!VID_SetMode (vid_modenum))    // restore prior mode
		I_Error ("VID_SetMode: Unable to set any mode, probably "
			   "because there's not enough memory available");
	    I_Error("Failed to set mode %d\n", modenum);
	    return 0;
	}
	else if (stat == -1)
	{
	   I_Error("Not enough mem for VID_SetMode...\n");
	   // not enough memory; just put things back the way they were
	    pcurrentmode = poldmode;
	    vid.width = pcurrentmode->width;
	    vid.height = pcurrentmode->height;
	    //vid.aspect = pcurrentmode->aspect;
	    vid.rowbytes = pcurrentmode->rowbytes;
	    return 0;
	}
    }

    //(*pcurrentmode->setpalette) (&vid, pcurrentmode, palette);

    vid_modenum = modenum;

    //printf ("%s\n", VID_ModeInfo (vid_modenum, NULL));

    //added:20-01-98: recalc all tables and realloc buffers based on
    //		      vid values.
    PRERR("VID_Setmode done... recalc is 1.\n");
    vid.recalc = 1;

    return 1;
}



// converts a segm:offs 32bit pair to a 32bit flat ptr
void *VID_ExtraFarToLinear (void *ptr)
{
    int     temp;

    temp = (int)ptr;
    return real2ptr(((temp & 0xFFFF0000) >> 12) + (temp & 0xFFFF));
}


/* ======================================================================== */
/* ======================================================================== */
/*
void VID_SetVESAPalette (viddef_t *lvid, vmode_t *pcurrentmode,
    unsigned char *pal)
{
    int     i;
    byte    *pp;

    UNUSED(lvid);
    UNUSED(pcurrentmode);

    pp = ppal;

    for (i=0 ; i<256 ; i++)
    {
	pp[2] = pal[0] >> 2;
	pp[1] = pal[1] >> 2;
	pp[0] = pal[2] >> 2;
	pp += 4;
	pal += 3;
    }

    regs.x.ax = 0x4F09;
    regs.x.bx = 0;
    regs.x.cx = 256;
    regs.x.dx = 0;
    regs.x.es = ptr2real(ppal) >> 4;
    regs.x.di = ptr2real(ppal) & 0xf;
    dos_int86(0x10);

    if (regs.x.ax != 0x4f)
	Sys_Error ("Unable to load VESA palette\n");
}*/


/* ======================================================================== */
// Helper function for VID_VesaGetExtraModes
// In:	vesa mode number, from the vesa videomodenumbers list
// Out: false, if no info for given modenum
/* ======================================================================== */
int VID_VesaGetModeInfo(int modenum)
{
    char    *infobuf;
    int     numimagepages;
    int     ret=true;			 //added:20-01-98:return value

#ifdef DEBUG
 printf("VID_VesaGetModeInfo(%x)...\n",modenum);
#endif

    infobuf = dos_getmemory(256);

    regs.x.ax = 0x4f01;
    regs.x.cx = modenum;
    regs.x.es = ptr2real(infobuf) >> 4;
    regs.x.di = ptr2real(infobuf) & 0xf;
    dos_int86(0x10);
    if (regs.x.ax != 0x4f)
    {
	return false;
    }
    else
    {
	modeinfo.modenum = modenum;
	modeinfo.bits_per_pixel = *(char*)(infobuf+25);
	modeinfo.bytes_per_pixel = (modeinfo.bits_per_pixel+1)/8;
	modeinfo.width = *(short*)(infobuf+18);
	modeinfo.height = *(short*)(infobuf+20);

    // we do only 8-bpp in software
	if ((modeinfo.bits_per_pixel != 8) ||
	    (modeinfo.bytes_per_pixel != 1) ||
	    (modeinfo.width > MAXVIDWIDTH) ||
	    (modeinfo.height > MAXVIDHEIGHT))
	{
	    //added:20-01-98:shhh, mem was not freed.
	    ret = false;
	    goto freeandret;
	}

	modeinfo.mode_attributes = *(short*)infobuf;

    // we only want color graphics modes that are supported by the hardware
	if ((modeinfo.mode_attributes &
	     (MODE_SUPPORTED_IN_HW | COLOR_MODE | GRAPHICS_MODE)) !=
	    (MODE_SUPPORTED_IN_HW | COLOR_MODE | GRAPHICS_MODE))
	{
	    //added:20-01-98:shhh, mem was not freed.
	    ret = false;
	    goto freeandret;
	}

    // we only work with linear frame buffers, except for 320x200, which can
    // effectively be linear when banked at 0xA000
	if (!(modeinfo.mode_attributes & LINEAR_FRAME_BUFFER))
	{
	    if ((modeinfo.width != 320) || (modeinfo.height != 200))
	    {
		//added:20-01-98:shhh, mem was not freed.
		ret = false;
		goto freeandret;
	    }
	}

	modeinfo.bytes_per_scanline = *(short*)(infobuf+16);

	modeinfo.pagesize = modeinfo.bytes_per_scanline * modeinfo.height;

	if (modeinfo.pagesize > totalvidmem)
	{
	    //added:20-01-98:shhh, mem was not freed.
	    ret = false;
	    goto freeandret;
	}

    // force to one page if the adapter reports it doesn't support more pages
    // than that, no matter how much memory it has--it may not have hardware
    // support for page flipping
    //	  numimagepages = *(unsigned char *)(infobuf+29);

    //added:20-01-98:page flipping not supported for now,
    //		     I'll have to do this later...
    numimagepages = 1;

	if (numimagepages <= 0)
	{
	// wrong, but there seems to be an ATI VESA driver that reports 0
	    modeinfo.numpages = 1;
	}
	else if (numimagepages < 3)
	{
	    modeinfo.numpages = numimagepages;
	}
	else
	{
	    modeinfo.numpages = 3;
	}

	if (*(char*)(infobuf+2) & 5)
	{
	    modeinfo.winasegment = *(unsigned short*)(infobuf+8);
	    modeinfo.win = 0;
	}
	else if (*(char*)(infobuf+3) & 5)
	{
	    modeinfo.winbsegment = *(unsigned short*)(infobuf+8);
	    modeinfo.win = 1;
	}
	modeinfo.granularity = *(short*)(infobuf+4) * 1024;
	modeinfo.win_size = *(short*)(infobuf+6) * 1024;
	modeinfo.memory_model = *(unsigned char*)(infobuf+27);
	modeinfo.num_pages = *(char*)(infobuf+29) + 1;

	modeinfo.red_width = *(char*)(infobuf+31);
	modeinfo.red_pos = *(char*)(infobuf+32);
	modeinfo.green_width = *(char*)(infobuf+33);
	modeinfo.green_pos = *(char*)(infobuf+34);
	modeinfo.blue_width = *(char*)(infobuf+35);
	modeinfo.blue_pos = *(char*)(infobuf+36);

	modeinfo.pptr = *(long *)(infobuf+40);

#ifdef DEBUG
	printf("VID: (VESA) info for mode 0x%x\n", modeinfo.modenum);
	printf("  mode attrib = 0x%0x\n", modeinfo.mode_attributes);
	printf("  win a attrib = 0x%0x\n", *(unsigned char*)(infobuf+2));
	printf("  win b attrib = 0x%0x\n", *(unsigned char*)(infobuf+3));
	printf("  win a seg 0x%0x\n", (int) modeinfo.winasegment);
	printf("  win b seg 0x%0x\n", (int) modeinfo.winbsegment);
	printf("  bytes per scanline = %d\n",
		modeinfo.bytes_per_scanline);
	printf("  width = %d, height = %d\n", modeinfo.width,
		modeinfo.height);
	printf("  win = %c\n", 'A' + modeinfo.win);
	printf("  win granularity = %d\n", modeinfo.granularity);
	printf("  win size = %d\n", modeinfo.win_size);
	printf("  bits per pixel = %d\n", modeinfo.bits_per_pixel);
	printf("  bytes per pixel = %d\n", modeinfo.bytes_per_pixel);
	printf("  memory model = 0x%x\n", modeinfo.memory_model);
	printf("  num pages = %d\n", modeinfo.num_pages);
	printf("  red width = %d\n", modeinfo.red_width);
	printf("  red pos = %d\n", modeinfo.red_pos);
	printf("  green width = %d\n", modeinfo.green_width);
	printf("  green pos = %d\n", modeinfo.green_pos);
	printf("  blue width = %d\n", modeinfo.blue_width);
	printf("  blue pos = %d\n", modeinfo.blue_pos);
	printf("  phys mem = %x\n", modeinfo.pptr);
#endif
    }

freeandret:
    dos_freememory(infobuf);
    return ret;
}


/* ======================================================================== */
//
//
/* ======================================================================== */
void VID_VesaGetExtraModes (void)
{
    int 	    nummodes;
    short	    *pmodenums;
    vbeinfoblock_t  *pinfoblock;
    __dpmi_meminfo  phys_mem_info;

    pinfoblock = dos_getmemory(sizeof(vbeinfoblock_t));

    *(long *)pinfoblock->VbeSignature = ('V'<<24) + ('B'<<16) + ('E'<<8) + '2';

// see if VESA support is available
    regs.x.ax = 0x4f00;
    regs.x.es = ptr2real(pinfoblock) >> 4;
    regs.x.di = ptr2real(pinfoblock) & 0xf;
    dos_int86(0x10);

    if (regs.x.ax != 0x4f)
	return;     // no VESA support

    if (pinfoblock->VbeVersion[1] < 0x02)
	return;     // not VESA 2.0 or greater

    printf ("VESA 2.0 compliant adapter:\n%s\n",
	      (char *)VID_ExtraFarToLinear (*(byte **)&pinfoblock->OemStringPtr[0]) );

    totalvidmem = *(unsigned short *)&pinfoblock->TotalMemory[0] << 16;

    pmodenums = (short *)
	    VID_ExtraFarToLinear (*(byte **)&pinfoblock->VideoModePtr[0]);

// find 8 bit modes until we either run out of space or run out of modes
    nummodes = 0;

    while ((*pmodenums != -1) && (nummodes < MAX_VESA_MODES))
    {
	//fill the modeinfo struct.
	if (VID_VesaGetModeInfo (*pmodenums))
	{
	    vesa_modes[nummodes].pnext = &vesa_modes[nummodes+1];
	    if (modeinfo.width > 999)
	    {
		if (modeinfo.height > 999)
		{
		    sprintf (&names[nummodes][0], "%4dx%4d", modeinfo.width,
			     modeinfo.height);
		    names[nummodes][9] = 0;
		}
		else
		{
		    sprintf (&names[nummodes][0], "%4dx%3d", modeinfo.width,
			     modeinfo.height);
		    names[nummodes][8] = 0;
		}
	    }
	    else
	    {
		if (modeinfo.height > 999)
		{
		    sprintf (&names[nummodes][0], "%3dx%4d", modeinfo.width,
			     modeinfo.height);
		    names[nummodes][8] = 0;
		}
		else
		{
		    sprintf (&names[nummodes][0], "%3dx%3d", modeinfo.width,
			     modeinfo.height);
		    names[nummodes][7] = 0;
		}
	    }

	    vesa_modes[nummodes].name = &names[nummodes][0];
	    vesa_modes[nummodes].width = modeinfo.width;
	    vesa_modes[nummodes].height = modeinfo.height;
	    //added:20-01-98:aspect ratio to be implemented...
	    //vesa_modes[nummodes].aspect =
	    //	      ((float)modeinfo.height / (float)modeinfo.width) *
	    //	      (320.0 / 240.0);
	    vesa_modes[nummodes].rowbytes = modeinfo.bytes_per_scanline;
	    vesa_modes[nummodes].planar = 0;
	    vesa_modes[nummodes].pextradata = &vesa_extra[nummodes];
	    vesa_modes[nummodes].setmode = VID_VesaInitMode;
	    //vesa_modes[nummodes].swapbuffers = VID_ExtraSwapBuffers;
	    //vesa_modes[nummodes].setpalette = VID_SetVESAPalette;

	    if (modeinfo.mode_attributes & LINEAR_FRAME_BUFFER)
	    {
	    // add linear bit to mode for linear modes
		vesa_extra[nummodes].vesamode = modeinfo.modenum | LINEAR_MODE;
		//vesa_extra[nummodes].pages[0] = 0;
		//vesa_extra[nummodes].pages[1] = modeinfo.pagesize;
		//vesa_extra[nummodes].pages[2] = modeinfo.pagesize * 2;
		vesa_modes[nummodes].numpages = 1; //modeinfo.numpages;

		//vesa_modes[nummodes].begindirectrect = VGA_BeginDirectRect;
		//vesa_modes[nummodes].enddirectrect = VGA_EndDirectRect;

		phys_mem_info.address = (int)modeinfo.pptr;
		phys_mem_info.size = 0x400000;

		// returns -1 on error
		if (__dpmi_physical_address_mapping(&phys_mem_info))
		{
		    //skip this mode, it doesnt work
		    goto NextMode;
		}

		// if physical mapping was ok... convert the selector:offset
		vesa_extra[nummodes].plinearmem =
			 real2ptr (phys_mem_info.address);
	    }
	    else
	    {
	    // banked at 0xA0000
		vesa_extra[nummodes].vesamode = modeinfo.modenum;
		//vesa_extra[nummodes].pages[0] = 0;
		vesa_extra[nummodes].plinearmem =
			real2ptr(modeinfo.winasegment<<4);

		//vesa_modes[nummodes].begindirectrect =
		//	  VGA_BankedBeginDirectRect;
		//vesa_modes[nummodes].enddirectrect = VGA_BankedEndDirectRect;
		//vesa_extra[nummodes].pages[1] = modeinfo.pagesize;
		//vesa_extra[nummodes].pages[2] = modeinfo.pagesize * 2;
		vesa_modes[nummodes].numpages = 1; //modeinfo.numpages;
	    }

	    //vesa_extra[nummodes].vga_incompatible =
	    //	      modeinfo.mode_attributes & VGA_INCOMPATIBLE;

	    nummodes++;
	}
NextMode:
	pmodenums++;
    }

// add the VESA modes at the start of the mode list (if there are any)
    if (nummodes)
    {
	vesa_modes[nummodes-1].pnext = NULL; //pvidmodes;
	pvidmodes = &vesa_modes[0];
	numvidmodes += nummodes;
	//ppal = dos_getmemory(256*4);
    }

    dos_freememory(pinfoblock);
}


/* ======================================================================== */
/* ======================================================================== */
boolean VID_FreeAndAllocVidbuffer (viddef_t *lvid)
{
static byte* vidbuffer=NULL;

    int  vidbuffersize;

    //if (allocnewbuffer)
    //{
      // alloc an extra line in case we want to wrap, and allocate the z-buffer
	vidbuffersize = (lvid->width * lvid->height * NUMSCREENS)
		      + (lvid->width * ST_HEIGHT);  //status bar
	//+  (lvid->width * lvid->height * sizeof (*d_pzbuffer));
    //}
    //else
    //{
    //	// just allocate the z-buffer
    //	  tbuffersize = lvid->width * lvid->height * sizeof (*d_pzbuffer);
    //}

    // see if there's enough memory
    //if ((host_parms.memsize - tbuffersize + SURFCACHE_SIZE_AT_320X200 +
    //	   0x10000 * 3) < MINIMUM_MEMORY)
    //{
    //	  Con_Printf ("Not enough memory for video mode\n");
    //	 VGA_pcurmode = NULL;	 // so no further accesses to the buffer are
    //				  //  attempted, particularly when clearing
    //	  return false;       // not enough memory for mode
    //}

    //added:20-01-98:hmmm.. should be freed when exiting the program...
    if (vidbuffer!=NULL)
    {
	free(vidbuffer);
    }

    // allocate the new screen buffer
    if( (vidbuffer = (byte *) malloc(vidbuffersize))==NULL )
	return false;

    lvid->buffer = (void *)vidbuffer;
    //lvid->conbuffer = lvid->buffer;

#ifdef DEBUG
 printf("VID_FreeAndAllocVidbuffer done, vidbuffersize: %x\n",vidbuffersize);
#endif
    return true;
}


/* ======================================================================== */
// Set video mode routine for STANDARD VGA MODES
// Out: 1 ok,
//	0 hardware could not set mode,
//     -1 no mem
/* ======================================================================== */
int VGA_InitMode (viddef_t *lvid, vmode_t *pcurrentmode)
{
    if (!VID_FreeAndAllocVidbuffer (lvid))
       return -1;		   //no mem

    //added:26-01-98: should clear video mem here

    //set mode 0x13
    PRERR("About to change to mode 0x13...\n");
    regs.h.ah = 0;
    regs.h.al = 0x13;
    dos_int86(0x10);

    // here it is the standard VGA 64k window, not an LFB
    // (you could have 320x200x256c with LFB in the vesa modes)
    lvid->direct = (byte *)real2ptr(0xa0000);

    lvid->numpages = 1;

    return 1;
}


/* ======================================================================== */
// Set video mode routine for VESA video modes, see VID_SetMode()
// Out: 1 ok,
//	0 hardware could not set mode,
//     -1 no mem
/* ======================================================================== */
int VID_VesaInitMode (viddef_t *lvid, vmode_t *pcurrentmode)
{
    vesa_extra_t    *pextra;
    int 	    pageoffset;

    pextra = pcurrentmode->pextradata;

#ifdef DEBUG
 printf("VID_VesaInitMode...\n");
 printf(" pcurrentmode->name %s\n",pcurrentmode->name);
 printf("		width %d\n",pcurrentmode->width);
 printf("		height %d\n",pcurrentmode->height);
 printf("		rowbytes %d\n",pcurrentmode->rowbytes);
 printf("		planar %d\n",pcurrentmode->planar);
 printf("		numpages %d\n",pcurrentmode->numpages);
 printf(" pcurrentmode->pextradata :\n");
 printf("		 ->vesamode %x\n",pextra->vesamode);
 printf("		 ->plinearmem %x\n\n",pextra->plinearmem);
#endif

    //added:20-01-98:no page flipping now... TO DO!!!
    //if (vid_nopageflip.value)
	lvid->numpages = 1;
    //else
    //	  lvid->numpages = pcurrentmode->numpages;

    // clean up any old vid buffer lying around, alloc new if needed
    if (!VID_FreeAndAllocVidbuffer (lvid))
       return -1;		   //no mem

    // clear the screen and wait for the next frame
    //added:20-01-98: should clear video mem here


// set the mode
    regs.x.ax = 0x4f02;
    regs.x.bx = pextra->vesamode;
    dos_int86(0x10);

    if (regs.x.ax != 0x4f)
	return 0;		// could not set mode

    //VID_banked = !(pextra->vesamode & LINEAR_MODE);
    //VID_membase = pextra->plinearmem;
    //VGA_width = lvid->width;
    //VGA_height = lvid->height;
    //VGA_rowbytes = lvid->rowbytes;

    //lvid->colormap = host_colormap;

    //VID_pagelist = &pextra->pages[0];

//added:20-01-98: should setup wait_vsync flag, currentpage here...
//		  plus check for display_enable bit

//added:20-01-98: here we should set the page if page flipping...

    // points to LFB, or the start of VGA mem.
    lvid->direct = pextra->plinearmem;

    //lvid->conrowbytes = lvid->rowbytes;
    //lvid->conwidth = lvid->width;
    //lvid->conheight = lvid->height;

    return 1;
}
