#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "qmus2mid.h"

int4 TRACKBUFFERSIZE = 65536L ;  /* 64 Ko */

int fwritemem(void *p,int size,int number, char **file)
{
  memcpy(*file,p,size*number);
  *file+=size*number;
  return number;
}


size_t fwrite2(const int2 *ptr, size_t size, char **file)
{
  int4 rev = 0;
  int i;

  for( i = 0 ; i < size ; i++ )
    rev = (rev << 8) + (((*ptr) >> (i*8)) & 0xFF) ;

  return fwritemem( &rev, size, 1, file ) ;
}


void FreeTracks( struct Track track[] )
{
  int i ;

  for( i = 0 ; i < 16 ; i++ )
    if( track[i].data )
      free( track[i].data ) ;
}

char LittleEndian(void)
{
  short i = 0x0001;
  char *p = (char *) &i;
  return *p;
}


void TWriteByte( char MIDItrack, char byte, struct Track track[] )
{
  int4 pos ;

  pos = track[MIDItrack].current ;
  if( pos < TRACKBUFFERSIZE )
    track[MIDItrack].data[pos] = byte ;
  else
    {
      printf("ERROR : Track buffer full.\n"
	     "Increase the track buffer size (option -size).\n" ) ;
      FreeTracks( track ) ;
      exit( EXIT_FAILURE ) ;
    }
  track[MIDItrack].current++ ;
}


void TWriteVarLen( int tracknum, register int4 value,
		  struct Track track[] )
{
  register int4 buffer ;

  buffer = value & 0x7f ;
  while( (value >>= 7) )
    {
      buffer <<= 8 ;
      buffer |= 0x80 ;
      buffer += (value & 0x7f) ;
    }
  while( 1 )
    {
      TWriteByte( tracknum, buffer, track ) ;
      if( buffer & 0x80 )
	buffer >>= 8 ;
      else
	break;
    }
}

int WriteMIDheader( int2 ntrks, int2 division, char **file )
{
  fwritemem( MIDIMAGIC , 10, 1, file ) ;
  fwrite2( &ntrks, 2, file) ;
  fwrite2( &division, 2, file ) ;
  return 0 ;
}

	/* maybe for ms-dog too ? */ /* Yes, why not ?... */
#define last(e) 	((unsigned char)(e & 0x80))
#define event_type(e)	((unsigned char)((e & 0x7F) >> 4))
#define channel(e)	((unsigned char)(e & 0x0F))

void TWriteString( char tracknum, const char *string, int length,
		   struct Track track[] )
{
  register int i ;

  for( i = 0 ; i < length ; i++ )
    TWriteByte( tracknum, string[i], track ) ;
}


void WriteTrack( int tracknum, char **file, struct Track track[] )
{
  int2 size ;
  size_t quot, rem ;

  /* Do we risk overflow here ? */
  size = track[tracknum].current+4 ;
  fwritemem( "MTrk", 4, 1, file ) ;
  if( !tracknum ) size += 33 ;

  fwrite2( &size, 4, file ) ;
  if( !tracknum)
    fwritemem( TRACKMAGIC1 "Quick MUS->MID ! by S.Bacquet", 33, 1, file ) ;
  quot = (size_t) (track[tracknum].current / 4096) ;
  rem = (size_t) (track[tracknum].current - quot*4096) ;
  fwritemem( track[tracknum].data, 4096, quot, file ) ;
  fwritemem( ((const unsigned char *) track[tracknum].data)+4096*quot, rem,
			 1, file ) ;
  fwritemem( TRACKMAGIC2, 4, 1, file ) ;
}


void WriteFirstTrack( char **file )
{
  int2 size ;

  size = 43 ;
  fwritemem( "MTrk", 4, 1, file ) ;
  fwrite2( &size, 4, file ) ;
  fwritemem( TRACKMAGIC3 , 4, 1, file ) ;
  fwritemem( "QMUS2MID (C) S.Bacquet", 22, 1, file ) ;
  fwritemem( TRACKMAGIC4, 6, 1, file ) ;
  fwritemem( TRACKMAGIC5, 7, 1, file ) ;
  fwritemem( TRACKMAGIC6, 4, 1, file ) ;
}

int4 ReadTime( char **file )
{
  register int4 time = 0 ;
  int byte ;

  do
    {
      byte = *(*file)++;
      if( byte != EOF ) time = (time << 7) + (byte & 0x7F) ;
    } while( (byte != EOF) && (byte & 0x80) ) ;

  return time ;
}

char FirstChannelAvailable( signed char MUS2MIDchannel[] )
{
  int i ;
  signed char old15 = MUS2MIDchannel[15], max = -1 ;

  MUS2MIDchannel[15] = -1 ;
  for( i = 0 ; i < 16 ; i++ )
    if( MUS2MIDchannel[i] > max ) max = MUS2MIDchannel[i] ;
  MUS2MIDchannel[15] = old15 ;

  return (max == 8 ? 10 : max+1) ;
}


int qmus2mid( char *mus, char *mid, int nodisplay,
	     int2 division, int BufferSize, int nocomp,int lenght)
{
  struct Track track[16] ;
  int2 TrackCnt = 0 ;
  char *file_mus, *file_mid ; // pointer in memory
  unsigned char et, MUSchannel, MIDIchannel, MIDItrack, NewEvent ;
  int i, event, data, r ;
  static MUSheader *MUSh ;
  int4 DeltaTime, TotalTime = 0, time, min, n = 0 ;
  unsigned char MUS2MIDcontrol[15] = {
    0,				/* Program change - not a MIDI control change */
    0x00,			/* Bank select */
    0x01,			/* Modulation pot */
    0x07,			/* Volume */
    0x0A,			/* Pan pot */
    0x0B,			/* Expression pot */
    0x5B,			/* Reverb depth */
    0x5D,			/* Chorus depth */
    0x40,			/* Sustain pedal */
    0x43,			/* Soft pedal */
    0x78,			/* All sounds off */
    0x7B,			/* All notes off */
    0x7E,			/* Mono */
    0x7F,			/* Poly */
    0x79			/* Reset all controllers */
  }, MIDIchan2track[16] ;
  signed char MUS2MIDchannel[16] ;
  char ouch = 0, sec ;

  file_mus = mus;
  file_mid = mid;

//  r = ReadMUSheader( &MUSh, file_mus ) ;
  MUSh=(MUSheader *)mus;
  if( strncmp( MUSh->ID, MUSMAGIC, 4 ) )
    return NOTMUSFILE ;

//  fseek( file_mus, MUSh.ScoreStart, SEEK_SET );
  file_mus=&(mus[MUSh->ScoreStart]);


  if( MUSh->channels > 15 )	 /* <=> MUSchannels+drums > 16 */
      return TOOMCHAN ;

  for( i = 0 ; i < 16 ; i++ )
    {
      MUS2MIDchannel[i] = -1 ;
      track[i].current = 0 ;
      track[i].vel = 64 ;
      track[i].DeltaTime = 0 ;
      track[i].LastEvent = 0 ;
      track[i].data = NULL ;
    }
  if( BufferSize )
    {
      TRACKBUFFERSIZE = ((int4) BufferSize) << 10 ;
//	if( !nodisplay )
//	  printf( "Track buffer size set to %d KB.\n", BufferSize ) ;
    }

  event = *(file_mus++);
  et = event_type( event ) ;
  MUSchannel = channel( event ) ;
  while( (et != 6) && file_mus-mus<lenght/*!feof( file_mus )*/ && (event != EOF) )
    {
      if( MUS2MIDchannel[MUSchannel] == -1 )
	{
	  MIDIchannel = MUS2MIDchannel[MUSchannel ] =
	    (MUSchannel == 15 ? 9 : FirstChannelAvailable( MUS2MIDchannel)) ;
	  MIDItrack   = MIDIchan2track[MIDIchannel] = TrackCnt++ ;
	  if( !(track[MIDItrack].data = (char *) malloc( TRACKBUFFERSIZE )) )
	  {
	      FreeTracks( track ) ;
	      return MEMALLOC ;
	  }
	}
      else
	{
	  MIDIchannel = MUS2MIDchannel[MUSchannel] ;
	  MIDItrack   = MIDIchan2track [MIDIchannel] ;
	}
      TWriteVarLen( MIDItrack, track[MIDItrack].DeltaTime, track ) ;
      track[MIDItrack].DeltaTime = 0 ;
      switch( et )
	{
	case 0 :		/* release note */
	  NewEvent = 0x90 | MIDIchannel ;
	  if( (NewEvent != track[MIDItrack].LastEvent) || nocomp )
	    {
	      TWriteByte( MIDItrack, NewEvent, track ) ;
	      track[MIDItrack].LastEvent = NewEvent ;
	    }
	  else
	    n++ ;
	  data = *(file_mus++) ;
	  TWriteByte( MIDItrack, data, track ) ;
	  TWriteByte( MIDItrack, 0, track ) ;
	  break ;
	case 1 :
	  NewEvent = 0x90 | MIDIchannel ;
	  if( (NewEvent != track[MIDItrack].LastEvent) || nocomp )
	    {
	      TWriteByte( MIDItrack, NewEvent, track ) ;
	      track[MIDItrack].LastEvent = NewEvent ;
	    }
	  else
	    n++ ;
	  data = *(file_mus++);
	  TWriteByte( MIDItrack, data & 0x7F, track ) ;
	  if( data & 0x80 )
	    track[MIDItrack].vel = *(file_mus++) ;
	  TWriteByte( MIDItrack, track[MIDItrack].vel, track ) ;
	  break ;
	case 2 :
	  NewEvent = 0xE0 | MIDIchannel ;
	  if( (NewEvent != track[MIDItrack].LastEvent) || nocomp )
	    {
	      TWriteByte( MIDItrack, NewEvent, track ) ;
	      track[MIDItrack].LastEvent = NewEvent ;
	    }
	  else
	    n++ ;
	  data = *(file_mus++) ;
	  TWriteByte( MIDItrack, (data & 1) << 6, track ) ;
	  TWriteByte( MIDItrack, data >> 1, track ) ;
	  break ;
	case 3 :
	  NewEvent = 0xB0 | MIDIchannel ;
	  if( (NewEvent != track[MIDItrack].LastEvent) || nocomp )
	    {
	      TWriteByte( MIDItrack, NewEvent, track ) ;
	      track[MIDItrack].LastEvent = NewEvent ;
	    }
	  else
	    n++ ;
	  data = *(file_mus++) ;
	  TWriteByte( MIDItrack, MUS2MIDcontrol[data], track ) ;
	  if( data == 12 )
	    TWriteByte( MIDItrack, MUSh->channels+1, track ) ;
	  else
	    TWriteByte( MIDItrack, 0, track ) ;
	  break ;
	case 4 :
	  data = *(file_mus++);
	  if( data )
	    {
	      NewEvent = 0xB0 | MIDIchannel ;
	      if( (NewEvent != track[MIDItrack].LastEvent) || nocomp )
		{
		  TWriteByte( MIDItrack, NewEvent, track ) ;
		  track[MIDItrack].LastEvent = NewEvent ;
		}
	      else
		n++ ;
	      TWriteByte( MIDItrack, MUS2MIDcontrol[data], track ) ;
	    }
	  else
	    {
	      NewEvent = 0xC0 | MIDIchannel ;
	      if( (NewEvent != track[MIDItrack].LastEvent) || nocomp )
		{
		  TWriteByte( MIDItrack, NewEvent, track ) ;
		  track[MIDItrack].LastEvent = NewEvent ;
		}
	      else
		n++ ;
	    }
	  data = *(file_mus++);
	  TWriteByte( MIDItrack, data, track ) ;
	  break ;
	case 5 :
	case 7 :
	  FreeTracks( track ) ;
	  return MUSFILECOR ;
	default : break ;
	}
      if( last( event ) )
	{
	  DeltaTime = ReadTime( &file_mus ) ;
	  TotalTime += DeltaTime ;
	  for( i = 0 ; i < (int) TrackCnt ; i++ )
	    track[i].DeltaTime += DeltaTime ;
	}
      event = *(file_mus++);
      if( event != EOF )
		  {
	  et = event_type( event ) ;
	  MUSchannel = channel( event ) ;
	}
      else
	ouch = 1 ;
    }
//  if( ouch )
//    printf( "WARNING : There are bytes missing at the end of %s.\n	      "
//	     "The end of the MIDI file might not fit the original one.\n", mus ) ;
  if( !division )
    division = 89 ;

  WriteMIDheader( TrackCnt+1, division, &file_mid ) ;
  WriteFirstTrack( &file_mid ) ;
  for( i = 0 ; i < (int) TrackCnt ; i++ )
    WriteTrack( i, &file_mid, track ) ;

  FreeTracks( track ) ;

  return 0 ;
}


