// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log:$
//
// DESCRIPTION:
//
//-----------------------------------------------------------------------------
#ifdef PC_DOS

static const char
rcsid[] = "$Id: m_bbox.c,v 1.1 1997/02/03 22:45:10 b1 Exp $";

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <netinet/in.h>
#include <errno.h>
#include <unistd.h>

#include <go32.h>
#include <pc.h>
#include <dpmi.h>
#include <dos.h>
#include <sys/nearptr.h>


#include "../i_system.h"
#include "../d_event.h"
#include "../d_net.h"
#include "../m_argv.h"

#include "../doomstat.h"

#ifdef __GNUG__
#pragma implementation "../i_net.h"
#endif
#include "../i_net.h"

void	NetSend (void);
boolean NetListen (void);


//
// NETWORKING
//

int	DOOMPORT = 0x60;
extern	int usebroadcast; // declared and used in d_net.c
extern	int doomatic;	  // declared and used in d_net.c
//
// I_InitNetwork
//
void I_InitNetwork (void)
{
  int i,netgamepar,p;

  netgamepar = M_CheckParm ("-net");
  if(!netgamepar)
  {
    doomcom=malloc(sizeof(*doomcom));
    memset(doomcom,0,sizeof(*doomcom));
    netgame = false;
    doomcom->id = DOOMCOM_ID;
    doomcom->numplayers = doomcom->numnodes = 1;
    doomcom->deathmatch = false;
    doomcom->consoleplayer = 0;
    doomcom-> ticdup = 1;
    doomcom-> extratics = 0;
    return;
  } // else net game

  __djgpp_nearptr_enable();
  // set up for network
  doomcom=(doomcom_t *)(__djgpp_conventional_base+atoi(myargv[netgamepar+1]));
  printf("I_DosNet : Using int 0x%x for communication\n",doomcom->intnum);

  netgame = true;

  if(M_CheckParm("-doomatic"))
  {
      doomatic=1;
      // Boris says:
      //  broadcasting packet must be in a real netgame because sending
      //  a packet to itself must be run the special hack with rebound not
      //  run for broadcast
      usebroadcast=M_CheckParm("-usebroadcast");
  }
  else
  {
      doomatic=0;
      usebroadcast=0;
  }

  i = M_CheckParm ("-dup");
  if (i && i< myargc-1)
  {
    doomcom->ticdup = myargv[i+1][0]-'0';
    if (doomcom->ticdup < 1)
	doomcom->ticdup = 1;
    if (doomcom->ticdup > 9)
	doomcom->ticdup = 9;
  }
  else
    doomcom-> ticdup = 1;

  if (M_CheckParm ("-extratic"))
    doomcom-> extratics = 1;
  else
    doomcom-> extratics = 0;

  p = M_CheckParm ("-port");
  if (p && p<myargc-1)
  {
      DOOMPORT = atoi (myargv[p+1]);
      printf ("using alternate port %i\n",DOOMPORT);
  }
}


void I_NetCmd (void)
{

    __dpmi_regs r;
    __dpmi_int(doomcom->intnum,&r);
}

#endif