
//
// i_dos.c : dos i/o
//

#include <sys/segments.h>
#include <go32.h>
#include <unistd.h>
#include <sys/nearptr.h>
#include <dos.h>
#include <string.h>
#include <dpmi.h>
#include <bios.h>

#include "i_dos.h"

// globals
regs_t regs;

static unsigned conventional_memory = -1;

__dpmi_regs callback_regs;

void map_in_conventional_memory(void)
{
    if (conventional_memory == -1)
    {
	if (__djgpp_nearptr_enable())
	{
	    conventional_memory = __djgpp_conventional_base;
	}
    }
}

// Converts a flat 32 bit ptr to a realmode 0x12345 type ptr (seg<<4 + offs)
unsigned int ptr2real(void *ptr)
{
    map_in_conventional_memory();
    return (int)ptr - conventional_memory;
}

// Converts 0x12345 (seg<<4+offs) realmode ptr to a flat 32bit ptr
void *real2ptr(unsigned int real)
{
    map_in_conventional_memory();
    return (void *) (real + conventional_memory);
}

void *far2ptr(unsigned int farptr)
{
    return real2ptr(((farptr & ~0xffff) >>12) + (farptr&0xffff));
}

unsigned int ptr2far(void *ptr)
{
    return ((ptr2real(ptr)&~0xf) << 12) + (ptr2real(ptr) & 0xf);
}

//
// Returns 0 on success
//

int dos_int86(int vec)
{
    int rc;
    regs.x.ss = regs.x.sp = 0;
    rc = _go32_dpmi_simulate_int(vec, (_go32_dpmi_registers *) &regs);
    return rc || (regs.x.flags & 1);
}

//int dos_int386(int vec, regs_t *inregs, regs_t *outregs)
//{
//    int rc;
//   memcpy(outregs, inregs, sizeof(regs_t));
//    outregs->x.ss = outregs->x.sp = 0;
//    rc = _go32_dpmi_simulate_int(vec, (_go32_dpmi_registers *) outregs);
//    return rc || (outregs->x.flags & 1);
//}

//
// Because of a quirk in dj's alloc-dos-memory wrapper, you need to keep
// the seginfo structure around for when you free the mem.
//

static _go32_dpmi_seginfo seginfo[10];

//---------------------------------- from <dpmi.h>
//typedef struct {
//  unsigned long size;
//  unsigned long pm_offset;
//  unsigned short pm_selector;
//  unsigned short rm_offset;
//  unsigned short rm_segment;
//} _go32_dpmi_seginfo;
//----------------------------------

//
// Allocate a part of the conventional memory area (the first 640k).
//
void *dos_getmemory(int size)
{

    int rc;
    _go32_dpmi_seginfo info;
    static int firsttime=1;
    int i;

    if (firsttime)
    {
	memset(seginfo, 0, sizeof(seginfo));
	firsttime = 0;
    }

    // set the size field to the number of paragraphs
    info.size = (size+15) / 16;
    rc = _go32_dpmi_allocate_dos_memory(&info);

    // on error, the size field contains the largest available size.
    if (rc)
	return 0;

    // the rm_segment field contain the segment of the allocated memory

    for (i=0;i<10;i++)
	if (!seginfo[i].rm_segment) break;
    seginfo[i] = info;
    return real2ptr((int) info.rm_segment << 4);

}

void dos_freememory(void *ptr)
{

    int i;
    int segment;

    segment = ptr2real(ptr) >> 4;
    for (i=0 ; i<10 ; i++)
	if (seginfo[i].rm_segment == segment)
	{
	    _go32_dpmi_free_dos_memory(&seginfo[i]);
	    seginfo[i].rm_segment = 0;
	    break;
	}

}

int dos_lockmem(void *addr, int size)
{
    __dpmi_meminfo info;
    info.address = (long) addr + __djgpp_base_address;
    info.size = size;
    if (__dpmi_lock_linear_region(&info))
	return __dpmi_error;
    else
	return 0;
}

int dos_unlockmem(void *addr, int size)
{
    __dpmi_meminfo info;
    info.address = (long) addr + __djgpp_base_address;
    info.size = size;
    if (__dpmi_unlock_linear_region(&info))
	return __dpmi_error;
    else
	return 0;
}
