//-----------------------------------------------------------------------------
//
// Write by Boris Pereira.
//
//
// DESCRIPTION:
//     Load dehacked file and change table and text from the exe
//
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#ifdef PC_DOS
#include <conio.h>
#endif

#include "doomdef.h"
#include "doomstat.h"
#include "sounds.h"
#include "info.h"
#include "m_cheat.h"

/* ======================================================================== */
// Load a dehacked file format 6 I (BP) don't know other format
/* ======================================================================== */
/* a sample for see
		   Thing 1 (Player)	  {	      // MT_PLAYER
int doomednum;	   ID # = 3232		    -1, 	    // doomednum
int spawnstate;    Initial frame = 32	    S_PLAY,	    // spawnstate
int spawnhealth;   Hit points = 3232	    100,	    // spawnhealth
int seestate;	   First moving frame = 32  S_PLAY_RUN1,	    // seestate
int seesound;	   Alert sound = 32	    sfx_None,		    // seesound
int reactiontime;  Reaction time = 3232     0,		    // reactiontime
int attacksound;   Attack sound = 32	    sfx_None,		    // attacksound
int painstate;	   Injury frame = 32	    S_PLAY_PAIN,	    // painstate
int painchance;     Pain chance = 3232	    255,	    // painchance
int painsound;	    Pain sound = 32	    sfx_plpain, 	    // painsound
int meleestate;    Close attack frame = 32  S_NULL,	    // meleestate
int missilestate;  Far attack frame = 32    S_PLAY_ATK1,	    // missilestate
int deathstate;     Death frame = 32	    S_PLAY_DIE1,	    // deathstate
int xdeathstate;   Exploding frame = 32     S_PLAY_XDIE1,	    // xdeathstate
int deathsound;     Death sound = 32	    sfx_pldeth, 	    // deathsound
int speed;	   Speed = 3232 	    0,		    // speed
int radius;	   Width = 211812352	    16*FRACUNIT,	    // radius
int height;	   Height = 211812352	    56*FRACUNIT,	    // height
int mass;	   Mass = 3232		    100,	    // mass
int damage;	   Missile damage = 3232    0,		    // damage
int activesound;   Action sound = 32	    sfx_None,		    // activesound
int flags;	   Bits = 3232		    MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH,
int raisestate;    Respawn frame = 32	    S_NULL	    // raisestate
					 }, */

int searchvalue(char *s)
{
  while(s[0]!='=' && s[0]!='\0') s++;
  if (s[0]=='=')
    return atoi(&s[1]);
  else
    return 0;
}

void readthing(FILE *f,int num)
{
  char s[200];
  char *word;
  int value;

  do{
    if(fgets(s,sizeof(s),f)!=NULL)
    {
      value=searchvalue(s);
      // set the value in apropriet field
      word=strtok(s," ");
	   if(!strcmp(word,"ID"))	    mobjinfo[num].doomednum   =value;
      else if(!strcmp(word,"Initial"))	    mobjinfo[num].spawnstate  =value;
      else if(!strcmp(word,"Hit"))	    mobjinfo[num].spawnhealth =value;
      else if(!strcmp(word,"First"))	    mobjinfo[num].seestate    =value;
      else if(!strcmp(word,"Alert"))	    mobjinfo[num].seesound    =value;
      else if(!strcmp(word,"Reaction"))     mobjinfo[num].reactiontime=value;
      else if(!strcmp(word,"Attack"))	    mobjinfo[num].attacksound =value;
      else if(!strcmp(word,"Injury"))	    mobjinfo[num].painstate   =value;
      else if(!strcmp(word,"Pain"))
	   {
	     word=strtok(NULL," ");
	     if(!strcmp(word,"chance"))     mobjinfo[num].painchance  =value;
	     else if(!strcmp(word,"sound")) mobjinfo[num].painsound   =value;
	   }
      else if(!strcmp(word,"Close"))	    mobjinfo[num].meleestate  =value;
      else if(!strcmp(word,"Far"))	    mobjinfo[num].missilestate=value;
      else if(!strcmp(word,"Death"))
	   {
	     word=strtok(NULL," ");
	     if(!strcmp(word,"frame"))	    mobjinfo[num].deathstate  =value;
	     else if(!strcmp(word,"sound")) mobjinfo[num].deathsound  =value;
	   }
      else if(!strcmp(word,"Exploding"))    mobjinfo[num].xdeathstate =value;
      else if(!strcmp(word,"Speed"))	    mobjinfo[num].speed       =value;
      else if(!strcmp(word,"Width"))	    mobjinfo[num].radius      =value;
      else if(!strcmp(word,"Height"))	    mobjinfo[num].height      =value;
      else if(!strcmp(word,"Mass"))	    mobjinfo[num].mass	      =value;
      else if(!strcmp(word,"Missile"))	    mobjinfo[num].damage      =value;
      else if(!strcmp(word,"Action"))	    mobjinfo[num].activesound =value;
      else if(!strcmp(word,"Bits"))	    mobjinfo[num].flags       =value;
      else if(!strcmp(word,"Respawn"))	    mobjinfo[num].raisestate  =value;
    }
  } while(s[0]!='\n' && !feof(f)); //finish when the line is empty
}
/*
Sprite number = 10
Sprite subnumber = 32968
Duration = 200
Next frame = 200
*/
void readframe(FILE* f,int num)
{
  char s[200];
  char *word1,*word2,*charvalue;
  int value;
  do{
    if(fgets(s,sizeof(s),f)!=NULL)
    {
      value=searchvalue(s);
      // set the value in apropriet field
      word1=strtok(s," ");
      word2=strtok(NULL," ");

      if(!strcmp(word1,"Sprite"))
      {
	     if(!strcmp(word2,"number"))     states[num].sprite   =value;
	else if(!strcmp(word2,"subnumber"))  states[num].frame	  =value;
      }
      else if(!strcmp(word1,"Duration"))     states[num].tics	  =value;
      else if(!strcmp(word1,"Next"))	     states[num].nextstate=value;
    }
  } while(s[0]!='\n' && !feof(f));
}

char *first_sound_name;

void readsound(FILE* f,int num)
{
  char s[200];
  char *word;
  int value;

  do{
    if(fgets(s,sizeof(s),f)!=NULL)
    {
      value=searchvalue(s);
      word=strtok(s," ");
	   if(!strcmp(word,"Offset"))	{
					  value-=150360;
					  if(value<=64) value/=8;
					  else if(value<=260) value=(value+4)/8;
					  else value=(value+8)/8;
					  S_sfx[num].name=S_sfx[value+1].name; // this don't work
					}
      else if(!strcmp(word,"Zero/One")) S_sfx[num].singularity=value;
      else if(!strcmp(word,"Value"))	S_sfx[num].priority   =value;
    }
  } while(s[0]!='\n' && !feof(f));
}

void readtext(FILE* f,int len1,int len2)
{
  char s[50];
  int i;

  // it is hard to change all the text in doom
  // here i implement only vital things
  // yes text change somes tables like music, sound and sprite name
  if(len1>6)
    return;

    if(fread(s,len1+len2,1,f))
    {
      for(i=0;i<108;i++)
	if(!strncmp(S_sfx[i].name,s,len1))
	{
	  strncpy(S_sfx[i].name,&(s[len1]),len2);
	  return;
	}
      for(i=0;i<NUMSPRITES;i++)
	if(!strncmp(sprnames[i],s,len1))
	{
	  strncpy(sprnames[i],&(s[len1]),len2);
	  return;
	}
      for(i=0;i<NUMSPRITES;i++)
	if(!strncmp(sprnames[i],s,len1))
	{
	  strncpy(sprnames[i],&(s[len1]),len2);
	  return;
	}
      for(i=1;i<68;i++)
	if(!strncmp(S_music[i].name,s,len1))
	{
	  strncpy(S_music[i].name,&(s[len1]),len2);
	  return;
	}

    }
}
/*
Ammo type = 2
Deselect frame = 11
Select frame = 12
Bobbing frame = 13
Shooting frame = 17
Firing frame = 10
*/
void readweapon(FILE *f,int num)
{
  char s[200];
  char *word;
  int value;
  printf("avant : %d\n",weaponinfo[num].ammo);
  do{
    if(fgets(s,sizeof(s),f)!=NULL)
    {
      value=searchvalue(s);
      word=strtok(s," ");

	   if(!strcmp(word,"Ammo"))	  weaponinfo[num].ammo	    =value;
      else if(!strcmp(word,"Deselect"))   weaponinfo[num].upstate   =value;
      else if(!strcmp(word,"Select"))	  weaponinfo[num].downstate =value;
      else if(!strcmp(word,"Bobbing"))	  weaponinfo[num].readystate=value;
      else if(!strcmp(word,"Shooting"))   weaponinfo[num].atkstate  =value;
      else if(!strcmp(word,"Firing"))	  weaponinfo[num].flashstate=value;
    }
  } while(s[0]!='\n' && !feof(f));
  printf("apret : %d\n",weaponinfo[num].ammo);
  getchar();
}
/*
Max ammo = 400
Per ammo = 40
*/

extern int clipammo[];

void readammo(FILE *f,int num)
{
  char s[200];
  char *word;
  int value;
  do{
    if(fgets(s,sizeof(s),f)!=NULL)
    {
      value=searchvalue(s);
      word=strtok(s," ");

	   if(!strcmp(word,"Max"))  maxammo[num] =value;
      else if(!strcmp(word,"Per"))  clipammo[num]=value;
    }
  } while(s[0]!='\n' && !feof(f));
}
// i don't like that but do you see a other way ?
extern int idfa_armor;
extern int idfa_armor_class;
extern int idkfa_armor;
extern int idkfa_armor_class;
extern int god_health;
extern int initial_health;
extern int initial_bullets;
extern int MAXHEALTH;
extern int max_armor;
extern int green_armor_class;
extern int blue_armor_class;
extern int maxsoul;
extern int soul_health;
extern int mega_health;
extern int BFGCELLS;

void readmisc(FILE *f)
{
  char s[200];
  char *word,*word2;
  int value;
  do{
    if(fgets(s,sizeof(s),f)!=NULL)
    {
      value=searchvalue(s);
      word=strtok(s," ");
      word2=strtok(NULL," ");

      if(!strcmp(word,"Initial"))
      {
	 if(!strcmp(word2,"Health"))	      initial_health=value;
	 else if(!strcmp(word2,"Bullets"))    initial_bullets=value;
      }
      else if(!strcmp(word,"Max"))
      {
	 if(!strcmp(word2,"Health"))	      MAXHEALTH=value;
	 else if(!strcmp(word2,"Armor"))      max_armor=value;
	 else if(!strcmp(word2,"Soulsphere")) maxsoul=value;
      }
      else if(!strcmp(word,"Green"))	     green_armor_class=value;
      else if(!strcmp(word,"Blue"))	     blue_armor_class=value;
      else if(!strcmp(word,"Soulsphere"))    soul_health=value;
      else if(!strcmp(word,"Megasphere"))    mega_health=value;
      else if(!strcmp(word,"God"))	     god_health=value;
      else if(!strcmp(word,"IDFA"))
      {
	 word2=strtok(NULL," ");
	 if(!strcmp(word2,"=")) 	      idfa_armor=value;
	 else if(!strcmp(word2,"Class"))      idfa_armor_class=value;
      }
      else if(!strcmp(word,"IDKFA"))
      {
	 word2=strtok(NULL," ");
	 if(!strcmp(word2,"=")) 	      idkfa_armor=value;
	 else if(!strcmp(word2,"Class"))      idkfa_armor_class=value;
      }
      else if(!strcmp(word,"BFG"))	     BFGCELLS=value;
      else if(!strcmp(word,"Monsters"))      {} // i don't found where is implemented
    }
  } while(s[0]!='\n' && !feof(f));
}

extern char cheat_mus_seq[];
extern char cheat_choppers_seq[];
extern char cheat_god_seq[];
extern char cheat_ammo_seq[];
extern char cheat_ammonokey_seq[];
extern char cheat_noclip_seq[];
extern char cheat_commercial_noclip_seq[];
extern char cheat_powerup_seq[7][10];
extern char cheat_clev_seq[];
extern char cheat_mypos_seq[];
extern char cheat_amap_seq[];

void change_cheat_code(char *cheatseq,char* newcheat)
{
  unsigned char *i,*j;

  // encript data
  for(i=newcheat;i[0]!='\0';i++)
      i[0]=SCRAMBLE(i[0]);

  for(i=cheatseq,j=newcheat;j[0]!='\0' && j[0]!=0xff;i++,j++)
      if(i[0]==1 || i[0]==0xff) // no more place in the cheat
	 return;
      else
	 i[0]=j[0];

  // newcheatseq < oldcheat
  j=i;
  // search special cheat with 100
  for(;i[0]!=0xff;i++)
      if(i[0]==1)
      {
	 *j++=1;
	 *j++=0;
	 *j++=0;
	 break;
      }
  *j=0xff;

  return;
}

void readcheat(FILE *f)
{
  char s[200];
  char *word,*word2;
  char *value;

  do{
    if(fgets(s,sizeof(s),f)!=NULL)
    {
      strtok(s,"=");
      value=strtok(NULL," \n"); 	// skip the space
      strtok(NULL," \n");	       // finish the string
      word=strtok(s," ");

      if(!strcmp(word	  ,"Change"))	     change_cheat_code(cheat_mus_seq,value);
      else if(!strcmp(word,"Chainsaw"))      change_cheat_code(cheat_choppers_seq,value);
      else if(!strcmp(word,"God"))	     change_cheat_code(cheat_god_seq,value);
      else if(!strcmp(word,"Ammo"))
	   {
	     word2=strtok(NULL," ");

	     if(!strcmp(word,"&"))	     change_cheat_code(cheat_ammo_seq,value);
	     else			     change_cheat_code(cheat_ammonokey_seq,value);
	   }
      else if(!strcmp(word,"No Clipping 1"))
	   {
	     word2=strtok(NULL," ");
	     word2=strtok(NULL," ");

	     if(!strcmp(word,"1"))	     change_cheat_code(cheat_noclip_seq,value);
	     else if(!strcmp(word,"2"))      change_cheat_code(cheat_commercial_noclip_seq,value);

	   }
      else if(!strcmp(word,"Invincibility")) change_cheat_code(cheat_powerup_seq[0],value);
      else if(!strcmp(word,"Berserk"))	     change_cheat_code(cheat_powerup_seq[1],value);
      else if(!strcmp(word,"Invisibility"))  change_cheat_code(cheat_powerup_seq[2],value);
      else if(!strcmp(word,"Radiation"))     change_cheat_code(cheat_powerup_seq[3],value);
      else if(!strcmp(word,"Auto-map"))      change_cheat_code(cheat_powerup_seq[4],value);
      else if(!strcmp(word,"Lite-Amp"))      change_cheat_code(cheat_powerup_seq[5],value);
      else if(!strcmp(word,"BEHOLD"))	     change_cheat_code(cheat_powerup_seq[6],value);
      else if(!strcmp(word,"Level"))	     change_cheat_code(cheat_clev_seq,value);
      else if(!strcmp(word,"Player"))	     change_cheat_code(cheat_mypos_seq,value);
      else if(!strcmp(word,"Map"))	     change_cheat_code(cheat_amap_seq,value);
    }
  } while(s[0]!='\n' && !feof(f));
}


void LoadDehackedFile(char *filename)
{
  FILE* f;
  char	s[200];
  char	*word,*word2;
  int	i;

  f=fopen(filename,"rt");
  if(f==0)
  {
    printf("Dehacked file '%s' not found\nPress ENTER to continu\n",filename);
    getchar();
    return;
  }
  else
  {
    printf("Loading Dehacked file %s\n",filename);
  }

  first_sound_name=S_sfx[1].name;

  // it don't test the version of doom and the version of dehacked
  // and version of dehacked file
  while(!feof(f))
  {
    fgets(s,sizeof(s),f);
    if(s[0]=='\n' || s[0]=='#')
      continue;
    word=strtok(s," ");
    if(word!=NULL)
    {
      if((word2=strtok(NULL," "))!=NULL)
      {
	i=atoi(word2);

	if(!strcmp(word,"Thing"))
	{
	  i--; // begin at 0 not 1;
	  if(i<NUMMOBJTYPES && i>=0)
	    readthing(f,i);
	}
	else if(!strcmp(word,"Frame") && i<NUMSTATES && i>=0)
	       readframe(f,i);
	else if(!strcmp(word,"Pointer"))
	     {
	       word=strtok(NULL," "); // get frame
	       if((word=strtok(NULL,")"))!=NULL)
	       {
		 i=atoi(word);
		 if(i<NUMSTATES && i>=0)
		 {
		   if(fgets(s,sizeof(s),f)!=NULL)
		     states[i].action=states[searchvalue(s)].action; // WARNING CROSS referance don't work
		 }
	       }
	     }
	else if(!strcmp(word,"Sound") && i<108 && i>=0)
	       readsound(f,i);
	else if(!strcmp(word,"Sprite") && i<NUMSPRITES && i>=0)
	     {
	       if(fgets(s,sizeof(s),f)!=NULL)
		 sprnames[i]=sprnames[(searchvalue(s)-151328)/8]; // WARNING CROSS referance don't work
	     }
	else if(!strcmp(word,"Text"))
	     {
	       int j;

	       if((word=strtok(NULL," "))!=NULL)
	       {
		 j=atoi(word);
		 readtext(f,i,j);
	       }
	     }
	else if(!strcmp(word,"Weapon") && i<NUMWEAPONS && i>=0)
	       readweapon(f,i);
	else if(!strcmp(word,"Ammo") && i<NUMAMMO && i>=0)
	       readammo(f,i);
	else if(!strcmp(word,"Misc") && i<NUMAMMO && i>=0)
	       readmisc(f);
	else if(!strcmp(word,"Cheat") && i<NUMAMMO && i>=0)
	       readcheat(f);

      }
    }
  } // end while
  fclose(f);
}