// wadsplit.c -- splits Doom wads into separate pieces

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>


char *p1names[] = { "PLAYPAL","COLORMAP","ENDOOM","DEMO1","DEMO2","DEMO3","DEMO4","DEMO5","DEMO6","DEMO7","DEMO8","DEMO9",0 };
char *p3names[] = { "TEXTURE1","TEXTURE2","TEXTURE3","TEXTURE4","TEXTURE5","TEXTURE6","TEXTURE7","TEXTURE8","TEXTURE9","PNAMES", 0 };

typedef enum { FALSE, TRUE } BOOL; // not needed for Windoze

typedef enum { full_wad, patch_wad, unknown_wad } wadtype_t;

wadtype_t wadtype = full_wad;

typedef struct
   {
    // Should be "IWAD" or "PWAD".
    unsigned char identification[4];
    int           numlumps;
    int           infotableofs;
   }wadinfo_t;

typedef struct
   {
    int           filepos;
    int           size;
    unsigned char name[8];
   }filelump_t;

wadinfo_t     wadhead, temphead;
filelump_t   *directory, *tempdir;
int           fn; // main WAD file
BOOL         *used;

unsigned char *filebuff;
char          filename[_MAX_PATH], lumpname[_MAX_PATH], gamedir[_MAX_PATH] = "./";
char          drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

void MakeFiles(void);
int  GetLumpNumForName(char *name);
void GetLumpData(int entry);

void main(int argc, char *argv[])
   {
    int i;

    if (argc < 2)
       {
        printf("ERROR:\n\tUsage: wadtoppw wadfile\n");
        exit(-1);
       }

    strcpy(filename, argv[1]);
    _splitpath( filename, drive, dir, fname, ext);
    if (stricmp(ext,".WAD") != 0)
       {
        printf("This utility only works on IWAD or PWAD '.WAD' files\n");
       }

    if ((fn = open(filename, O_BINARY | O_RDONLY)) == -1)
       {
        printf("Error opening file %s\n", filename);
       }
    else
       {
        read(fn, &wadhead, sizeof(wadinfo_t));
        if (strncmp((const char *)&wadhead.identification, "IWAD", 4) == 0)
           {
            wadtype = full_wad;
            printf("This is a full WAD\n");
           }
        else
        if (strncmp((const char *)&wadhead.identification, "PWAD", 4) == 0)
           {
            wadtype = patch_wad;
            printf("This is a patch WAD. Game %s\n", fname);
           }
        else
           {
            wadtype = unknown_wad;
            printf("This utility only works on IWAD or PWAD '.WAD' files\n");
            close(fn);
            exit(-2);
           }
        filebuff = (unsigned char *)malloc(1024*1024);
        printf("WAD file has %d lumps\n", wadhead.numlumps);
        lseek(fn, wadhead.infotableofs, SEEK_SET);
        directory = (filelump_t *)malloc(sizeof(filelump_t)*wadhead.numlumps);
        tempdir = (filelump_t *)malloc(sizeof(filelump_t)*wadhead.numlumps);
        used = (BOOL *)malloc(sizeof(BOOL)*wadhead.numlumps);
        for (i = 0; i < wadhead.numlumps; i++)
           {
            used[i] = FALSE;
           }
        read(fn, directory, (sizeof(filelump_t)*wadhead.numlumps));
        MakeFiles();
        close(fn);
        free(filebuff);
       }
   }


int GetLumpNumForName(char *name)
   {
    char  tname[10];
    int   i;

    for (i = 0; i < wadhead.numlumps; i++)
       {
        strncpy(tname, directory[i].name, 8);
        tname[8] = '\0';
        if (stricmp(tname, name) == 0)
           {
            return i;
           }
       }
    return -1;
   }

void GetLumpData(int entry)
   {
    lseek(fn, directory[entry].filepos, SEEK_SET);
    if (read(fn, filebuff, directory[entry].size) != directory[entry].size)
       {
        printf("Error reading in file data on lump %d\n");
       }
    used[entry] = TRUE;
   }

void MakeFiles()
   {
    static BOOL inbsp = FALSE;
    int         i, lnum, lfn, lump, episode, mission, blump, elump, coffset, bytes = 0;
    char        tname[10], buff[4] = { 0, 0, 0, 0 };
    short       tshort = 0;

    printf("Pulling level data from WAD file...\n");
    temphead.numlumps = 0;
    sprintf(lumpname, "%s%s.WP2", gamedir, fname);
    lfn = open(lumpname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, 0666);
    write(lfn, &temphead, sizeof(wadinfo_t));

    printf("Grab Doom1 style levels...\n");

    for (episode = 1; episode < 10; episode++)
       {
        for (mission = 1; mission < 10; mission++)
           {
            sprintf(tname, "E%1dM%1d", episode, mission);
            if ((lump = GetLumpNumForName(tname)) != -1)
               {
                for (i = 0; i < 11; i++)
                   {
                    tempdir[temphead.numlumps].size = directory[lump+i].size;
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
                    tempdir[temphead.numlumps].filepos = tell(lfn);
                    memcpy(tempdir[temphead.numlumps].name, directory[lump+i].name, 8);
                    GetLumpData(lump+i);
                    write(lfn, filebuff, tempdir[temphead.numlumps].size);
                    temphead.numlumps++;
                   }
               }
           }
       }
    printf("Grab Doom2 style levels...\n");

    for (mission = 1; mission < 100; mission++)
       {
        sprintf(tname, "MAP%02d", mission);
        if ((lump = GetLumpNumForName(tname)) != -1)
           {
            for (i = 0; i < 10; i++)
               {
                tempdir[temphead.numlumps].size = directory[lump+i].size;
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
                tempdir[temphead.numlumps].filepos = tell(lfn);
                memcpy(tempdir[temphead.numlumps].name, directory[lump+i].name, 8);
                GetLumpData(lump+i);
                write(lfn, filebuff, tempdir[temphead.numlumps].size);
                temphead.numlumps++;
               }
           }
       }
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
    temphead.infotableofs = tell(lfn);
    memcpy(temphead.identification, wadhead.identification, 4);
    write(lfn, tempdir, (sizeof(filelump_t)*temphead.numlumps));
    lseek(lfn, 0, SEEK_SET);
    write(lfn, &temphead, sizeof(wadinfo_t));
    close(lfn);
    printf("Pulled %d lumps for part 2.\n", temphead.numlumps);
    
    blump = GetLumpNumForName("P_START");
    elump = GetLumpNumForName("P_END");
    if ((blump != -1) && (elump != -1))
       {
        printf("Pulling patches (textures) from WAD file...\n");
        temphead.numlumps = 0;
        sprintf(lumpname, "%s%s.WP3", gamedir, fname);
        lfn = open(lumpname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, 0666);
        //memcpy(temphead.identification, wadhead.identification, 4);
        write(lfn, &temphead, sizeof(wadinfo_t));
        for (lnum = 0; p3names[lnum] != 0; lnum++)
           {
            if ((lump = GetLumpNumForName(p3names[lnum])) != -1)
               {
                tempdir[temphead.numlumps].size = directory[lump].size;
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
                tempdir[temphead.numlumps].filepos = tell(lfn);
                memcpy(tempdir[temphead.numlumps].name, directory[lump].name, 8);
                GetLumpData(lump);
                write(lfn, filebuff, tempdir[temphead.numlumps].size);
                temphead.numlumps++;
               }
           }
        for (lump = blump; lump <= elump; lump++)
           {
            tempdir[temphead.numlumps].size = directory[lump].size;
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
            tempdir[temphead.numlumps].filepos = tell(lfn);
            memcpy(tempdir[temphead.numlumps].name, directory[lump].name, 8);
            GetLumpData(lump);
            write(lfn, filebuff, tempdir[temphead.numlumps].size);
            temphead.numlumps++;
           }
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
        temphead.infotableofs = tell(lfn);
        memcpy(temphead.identification, wadhead.identification, 4);
        write(lfn, tempdir, (sizeof(filelump_t)*temphead.numlumps));
        lseek(lfn, 0, SEEK_SET);
        write(lfn, &temphead, sizeof(wadinfo_t));
        close(lfn);
        printf("Pulled %d lumps for part 3.\n", temphead.numlumps);
       }
    else
       {
        printf("No patches section to pull...\n");
       }

    blump = GetLumpNumForName("S_START");
    elump = GetLumpNumForName("S_END");

    if ((blump != -1) && (elump != -1))
       {
        printf("Pulling sprites from WAD file...\n");
        temphead.numlumps = 0;
        sprintf(lumpname, "%s%s.WP4", gamedir, fname);
        lfn = open(lumpname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, 0666);
        //memcpy(temphead.identification, wadhead.identification, 4);
        write(lfn, &temphead, sizeof(wadinfo_t));
        for (lump = blump; lump <= elump; lump++)
           {
            tempdir[temphead.numlumps].size = directory[lump].size;
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
           tempdir[temphead.numlumps].filepos = tell(lfn);
            memcpy(tempdir[temphead.numlumps].name, directory[lump].name, 8);
            GetLumpData(lump);
            write(lfn, filebuff, tempdir[temphead.numlumps].size);
            temphead.numlumps++;
           }
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
        temphead.infotableofs = tell(lfn);
        memcpy(temphead.identification, wadhead.identification, 4);
        write(lfn, tempdir, (sizeof(filelump_t)*temphead.numlumps));
        lseek(lfn, 0, SEEK_SET);
        write(lfn, &temphead, sizeof(wadinfo_t));
        close(lfn);
        printf("Pulled %d lumps for part 4.\n", temphead.numlumps);
       }
    else
       {
        printf("No sprites section to pull...\n");
       }
    
    blump = GetLumpNumForName("F_START");
    elump = GetLumpNumForName("F_END");

    if ((blump != -1) && (elump != -1))
       {
        printf("Pulling flats from WAD file...\n");
        temphead.numlumps = 0;
        sprintf(lumpname, "%s%s.WP5", gamedir, fname);
        lfn = open(lumpname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, 0666);
        //memcpy(temphead.identification, wadhead.identification, 4);
        write(lfn, &temphead, sizeof(wadinfo_t));
        for (lump = blump; lump <= elump; lump++)
           {
            tempdir[temphead.numlumps].size = directory[lump].size;
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
            tempdir[temphead.numlumps].filepos = tell(lfn);
            memcpy(tempdir[temphead.numlumps].name, directory[lump].name, 8);
            GetLumpData(lump);
            write(lfn, filebuff, tempdir[temphead.numlumps].size);
            temphead.numlumps++;
           }
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
        temphead.infotableofs = tell(lfn);
        memcpy(temphead.identification, wadhead.identification, 4);
        write(lfn, tempdir, (sizeof(filelump_t)*temphead.numlumps));
        lseek(lfn, 0, SEEK_SET);
        write(lfn, &temphead, sizeof(wadinfo_t));
        close(lfn);
        printf("Pulled %d lumps for part 5.\n", temphead.numlumps);
       }
    else
       {
        printf("No flats section to pull...\n");
       }
    
    printf("Pulling miscellaneous data from WAD file...\n");
    temphead.numlumps = 0;
    sprintf(lumpname, "%s%s.WP1", gamedir, fname);
    lfn = open(lumpname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, 0666);
    write(lfn, &temphead, sizeof(wadinfo_t));
    for (lump = 0; lump < wadhead.numlumps; lump++)
       {
        if (used[lump] == FALSE)
           {
            tempdir[temphead.numlumps].size = directory[lump].size;
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
            tempdir[temphead.numlumps].filepos = tell(lfn);
            memcpy(tempdir[temphead.numlumps].name, directory[lump].name, 8);
            GetLumpData(lump);
            write(lfn, filebuff, tempdir[temphead.numlumps].size);
            temphead.numlumps++;
           }
       }
                    if ((bytes = (tell(lfn) % 4)) != 0)
                       {
                        write(lfn, buff, bytes);
                       }
    temphead.infotableofs = tell(lfn);
    memcpy(temphead.identification, wadhead.identification, 4);
    write(lfn, tempdir, (sizeof(filelump_t)*temphead.numlumps));
    lseek(lfn, 0, SEEK_SET);
    write(lfn, &temphead, sizeof(wadinfo_t));
    close(lfn);
    printf("Pulled %d lumps for part 1.\n", temphead.numlumps);

    coffset = 12;
    for (i = 0; i < wadhead.numlumps; i++)
       {
        strncpy(tname, directory[i].name, 8);
        tname[8] = '\0';
        printf("Lump %5d: %-8s %8d bytes at %8X\n", i, tname,
               directory[i].size, directory[i].filepos);
        if (directory[i].size == 0)
           {
            printf("This lump is a \"marker\" lump and contains no data.\n");
           }
        if (stricmp(tname, "P_START") == 0)
                printf("Patches start here...\n");
            else
            if (stricmp(tname, "P_END") == 0)
               printf("Patches end here...\n");
            else
            if (stricmp(tname, "S_START") == 0)
               printf("Sprites start here...\n");
            else
            if (stricmp(tname, "S_END") == 0)
               printf("Sprites end here...\n");
            else
            if (stricmp(tname, "F_START") == 0)
               printf("Flats start here...\n");
            else
            if (stricmp(tname, "F_END") == 0)
               printf("Flats end here...\n");
            else
            if (strnicmp(tname, "TEXTURE", 7) == 0)
               {
                printf("A textures section here...\n");
           }
        if (directory[i].filepos != coffset)
           {
            printf("Directory %d -> real %d\n", directory[i].filepos, coffset);
            coffset = directory[i].filepos;
           }
        coffset += directory[i].size;
       }
   }