//
// wcedoom.h - definitions header file for wcedoom.c
//
#define OSR2_BUILD_NUMBER 1111

typedef struct
   {
    int   width;
    int   height;
    int   bpp;
    int   flags;
    int   frequency;
   }screen_res_t;

typedef struct
   {
    HINSTANCE        hInstance;
    int              iCmdShow;
    HWND             hWnd;
    HDC              hDC;
    HGLRC            hGLRC;
    BOOL             bActive;
    BOOL             bFullScreen;
    ATOM             wndclass;
    WNDPROC          wndproc;
    int              width;
    int              height;
    int              bpp;
    int              bStretch;
    BOOL             bChangeBPP;
    BOOL             bAllowSoft;
    TCHAR           *szCmdLine;
    int              argc;
    TCHAR          **argv;
    int              glnWidth;
    int              glnHeight;
    float            gldAspect;
    float            NearClip;
    float            FarClip;
    float            fov;
    int              iResCount;
    screen_res_t    *pResolutions;
    int              iVidMode;
    HANDLE           iwad;
    BITMAPINFO      *bmi;
    HBITMAP          hBitmap;
    HDC              hMemDC;
    LOGPALETTE      *GamePal;
    HPALETTE         hPalette;
    unsigned char   *scrnbuff;
    unsigned char   *blitbuff;
   }windata_t;

typedef struct
   {
    int  width;
    int  height;
    int  bpp;
   }devinfo_t;

typedef enum { STARTUP, RUN, ABORT, SHUTDOWN } ProgramState_t;

void GetParameters( void );
int  FindNumParameter(TCHAR *s);
BOOL FindParameter(TCHAR *s);
void Cleanup(void);
void FatalError(int Message);

#ifndef _WIN32_WCE
void cprintf(char *message, ... );
void BuildModeList(void);
BOOL SetVideoMode(void);
#endif

void CreateBlitSurface(void);
void BlitScreen(void);

// New File I/O functions
int    FileAccess(LPCTSTR, DWORD);
HANDLE FileAppend(LPCTSTR FileName);
void   FileClose(HANDLE);
HANDLE FileCreate(LPCTSTR);
DWORD  FileLength(HANDLE);
HANDLE FileOpen(LPCTSTR);
DWORD  FileRead(HANDLE, LPCVOID, DWORD);
DWORD  FileSeek(HANDLE hFile, LONG distance, DWORD method);
DWORD  FileWrite(HANDLE, LPCVOID, DWORD);

void AbortProgram(void);
#ifdef _WIN32_WCE
void itoa( int, char *, int );
char toupper(char c);
#endif

void CreateDebug(void);
void WriteDebug(char *s);

TCHAR *StrToUnicode(char *s);
char  *StrFromUnicode(TCHAR *s);
