// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// Copyright(C) 2000 James Haley
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------
//
// DESCRIPTION:
//      Thing frame/state LUT,
//      generated by multigen utilitiy.
//      This one is the original DOOM version, preserved.
//
//-----------------------------------------------------------------------------

#ifndef __INFO__
#define __INFO__

// Needed for action function pointer handling.
#include "d_think.h"

// ********************************************************************
// Sprite name enumeration - must match info.c
// ********************************************************************
typedef enum                                  
{
  SPR_TROO,
  SPR_SHTG,
  SPR_PUNG,
  SPR_PISG,
  SPR_PISF,
  SPR_SHTF,
  SPR_SHT2,
  SPR_CHGG,
  SPR_CHGF,
  SPR_MISG,
  SPR_MISF,
  SPR_SAWG,
  SPR_PLSG,
  SPR_PLSF,
  SPR_BFGG,
  SPR_BFGF,
  SPR_BLUD,
  SPR_PUFF,
  SPR_BAL1,
  SPR_BAL2,
  SPR_PLSS,
  SPR_PLSE,
  SPR_MISL,
  SPR_BFS1,
  SPR_BFE1,
  SPR_BFE2,
  SPR_TFOG,
  SPR_IFOG,
  SPR_PLAY,
  SPR_POSS,
  SPR_SPOS,
  SPR_VILE,
  SPR_FIRE,
  SPR_FATB,
  SPR_FBXP,
  SPR_SKEL,
  SPR_MANF,
  SPR_FATT,
  SPR_CPOS,
  SPR_SARG,
  SPR_HEAD,
  SPR_BAL7,
  SPR_BOSS,
  SPR_BOS2,
  SPR_SKUL,
  SPR_SPID,
  SPR_BSPI,
  SPR_APLS,
  SPR_APBX,
  SPR_CYBR,
  SPR_PAIN,
  SPR_SSWV,
  SPR_KEEN,
  SPR_BBRN,
  SPR_BOSF,
  SPR_ARM1,
  SPR_ARM2,
  SPR_BAR1,
  SPR_BEXP,
  SPR_FCAN,
  SPR_BON1,
  SPR_BON2,
  SPR_BKEY,
  SPR_RKEY,
  SPR_YKEY,
  SPR_BSKU,
  SPR_RSKU,
  SPR_YSKU,
  SPR_STIM,
  SPR_MEDI,
  SPR_SOUL,
  SPR_PINV,
  SPR_PSTR,
  SPR_PINS,
  SPR_MEGA,
  SPR_SUIT,
  SPR_PMAP,
  SPR_PVIS,
  SPR_CLIP,
  SPR_AMMO,
  SPR_ROCK,
  SPR_BROK,
  SPR_CELL,
  SPR_CELP,
  SPR_SHEL,
  SPR_SBOX,
  SPR_BPAK,
  SPR_BFUG,
  SPR_MGUN,
  SPR_CSAW,
  SPR_LAUN,
  SPR_PLAS,
  SPR_SHOT,
  SPR_SGN2,
  SPR_COLU,
  SPR_SMT2,
  SPR_GOR1,
  SPR_POL2,
  SPR_POL5,
  SPR_POL4,
  SPR_POL3,
  SPR_POL1,
  SPR_POL6,
  SPR_GOR2,
  SPR_GOR3,
  SPR_GOR4,
  SPR_GOR5,
  SPR_SMIT,
  SPR_COL1,
  SPR_COL2,
  SPR_COL3,
  SPR_COL4,
  SPR_CAND,
  SPR_CBRA,
  SPR_COL6,
  SPR_TRE1,
  SPR_TRE2,
  SPR_ELEC,
  SPR_CEYE,
  SPR_FSKU,
  SPR_COL5,
  SPR_TBLU,
  SPR_TGRN,
  SPR_TRED,
  SPR_SMBT,
  SPR_SMGT,
  SPR_SMRT,
  SPR_HDB1,
  SPR_HDB2,
  SPR_HDB3,
  SPR_HDB4,
  SPR_HDB5,
  SPR_HDB6,
  SPR_POB1,
  SPR_POB2,
  SPR_BRS1,
  SPR_TLMP,
  SPR_TLP2,
  SPR_TNT1,

#ifdef DOGS
  SPR_DOGS, // killough 7/19/98: Marine's best friend :)
#endif

  SPR_PLS1, // killough 7/19/98: first  of two plasma fireballs in the beta
  SPR_PLS2, // killough 7/19/98: second of two plasma fireballs in the beta

        // sf: beta sprites removed
  SPR_PART,

// Start Eternity TC New Sprites
  SPR_MNTR, // haleyjd 1/22/99: Minotaurus / Maulotaur
  SPR_FX12, // minotaur attack 1
  SPR_FX13, // haleyjd 1/23/99: Minotaur attacks 2 & 3
  SPR_FX04, // Phoenix Puff
  SPR_TRE4, // joel - prevent conflict
  SPR_TRE5, // swamp tree 2
  SPR_TRE6, // autumn tree
  SPR_TRDT, // fragile tree
  SPR_MSS1, // moss #1
  SPR_MSS2, // moss #2
  SPR_CLER, // cleric enemy
  SPR_CBAL, // cleric projectile
  SPR_FBUL, // bull torch
  SPR_SPSH, // terrain splashes
  SPR_SLDG, // swamp water splash
  SPR_FOGS, // fog clouds
  SPR_FOGM,
  SPR_FOGL,
  SPR_LCLR, // special cleric boss frames
  SPR_BRPL, // horned column
  SPR_BARL, // wood barrel
  SPR_TST0, // meat clever
  SPR_TST1, // beer stein 1
  SPR_ARMR, // suit of armor,
  SPR_STM1, // burnt stump
  SPR_STM2, // cut stump
  SPR_SKH1, // hanging skull
  SPR_GAR8, // short gargoyle
  SPR_GAR4, // tall gargoyle
  SPR_WTRH, // wall torch
  SPR_CHDL, // chandelier
  SPR_MSH2, // mushroom
  SPR_CDRN, // cauldron
  SPR_TST2, // beer stein 2
  SPR_SWMV, // swamp vine
  SPR_CPS5, // corpses
  SPR_CPS6,
  SPR_CPS1,
  SPR_CPS4,
  SPR_TMS6, // tombstones
  SPR_TMS1,
  SPR_TMS5,
  SPR_RCK2, // joel - 2 to prevent conflict
  SPR_RCK4, // large rock
  SPR_TST6, // cup w/ blood
  SPR_TST7, // cup
  SPR_DWRF, // helper dwarf  08/11/99 haleyjd
  SPR_GRD1, // guard character
  SPR_CYBN, // cyberguard
  SPR_FDWF, // dwarf alterego
  SPR_GRLN, // grenade launcher pickup
  SPR_GREN, // grenade in flight
  SPR_GRNP, // grenade ammo
  SPR_PNS2, // blur sphere 2
  SPR_CAXE, // cyberguard toys
  SPR_CSTF,
  SPR_TGLT, // glitter
  SPR_ABK1, // inert Necronomicon >:)
  SPR_KEY1, // new keys
  SPR_KEY2,
  SPR_KEY3,
  SPR_KEY4,
  SPR_KEY5,
  SPR_KEY6,
  SPR_KEY7,
  SPR_KEY8,
  SPR_KEY9,
  SPR_KEYA,
  SPR_KEYB,
  SPR_NSPD, // floating spiderdemon >>>:)
  SPR_FX15, // mummy head projectile
  SPR_MUMM, // Halif's pet golem
  SPR_LVAS, // lava terraintype
// End Eternity TC New Sprites
  SPR_RCK1,
  SPR_TRE3, // joel: new COD objects
  SPR_CROS, // joel: sprite set for Holy Cross
  SPR_CRSS, // joel: pickup sprite

  NUMSPRITES  // counter of how many there are
} spritenum_t;

// ********************************************************************
// States (frames) enumeration -- must match info.c
// ********************************************************************
typedef enum
{
  S_NULL,
  S_LIGHTDONE,
  S_PUNCH,
  S_PUNCHDOWN,
  S_PUNCHUP,
  S_PUNCH1,
  S_PUNCH2,
  S_PUNCH3,
  S_PUNCH4,
  S_PUNCH5,
  S_PISTOL,
  S_PISTOLDOWN,
  S_PISTOLUP,
  S_PISTOL1,
  S_PISTOL2,
  S_PISTOL3,
  S_PISTOL4,
  S_PISTOLFLASH,
  S_SGUN,
  S_SGUNDOWN,
  S_SGUNUP,
  S_SGUN1,
  S_SGUN2,
  S_SGUN3,
  S_SGUN4,
  S_SGUN5,
  S_SGUN6,
  S_SGUN7,
  S_SGUN8,
  S_SGUN9,
  S_SGUNFLASH1,
  S_SGUNFLASH2,
  S_DSGUN,
  S_DSGUNDOWN,
  S_DSGUNUP,
  S_DSGUN1,
  S_DSGUN2,
  S_DSGUN3,
  S_DSGUN4,
  S_DSGUN5,
  S_DSGUN6,
  S_DSGUN7,
  S_DSGUN8,
  S_DSGUN9,
  S_DSGUN10,
  S_DSNR1,
  S_DSNR2,
  S_DSGUNFLASH1,
  S_DSGUNFLASH2,
  S_CHAIN,
  S_CHAINDOWN,
  S_CHAINUP,
  S_CHAIN1,
  S_CHAIN2,
  S_CHAIN3,
  S_CHAINFLASH1,
  S_CHAINFLASH2,
  S_MISSILE,
  S_MISSILEDOWN,
  S_MISSILEUP,
  S_MISSILE1,
  S_MISSILE2,
  S_MISSILE3,
  S_MISSILEFLASH1,
  S_MISSILEFLASH2,
  S_MISSILEFLASH3,
  S_MISSILEFLASH4,
  S_SAW,
  S_SAWB,
  S_SAWDOWN,
  S_SAWUP,
  S_SAW1,
  S_SAW2,
  S_SAW3,
  S_PLASMA,
  S_PLASMADOWN,
  S_PLASMAUP,
  S_PLASMA1,
  S_PLASMA2,
  S_PLASMAFLASH1,
  S_PLASMAFLASH2,
  S_BFG,
  S_BFGDOWN,
  S_BFGUP,
  S_BFG1,
  S_BFG2,
  S_BFG3,
  S_BFG4,
  S_BFGFLASH1,
  S_BFGFLASH2,
  S_BLOOD1,
  S_BLOOD2,
  S_BLOOD3,
  S_PUFF1,
  S_PUFF2,
  S_PUFF3,
  S_PUFF4,
  S_TBALL1,
  S_TBALL2,
  S_TBALLX1,
  S_TBALLX2,
  S_TBALLX3,
  S_RBALL1,
  S_RBALL2,
  S_RBALLX1,
  S_RBALLX2,
  S_RBALLX3,
  S_PLASBALL,
  S_PLASBALL2,
  S_PLASEXP,
  S_PLASEXP2,
  S_PLASEXP3,
  S_PLASEXP4,
  S_PLASEXP5,
  S_ROCKET,
  S_BFGSHOT,
  S_BFGSHOT2,
  S_BFGLAND,
  S_BFGLAND2,
  S_BFGLAND3,
  S_BFGLAND4,
  S_BFGLAND5,
  S_BFGLAND6,
  S_BFGEXP,
  S_BFGEXP2,
  S_BFGEXP3,
  S_BFGEXP4,
  S_EXPLODE1,
  S_EXPLODE2,
  S_EXPLODE3,
  S_TFOG,
  S_TFOG01,
  S_TFOG02,
  S_TFOG2,
  S_TFOG3,
  S_TFOG4,
  S_TFOG5,
  S_TFOG6,
  S_TFOG7,
  S_TFOG8,
  S_TFOG9,
  S_TFOG10,
  S_IFOG,
  S_IFOG01,
  S_IFOG02,
  S_IFOG2,
  S_IFOG3,
  S_IFOG4,
  S_IFOG5,
  S_PLAY,
  S_PLAY_RUN1,
  S_PLAY_RUN2,
  S_PLAY_RUN3,
  S_PLAY_RUN4,
  S_PLAY_ATK1,
  S_PLAY_ATK2,
  S_PLAY_PAIN,
  S_PLAY_PAIN2,
  S_PLAY_DIE1,
  S_PLAY_DIE2,
  S_PLAY_DIE3,
  S_PLAY_DIE4,
  S_PLAY_DIE5,
  S_PLAY_DIE6,
  S_PLAY_DIE7,
  S_PLAY_XDIE1,
  S_PLAY_XDIE2,
  S_PLAY_XDIE3,
  S_PLAY_XDIE4,
  S_PLAY_XDIE5,
  S_PLAY_XDIE6,
  S_PLAY_XDIE7,
  S_PLAY_XDIE8,
  S_PLAY_XDIE9,
  S_POSS_STND,
  S_POSS_STND2,
  S_POSS_RUN1,
  S_POSS_RUN2,
  S_POSS_RUN3,
  S_POSS_RUN4,
  S_POSS_RUN5,
  S_POSS_RUN6,
  S_POSS_RUN7,
  S_POSS_RUN8,
  S_POSS_ATK1,
  S_POSS_ATK2,
  S_POSS_ATK3,
  S_POSS_PAIN,
  S_POSS_PAIN2,
  S_POSS_DIE1,
  S_POSS_DIE2,
  S_POSS_DIE3,
  S_POSS_DIE4,
  S_POSS_DIE5,
  S_POSS_XDIE1,
  S_POSS_XDIE2,
  S_POSS_XDIE3,
  S_POSS_XDIE4,
  S_POSS_XDIE5,
  S_POSS_XDIE6,
  S_POSS_XDIE7,
  S_POSS_XDIE8,
  S_POSS_XDIE9,
  S_POSS_RAISE1,
  S_POSS_RAISE2,
  S_POSS_RAISE3,
  S_POSS_RAISE4,
  S_SPOS_STND,
  S_SPOS_STND2,
  S_SPOS_RUN1,
  S_SPOS_RUN2,
  S_SPOS_RUN3,
  S_SPOS_RUN4,
  S_SPOS_RUN5,
  S_SPOS_RUN6,
  S_SPOS_RUN7,
  S_SPOS_RUN8,
  S_SPOS_ATK1,
  S_SPOS_ATK2,
  S_SPOS_ATK3,
  S_SPOS_PAIN,
  S_SPOS_PAIN2,
  S_SPOS_DIE1,
  S_SPOS_DIE2,
  S_SPOS_DIE3,
  S_SPOS_DIE4,
  S_SPOS_DIE5,
  S_SPOS_XDIE1,
  S_SPOS_XDIE2,
  S_SPOS_XDIE3,
  S_SPOS_XDIE4,
  S_SPOS_XDIE5,
  S_SPOS_XDIE6,
  S_SPOS_XDIE7,
  S_SPOS_XDIE8,
  S_SPOS_XDIE9,
  S_SPOS_RAISE1,
  S_SPOS_RAISE2,
  S_SPOS_RAISE3,
  S_SPOS_RAISE4,
  S_SPOS_RAISE5,
  S_VILE_STND,
  S_VILE_STND2,
  S_VILE_RUN1,
  S_VILE_RUN2,
  S_VILE_RUN3,
  S_VILE_RUN4,
  S_VILE_RUN5,
  S_VILE_RUN6,
  S_VILE_RUN7,
  S_VILE_RUN8,
  S_VILE_RUN9,
  S_VILE_RUN10,
  S_VILE_RUN11,
  S_VILE_RUN12,
  S_VILE_ATK1,
  S_VILE_ATK2,
  S_VILE_ATK3,
  S_VILE_ATK4,
  S_VILE_ATK5,
  S_VILE_ATK6,
  S_VILE_ATK7,
  S_VILE_ATK8,
  S_VILE_ATK9,
  S_VILE_ATK10,
  S_VILE_ATK11,
  S_VILE_HEAL1,
  S_VILE_HEAL2,
  S_VILE_HEAL3,
  S_VILE_PAIN,
  S_VILE_PAIN2,
  S_VILE_DIE1,
  S_VILE_DIE2,
  S_VILE_DIE3,
  S_VILE_DIE4,
  S_VILE_DIE5,
  S_VILE_DIE6,
  S_VILE_DIE7,
  S_VILE_DIE8,
  S_VILE_DIE9,
  S_VILE_DIE10,
  S_FIRE1,
  S_FIRE2,
  S_FIRE3,
  S_FIRE4,
  S_FIRE5,
  S_FIRE6,
  S_FIRE7,
  S_FIRE8,
  S_FIRE9,
  S_FIRE10,
  S_FIRE11,
  S_FIRE12,
  S_FIRE13,
  S_FIRE14,
  S_FIRE15,
  S_FIRE16,
  S_FIRE17,
  S_FIRE18,
  S_FIRE19,
  S_FIRE20,
  S_FIRE21,
  S_FIRE22,
  S_FIRE23,
  S_FIRE24,
  S_FIRE25,
  S_FIRE26,
  S_FIRE27,
  S_FIRE28,
  S_FIRE29,
  S_FIRE30,
  S_SMOKE1,
  S_SMOKE2,
  S_SMOKE3,
  S_SMOKE4,
  S_SMOKE5,
  S_TRACER,
  S_TRACER2,
  S_TRACEEXP1,
  S_TRACEEXP2,
  S_TRACEEXP3,
  S_SKEL_STND,
  S_SKEL_STND2,
  S_SKEL_RUN1,
  S_SKEL_RUN2,
  S_SKEL_RUN3,
  S_SKEL_RUN4,
  S_SKEL_RUN5,
  S_SKEL_RUN6,
  S_SKEL_RUN7,
  S_SKEL_RUN8,
  S_SKEL_RUN9,
  S_SKEL_RUN10,
  S_SKEL_RUN11,
  S_SKEL_RUN12,
  S_SKEL_FIST1,
  S_SKEL_FIST2,
  S_SKEL_FIST3,
  S_SKEL_FIST4,
  S_SKEL_MISS1,
  S_SKEL_MISS2,
  S_SKEL_MISS3,
  S_SKEL_MISS4,
  S_SKEL_PAIN,
  S_SKEL_PAIN2,
  S_SKEL_DIE1,
  S_SKEL_DIE2,
  S_SKEL_DIE3,
  S_SKEL_DIE4,
  S_SKEL_DIE5,
  S_SKEL_DIE6,
  S_SKEL_RAISE1,
  S_SKEL_RAISE2,
  S_SKEL_RAISE3,
  S_SKEL_RAISE4,
  S_SKEL_RAISE5,
  S_SKEL_RAISE6,
  S_FATSHOT1,
  S_FATSHOT2,
  S_FATSHOTX1,
  S_FATSHOTX2,
  S_FATSHOTX3,
  S_FATT_STND,
  S_FATT_STND2,
  S_FATT_RUN1,
  S_FATT_RUN2,
  S_FATT_RUN3,
  S_FATT_RUN4,
  S_FATT_RUN5,
  S_FATT_RUN6,
  S_FATT_RUN7,
  S_FATT_RUN8,
  S_FATT_RUN9,
  S_FATT_RUN10,
  S_FATT_RUN11,
  S_FATT_RUN12,
  S_FATT_ATK1,
  S_FATT_ATK2,
  S_FATT_ATK3,
  S_FATT_ATK4,
  S_FATT_ATK5,
  S_FATT_ATK6,
  S_FATT_ATK7,
  S_FATT_ATK8,
  S_FATT_ATK9,
  S_FATT_ATK10,
  S_FATT_PAIN,
  S_FATT_PAIN2,
  S_FATT_DIE1,
  S_FATT_DIE2,
  S_FATT_DIE3,
  S_FATT_DIE4,
  S_FATT_DIE5,
  S_FATT_DIE6,
  S_FATT_DIE7,
  S_FATT_DIE8,
  S_FATT_DIE9,
  S_FATT_DIE10,
  S_FATT_RAISE1,
  S_FATT_RAISE2,
  S_FATT_RAISE3,
  S_FATT_RAISE4,
  S_FATT_RAISE5,
  S_FATT_RAISE6,
  S_FATT_RAISE7,
  S_FATT_RAISE8,
  S_CPOS_STND,
  S_CPOS_STND2,
  S_CPOS_RUN1,
  S_CPOS_RUN2,
  S_CPOS_RUN3,
  S_CPOS_RUN4,
  S_CPOS_RUN5,
  S_CPOS_RUN6,
  S_CPOS_RUN7,
  S_CPOS_RUN8,
  S_CPOS_ATK1,
  S_CPOS_ATK2,
  S_CPOS_ATK3,
  S_CPOS_ATK4,
  S_CPOS_PAIN,
  S_CPOS_PAIN2,
  S_CPOS_DIE1,
  S_CPOS_DIE2,
  S_CPOS_DIE3,
  S_CPOS_DIE4,
  S_CPOS_DIE5,
  S_CPOS_DIE6,
  S_CPOS_DIE7,
  S_CPOS_XDIE1,
  S_CPOS_XDIE2,
  S_CPOS_XDIE3,
  S_CPOS_XDIE4,
  S_CPOS_XDIE5,
  S_CPOS_XDIE6,
  S_CPOS_RAISE1,
  S_CPOS_RAISE2,
  S_CPOS_RAISE3,
  S_CPOS_RAISE4,
  S_CPOS_RAISE5,
  S_CPOS_RAISE6,
  S_CPOS_RAISE7,
  S_TROO_STND,
  S_TROO_STND2,
  S_TROO_RUN1,
  S_TROO_RUN2,
  S_TROO_RUN3,
  S_TROO_RUN4,
  S_TROO_RUN5,
  S_TROO_RUN6,
  S_TROO_RUN7,
  S_TROO_RUN8,
  S_TROO_ATK1,
  S_TROO_ATK2,
  S_TROO_ATK3,
  S_TROO_PAIN,
  S_TROO_PAIN2,
  S_TROO_DIE1,
  S_TROO_DIE2,
  S_TROO_DIE3,
  S_TROO_DIE4,
  S_TROO_DIE5,
  S_TROO_XDIE1,
  S_TROO_XDIE2,
  S_TROO_XDIE3,
  S_TROO_XDIE4,
  S_TROO_XDIE5,
  S_TROO_XDIE6,
  S_TROO_XDIE7,
  S_TROO_XDIE8,
  S_TROO_RAISE1,
  S_TROO_RAISE2,
  S_TROO_RAISE3,
  S_TROO_RAISE4,
  S_TROO_RAISE5,
  S_SARG_STND,
  S_SARG_STND2,
  S_SARG_RUN1,
  S_SARG_RUN2,
  S_SARG_RUN3,
  S_SARG_RUN4,
  S_SARG_RUN5,
  S_SARG_RUN6,
  S_SARG_RUN7,
  S_SARG_RUN8,
  S_SARG_ATK1,
  S_SARG_ATK2,
  S_SARG_ATK3,
  S_SARG_PAIN,
  S_SARG_PAIN2,
  S_SARG_DIE1,
  S_SARG_DIE2,
  S_SARG_DIE3,
  S_SARG_DIE4,
  S_SARG_DIE5,
  S_SARG_DIE6,
  S_SARG_RAISE1,
  S_SARG_RAISE2,
  S_SARG_RAISE3,
  S_SARG_RAISE4,
  S_SARG_RAISE5,
  S_SARG_RAISE6,
  S_HEAD_STND,
  S_HEAD_RUN1,
  S_HEAD_ATK1,
  S_HEAD_ATK2,
  S_HEAD_ATK3,
  S_HEAD_PAIN,
  S_HEAD_PAIN2,
  S_HEAD_PAIN3,
  S_HEAD_DIE1,
  S_HEAD_DIE2,
  S_HEAD_DIE3,
  S_HEAD_DIE4,
  S_HEAD_DIE5,
  S_HEAD_DIE6,
  S_HEAD_RAISE1,
  S_HEAD_RAISE2,
  S_HEAD_RAISE3,
  S_HEAD_RAISE4,
  S_HEAD_RAISE5,
  S_HEAD_RAISE6,
  S_BRBALL1,
  S_BRBALL2,
  S_BRBALLX1,
  S_BRBALLX2,
  S_BRBALLX3,
  S_BOSS_STND,
  S_BOSS_STND2,
  S_BOSS_RUN1,
  S_BOSS_RUN2,
  S_BOSS_RUN3,
  S_BOSS_RUN4,
  S_BOSS_RUN5,
  S_BOSS_RUN6,
  S_BOSS_RUN7,
  S_BOSS_RUN8,
  S_BOSS_ATK1,
  S_BOSS_ATK2,
  S_BOSS_ATK3,
  S_BOSS_PAIN,
  S_BOSS_PAIN2,
  S_BOSS_DIE1,
  S_BOSS_DIE2,
  S_BOSS_DIE3,
  S_BOSS_DIE4,
  S_BOSS_DIE5,
  S_BOSS_DIE6,
  S_BOSS_DIE7,
  S_BOSS_RAISE1,
  S_BOSS_RAISE2,
  S_BOSS_RAISE3,
  S_BOSS_RAISE4,
  S_BOSS_RAISE5,
  S_BOSS_RAISE6,
  S_BOSS_RAISE7,
  S_BOS2_STND,
  S_BOS2_STND2,
  S_BOS2_RUN1,
  S_BOS2_RUN2,
  S_BOS2_RUN3,
  S_BOS2_RUN4,
  S_BOS2_RUN5,
  S_BOS2_RUN6,
  S_BOS2_RUN7,
  S_BOS2_RUN8,
  S_BOS2_ATK1,
  S_BOS2_ATK2,
  S_BOS2_ATK3,
  S_BOS2_PAIN,
  S_BOS2_PAIN2,
  S_BOS2_DIE1,
  S_BOS2_DIE2,
  S_BOS2_DIE3,
  S_BOS2_DIE4,
  S_BOS2_DIE5,
  S_BOS2_DIE6,
  S_BOS2_DIE7,
  S_BOS2_RAISE1,
  S_BOS2_RAISE2,
  S_BOS2_RAISE3,
  S_BOS2_RAISE4,
  S_BOS2_RAISE5,
  S_BOS2_RAISE6,
  S_BOS2_RAISE7,
  S_SKULL_STND,
  S_SKULL_STND2,
  S_SKULL_RUN1,
  S_SKULL_RUN2,
  S_SKULL_ATK1,
  S_SKULL_ATK2,
  S_SKULL_ATK3,
  S_SKULL_ATK4,
  S_SKULL_PAIN,
  S_SKULL_PAIN2,
  S_SKULL_DIE1,
  S_SKULL_DIE2,
  S_SKULL_DIE3,
  S_SKULL_DIE4,
  S_SKULL_DIE5,
  S_SKULL_DIE6,
  S_SPID_STND,
  S_SPID_STND2,
  S_SPID_RUN1,
  S_SPID_RUN2,
  S_SPID_RUN3,
  S_SPID_RUN4,
  S_SPID_RUN5,
  S_SPID_RUN6,
  S_SPID_RUN7,
  S_SPID_RUN8,
  S_SPID_RUN9,
  S_SPID_RUN10,
  S_SPID_RUN11,
  S_SPID_RUN12,
  S_SPID_ATK1,
  S_SPID_ATK2,
  S_SPID_ATK3,
  S_SPID_ATK4,
  S_SPID_PAIN,
  S_SPID_PAIN2,
  S_SPID_DIE1,
  S_SPID_DIE2,
  S_SPID_DIE3,
  S_SPID_DIE4,
  S_SPID_DIE5,
  S_SPID_DIE6,
  S_SPID_DIE7,
  S_SPID_DIE8,
  S_SPID_DIE9,
  S_SPID_DIE10,
  S_SPID_DIE11,
  S_BSPI_STND,
  S_BSPI_STND2,
  S_BSPI_SIGHT,
  S_BSPI_RUN1,
  S_BSPI_RUN2,
  S_BSPI_RUN3,
  S_BSPI_RUN4,
  S_BSPI_RUN5,
  S_BSPI_RUN6,
  S_BSPI_RUN7,
  S_BSPI_RUN8,
  S_BSPI_RUN9,
  S_BSPI_RUN10,
  S_BSPI_RUN11,
  S_BSPI_RUN12,
  S_BSPI_ATK1,
  S_BSPI_ATK2,
  S_BSPI_ATK3,
  S_BSPI_ATK4,
  S_BSPI_PAIN,
  S_BSPI_PAIN2,
  S_BSPI_DIE1,
  S_BSPI_DIE2,
  S_BSPI_DIE3,
  S_BSPI_DIE4,
  S_BSPI_DIE5,
  S_BSPI_DIE6,
  S_BSPI_DIE7,
  S_BSPI_RAISE1,
  S_BSPI_RAISE2,
  S_BSPI_RAISE3,
  S_BSPI_RAISE4,
  S_BSPI_RAISE5,
  S_BSPI_RAISE6,
  S_BSPI_RAISE7,
  S_ARACH_PLAZ,
  S_ARACH_PLAZ2,
  S_ARACH_PLEX,
  S_ARACH_PLEX2,
  S_ARACH_PLEX3,
  S_ARACH_PLEX4,
  S_ARACH_PLEX5,
  S_CYBER_STND,
  S_CYBER_STND2,
  S_CYBER_RUN1,
  S_CYBER_RUN2,
  S_CYBER_RUN3,
  S_CYBER_RUN4,
  S_CYBER_RUN5,
  S_CYBER_RUN6,
  S_CYBER_RUN7,
  S_CYBER_RUN8,
  S_CYBER_ATK1,
  S_CYBER_ATK2,
  S_CYBER_ATK3,
  S_CYBER_ATK4,
  S_CYBER_ATK5,
  S_CYBER_ATK6,
  S_CYBER_PAIN,
  S_CYBER_DIE1,
  S_CYBER_DIE2,
  S_CYBER_DIE3,
  S_CYBER_DIE4,
  S_CYBER_DIE5,
  S_CYBER_DIE6,
  S_CYBER_DIE7,
  S_CYBER_DIE8,
  S_CYBER_DIE9,
  S_CYBER_DIE10,
  S_PAIN_STND,
  S_PAIN_RUN1,
  S_PAIN_RUN2,
  S_PAIN_RUN3,
  S_PAIN_RUN4,
  S_PAIN_RUN5,
  S_PAIN_RUN6,
  S_PAIN_ATK1,
  S_PAIN_ATK2,
  S_PAIN_ATK3,
  S_PAIN_ATK4,
  S_PAIN_PAIN,
  S_PAIN_PAIN2,
  S_PAIN_DIE1,
  S_PAIN_DIE2,
  S_PAIN_DIE3,
  S_PAIN_DIE4,
  S_PAIN_DIE5,
  S_PAIN_DIE6,
  S_PAIN_RAISE1,
  S_PAIN_RAISE2,
  S_PAIN_RAISE3,
  S_PAIN_RAISE4,
  S_PAIN_RAISE5,
  S_PAIN_RAISE6,
  S_SSWV_STND,
  S_SSWV_STND2,
  S_SSWV_RUN1,
  S_SSWV_RUN2,
  S_SSWV_RUN3,
  S_SSWV_RUN4,
  S_SSWV_RUN5,
  S_SSWV_RUN6,
  S_SSWV_RUN7,
  S_SSWV_RUN8,
  S_SSWV_ATK1,
  S_SSWV_ATK2,
  S_SSWV_ATK3,
  S_SSWV_ATK4,
  S_SSWV_ATK5,
  S_SSWV_ATK6,
  S_SSWV_PAIN,
  S_SSWV_PAIN2,
  S_SSWV_DIE1,
  S_SSWV_DIE2,
  S_SSWV_DIE3,
  S_SSWV_DIE4,
  S_SSWV_DIE5,
  S_SSWV_XDIE1,
  S_SSWV_XDIE2,
  S_SSWV_XDIE3,
  S_SSWV_XDIE4,
  S_SSWV_XDIE5,
  S_SSWV_XDIE6,
  S_SSWV_XDIE7,
  S_SSWV_XDIE8,
  S_SSWV_XDIE9,
  S_SSWV_RAISE1,
  S_SSWV_RAISE2,
  S_SSWV_RAISE3,
  S_SSWV_RAISE4,
  S_SSWV_RAISE5,
  S_KEENSTND,
  S_COMMKEEN,
  S_COMMKEEN2,
  S_COMMKEEN3,
  S_COMMKEEN4,
  S_COMMKEEN5,
  S_COMMKEEN6,
  S_COMMKEEN7,
  S_COMMKEEN8,
  S_COMMKEEN9,
  S_COMMKEEN10,
  S_COMMKEEN11,
  S_COMMKEEN12,
  S_KEENPAIN,
  S_KEENPAIN2,
  S_BRAIN,
  S_BRAIN_PAIN,
  S_BRAIN_DIE1,
  S_BRAIN_DIE2,
  S_BRAIN_DIE3,
  S_BRAIN_DIE4,
  S_BRAINEYE,
  S_BRAINEYESEE,
  S_BRAINEYE1,
  S_SPAWN1,
  S_SPAWN2,
  S_SPAWN3,
  S_SPAWN4,
  S_SPAWNFIRE1,
  S_SPAWNFIRE2,
  S_SPAWNFIRE3,
  S_SPAWNFIRE4,
  S_SPAWNFIRE5,
  S_SPAWNFIRE6,
  S_SPAWNFIRE7,
  S_SPAWNFIRE8,
  S_BRAINEXPLODE1,
  S_BRAINEXPLODE2,
  S_BRAINEXPLODE3,
  S_ARM1,
  S_ARM1A,
  S_ARM2,
  S_ARM2A,
  S_BAR1,
  S_BAR2,
  S_BEXP,
  S_BEXP2,
  S_BEXP3,
  S_BEXP4,
  S_BEXP5,
  S_BBAR1,
  S_BBAR2,
  S_BBAR3,
  S_BON1,
  S_BON1A,
  S_BON1B,
  S_BON1C,
  S_BON1D,
  S_BON1E,
  S_BON2,
  S_BON2A,
  S_BON2B,
  S_BON2C,
  S_BON2D,
  S_BON2E,
  S_BKEY,
  S_BKEY2,
  S_RKEY,
  S_RKEY2,
  S_YKEY,
  S_YKEY2,
  S_BSKULL,
  S_BSKULL2,
  S_RSKULL,
  S_RSKULL2,
  S_YSKULL,
  S_YSKULL2,
  S_STIM,
  S_MEDI,
  S_SOUL,
  S_SOUL2,
  S_SOUL3,
  S_SOUL4,
  S_SOUL5,
  S_SOUL6,
  S_PINV,
  S_PINV2,
  S_PINV3,
  S_PINV4,
  S_PSTR,
  S_PINS,
  S_PINS2,
  S_PINS3,
  S_PINS4,
  S_MEGA,
  S_MEGA2,
  S_MEGA3,
  S_MEGA4,
  S_SUIT,
  S_PMAP,
  S_PMAP2,
  S_PMAP3,
  S_PMAP4,
  S_PMAP5,
  S_PMAP6,
  S_PVIS,
  S_PVIS2,
  S_CLIP,
  S_AMMO,
  S_ROCK,
  S_BROK,
  S_CELL,
  S_CELP,
  S_SHEL,
  S_SBOX,
  S_BPAK,
  S_BFUG,
  S_MGUN,
  S_CSAW,
  S_LAUN,
  S_PLAS,
  S_SHOT,
  S_SHOT2,
  S_COLU,
  S_STALAG,
  S_BLOODYTWITCH,
  S_BLOODYTWITCH2,
  S_BLOODYTWITCH3,
  S_BLOODYTWITCH4,
  S_DEADTORSO,
  S_DEADBOTTOM,
  S_HEADSONSTICK,
  S_GIBS,
  S_HEADONASTICK,
  S_HEADCANDLES,
  S_HEADCANDLES2,
  S_DEADSTICK,
  S_LIVESTICK,
  S_LIVESTICK2,
  S_MEAT2,
  S_MEAT3,
  S_MEAT4,
  S_MEAT5,
  S_STALAGTITE,
  S_TALLGRNCOL,
  S_SHRTGRNCOL,
  S_TALLREDCOL,
  S_SHRTREDCOL,
  S_CANDLESTIK,
  S_CANDELABRA,
  S_SKULLCOL,
  S_TORCHTREE,
  S_BIGTREE,
  S_TECHPILLAR,
  S_EVILEYE,
  S_EVILEYE2,
  S_EVILEYE3,
  S_EVILEYE4,
  S_FLOATSKULL,
  S_FLOATSKULL2,
  S_FLOATSKULL3,
  S_HEARTCOL,
  S_HEARTCOL2,
  S_BLUETORCH,
  S_BLUETORCH2,
  S_BLUETORCH3,
  S_BLUETORCH4,
  S_GREENTORCH,
  S_GREENTORCH2,
  S_GREENTORCH3,
  S_GREENTORCH4,
  S_REDTORCH,
  S_REDTORCH2,
  S_REDTORCH3,
  S_REDTORCH4,
  S_BTORCHSHRT,
  S_BTORCHSHRT2,
  S_BTORCHSHRT3,
  S_BTORCHSHRT4,
  S_GTORCHSHRT,
  S_GTORCHSHRT2,
  S_GTORCHSHRT3,
  S_GTORCHSHRT4,
  S_RTORCHSHRT,
  S_RTORCHSHRT2,
  S_RTORCHSHRT3,
  S_RTORCHSHRT4,
  S_HANGNOGUTS,
  S_HANGBNOBRAIN,
  S_HANGTLOOKDN,
  S_HANGTSKULL,
  S_HANGTLOOKUP,
  S_HANGTNOBRAIN,
  S_COLONGIBS,
  S_SMALLPOOL,
  S_BRAINSTEM,
  S_TECHLAMP,
  S_TECHLAMP2,
  S_TECHLAMP3,
  S_TECHLAMP4,
  S_TECH2LAMP,
  S_TECH2LAMP2,
  S_TECH2LAMP3,
  S_TECH2LAMP4,
  S_TNT1, // add state for invisible sprite         // phares 3/8/98 

  S_GRENADE,   // killough 8/9/98: grenade launcher
  S_DETONATE,  // killough 8/9/98: detonation of objects
  S_DETONATE2,
  S_DETONATE3, 

#ifdef DOGS
  S_DOGS_STND,      // killough 7/19/98: Marine's best friend :)
  S_DOGS_STND2,
  S_DOGS_RUN1,
  S_DOGS_RUN2,
  S_DOGS_RUN3,
  S_DOGS_RUN4,
  S_DOGS_RUN5,
  S_DOGS_RUN6,
  S_DOGS_RUN7,
  S_DOGS_RUN8,
  S_DOGS_ATK1,
  S_DOGS_ATK2,
  S_DOGS_ATK3,
  S_DOGS_PAIN,
  S_DOGS_PAIN2,
  S_DOGS_DIE1,
  S_DOGS_DIE2,
  S_DOGS_DIE3,
  S_DOGS_DIE4,
  S_DOGS_DIE5,
  S_DOGS_DIE6,
  S_DOGS_RAISE1,
  S_DOGS_RAISE2,
  S_DOGS_RAISE3,
  S_DOGS_RAISE4,
  S_DOGS_RAISE5,
  S_DOGS_RAISE6,
#endif

  S_OLDBFG1,  // killough 7/11/98: the old BFG's 43 firing frames
  S_OLDBFG42 = S_OLDBFG1+41,
  S_OLDBFG43,

  S_PLS1BALL,      // killough 7/19/98: first plasma fireball in the beta
  S_PLS1BALL2,
  S_PLS1EXP,
  S_PLS1EXP2,
  S_PLS1EXP3,
  S_PLS1EXP4,
  S_PLS1EXP5,

  S_PLS2BALL,     // killough 7/19/98: second plasma fireball in the beta
  S_PLS2BALL2,
  S_PLS2BALLX1,
  S_PLS2BALLX2,
  S_PLS2BALLX3,

        // sf: removed MBF beta states

  S_MUSHROOM,  // killough 10/98: mushroom explosion effect
  S_PART1,

// Start Eternity TC New Frame States
  // Start Minotaurus Frames
  S_MNTR_LOOK1,
  S_MNTR_LOOK2,
  S_MNTR_WALK1,
  S_MNTR_WALK2,
  S_MNTR_WALK3,
  S_MNTR_WALK4,
  S_MNTR_ATK1_1,
  S_MNTR_ATK1_2,
  S_MNTR_ATK1_3,
  S_MNTR_ATK2_1,
  S_MNTR_ATK2_2,
  S_MNTR_ATK2_3,
  S_MNTR_ATK3_1,
  S_MNTR_ATK3_2,
  S_MNTR_ATK3_3,
  S_MNTR_ATK3_4,
  S_MNTR_ATK4_1,
  S_MNTR_PAIN1,
  S_MNTR_PAIN2,
  S_MNTR_DIE1,
  S_MNTR_DIE2,
  S_MNTR_DIE3,
  S_MNTR_DIE4,
  S_MNTR_DIE5,
  S_MNTR_DIE6,
  S_MNTR_DIE7,
  S_MNTR_DIE8,
  S_MNTR_DIE9,
  S_MNTR_DIE10,
  S_MNTR_DIE11,
  S_MNTR_DIE12,
  S_MNTR_DIE13,
  S_MNTR_DIE14,
  S_MNTR_DIE15,
  // End Minotaurus Frames
  // MNTRFX1 -- Minotaur Attack 1
  S_MNTRFX1_1,
  S_MNTRFX1_2,
  S_MNTRFXI1_1,
  S_MNTRFXI1_2,
  S_MNTRFXI1_3,
  S_MNTRFXI1_4,
  S_MNTRFXI1_5,
  S_MNTRFXI1_6,
  // End MNTRFX1
  // haleyjd 1/23/99: Start MNTRFX2
  S_MNTRFX2_1,
  S_MNTRFXI2_1,
  S_MNTRFXI2_2,
  S_MNTRFXI2_3,
  S_MNTRFXI2_4,
  S_MNTRFXI2_5,
  // End MNTRFX2
  // Start MNTRFX3
  S_MNTRFX3_1,
  S_MNTRFX3_2,
  S_MNTRFX3_3,
  S_MNTRFX3_4,
  S_MNTRFX3_5,
  S_MNTRFX3_6,
  S_MNTRFX3_7,
  S_MNTRFX3_8,
  S_MNTRFX3_9,
  // End MNTRFX3
  // Start Phoenix Puff
  S_PHOENIXPUFF1,
  S_PHOENIXPUFF2,
  S_PHOENIXPUFF3,
  S_PHOENIXPUFF4,
  S_PHOENIXPUFF5,
  // End Phoenix Puff
  // Start Ambient Sounds
  S_SND_WIND,    // Wind - 2fx
  S_SND_WATER,   // Water
  S_SND_WATERFL, // Waterfall / rushing
  S_SND_LAUGH1,  // Laughing
  S_SND_DRIP,    // Dripping
  S_SND_FOREST,  // Forest collage
  S_SND_SWAMP,   // Swamp collage
  // End Ambient Sounds
  // Start Trees :)
  S_TRE3_1,     // swamp tree 1
  S_TRE4_1,     // swamp tree 2
  S_TRE5_1,     // autumn tree
  S_TRDT_1,     // fragile tree
  S_TRDT_DTH1,  // fragile tree death
  S_TRDT_DTH2,
  S_TRDT_DTH3,
  S_TRDT_DTH4,
  S_TRDT_DTH5,
  S_TRDT_DTH6,
  // End trees :)
  S_MOSS1,       // moss #1
  S_MOSS2,       // moss #2
  S_CLER_STND1,  // Cleric frames
  S_CLER_STND2,
  S_CLER_WALK1,
  S_CLER_WALK2,
  S_CLER_WALK3,
  S_CLER_WALK4,
  S_CLER_ATK1,
  S_CLER_ATK2,
  S_CLER_ATK3,
  S_CLER_PAIN,
  S_CLER_DTH1,
  S_CLER_DTH2,
  S_CLER_DTH3,
  S_CLER_DTH4,
  S_CLER_DTH5,
  S_CLER_DTH6,
  S_CLER_DTH7,
  S_CLER_DTH8,
  S_CLER_DTH9,
  S_CLER_XDTH1,
  S_CLER_XDTH2,
  S_CLER_XDTH3,
  S_CLER_XDTH4,
  S_CLER_XDTH5,
  S_CLER_XDTH6,
  S_CLER_XDTH7,
  S_CLER_XDTH8,
  S_CLER_XDTH9,
  S_CLER_XDTH10,
  S_CLER_RAISE1,
  S_CLER_RAISE2,
  S_CLER_RAISE3,
  S_CLER_RAISE4,
  S_CLER_RAISE5,
  S_CLER_RAISE6,
  S_CLER_RAISE7,
  S_CLER_RAISE8,
  S_CBAL_1,     // Cleric Projectile
  S_CBAL_2,
  S_CBAL_X1,
  S_CBAL_X2,
  S_CBAL_X3,
  S_CBAL_X4,
  S_ZFIREBULL1,
  S_ZFIREBULL2,
  S_ZFIREBULL3,
  S_ZFIREBULL4,
  S_ZFIREBULL5,
  S_ZFIREBULL6,
  S_ZFIREBULL7,
  S_ZFIREBULL_U,
  S_SPLASH1,
  S_SPLASH2,
  S_SPLASH3,
  S_SPLASH4,
  S_SPLASHX,
  S_SPLASHBASE1,
  S_SPLASHBASE2,
  S_SPLASHBASE3,
  S_SPLASHBASE4,
  S_SPLASHBASE5,
  S_SPLASHBASE6,
  S_SPLASHBASE7,
  S_SLUDGE1,
  S_SLUDGE2,
  S_SLUDGE3,
  S_SLUDGE4,
  S_SLUDGEX,
  S_SLUDGEBASE1,
  S_SLUDGEBASE2,
  S_SLUDGEBASE3,
  S_SLUDGEBASE4,
  S_SND_BUBBLE,  // more ambients
  S_SND_SHLURP,
  S_SND_ROCKS,
  S_SPAWNFOG1,  // fog spawning things
  S_FOGPATCHS1,
  S_FOGPATCHS2,
  S_FOGPATCHS3,
  S_FOGPATCHS4,
  S_FOGPATCHS5,
  S_FOGPATCHS0,
  S_FOGPATCHM1,
  S_FOGPATCHM2,
  S_FOGPATCHM3,
  S_FOGPATCHM4,
  S_FOGPATCHM5,
  S_FOGPATCHM0,
  S_FOGPATCHMA,
  S_FOGPATCHMB,
  S_FOGPATCHMC,
  S_FOGPATCHMD,
  S_FOGPATCHL1,
  S_FOGPATCHL2,
  S_FOGPATCHL3,
  S_FOGPATCHL4,
  S_FOGPATCHL5,
  S_FOGPATCHL0,
  S_FOGPATCHLA,
  S_FOGPATCHLB,
  S_FOGPATCHLC,
  S_FOGPATCHLD,
  S_LCLER_WALK1,
  S_LCLER_WALK2,
  S_LCLER_WALK3,
  S_LCLER_WALK4,
  S_LCLER_ATK1,
  S_LCLER_ATK2,
  S_LCLER_ATK3,
  S_LCLER_ATK4,
  S_LCLER_PAIN,
  S_LCLER_SPEC,
  S_LCLER_SPEC2,
  S_LCLER_SPEC3,
  S_LCLER_TELE1,
  S_LCLER_BREAK1,
  S_LCLER_BREAK2,
  S_LCLER_BREAK3,
  S_LCLER_BREAK4,
  S_LCLER_BREAK5,
  S_LCLER_BREAK6,
  S_LCLER_BREAK7,
  S_LCLER_BREAK8,
  S_LCLER_BREAK9,
  S_LCLER_BREAK10,
  S_BCOLUMN,
  S_WOODBARREL,
  S_TABLESTUFF1,
  S_TABLESTUFF2,
  S_SUITOFARMOR,
  S_TREESTUMP1,
  S_TREESTUMP2,
  S_HANGINGSKULL,
  S_SHORTGARGOYLE,
  S_TALLGARGOYLE,
  S_WALLTORCH1,
  S_WALLTORCH2,
  S_WALLTORCH3,
  S_CHANDELIER1,
  S_CHANDELIER2,
  S_CHANDELIER3,
  S_BIGSHROOM,
  S_CAULDRON_U,
  S_TABLESTUFF3,
  S_SWAMPVINE,
  S_CORPSEHANGINGMANGLED,
  S_CORPSESITTING,
  S_CORPSEIMPALED,
  S_CORPSEHANGING,
  S_TOMBSTONETALL,
  S_TOMBSTONERIP,
  S_TOMBSTONEANKH,
  S_ROCKSMALL,
  S_ROCKLARGE,
  S_TABLESTUFF4,
  S_TABLESTUFF5,
  S_GUARD1STAND,   // guard
  S_DWARFSTAND1,  // helper dwarf
  S_DWARFSTAND2,
  S_DWARFWALK1,
  S_DWARFWALK2,
  S_DWARFPAIN,
  S_DWARFDEATH1,
  S_DWARFDEATH2,
  S_DWARFDEATH3,
  S_DWARFDEATH4,
  S_DWARFDEATH5,
  S_DWARFATK1,
  S_DWARFREDAURA1,
  S_DWARFREDAURA2,
  S_DWARFREDAURA3,
  S_DWARFBLUEAURA1,
  S_DWARFBLUEAURA2,
  S_DWARFBLUEAURA3,
  S_DWARFGREENAURA1,
  S_DWARFGREENAURA2,
  S_DWARFGREENAURA3,
  S_DWARFPURPLEAURA1,
  S_DWARFPURPLEAURA2,
  S_DWARFPURPLEAURA3,
  S_DWARFATK2,
  S_DWARF1TALK1,
  S_GUARD2TALK1,
  S_CYBERGUARD1,
  S_CYBERGUARD2LOOK,
  S_CYBERGUARD2SEE,
  S_ALTDWARFSTAND1,
  S_ALTDWARFSTAND2,
  S_ALTDWARFWALK1,
  S_ALTDWARFWALK2,
  S_ALTDWARFPAIN,
  S_ALTDWARFDEATH1,
  S_ALTDWARFDEATH2,
  S_ALTDWARFDEATH3,
  S_ALTDWARFDEATH4,
  S_ALTDWARFDEATH5,
  S_ALTDWARFATTACK,
  S_GRENADEW,       // grenade gun frames
  S_GRENADEDOWN,
  S_GRENADEUP,
  S_GRENADE1,
  S_GRENADE2,
  S_GRENADE3,
  S_GRENADEFLASH1,
  S_GRENADEFLASH2,
  S_GRENADEFLASH3,
  S_GRENADEFLASH4,
  S_GRNDLAUNCHER,  // grenade launcher pickup gun
  S_GRENADEPICKUP, // grenade pickup ammo
  S_GRENADEFLIGHT, // grenade in flight
  S_PNS2_1,        // new blur sphere -- total invisibility
  S_PNS2_2,
  S_PNS2_3,
  S_PNS2_4,
  S_PHOENIXSHOT1,
  S_PHOENIXSHOTX1,
  S_PHOENIXSHOTX2,
  S_PHOENIXSHOTX3,
  S_PHOENIXSHOTX4,
  S_PHOENIXSHOTX5,
  S_AXEFALL1,
  S_AXEFALL2,
  S_AXEFALL3,
  S_AXEFALL4,
  S_STAFF_FALL1,
  S_STAFF_FALL2,
  S_STAFF_FALL3,
  S_GLITTER1,
  S_GLITTER2,
  S_GLITTER3,
  S_GLITTER4,
  S_GLITTER5,
  S_NECRONOMICON_A,
  S_KEY1,
  S_KEY2,
  S_KEY3,
  S_KEY4,
  S_KEY5,
  S_KEY6,
  S_KEY7,
  S_KEY8,
  S_KEY9,
  S_KEYA,
  S_KEYB,
  S_NEWSPIDER_STND,
  S_NEWSPIDER_STND2,
  S_NEWSPIDER_WALK1,
  S_NEWSPIDER_WALK2,
  S_NEWSPIDER_CHECK,
  S_NEWSPIDER_FIRE1,
  S_NEWSPIDER_FIRE2,
  S_NEWSPIDER_REFIRE,
  S_NEWSPIDER_DIE1,
  S_NEWSPIDER_DIE2,
  S_NEWSPIDER_DIE3,
  S_NEWSPIDER_DIE4,
  S_NEWSPIDER_DIE5,
  S_NEWSPIDER_DIE6,
  S_NEWSPIDER_DIE7,
  S_NEWSPIDER_DIE8,
  S_SND_CHAINS,
  S_SND_GONG,
  S_SND_LAVA,
  S_SND_AMB1,
  S_MUMHEAD_1,
  S_MUMHEAD_2,
  S_MUMHEAD_3,
  S_MUMHEAD_X1,
  S_MUMHEAD_X2,
  S_MUMHEAD_X3,
  S_MUMHEAD_X4,
  S_MUMMY_STAND1,
  S_MUMMY_STAND2,
  S_MUMMY_WALK1,
  S_MUMMY_WALK2,
  S_MUMMY_WALK3,
  S_MUMMY_WALK4,
  S_MUMMY_ATK1,
  S_MUMMY_ATK2,
  S_MUMMY_ATK3,
  S_MUMMY_ATK4,
  S_MUMMY_ATK5,
  S_MUMMY_ATK6,
  S_MUMMY_PAIN1,
  S_MUMMY_PAIN2,
  S_MUMMY_DIE1,
  S_MUMMY_DIE2,
  S_MUMMY_DIE3,
  S_MUMMY_DIE4,
  S_MUMMY_DIE5,
  S_MUMMY_DIE6,
  S_MUMMY_DIE7,
  S_MUMMY_DIE8,
  S_MUMMY_SOUL1,
  S_MUMMY_SOUL2,
  S_MUMMY_SOUL3,
  S_MUMMY_SOUL4,
  S_MUMMY_SOUL5,
  S_MUMMY_SOUL6,
  S_MUMMY_SOUL7,
  S_LAVASPLASH1,
  S_LAVASPLASH2,
  S_LAVASPLASH3,
  S_LAVASPLASH4,
  S_LAVASPLASH5,
  S_LAVASPLASH6,
  S_LAVASMOKE1,
  S_LAVASMOKE2,
  S_LAVASMOKE3,
  S_LAVASMOKE4,
  S_LAVASMOKE5,
  // End Eternity TC New Frame States
// joel: new COD objects
  S_COD_ROCK1,
  S_COD_TREE1,

// joel: Holy Cross states
  S_CROSS,
  S_CROSSDOWN,
  S_CROSSUP,
  S_CROSS1,
  S_CROSS2,
  S_CROSS3,
  S_CROSS4,
  S_CROSS5,

// joel: state for cross pickup
  S_CRSS,
// joel: new Cyberdemon
  S_CCYBER_STND,
  S_CCYBER_STND2,
  S_CCYBER_RUN1,
  S_CCYBER_RUN2,
  S_CCYBER_RUN3,
  S_CCYBER_RUN4,
  S_CCYBER_RUN5,
  S_CCYBER_RUN6,
  S_CCYBER_RUN7,
  S_CCYBER_RUN8,
  S_CCYBER_ATK1,
  S_CCYBER_ATK2,
  S_CCYBER_ATK3,
  S_CCYBER_ATK4,
  S_CCYBER_ATK5,
  S_CCYBER_ATK6,
  S_CCYBER_PAIN,
  S_CCYBER_DIE1,
  S_CCYBER_DIE2,
  S_CCYBER_DIE3,
  S_CCYBER_DIE4,
  S_CCYBER_DIE5,
  S_CCYBER_DIE6,
  S_CCYBER_DIE7,
  S_CCYBER_DIE8,
  S_CCYBER_DIE9,
  S_CCYBER_DIE10,
// joel: new Archvile
  S_CVILE_STND,
  S_CVILE_STND2,
  S_CVILE_RUN1,
  S_CVILE_RUN2,
  S_CVILE_RUN3,
  S_CVILE_RUN4,
  S_CVILE_RUN5,
  S_CVILE_RUN6,
  S_CVILE_RUN7,
  S_CVILE_RUN8,
  S_CVILE_RUN9,
  S_CVILE_RUN10,
  S_CVILE_RUN11,
  S_CVILE_RUN12,
  S_CVILE_ATK1,
  S_CVILE_ATK2,
  S_CVILE_ATK3,
  S_CVILE_ATK4,
  S_CVILE_ATK5,
  S_CVILE_ATK6,
  S_CVILE_ATK7,
  S_CVILE_ATK8,
  S_CVILE_ATK9,
  S_CVILE_ATK10,
  S_CVILE_ATK11,
  S_CVILE_HEAL1,
  S_CVILE_HEAL2,
  S_CVILE_HEAL3,
  S_CVILE_PAIN,
  S_CVILE_PAIN2,
  S_CVILE_DIE1,
  S_CVILE_DIE2,
  S_CVILE_DIE3,
  S_CVILE_DIE4,
  S_CVILE_DIE5,
  S_CVILE_DIE6,
  S_CVILE_DIE7,
  S_CVILE_DIE8,
  S_CVILE_DIE9,
  S_CVILE_DIE10,

// joel: ambient sounds
  S_BUZZ1,
  S_BUZZ2,
  S_COMP1,
  S_COMP2,
  S_DRIP1,
  S_DRIP2,
  S_AFIRE1,
  S_AFIRE2,
  S_LAVA1,
  S_LAVA2,
  S_RIVER1,
  S_RIVER2,
  S_WFALL1,
  S_WFALL2,
  S_WIND1,
  S_WIND2,
  S_WIND1_1,
  S_WIND1_2,

  S_HardAssZombieman_ATK1,
  S_HardAssZombieman_ATK2,
  S_HardAssZombieman_ATK3,

// joel: legion trigger guy death states
  S_TRIGGERPOSS_DIE1,
  S_TRIGGERPOSS_DIE2,
  S_TRIGGERPOSS_DIE3,
  S_TRIGGERPOSS_DIE4,
  S_TRIGGERPOSS_DIE5,

  S_TRIGGERSPOS_DIE1,
  S_TRIGGERSPOS_DIE2,
  S_TRIGGERSPOS_DIE3,
  S_TRIGGERSPOS_DIE4,
  S_TRIGGERSPOS_DIE5,

  S_TRIGGERSARG_DIE1,
  S_TRIGGERSARG_DIE2,
  S_TRIGGERSARG_DIE3,
  S_TRIGGERSARG_DIE4,
  S_TRIGGERSARG_DIE5,
  S_TRIGGERSARG_DIE6,

  S_TRIGGERTROO_DIE1,
  S_TRIGGERTROO_DIE2,
  S_TRIGGERTROO_DIE3,
  S_TRIGGERTROO_DIE4,
  S_TRIGGERTROO_DIE5,

  // joel: demon & spectre states the same

  S_TRIGGERSKULL_DIE1,
  S_TRIGGERSKULL_DIE2,
  S_TRIGGERSKULL_DIE3,
  S_TRIGGERSKULL_DIE4,
  S_TRIGGERSKULL_DIE5,
  S_TRIGGERSKULL_DIE6,

  S_TRIGGERHEAD_DIE1,
  S_TRIGGERHEAD_DIE2,
  S_TRIGGERHEAD_DIE3,
  S_TRIGGERHEAD_DIE4,
  S_TRIGGERHEAD_DIE5,
  S_TRIGGERHEAD_DIE6,

  S_TRIGGERBOSS_DIE1,
  S_TRIGGERBOSS_DIE2,
  S_TRIGGERBOSS_DIE3,
  S_TRIGGERBOSS_DIE4,
  S_TRIGGERBOSS_DIE5,
  S_TRIGGERBOSS_DIE6,
  S_TRIGGERBOSS_DIE7,

  S_TRIGGERCYBER_DIE1,
  S_TRIGGERCYBER_DIE2,
  S_TRIGGERCYBER_DIE3,
  S_TRIGGERCYBER_DIE4,
  S_TRIGGERCYBER_DIE5,
  S_TRIGGERCYBER_DIE6,
  S_TRIGGERCYBER_DIE7,
  S_TRIGGERCYBER_DIE8,
  S_TRIGGERCYBER_DIE9,
  S_TRIGGERCYBER_DIE10,

  S_TRIGGERSPID_DIE1,
  S_TRIGGERSPID_DIE2,
  S_TRIGGERSPID_DIE3,
  S_TRIGGERSPID_DIE4,
  S_TRIGGERSPID_DIE5,
  S_TRIGGERSPID_DIE6,
  S_TRIGGERSPID_DIE7,
  S_TRIGGERSPID_DIE8,
  S_TRIGGERSPID_DIE9,
  S_TRIGGERSPID_DIE10,
  S_TRIGGERSPID_DIE11,

  S_TRIGGERCPOS_DIE1,
  S_TRIGGERCPOS_DIE2,
  S_TRIGGERCPOS_DIE3,
  S_TRIGGERCPOS_DIE4,
  S_TRIGGERCPOS_DIE5,
  S_TRIGGERCPOS_DIE6,
  S_TRIGGERCPOS_DIE7,

  S_TRIGGERBOS2_DIE1,
  S_TRIGGERBOS2_DIE2,
  S_TRIGGERBOS2_DIE3,
  S_TRIGGERBOS2_DIE4,
  S_TRIGGERBOS2_DIE5,
  S_TRIGGERBOS2_DIE6,
  S_TRIGGERBOS2_DIE7,

  S_TRIGGERBSPI_DIE1,
  S_TRIGGERBSPI_DIE2,
  S_TRIGGERBSPI_DIE3,
  S_TRIGGERBSPI_DIE4,
  S_TRIGGERBSPI_DIE5,
  S_TRIGGERBSPI_DIE6,
  S_TRIGGERBSPI_DIE7,

  S_TRIGGERPAIN_DIE1,
  S_TRIGGERPAIN_DIE2,
  S_TRIGGERPAIN_DIE3,
  S_TRIGGERPAIN_DIE4,
  S_TRIGGERPAIN_DIE5,
  S_TRIGGERPAIN_DIE6,

  S_TRIGGERSKEL_DIE1,
  S_TRIGGERSKEL_DIE2,
  S_TRIGGERSKEL_DIE3,
  S_TRIGGERSKEL_DIE4,
  S_TRIGGERSKEL_DIE5,
  S_TRIGGERSKEL_DIE6,

  S_TRIGGERFATT_DIE1,
  S_TRIGGERFATT_DIE2,
  S_TRIGGERFATT_DIE3,
  S_TRIGGERFATT_DIE4,
  S_TRIGGERFATT_DIE5,
  S_TRIGGERFATT_DIE6,
  S_TRIGGERFATT_DIE7,
  S_TRIGGERFATT_DIE8,
  S_TRIGGERFATT_DIE9,
  S_TRIGGERFATT_DIE10,
// joel - new COD baron states
  S_CBOSS_STND,
  S_CBOSS_STND2,
  S_CBOSS_RUN1,
  S_CBOSS_RUN2,
  S_CBOSS_RUN3,
  S_CBOSS_RUN4,
  S_CBOSS_RUN5,
  S_CBOSS_RUN6,
  S_CBOSS_RUN7,
  S_CBOSS_RUN8,
  S_CBOSS_ATK1,
  S_CBOSS_ATK2,
  S_CBOSS_ATK3,
  S_CBOSS_PAIN,
  S_CBOSS_PAIN2,
  S_CBOSS_DIE1,
  S_CBOSS_DIE2,
  S_CBOSS_DIE3,
  S_CBOSS_DIE4,
  S_CBOSS_DIE5,
  S_CBOSS_DIE6,
  S_CBOSS_DIE7,
  S_CBOSS_RAISE1,
  S_CBOSS_RAISE2,
  S_CBOSS_RAISE3,
  S_CBOSS_RAISE4,
  S_CBOSS_RAISE5,
  S_CBOSS_RAISE6,
  S_CBOSS_RAISE7,

  NUMSTATES  // Counter of how many there are
} statenum_t;

// ********************************************************************
// Definition of the state (frames) structure
// ********************************************************************
typedef struct
{
  spritenum_t sprite;       // sprite number to show
  long        frame;        // which frame/subframe of the sprite is shown
  long        tics;         // number of gametics this frame should last
  void        (*action)();  // code pointer to function for action if any
  statenum_t  nextstate;    // linked list pointer to next state or zero
  long        misc1, misc2; // used for psprite positioning
} state_t;

// these are in info.c
extern state_t  states[NUMSTATES];
extern char *sprnames[];             // 1/17/98 killough

// ********************************************************************
// Thing enumeration -- must match info.c
// ********************************************************************
// Note that many of these are generically named for the ornamentals
//
typedef enum {
  MT_PLAYER,
  MT_POSSESSED,
  MT_SHOTGUY,
  MT_VILE,
  MT_FIRE,
  MT_UNDEAD,
  MT_TRACER,
  MT_SMOKE,
  MT_FATSO,
  MT_FATSHOT,
  MT_CHAINGUY,
  MT_TROOP,
  MT_SERGEANT,
  MT_SHADOWS,
  MT_HEAD,
  MT_BRUISER,
  MT_BRUISERSHOT,
  MT_KNIGHT,
  MT_SKULL,
  MT_SPIDER,
  MT_BABY,
  MT_CYBORG,
  MT_PAIN,
  MT_WOLFSS,
  MT_KEEN,
  MT_BOSSBRAIN,
  MT_BOSSSPIT,
  MT_BOSSTARGET,
  MT_SPAWNSHOT,
  MT_SPAWNFIRE,
  MT_BARREL,
  MT_TROOPSHOT,
  MT_HEADSHOT,
  MT_ROCKET,
  MT_PLASMA,
  MT_BFG,
  MT_ARACHPLAZ,
  MT_PUFF,
  MT_BLOOD,
  MT_TFOG,
  MT_IFOG,
  MT_TELEPORTMAN,
  MT_EXTRABFG,
  MT_MISC0,
  MT_MISC1,
  MT_MISC2,
  MT_MISC3,
  MT_MISC4,
  MT_MISC5,
  MT_MISC6,
  MT_MISC7,
  MT_MISC8,
  MT_MISC9,
  MT_MISC10,
  MT_MISC11,
  MT_MISC12,
  MT_INV,
  MT_MISC13,
  MT_INS,
  MT_MISC14,
  MT_MISC15,
  MT_MISC16,
  MT_MEGA,
  MT_CLIP,
  MT_MISC17,
  MT_MISC18,
  MT_MISC19,
  MT_MISC20,
  MT_MISC21,
  MT_MISC22,
  MT_MISC23,
  MT_MISC24,
  MT_MISC25,
  MT_CHAINGUN,
  MT_MISC26,
  MT_MISC27,
  MT_MISC28,
  MT_SHOTGUN,
  MT_SUPERSHOTGUN,
  MT_MISC29,
  MT_MISC30,
  MT_MISC31,
  MT_MISC32,
  MT_MISC33,
  MT_MISC34,
  MT_MISC35,
  MT_MISC36,
  MT_MISC37,
  MT_MISC38,
  MT_MISC39,
  MT_MISC40,
  MT_MISC41,
  MT_MISC42,
  MT_MISC43,
  MT_MISC44,
  MT_MISC45,
  MT_MISC46,
  MT_MISC47,
  MT_MISC48,
  MT_MISC49,
  MT_MISC50,
  MT_MISC51,
  MT_MISC52,
  MT_MISC53,
  MT_MISC54,
  MT_MISC55,
  MT_MISC56,
  MT_MISC57,
  MT_MISC58,
  MT_MISC59,
  MT_MISC60,
  MT_MISC61,
  MT_MISC62,
  MT_MISC63,
  MT_MISC64,
  MT_MISC65,
  MT_MISC66,
  MT_MISC67,
  MT_MISC68,
  MT_MISC69,
  MT_MISC70,
  MT_MISC71,
  MT_MISC72,
  MT_MISC73,
  MT_MISC74,
  MT_MISC75,
  MT_MISC76,
  MT_MISC77,
  MT_MISC78,
  MT_MISC79,
  MT_MISC80,
  MT_MISC81,
  MT_MISC82,
  MT_MISC83,
  MT_MISC84,
  MT_MISC85,
  MT_MISC86,
  MT_PUSH,    // controls push source                     // phares
  MT_PULL,    // controls pull source                     // phares 3/20/98

#ifdef DOGS
  MT_DOGS,    // killough 7/19/98: Marine's best friend
#endif

  MT_PLASMA1, // killough 7/11/98: first  of alternating beta plasma fireballs
  MT_PLASMA2, // killough 7/11/98: second of alternating beta plasma fireballs

        // sf: beta things removed
  MT_CAMERA,
  MT_PARTICLE,

// Start Eternity TC New Things
  MT_MINOTAUR,          // haleyjd 1/22/99: Minotaurus/Maulotaur
  MT_MNTRFX1,           // Minotaur attack 1
  MT_MNTRFX2,           // haleyjd 1/23/99: Minotaur attack 2
  MT_MNTRFX3,           // minotaur attack 3
  MT_PHOENIXPUFF,       // phoenix puff
  MT_SNDWIND,           // wind ambience
  MT_SNDWATER,          // water ambience
  MT_SNDWATER2,         // waterfall ambience
  MT_SNDLAUGH,          // laughing ambience
  MT_SNDDRIP,           // dripping ambience
  MT_SNDFOREST,         // forest ambience
  MT_SNDSWAMP,          // swamp ambience
  MT_TRE3,              // swamp tree 1
  MT_TRE4,              // swamp tree 2
  MT_TRE5,              // autumn tree
  MT_TRDT,              // fragile tree
  MT_MOSS1,             // moss #1
  MT_MOSS2,             // moss #2
  MT_CLERIC,            // cleric enemy
  MT_CLRBALL,           // cleric projectile
  MT_ZFIREBULL,         // bull torch, lit
  MT_ZFIREBULL_UNLIT,   // bull torch, unlit
  MT_SPLASH,            // water terrain splashes
  MT_SPLASHBASE,
  MT_SLUDGECHUNK,       // sludge terrain splashes
  MT_SLUDGEBASE,
  MT_SNDBUBBLE,         // more ambient sounds
  MT_SNDSHLURP,
  MT_SNDROCKS,
  MT_FOGSPAWNER,        // fog spawning things
  MT_FOGPATCHS,         
  MT_FOGPATCHM,
  MT_FOGPATCHL,
  MT_LEADERCLERIC,
  MT_BCOLUMN,
  MT_WBARREL,
  MT_HANGINGSKULL,
  MT_WALLTORCH,
  MT_CHANDELIER,
  MT_TABLESTUFF1,
  MT_TABLESTUFF2,
  MT_TABLESTUFF3,
  MT_TABLESTUFF4,
  MT_TABLESTUFF5,
  MT_SUITOFARMOR,
  MT_STUMP1,
  MT_STUMP2,
  MT_GARGOYLE1,
  MT_GARGOYLE2,
  MT_MUSHROOM,
  MT_CAULDRON_UNLIT,
  MT_SWAMPVINE,
  MT_NEWCORPSE1,
  MT_NEWCORPSE2,
  MT_NEWCORPSE3,
  MT_NEWCORPSE4,
  MT_TOMBSTONETALL,
  MT_TOMBSTONERIP,
  MT_TOMBSTONEANKH,
  MT_ROCK1,
  MT_ROCK2,
  MT_GUARD1,
  MT_DWARF,
  MT_DWARFDLG1,  // talking dwarf
  MT_GUARDDLG1,  // talking guard
  MT_CYBERGUARD1, // inert cyberguard
  MT_CYBERGUARD2, // cyberguard boss
  MT_ALTERDWARF,  // dwarf alterego
  MT_GRENADE,     // grenade in flight
  MT_GRENADEGUN,  // gun to pick up
  MT_GRENADEM15,  // ammo grenade
  MT_TOTALINVSPHERE,  // total invisibility powerup -- new blur sphere
  MT_PHOENIXSHOT,
  MT_BROKENAXE,   // items discarded by cyberguard
  MT_BROKENSTAFF,
  MT_SPARKLE,     // magic sparkle
  MT_NECRONOMICON_A,
  MT_KEY1,
  MT_KEY2,
  MT_KEY3,
  MT_KEY4,
  MT_KEY5,
  MT_KEY6,
  MT_KEY7,
  MT_KEY8,
  MT_KEY9,
  MT_KEYA,
  MT_KEYB,
  MT_NEWSPIDER,
  MT_SNDCHAINS,
  MT_SNDGONG,
  MT_SNDLAVA,
  MT_SNDAMB1,
  MT_MUMHEAD,
  MT_MUMMY,
  MT_MUMMYSOUL,
  // haleyjd: place holder objects
  MT_CLERICSPOT, // for leader cleric teleporting
  MT_HALIFSPOT,  // for halif's enemy teleport
  MT_CAMERANODE, // for camera moves
  MT_LAVASPLASH, // lava terraintype (finally)
  MT_LAVASMOKE,
// End Eternity TC New Things
// joel: new COD objects
  MT_CROSS,
  MT_CROCK1,
  MT_CTREE1,
// joel: new bad guys for COD
  MT_CPOSSESSED,
  MT_CSHOTGUY,
  MT_CCHAINGUY,
  MT_CSPIDER,
  MT_CKNIGHT,
  MT_CBRUISER,
  MT_CCYBORG,
  MT_CVILE,
// joel: ambient sounds
  MT_BUZZ,
  MT_COMP,
  MT_DRIP,
  MT_AFIRE,
  MT_LAVA,
  MT_RIVER,
  MT_WFALL,
  MT_WIND,
  MT_WIND1,
  HardAssZombieman, // joel: legion crew
  Trigger_Trooper,
  Trigger_ShotgunGuy,
  Trigger_Spectre,
  Trigger_Imp,
  Trigger_Demon,
  Trigger_LostSoul,
  Trigger_Cacodemon,
  Trigger_BaronOfHell,
  Trigger_Cyberdemon,
  Trigger_SpiderMastermind,
  Trigger_HeavyWeaponDude,
  Trigger_HellKnight,
  Trigger_Arachnatron,
  Trigger_PainElemental,
  Trigger_Revenant,
  Trigger_Mancubus,

  NUMMOBJTYPES  // Counter of how many there are

} mobjtype_t;

// ********************************************************************
// Definition of the Thing structure
// ********************************************************************
// Note that these are only indices to the state, sound, etc. arrays
// and not actual pointers.  Most can be set to zero if the action or
// sound doesn't apply (like lamps generally don't attack or whistle).

typedef struct
{
    int doomednum;    // Thing number used in id's editor, and now
                      //  probably by every other editor too
    int spawnstate;   // The state (frame) index when this Thing is
                      //  first created
    int spawnhealth;  // The initial hit points for this Thing
    int seestate;     // The state when it sees you or wakes up
    int seesound;     // The sound it makes when waking
    int reactiontime; // How many tics it waits after it wakes up
                      //  before it will start to attack, in normal
                      //  skills (halved for nightmare)
    int attacksound;  // The sound it makes when it attacks
    int painstate;    // The state to indicate pain
    int painchance;   // A number that is checked against a random
                      //  number 0-255 to see if the Thing is supposed
                      //  to go to its painstate or not.  Note this
                      //  has absolutely nothing to do with the chance
                      //  it will get hurt, just the chance of it
                      //  reacting visibly.
    int painsound;    // The sound it emits when it feels pain
    int meleestate;   // Melee==close attack
    int missilestate; // What states to use when it's in the air, if
                      //  in fact it is ever used as a missile
    int deathstate;   // What state begins the death sequence
    int xdeathstate;  // What state begins the horrible death sequence
                      //  like when a rocket takes out a trooper
    int deathsound;   // The death sound.  See also A_Scream() in
                      //  p_enemy.c for some tweaking that goes on
                      //  for certain monsters
    int speed;        // How fast it moves.  Too fast and it can miss
                      //  collision logic.
    int radius;       // An often incorrect radius
    int height;       // An often incorrect height, used only to see
                      //  if a monster can enter a sector
    int mass;         // How much an impact will move it.  Cacodemons
                      //  seem to retreat when shot because they have
                      //  very little mass and are moved by impact
    int damage;       // If this is a missile, how much does it hurt?
    int activesound;  // What sound it makes wandering around, once
                      //  in a while.  Chance is 3/256 it will.
    int flags;        // Bit masks for lots of things.  See p_mobj.h
    int flags2;       // More bit masks for lots of other things -- haleyjd
    int raisestate;   // The first state for an Archvile or respawn
                      //  resurrection.  Zero means it won't come
                      //  back to life.
} mobjinfo_t;

// See p_mobj_h for addition more technical info
extern mobjinfo_t mobjinfo[NUMMOBJTYPES];

#endif

//----------------------------------------------------------------------------
//
// $Log: info.h,v $
// Revision 1.10  1998/05/12  12:47:31  phares
// Removed OVER_UNDER code
//
// Revision 1.9  1998/05/06  11:31:53  jim
// Moved predefined lump writer info->w_wad
//
// Revision 1.8  1998/05/04  21:35:54  thldrmn
// commenting and reformatting
//
// Revision 1.7  1998/04/22  06:33:58  killough
// Add const to WritePredefinedLumpWad() parm
//
// Revision 1.6  1998/04/21  23:47:10  jim
// Predefined lump dumper option
//
// Revision 1.5  1998/03/23  15:24:09  phares
// Changed pushers to linedef control
//
// Revision 1.4  1998/03/09  18:30:43  phares
// Added invisible sprite for MT_PUSH
//
// Revision 1.3  1998/02/24  08:45:53  phares
// Pushers, recoil, new friction, and over/under work
//
// Revision 1.2  1998/01/26  19:27:02  phares
// First rev with no ^Ms
//
// Revision 1.1.1.1  1998/01/19  14:02:57  rand
// Lee's Jan 19 sources
//
//----------------------------------------------------------------------------
