#include "lightgen.h"
#include "util.h"
#include "wad.h"



std::vector<wSector_t *> AllDaySectors;
std::ofstream OutFile;

const int TagFor242 = 9999;
const int StartTag = 10000;
const int LightStartTag = 10000;
const int TransferStartTag = 15000;
const int StaticTag = 12000;

void LG_OpenOutFile()
{
	OutFile.open("output.wl", std::ios::out);
}

void LG_CloseOutFile()
{
	OutFile.close();
}

void LC_Exit(int code)
{
	exit(code);
}

void LG_ReadSectors(wFile_t *file, std::string mapname, std::vector<wSector_t *> &sects)
{
	const int SECTOR_SIZE = 26;
	// clear everything
	if (!sects.empty()) {
		for (std::vector<wSector_t *>::iterator it = sects.begin(); it != sects.end(); ++it) {
			delete *it;
			sects.erase(sects.begin());
		}
	}

	wEntry_t *sectors = Wad_FindEntry(file, "SECTORS",
		Wad_FindEntry(file, mapname.c_str(), NULL, false), false);
	if (sectors) {
		uint8_t *sectLump = (uint8_t *)malloc(sectors->size * sizeof(uint8_t)); // SECTORS's data
		fseek(file->file, sectors->offset, SEEK_SET);
		fread((void*)sectLump, 1, sectors->size, file->file); 

		for (size_t i = 0; i < sectors->size; i += SECTOR_SIZE) { //
			wSector_t *sector = new wSector_t;
			sector->FloorHeight = read2bytes_mem((void *)(sectLump + i));
			sector->CeilingHeight = read2bytes_mem((void *)(sectLump + i + 0x02));
			memcpy((void *)(sector->FloorTexture), (void *)(sectLump + i + 0x04), 8);
			memcpy((void *)(sector->CeilingTexture), (void *)(sectLump + i + 0x0C), 8);
			sector->Light = read2bytes_mem((void *)(sectLump + i + 0x14));
			sector->Tag = read2bytes_mem((void *)(sectLump + i + 0x18));
			if (sector->Tag >= StartTag) {
				sects.push_back(sector);
			} else {
				delete sector;
			}
			
		}
		delete [] sectLump;
	}
}

void LG_GenerateGeometry(std::vector<wSector_t *> daySects)
{
	const int dayintics = 1024;
	const int numsect = daySects.size();
	const int daytonight[] = {240, 224, 208, 192, 176, 160, 144, 128, 112};
	
	LG_OpenOutFile();
	OutFile << "#\"standard.h\"" << std::endl;
	OutFile << "#\"spawns.h\"" << std::endl;
	
	// Voodoo controller
	
	OutFile << "Voodoo_Evening(tag)" << std::endl;
	OutFile << "{" << std::endl;
	// vBoxSize - horizontal size of box, multiple of 32, rounded upward 
	OutFile << "set(\"vBoxSize\", mul(add(div(" << numsect << ", 32), 1), 32))" << std::endl;
	// number of voodoo dools
	OutFile << "set(\"voodoos\", div(get(\"vBoxSize\"), 32))" << std::endl;
	// first light to minimum neighbor
	OutFile << "typeline(157,tag, step(-32, 0))" << std::endl;
	// just lines to the end
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	// transfer light to minimum neighbor
	OutFile << "typeline(157,1099, step(-32, 0))" << std::endl;
	// just lines to the end
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	
	// determine current light level
	OutFile << "{eq(tag, 1002) ? set(\"lightlevel\", 113) : \
		{eq(tag, 1003) ? set(\"lightlevel\", 129) : \
		{eq(tag, 1004) ? set(\"lightlevel\", 145) : \
		{eq(tag, 1005) ? set(\"lightlevel\", 161) : \
		{eq(tag, 1006) ? set(\"lightlevel\", 177) : \
		{eq(tag, 1007) ? set(\"lightlevel\", 193) : \
		{eq(tag, 1008) ? set(\"lightlevel\", 209) : \
		{eq(tag, 1009) ? set(\"lightlevel\", 225) : \
		{eq(tag, 1010) ? set(\"lightlevel\", 241) : set(\"lightlevel\", 0)}}}}}}}}}" << std::endl;
	
	int counter = TransferStartTag;
	for (int i = 0; i < daySects.size(); ++i) {
		wSector_t &daysector = *daySects[i];

		OutFile << "{lessthaneq(" << daysector.Light << ", get(\"lightlevel\")) ? \
			movestep(-1, 0) : typeline(157," << counter++ << ", step(-1, 0))}" << std::endl; 
			 /*
		OutFile << "{lessthaneq(" << daysector.Light << ", get(\"lightlevel\")) ? \
			movestep(-1, 0) : typeline(157," << counter++ << ", step(-1, 0))}" << std::endl;*/
	}
	// just lines to the end
	OutFile << "step(inv(sub(get(\"vBoxSize\"), " << numsect <<")), 0)" << std::endl;
	// end
	
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	// next light transfer
	OutFile << "typeline(157, " << TagFor242 << ", step(-32, 0))" << std::endl;
	// just lines to the end
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), 30)" << std::endl;
	
	OutFile << "}" << std::endl;
	
	
	// Voodoo morning controller
	OutFile << "Voodoo_Morning(tag)" << std::endl;
	OutFile << "{" << std::endl;
	// vBoxSize - horizontal size of box, multiple of 32, rounded upward 
	OutFile << "set(\"vBoxSize\", mul(add(div(" << numsect << ", 32), 1), 32))" << std::endl;
	// number of voodoo dools
	OutFile << "set(\"voodoos\", div(get(\"vBoxSize\"), 32))" << std::endl;
	OutFile << "typeline(80,tag, step(-32, 0))" << std::endl;
	// just lines to the end
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	// transfer light to minimum neighbor
	OutFile << "typeline(80,1099, step(-32, 0))" << std::endl;
	// just lines to the end
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	
	// determine current light level
	OutFile << "{eq(tag, 1003) ? set(\"lightlevel\", 127) : \
		{eq(tag, 1004) ? set(\"lightlevel\", 143) : \
		{eq(tag, 1005) ? set(\"lightlevel\", 159) : \
		{eq(tag, 1006) ? set(\"lightlevel\", 175) : \
		{eq(tag, 1007) ? set(\"lightlevel\", 191) : \
		{eq(tag, 1008) ? set(\"lightlevel\", 207) : \
		{eq(tag, 1009) ? set(\"lightlevel\", 223) : \
		{eq(tag, 1010) ? set(\"lightlevel\", 239) : \
		{eq(tag, 1011) ? set(\"lightlevel\", 254) : set(\"lightlevel\", 0)}}}}}}}}}" << std::endl;
	
	counter = TransferStartTag;
	for (int i = 0; i < daySects.size(); ++i) {
		wSector_t &daysector = *daySects[i];
		OutFile << "{lessthaneq(" << daysector.Light << ", get(\"lightlevel\")) ? \
			movestep(-1, 0) : typeline(80," << counter++ << ", step(-1, 0))}" << std::endl; 
	}
	// just lines to the end
	OutFile << "step(inv(sub(get(\"vBoxSize\"), " << numsect <<")), 0)" << std::endl;
	// end
	OutFile << "movestep(get(\"vBoxSize\"), -1)" << std::endl;
	// next light transfer
	OutFile << "typeline(80, " << TagFor242 << ", step(-32, 0))" << std::endl;
	// just lines to the end
	OutFile << "for(2,get(\"voodoos\"),step(-32, 0))" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), 30)" << std::endl;
	
	OutFile << "}" << std::endl;
	
	
	OutFile << "GenVoodooController" << std::endl;
	OutFile << "{" << std::endl;
	OutFile << "set(\"vBoxSize\", mul(add(div(" << daySects.size() << ", 32), 1), 32))" << std::endl;
	OutFile << "set(\"voodoos\", div(get(\"vBoxSize\"), 32))" << std::endl;
	OutFile << "movestep(0, " << dayintics <<")" << std::endl;
	OutFile << "movestep(-16, -64)" << std::endl;	
	
	OutFile << "Voodoo_Morning(1011)" << std::endl;
	OutFile << "Voodoo_Morning(1010)" << std::endl;
	OutFile << "Voodoo_Morning(1009)" << std::endl;
	OutFile << "Voodoo_Morning(1008)" << std::endl;
	OutFile << "Voodoo_Morning(1007)" << std::endl;
	OutFile << "Voodoo_Morning(1006)" << std::endl;
	OutFile << "Voodoo_Morning(1005)" << std::endl;
	OutFile << "Voodoo_Morning(1004)" << std::endl;
	for (int i = 0; i < daySects.size(); ++i) {
		wSector_t &daysector = *daySects[i];
		OutFile << "typeline(157,"<<TransferStartTag+i <<", step(-1, 0))" << std::endl;
	}
	OutFile << "step(inv(sub(get(\"vBoxSize\"), " << numsect <<")), 0)" << std::endl;
	OutFile << "movestep(get(\"vBoxSize\"), 10)" << std::endl;
	
	
	OutFile << "typeline(157,1000, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1001, step(-1, 0))"  << std::endl;
	OutFile << "typeline(157,1002, step(-1, 0))"  << std::endl;
	OutFile << "typeline(157,1003, step(-1, 0))"  << std::endl;
	OutFile << "typeline(157,1004, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1005, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1006, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1007, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1008, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1009, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1010, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1011, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,1099, step(-1, 0))" << std::endl;
	OutFile << "typeline(157,9999, step(-1, 0))" << std::endl;
	OutFile << "movestep(inv(sub(get(\"vBoxSize\"), " << 14 <<")), 0)" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), 10)" << std::endl;
	
	
	OutFile << "Voodoo_Evening(1003)" << std::endl;
	OutFile << "Voodoo_Evening(1004)" << std::endl;
	OutFile << "Voodoo_Evening(1005)" << std::endl;
	OutFile << "Voodoo_Evening(1006)" << std::endl;
	OutFile << "Voodoo_Evening(1007)" << std::endl;
	OutFile << "Voodoo_Evening(1008)" << std::endl;
	OutFile << "Voodoo_Evening(1009)" << std::endl;
	OutFile << "Voodoo_Evening(1010)" << std::endl;
	for (int i = 0; i < daySects.size(); ++i) {
		wSector_t &daysector = *daySects[i];
		OutFile << "typeline(81,"<<TransferStartTag+i <<", step(-1, 0))" << std::endl;
	}
	OutFile << "step(inv(sub(get(\"vBoxSize\"), " << numsect <<")), 0)" << std::endl;
	OutFile << "movestep(get(\"vBoxSize\"), 10)" << std::endl;
	
	OutFile << "typeline(81,1000, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1001, step(-1, 0))"  << std::endl;
	OutFile << "typeline(81,1002, step(-1, 0))"  << std::endl;
	OutFile << "typeline(81,1003, step(-1, 0))"  << std::endl;
	OutFile << "typeline(81,1004, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1005, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1006, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1007, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1008, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1009, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1010, step(-1, 0))" << std::endl;
	OutFile << "typeline(81,1011, step(-1, 0))" << std::endl;
	OutFile << "movestep(inv(sub(get(\"vBoxSize\"), " << 12 <<")), 0)" << std::endl;
	// one mappixel further
	OutFile << "movestep(get(\"vBoxSize\"), 1)" << std::endl;
	OutFile << "movestep(0, 64)" << std::endl;
	
	
	
	OutFile << "movestep(0, inv(add(get(\"vBoxSize\"), 1)))" << std::endl;
	
	OutFile << "typesector(0, 1012, " << std::endl;
	OutFile << "step(add(get(\"vBoxSize\"), 2), 0)" << std::endl;
	OutFile << "step(0, "<< dayintics <<")" << std::endl;
	OutFile << "step(inv(add(get(\"vBoxSize\"), 2)), 0)" << std::endl;
	OutFile << "step(0, inv("<< dayintics <<"))" << std::endl;
	OutFile << "rightsector(0, 128, 255) )" << std::endl;
	OutFile << "movestep(0, "<< dayintics <<")" << std::endl;
	OutFile << "typeline(252,1012, step(0, -64))" << std::endl;
	OutFile << "player1start" << std::endl;
	OutFile << "movestep(17, 0)" << std::endl;
	OutFile << "for(1,get(\"voodoos\"), thing movestep(32, 0))" << std::endl;
	OutFile << "}" << std::endl;
	LG_CloseOutFile();
	
	int sectorcount = 0;
	int filecount = 0;
	int count = 0;
	const int MaxSects = 100;
	counter = TransferStartTag;
	for (std::vector<wSector_t *>::iterator it = daySects.begin(); it != daySects.end(); ++it) {
		if (count % MaxSects == 0) {
			if (OutFile.is_open()) {
				OutFile << "}" << std::endl;
				OutFile << "main {" << std::endl;
				OutFile << "rotright" << std::endl;
				OutFile << "GetLightManager"<<filecount << std::endl;
				OutFile << "}" << std::endl;
				++filecount;
				
				OutFile.close();
			}
			std::string str("sector");
			str.append(std::to_string(filecount));
			str.append(".wl");
			OutFile.open(str, std::ios::out);
			OutFile << "#\"standard.h\"" << std::endl;
			OutFile << "#\"spawns.h\"" << std::endl;
			OutFile << "GetLightManager" << filecount << std::endl;
			OutFile << "{" << std::endl;
			OutFile << "top(\"SKY1\")" << std::endl;
			OutFile << "step(24, 0)" << std::endl;
			OutFile << "step(0, " << 2*(MaxSects+50)+1 << ")" << std::endl;
			OutFile << "step(-24, 0)" << std::endl;
			OutFile << "step(0," << -(2*(MaxSects+50)+1) <<")" << std::endl;
			OutFile << "typesector(0, 1099, rightsector(-10000, 10000, 255))" << std::endl;
		}
		
		
		wSector_t &sector = **it;
		OutFile << "step(-1, 0)" << std::endl;
		OutFile << "typeline(213, " << sector.Tag << ", step(1, 1))" << std::endl;
		OutFile << "step(0, -1)" << std::endl;
		OutFile << "typesector(0, " << (sector.Tag >= StaticTag ? 6666 : counter) << ", leftsector(-10000, 10000, 255))" << std::endl;
		OutFile << "movestep(-1, 0)" << std::endl;
		OutFile << "typeline(271, " << sector.Tag << ", step(-1, 1))" << std::endl;
		OutFile << "typeline(242, " << sector.Tag << ", step(1, 0))" << std::endl;
		OutFile << "typeline(261, " << sector.Tag << ", step(1, 0))" << std::endl;
		OutFile << "typeline(213, " << sector.Tag << ", step(-1, -1))" << std::endl;
		OutFile << "floor(\"";
		OutFile.write(sector.FloorTexture, std::min<int>(8, strlen(sector.FloorTexture)));
		OutFile << "\")" << std::endl;
		OutFile << "ceil(\"";
		OutFile.write(sector.CeilingTexture, std::min<int>(8, strlen(sector.CeilingTexture)));
		OutFile << "\")" << std::endl;
		OutFile << "typesector(0," << (sector.Tag >= StaticTag ? 0 : TagFor242) << ", leftsector("
			<< sector.FloorHeight + 1 << ", " << sector.FloorHeight + 1 << ", " << sector.Light<<"))" << std::endl;
		OutFile << "movestep(1, 2)" << std::endl;
		++count;
		++counter;
	}

	if (OutFile.is_open()) {
		OutFile << "}" << std::endl;
		OutFile << "main {" << std::endl;
		OutFile << "rotright" << std::endl;
		OutFile << "GetLightManager"<<filecount << std::endl;
		OutFile << "}" << std::endl;
		OutFile.close();
	}
	
}

static void Usage()
{
	fprintf(stdout, "Usage: boomlightgen [OPTIONS] mapname daywad\n");
	
	fprintf(stdout, "  mapname\t Map to use\n");
	fprintf(stdout, "  daywad\t Wad used for day light\n");
} 

int LG_Main(int argc, char **argv)
{
	fprintf(stdout, "boomlightgen 0.1 by cybermind - a tool to generate realistic day/night cycle for Boom wads.\n");
	if (argc < 3) {
		Usage();
		system("pause");
		LC_Exit(1);
	}
	std::string mapname(argv[1]);
	std::string daywad(argv[2]);
	wFile_t *daywadfile = Wad_Open(daywad.c_str());
	if (!daywadfile) {
		LC_Exit(1);
	}

	LG_ReadSectors(daywadfile, mapname, AllDaySectors);
	fprintf(stdout, "daysectors: %d\n", AllDaySectors.size());	
	
	LG_GenerateGeometry(AllDaySectors);
	fprintf(stdout, "done\n");
	return 0;
} 

int main(int argc, char **argv)
{
	return LG_Main(argc, argv);
}