#define SPIDERPOINTCOUNT 4

#define DESCENTSPEED    24
#define DESCENTHEIGHT   256

#define SPAWND_MIN      35
#define SPAWND_MAX      140

#define PAD_ARMORY  0
#define PAD_HEALTH  1

int WithSamsara = 0;
int WithLelweps = 0;

#define ITEMCOUNT 24

#define I_HEALTHBONUS        0
#define I_STIMPACK           1
#define I_MEDIKIT            2
#define I_SOULSPHERE         3
#define I_ARMORBONUS         4
#define I_GREENARMOR         5
#define I_BLUEARMOR          6
#define I_CLIP               7
#define I_SHELL              8
#define I_ROCKET             9
#define I_CELL               10
#define I_CLIPBOX            11
#define I_SHELLBOX           12
#define I_ROCKETBOX          13
#define I_CELLBOX            14
#define I_BACKPACK           15
#define I_CHAINSAW           16
#define I_SHOTGUN            17
#define I_SUPERSHOTGUN       18
#define I_CHAINGUN           19
#define I_ROCKETLAUNCHER     20
#define I_PLASMARIFLE        21
#define I_BFG9000            22
#define I_MEGASPHERE         23

int SpawnableItems[ITEMCOUNT][2] = 
{
    {"HealthBonus",         "Health Bonus"},
    {"Stimpack",            "Stimpack"},
    {"Medikit",             "Medikit"},
    {"Soulsphere",          "Soulsphere"},

    {"ArmorBonus",          "Armor Bonus"},
    {"GreenArmor",          "Green Armor"},
    {"BlueArmor",           "Blue Armor"},

    {"Clip",                "Clip"},
    {"Shell",               "Shells"},
    {"RocketAmmo",          "Rocket"},
    {"Cell",                "Minor cell"},

    {"ClipBox",             "Box of bullets"},
    {"ShellBox",            "Box of shells"},
    {"RocketBox",           "Box of rockets"},
    {"CellPack",            "Major cell"},

    {"Backpack",            "Backpack"},

    {"Chainsaw",            "Communicator"},
    {"Shotgun",             "Shotgun"},
    {"SuperShotgun",        "Super Shotgun"},
    {"Chaingun",            "Chaingun"},
    {"RocketLauncher",      "Rocket launcher"},
    {"PlasmaRifle",         "Plasma Rifle"},
    {"BFG9000",             "BFG9000!"},

    {"Megasphere",          "Megasphere"},
};

int SamsaraItems[ITEMCOUNT][3] =
{
    {0,                         0, 0},
    {0,                         0, 0},
    {0,                         0, 0},
    {0,                         0, 0},

    {0,                         0, 0},
    {0,                         0, 0},
    {0,                         0, 0},

    {0,                         0, 0},
    {0,                         0, 0},
    {0,                         0, 0},
    {0,                         0, 0},

    {0,                         0, 0},
    {0,                         0, 0},
    {0,                         0, 0},
    {0,                         0, 0},

    {0,                         0, 0},

    {"SamsaraSlotOnePickup",    "Slot I",       "GotWeapon0"},
    {"SamsaraSlotTwoPickup",    "Slot II",      "GotWeapon2"},
    {"SamsaraSlotThreePickup",  "Slot III",     "GotWeapon3"},
    {"SamsaraSlotFourPickup",   "Slot IV",      "GotWeapon4"},
    {"SamsaraSlotFivePickup",   "Slot V",       "GotWeapon5"},
    {"SamsaraSlotSixPickup",    "Slot VI",      "GotWeapon6"},
    {"SamsaraSlotSevenPickup",  "Slot VII",     "GotWeapon7"},

    {0,                         0, 0},
};

#define LELCOUNT 5

int LelwepsItems[ITEMCOUNT][LELCOUNT] =
{
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 

    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 

    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 

    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 
    {0, 0, 0, 0, 0}, 

    {0, 0, 0, 0, 0}, 

    {"Quaker",              "Abortion Shotgun",         "Pist'o'l",             "Launcher Pistol",      0},
    {"Confetti Shotgun",    "Phalanx",                  "Super Spheregun",      "Fireball Shotgun",     "Shotgun Breeder"},
    {"Super Noclip",        "Super Rocket Shotgun",     "Super Healgun",        "Permaflamewall",       "Healing Pistol"},
    {"Storm Bolter",        "Bolter",                   "Flame Chaingun",       "Lul",                  "Jump Pads"},
    {"WTRL",                "ClusterGrenadeLauncher",   "FireGrenadeLauncher",  "Harbinger",            "BlackHole_Generator"},
    {"Geo-Maker",           "LGD1",                     "Lasgun",               "IceAgeCannon",         "VorpalBlade"},
    {"Holowall Spawner",    "Powerful",                 "IonCannon",            "TCBPR",                0},

    {0,                         0, 0, 0},
};

// Second argument - don't deplete pool when spawned?

int ItemPads[ITEMCOUNT][2] = 
{
    {PAD_HEALTH,    0},
    {PAD_HEALTH,    0},
    {PAD_HEALTH,    0},
    {PAD_HEALTH,    0},
    {PAD_HEALTH,    0},
    {PAD_HEALTH,    0},
    {PAD_HEALTH,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    0},
    {PAD_ARMORY,    1},
    {PAD_ARMORY,    1},
    {PAD_ARMORY,    1},
    {PAD_ARMORY,    1},
    {PAD_ARMORY,    1},
    {PAD_ARMORY,    1},
    {PAD_ARMORY,    1},
    {PAD_ARMORY,    1},
    {PAD_HEALTH,    0},
};

int ItemPoints[ITEMCOUNT] = {0};
int ItemsSpawned[ITEMCOUNT] = {0};

// First index is the item index
// Second index is the amount spawned
// Third index is the tic on which the last item was spawned

int ItemDisplayMessages[ITEMCOUNT][3];

#define MONSTERCOUNT        18
#define MONSTERITEMCOUNT    7

int MonsterScale;
int FutilityScore;

int SpiderPoints[SPIDERPOINTCOUNT] = 
{
    103, 104, 105, 106
};

int MonsterNames[MONSTERCOUNT] = 
{
    "Zombieman",
    "ShotgunGuy",
    "ChaingunGuy",
    "DoomImp",
    "Demon",
    "Spectre",
    "Cacodemon",
    "LostSoul",
    "PainElemental",
    "Revenant",
    "HellKnight",
    "Arachnotron",
    "Fatso",
    "BaronOfHell",
    "Archvile",
    "SpiderMastermind",
    "Cyberdemon",
    "WolfensteinSS",
};

// Argument meanings:
//  0 - minimum monster points needed to spawn this monster
//  1 - can it only spawn at spider pads?
//  2 - how many monster points are given for killing this monster

int MonsterCosts[MONSTERCOUNT][3] = 
{
    {0,      0, 2},
    {15,     0, 4},
    {50,     0, 8},
    {25,     0, 5},
    {50,     0, 10}, 
    {80,     0, 10}, 
    {150,    0, 20},
    {50,     0, 10},
    {500,    0, 25},
    {200,    0, 60},
    {200,    0, 40},
    {250,    0, 40},
    {300,    0, 50},
    {400,    0, 60},
    {1500,   0, 100},
    {1500,   1, 200},
    {2500,   0, 250},
    {35,     0, 5},
};

int MonsterItems[MONSTERCOUNT][1 + (MONSTERITEMCOUNT * 3)] = 
{
    //                          1                        2                            3                            4                                5                               6                               7
    /* Zombieman         */ {4, I_SHELL,     5,   12,    I_HEALTHBONUS,   95,  125,   I_SHOTGUN,       10,  20,    I_ROCKET,            2,   4}, 
    /* Shotgun guy       */ {6, I_STIMPACK,  35,  50,    I_GREENARMOR,    3,   6,     I_SHOTGUN,       100, 100,   I_CLIP,              30,  45,    I_ROCKET,       4,   8,         I_BACKPACK,         1,  1},
    /* Chaingun guy      */ {6, I_STIMPACK,  75,  100,   I_SHELL,         15,  35,    I_CHAINGUN,      100, 100,   I_GREENARMOR,        5,   10,    I_ROCKET,       10,  20,        I_BACKPACK,         1,  3},
    /* Imp               */ {5, I_SHELL,     8,   15,    I_STIMPACK,      40,  40,    I_SHOTGUN,       100, 100,   I_CLIP,              30,  50,    I_ROCKET,       15,  25},
    /* Demon             */ {7, I_SHELL,     20,  35,    I_GREENARMOR,    5,   10,    I_SUPERSHOTGUN,  15,  35,    I_CHAINSAW,          100, 100,   I_CLIP,         80,  120,       I_ROCKETLAUNCHER,   5,  15,     I_ROCKET,       30, 50},
    /* Spectre           */ {7, I_SHELL,     25,  40,    I_STIMPACK,      30,  45,    I_GREENARMOR,    6,   12,    I_SUPERSHOTGUN,      20,  40,    I_CLIP,         90,  130,       I_ROCKETLAUNCHER,   8,  18,     I_ROCKET,       40, 60},
    /* Cacodemon         */ {7, I_SHELL,     65,  85,    I_STIMPACK,      40,  60,    I_SUPERSHOTGUN,  35,  50,    I_ROCKETLAUNCHER,    15,  30,    I_ROCKET,       40,  55,        I_CELL,             20, 35,     I_PLASMARIFLE,  8,  13},
    /* Lost soul         */ {4, I_SHELL,     5,   15,    I_CLIP,          25,  35,    I_HEALTHBONUS,   340, 430,   I_CHAINGUN,          50,  100,   I_SUPERSHOTGUN, 1,   4,         I_BACKPACK,         3,  5},
    /* Pain elemental    */ {5, I_SHELL,     120, 150,   I_MEDIKIT,       55,  85,    I_BLUEARMOR,     30,  55,    I_CELL,              85,  105,   I_PLASMARIFLE,  100, 100},
    /* Revenant          */ {6, I_SHELL,     70,  130,   I_MEDIKIT,       90,  120,   I_BLUEARMOR,     20,  35,    I_ROCKETLAUNCHER,    25,  35,    I_ROCKET,       75,  95,        I_BACKPACK,         15, 35},
    /* Hell knight       */ {6, I_SHELL,     140, 180,   I_STIMPACK,      150, 210,   I_ROCKET,        50,  70,    I_ROCKETLAUNCHER,    20,  30,    I_CELL,         40,  0,         I_PLASMARIFLE,      15, 20},
    /* Arachnotron       */ {6, I_SHELL,     80,  120,   I_MEDIKIT,       90,  125,   I_ROCKET,        120, 150,   I_CELL,              40,  60,    I_PLASMARIFLE,  30,  40,        I_BFG9000,          5,  10},
    /* Fatso             */ {5, I_ROCKET,    180, 250,   I_MEDIKIT,       60,  90,    I_CELL,          80,  120,   I_PLASMARIFLE,       30,  35,    I_BFG9000,      5,   10},
    /* Baron of Hell     */ {6, I_ROCKET,    240, 400,   I_CELL,          240, 300,   I_MEDIKIT,       100, 150,   I_ROCKETLAUNCHER,    100, 100,   I_PLASMARIFLE,  100, 100,       I_BFG9000,          15, 25},
    /* Arch-Vile         */ {5, I_ROCKET,    200, 300,   I_CELL,          200, 350,   I_SOULSPHERE,    105, 185,   I_PLASMARIFLE,       100, 100,   I_BFG9000,      25,  40},
    /* Spider mastermind */ {4, I_CELLBOX,   150, 225,   I_SOULSPHERE,    185, 245,   I_BLUEARMOR,     65,  95,    I_BFG9000,           40,  65},
    /* Cyberdemon        */ {4, I_CELLBOX,   200, 325,   I_SOULSPHERE,    200, 270,   I_MEGASPHERE,    40,  65,    I_BFG9000,           50,  75},
    /* Nazi              */ {5, I_SHELL,     15,  25,    I_HEALTHBONUS,   120, 300,   I_CHAINGUN,      35,  55,    I_ROCKET,            8,   16,    I_BACKPACK,     1,   2},
};

#define IGNORECOUNT 63
int IgnorableItems[IGNORECOUNT] =
{
    "MapSpot" , "MapSpotGravity", "Clip", "Shell", "RocketAmmo", "Cell",
    "ClipBox", "ShellBox", "RocketBox", "Cellpack", "Chainsaw", "Shotgun",
    "SuperShotgun", "Chaingun", "RocketLauncher", "PlasmaRifle", "BFG9000",
    "Stimpack", "Medikit", "Berserk", "Soulsphere", "Blursphere", "Megasphere",
    "InvulnerabilitySphere", "PointLightAdditive", "PointLightFlicker",
    "PointLightFlickerAdditive", "PointLightFlickerSubtractive",
    "PointLightFlickerRandom", "PointLightFlickerRandomAdditive",
    "PointLightFlickerRandomSubtractive", "PointLightPulse",
    "PointLightPulseAdditive", "PointLightPulseSubtractive",
    "PointLightSubtractive", "SectorPointLight", "SectorPointLightAdditive",
    "SectorPointLightSubtractive", "Blood", "BulletPuff", "Rocket", "PlasmaBall",
    "BFGBall",

    // Samsara shit
    
    "SamsaraSlotOnePickup", "SamsaraSlotOneDrop",
    "SamsaraSlotTwoPickup", "SamsaraSlotTwoDrop",
    "SamsaraSlotThreePickup", "SamsaraSlotThreeDrop",
    "SamsaraSlotFourPickup", "SamsaraSlotFourDrop",
    "SamsaraSlotFivePickup", "SamsaraSlotFiveDrop",
    "SamsaraSlotSixPickup", "SamsaraSlotSixDrop",
    "SamsaraSlotSevenPickup", "SamsaraSlotSevenDrop",
    "SamsaraUniquePickup1", "SamsaraUniquePickup2",
    "Clip2", "ShotgunDrop", "ChingunDrop",

    // Lelweps shit
    
    "Confetti Shotgun",
};

int PossibleMonsters[MONSTERCOUNT];

int MinimapIDCounter = 100;

#define MAP_ORIGIN_X        (-5120.0)
#define MAP_ORIGIN_Y        (4608.0)

#define MAP_WIDTH           (9728.0)
#define MAP_HEIGHT          (9728.0)

#define MINIMAP_WIDTH       256
#define MINIMAP_HEIGHT      256

#define MINIMAP_SCALE_X     0.75
#define MINIMAP_SCALE_Y     0.75

#define MINIMAP_ORIGIN_X    50.1
#define MINIMAP_ORIGIN_Y    70.1
