#include "zcommon.acs"

#include "futilitydefs.h"
#include "futilityfuncs.h"

int IsServer = 0;

script 1 open
{
    int i, oldScore;
    int hudx, hudy, x, y;
    int testtid = unusedTID(3500, 10500);

    IsServer = 1;

    if (Spawn("CalmYoLegsDuke", 320.0, 0, 16.0, testtid))
    {
        Thing_Remove(testtid);
        WithSamsara = 1;
    }

    if (Spawn("WTRL", 320.0, 0, 16.0, testtid))
    {
        Thing_Remove(testtid);
        WithLelweps = 1;
    }

    MonsterScale = 10;
    
    Sector_SetFloorPanning(1, 32, 0, 32, 0);
    Sector_SetFloorPanning(2, 32, 0, 0,  0);
    Sector_SetFloorPanning(3, 0,  0, 32, 0);
    
    Sector_SetRotation(7, 90, 90);
    Sector_SetFloorPanning(7, 0, 0, 16, 0);
    Sector_SetCeilingPanning(7, 0, 0, 16, 0);
    
    Sector_SetRotation(8, 90, 90);
    Sector_SetFloorPanning(8, 0, 0, -16, 0);
    Sector_SetCeilingPanning(8, 0, 0, -16, 0);

    Sector_SetLink(9,  10, 0, 1);
    Sector_SetLink(11, 12, 0, 1);
    
    Light_Glow(4, 160, 224, 36);
    Light_Glow(5, 160, 192, 36);
    Light_Glow(6, 160, 176, 36);
    
    ACS_ExecuteWithResult(2, 101, 101, 112);
    ACS_ExecuteWithResult(2, 102, 121, 131);
    ACS_ExecuteWithResult(2, 107, 141, 158);
    ACS_ExecuteWithResult(2, 108, 161, 177);
    ACS_ExecuteWithResult(2, 111, 180, 204);

    // spider points
    ACS_ExecuteWithResult(2, 103, 502, 502);
    ACS_ExecuteWithResult(2, 104, 503, 503);
    ACS_ExecuteWithResult(2, 105, 504, 504);
    ACS_ExecuteWithResult(2, 106, 501, 501);

    for (i = 0; i < ITEMCOUNT; i++)
    {
        Futility_RemoveItemDisplay(i);
    }

    while (1)
    {
        Futility_SpawnItems();
        Futility_DisplayItems();

        SetHudSize(800, 600, 1);

        if (Timer() % 36 == 0 || oldScore != FutilityScore)
        {
            hudx = FixedDiv(1024, MINIMAP_SCALE_X);
            hudy = FixedDiv(768,  MINIMAP_SCALE_Y);

            SetFont("SMALLFONT");

            x = itof(ftoi(MINIMAP_ORIGIN_X)) + itof(MINIMAP_WIDTH/2);  // X center of text == X center of minimap
            y = itof(ftoi(MINIMAP_ORIGIN_Y)) + itof(MINIMAP_HEIGHT) + 18.0;  // right below minimap

            x /= hudx; x *= 800; x = itof(ftoi(x)) + 0.4;
            y /= hudy; y *= 600; y = itof(ftoi(y));
            
            SetHudSize(800, 600, 1);
            HudMessage(s:"SCORE"; HUDMSG_PLAIN, 2501, CR_GOLD, x, y, 2.0);
            
            HudMessage(d:FutilityScore; HUDMSG_PLAIN, 2502, CR_WHITE, x, y + 16.0, 2.0);
        }

        if (Timer() % 140 == 0 && Timer() != 0) { MonsterScale = FixedMul(MonsterScale, 0.95); }
        if (Timer() % 36 == 0) { MinimapIDCounter = 1000; }

        oldScore = FutilityScore;
        Delay(1);
    }
}

script 4 open clientside
{
    if (IsServer) { terminate; }

    while (1)
    {
        PlotOnMap("", 0, 0, 0);
        MinimapIDCounter = 1000;
        Delay(36);
    }
}


script 2 (int monsector, int monstart, int monend)
{
    int population;
    int montid;
    int spidersector = 0;
    int i;

    for (i = 0; i < SPIDERPOINTCOUNT; i++)
    {
        if (monsector == SpiderPoints[i]) { spidersector = 1; break; }
    }

    if (monstart > monend) { monstart ^= monend; monend ^= monstart; monstart ^= monend; }
    
    while (1)
    {
        Delay(random(SPAWND_MIN, SPAWND_MAX));
        
        population = SectorPopulation(monsector);
        while (population > 0)
        {
            //Log(s:"wait (", d:population, s:") on ", d:monsector);
            Delay(1);
            population = SectorPopulation(monsector);
        }
        
        Delay(2);
        
        Line_SetBlocking(monsector, 4, 0);  // players
        Floor_LowerByValue(monsector, DESCENTSPEED, DESCENTHEIGHT);
        TagWait(monsector);
        
        Delay(18);
        
        montid = unusedTID(20000, 30000);
        
        for (i = monstart; i <= monend; i++)
        {
            Futility_Spawn(i, montid, spidersector);
        }
        
        Line_SetBlocking(monsector, 0, 4);
        Floor_RaiseByValue(monsector, DESCENTSPEED, DESCENTHEIGHT);
        TagWait(monsector);
    }
}

script 3 enter
{
    int time = 0;
    int i;

    if (!WithSamsara)
    {
        ClearInventory();  // for coming from previous map

        if (WithLelweps)
        {
            GiveInventory("DarkLauncher", 1);
        }
        else
        {
            GiveInventory("Fist",   1);
            GiveInventory("Pistol", 1);
            TakeInventory("Clip",   0x7FFFFFFF);
            GiveInventory("Clip",   100);
        }
    }

    while (1)
    {
        if (time % 36 == 0) { PlotOnMap("TOD_GRNM", 20, GetActorX(0), GetActorY(0)); }

        if (WithSamsara && CheckInventory("GotWeapon2") && CheckInventory("MarathonClass") && !CheckInventory("CanDualShotties"))
        {
            GiveInventory("CanDualShotties", 1);
        }

        for (i = 0; i < ITEMCOUNT; i++)
        {
            if (ItemPads[i][1] && ItemsSpawned[i] > 0)
            {
                Futility_EnsureGiven(i);
            }
        }

        time++;
        Delay(1);
    }
}


script 11 (int index)
{
    int i, cost;

    if (GetActorProperty(0, APROP_Speed) < 1.0)
    {
        SetActorProperty(0, APROP_Speed, ftoi(GetActorProperty(0, APROP_Speed)));
    }

    SetActorProperty(0, APROP_Speed, GetActorProperty(0, APROP_Speed));
    
    ACS_ExecuteAlways(14, 0, index);

    cost = MonsterCosts[index][2];
    if (!cost) { cost = MonsterCosts[index][0] / 5; }
    cost = max(2, cost);

    if (~ClassifyActor(0) & ACTOR_MONSTER) { terminate; }
    
    while (GetActorProperty(0, APROP_Health) > 0)
    {
        Delay(1);
    }
    
    if (ACS_ExecuteWithResult(13) != -1)
    {
        MonsterScale += cost;
        FutilityScore += cost;
        Futility_AddItemPoints(index);
    }

    SetActorProperty(0, APROP_Speed, ftoi(GetActorProperty(0, APROP_Speed)));

    for (i = 0; i < 105; i++)
    {
        if (GetActorProperty(0, APROP_Health) > 0)
        {
            ACS_ExecuteWithResult(11, index);
            terminate;
        }
        Delay(1);
    }
    
    while (GetActorProperty(0, APROP_Alpha) > 0)
    {
        if (GetActorProperty(0, APROP_Health) > 0)
        {
            GiveInventory("Futility_MonsterUnfade", 1);
            ACS_ExecuteWithResult(11, index);
            terminate;
        }

        GiveInventory("Futility_MonsterFade", 1);
        Delay(1);
    }
    
    Thing_Remove(0);
}


script 12 (int give, int maxmod)
{
    int maxhp = GetActorProperty(0, APROP_SpawnHealth) + maxmod;
    int hp = GetActorProperty(0, APROP_Health);

    SetActorProperty(0, APROP_Health, min(maxhp, hp+give));
}

script 13 (void)
{
    SetActivatorToTarget(0);
    SetResultValue(PlayerNumber());
}


script 14 (int index) clientside
{
    int time;
    int dotsize = max(5, min(50, MonsterCosts[index][0] / 20));

    while (GetActorProperty(0, APROP_Speed) >= 1.0)
    {
        if (time % 36 == 0)
        {
            PlotOnMap("TOD_REDM", dotsize, GetActorX(0), GetActorY(0));
        }

        time++;
        Delay(1);
    }
}
