// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// DESCRIPTION:
//      Refresh/render internal state variables (global).
//
//-----------------------------------------------------------------------------


#ifndef __R_STATE__
#define __R_STATE__

// Need data structure definitions.
#include "d_player.h"
#include "r_data.h"



#ifdef __GNUG__
#pragma interface
#endif



//
// Refresh internal data structures,
//  for rendering.
//

// needed for texture pegging
extern fixed_t*         textureheight;

// needed for pre rendering (fracs)
extern fixed_t*         spritewidth;

extern fixed_t*         spriteoffset;
extern fixed_t*         spritetopoffset;

extern lighttable_t*    colormaps;

// -ES- 1998/08/20 Added these two
extern lighttable_t     *colormaps8, *colormaps16;
extern int numcolourmaps;

extern int              viewwidth;
extern int              scaledviewwidth;
extern int              viewheight;


// for global animation
extern int*             flatlist;
extern int*             flattranslation;        
extern int*             texturetranslation;     


// Sprite....
extern int*             spritelist;
extern int              numspritelumps;



//
// Lookup tables for map data.
//
extern int              numsprites;
extern spritedef_t*     sprites;

extern int              numvertexes;
extern vertex_t*        vertexes;

extern int              numsegs;
extern seg_t*           segs;

extern int              numsectors;
extern sector_t*        sectors;

extern int              numsubsectors;
extern subsector_t*     subsectors;

extern int              numnodes;
extern node_t*          nodes;

extern int              numlines;
extern line_t*          lines;

extern int              numsides;
extern side_t*          sides;


//
// POV data.
//
extern fixed_t          viewx;
extern fixed_t          viewy;
extern fixed_t          viewz;

extern angle_t          viewangle;
extern player_t*        viewplayer;


// -ES- 1999/03/20 Added these.
// Angles that are used for linedef clipping.
// Nearly the same as leftangle/rightangle, but slightly rounded to fit
// viewangletox lookups, and converted to BAM format.
extern angle_t leftclipangle, rightclipangle; // angles used for clipping
extern angle_t clipscope; // the scope of the clipped area (leftclipangle-rightclipangle)

extern angle_t topangle, bottomangle, // the most extreme angles of the view
               rightangle, leftangle;
extern fixed_t topslope, bottomslope, // tangents for the angles
               rightslope, leftslope;

// -ES- 1999/03/02 Added these.
extern angle_t          FIELDOFVIEW; // Number of FINEANGLES in viewwidth wide window

// Unit scale is used at distance distunit
extern fixed_t          x_distunit;
extern fixed_t          y_distunit;
// the x and y distunit used by original doom, used for lighting calc
#define ORIG_DISTUNIT (FRACUNIT*160)

extern int              viewangletox[FINEANGLES/2];
extern angle_t          *xtoviewangle;

extern fixed_t          rw_distance;
extern angle_t          rw_normalangle;



// angle to line origin
extern int              rw_angle1;

// Segs count?
extern int              sscount;

extern int              floorplane;
extern int              ceilingplane;


#endif
//-----------------------------------------------------------------------------
//
// $Log:$
//
//-----------------------------------------------------------------------------
