#include "../../doom/server/weapons.c"

void A_FireRailgun(mobj_t *actor)
{
	player_t *player = actor->player;
	TVec forward, org;
	TAVec angles;

    player->ammo[player->w_ammo] -= RAILCELLS;

    angles.pitch = actor->angles.pitch;
    angles.roll = actor->angles.roll;
    angles.yaw = actor->angles.yaw;
    AimLineAttack(actor, &angles, 10000.0);
    AngleVector(&angles, &forward);
    RailAttack(actor, &forward, 10000.0, 150);

    org = actor->origin + forward * 8.0;
    org.z += actor->height * 0.5; 

    StartSoundName(actor, "KeenPain");

	MSG_Select(MSG_SV_DATAGRAM, NULL);
	MSG_WriteByte(svc_rail);
	MSG_WriteShort(ftoi(org.x));
	MSG_WriteShort(ftoi(org.y));
	MSG_WriteShort(ftoi(org.z));
	MSG_WriteShort(ftoi(rail_hit_point.x));
	MSG_WriteShort(ftoi(rail_hit_point.y));
	MSG_WriteShort(ftoi(rail_hit_point.z));
}  
