#include "../../doom/server/map.c"

TVec rail_hit_point;

boolean PTR_RailTraverse(intercept_t* in)
{
	boolean result;
	TVec hit_point;

	result = PTR_ShootTraverse(in);
	if (!in->isaline)
		result = true;

	if (!result)
	    rail_hit_point = shoot_origin + (shoot_range * in->frac) * shoot_dir;

	return result;	
}


int RailAttack(mobj_t* t1, TVec *dir, float distance, int damage)
{
	TVec		dst;

    shoot_thing = t1;
    la_damage = damage;

	shoot_origin = t1->origin;
    shoot_origin.z += t1->height * 0.5 + 8.0 - t1->floorclip;

	shoot_dir = *dir;
	shoot_range = distance;

	dst = shoot_origin + shoot_range * shoot_dir;
	linestart = shoot_origin;

    if (!P_PathTraverse(t1->origin.x, t1->origin.y, dst.x, dst.y,
    	PT_ADDLINES | PT_ADDTHINGS, PTR_RailTraverse))
	{
		return false;
	}

	lineend = dst;
	return ShootCheckPlanes(PointInSubsector(dst.x, dst.y)->sector);
}
