UNIT   Timing;	(* by Marc Palms, 25.6.93 *)

 (*  The UNIT supplies a simple timing mechanism to fit loops to
     your machine.

     Situation:
       given:  a loop:  for(i=a; i<=a+diff; i+=STEP)
       			  {do_action(i); MyDelay(DELAY_TIME);}

               where do_action() does some on-screen action
                (dimming, mouse-movement, ...)

       wanted:  values for STEP and DELAY_TIME to fit the loop to
                your machine

       usage:   Start_Measure;
       		<loop_without_delay>
                DELAY_TIME := Get_Step_Delay(time_loop_should_take,
			                     diff,
                                             STEP);
  *)


INTERFACE



 PROCEDURE  StartMeasure;
 (* ---------------------------------------- *)
  (* This procedure is to be invoked right before the timing-test starts.
   *)



 PROCEDURE  GetStepDelay(    opt_time,
 			     diff      : WORD;
			 VAR step,
			     wait      : WORD );  (* in&out *)
 (* ---------------------------------------- *)
  (* This procedure returns the step and delay to turn your machine into
     the 'optimum machine'.
     opt_time   :  msecs. the test SHOULD take
     diff       :  times the action is performed when step=1
     step 	:  IN : the step-width the test was performed with
                :  OUT: the optimum step-width
     wait       :  IN : the time-delay (msecs.) the test was performed with
     wait       :  OUT: the optimum time-delay to wait after each step
   *)



 PROCEDURE  AdjustDelay(test_time : WORD);
  (*  The procedure ajusts 'delay_FAC' and 'delay_DIV' to your machine.
      Together with 'MyDelay()' it supplies a more accurate means of
      delay.
      The procedure waits what 'test_time' hsecs and then measures
      the time elapsed, thus computing the adjustment-factor for Delay().
      NOTE:
        test_time should be >= 50 to get accurate results
        (best values :  50 (=0.5secs)  - 300 (=3secs))
        (the higher test_time is the better the results will be)
   *)



 PROCEDURE  MyDelay(msecs : WORD);
 (* ---------------------------------------- *)
  (*  Together with 'CheckDelay()' this procedure supplies a
      machine-independent delay.
   *)




IMPLEMENTATION

 USES  DOS, CRT;


 CONST HSECS_PER_DAY = 24 * 60 * 60 * 100;

 CONST  delay_FAC  : LONGINT = 100;	(* standard *)
 	delay_DIV  : LONGINT = 100;


 VAR   start_time : LONGINT;


 PROCEDURE  StartMeasure;
 (* ---------------------------------------- *)
  (* This procedure is to be invoked right before the timing-test starts.
   *)

   VAR   h, m, s, hs : WORD;

   BEGIN

      GetTime(h, m, s, hs);

      start_time := (((LONGINT(h) * 60 + m) * 60)+ s) * 100 + hs;

   END;  (* Start_Measure *)





 PROCEDURE  GetStepDelay(    opt_time,
 			     diff      : WORD;
			 VAR step,
			     wait      : WORD );  (* in&out *)
 (* ---------------------------------------- *)
  (* This procedure returns the step and delay to turn your machine into
     the 'optimum machine'.
     opt_time   :  msecs. the test SHOULD take
     diff       :  times the action is performed when step=1
     step 	:  IN : the step-width the test was performed with
                :  OUT: the optimum step-width
     wait       :  IN : the time-delay (msecs.) the test was performed with
     wait       :  OUT: the optimum time-delay to wait after each step
   *)

   VAR   h, m, s, hs : WORD;
         used_time,
         new_wait,
         net_time,
         full_time  : LONGINT;

   BEGIN

      GetTime(h, m, s, hs);
      used_time := (((LONGINT(h) * 60 + m) * 60)+ s) * 100 + hs - start_time;

      WHILE  used_time < 0  DO
        INC(used_time, HSECS_PER_DAY);
      used_time := used_time * 10;	(* hsecs to msecs *)

      net_time := used_time - wait * (PRED(diff + step) DIV step);
      IF  net_time < 0  THEN
        net_time := 0;

      full_time := net_time * step;

      step := full_time DIV opt_time;
      IF  step = 0  THEN  (* your machine is too fast *)
         step := 1;

      new_wait := (opt_time * step - full_time) DIV diff;
      IF  new_wait > 0  THEN
         wait := new_wait
      ELSE
      	 wait := 0;

   END; (* GetStepDelay *)





 PROCEDURE  AdjustDelay(test_time : WORD);
  (*  The procedure ajusts 'delay_FAC' and 'delay_DIV' to your machine.
      Together with 'MyDelay()' it supplies a more accurate means of
      delay.
      The procedure waits what 'test_time' hsecs and then measures
      the time elapsed, thus computing the adjustment-factor for Delay().
      NOTE:
        test_time should be >= 50 to get accurate results
        (best values :  50 (=0.5secs)  - 300 (=3secs))
        (the higher test_time is the better the results will be)
   *)

   VAR  start,
   	used  	    : LONGINT;
        h, m, s, hs : WORD;

   BEGIN

      GetTime(h, m, s, hs);
      start := (((LONGINT(h) * 60 + m) * 60)+ s) * 100 + hs;
      Delay(test_time * 10);

      GetTime(h, m, s, hs);
      used := (((LONGINT(h) * 60 + m) * 60)+ s) * 100 + hs - start;
      WHILE  used < 0  DO
        INC(used, HSECS_PER_DAY);

      delay_FAC := test_time;
      delay_DIV := used;

   END;  (* CheckDelay *)




 PROCEDURE  MyDelay(msecs : WORD);
  (*  Together with 'CheckDelay()' this procedure supplies a
      machine-independent delay.
   *)

   BEGIN
     IF msecs > 0 THEN Delay((msecs * delay_FAC) DIV delay_DIV);
   END; (* MyDelay *)


END.  (* UNIT Timing *)
