/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kgd.card.player.gui.Stat;
import kgd.card.player.gui.Tools;
import kgd.card.player.io.StatCodec;

public final class Shareware {
    private static final List KEYS = new ArrayList(36);
    private char[][] ivChars = new char[10][];
    private String ivTitle;
    private String ivVersion;
    private File ivFile = null;
    private String ivCode = null;
    private String ivKey = null;
    private boolean ivRegistered = false;
    private Map ivSharewareGames = new HashMap();
    private Map ivStats;

    public Shareware(Map map) {
        this.ivStats = map;
        try {
            this.initialize();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void checkRegistration() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.ivCode, ".");
        int n = new Integer(stringTokenizer.nextToken());
        int n2 = new Integer(stringTokenizer.nextToken());
        int n3 = new Integer(stringTokenizer.nextToken());
        int n4 = new Integer(stringTokenizer.nextToken());
        int n5 = new Integer(stringTokenizer.nextToken());
        char[] cArray = new char[]{this.ivChars[n][n2], this.ivChars[n][n3], this.ivChars[n][n4], this.ivChars[n][n5]};
        String string = new String(cArray);
        this.ivRegistered = string.equals(this.ivKey);
    }

    private void decode() throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(this.ivFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inflaterInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        if (!bufferedReader.readLine().equals(this.ivTitle)) {
            throw new Exception("Shareware file corrupted");
        }
        this.ivCode = bufferedReader.readLine();
        this.ivKey = bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            String string2 = stringTokenizer.nextToken();
            int n = new Integer(stringTokenizer.nextToken());
            this.ivSharewareGames.put(string2, new SharewareGame(string2, n));
        }
        bufferedReader.close();
        inputStreamReader.close();
        inflaterInputStream.close();
        bufferedInputStream.close();
        fileInputStream.close();
    }

    private void encode() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.ivFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(bufferedOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(deflaterOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        bufferedWriter.write(this.ivTitle);
        bufferedWriter.newLine();
        bufferedWriter.write(this.ivCode);
        bufferedWriter.newLine();
        bufferedWriter.write(this.ivKey);
        bufferedWriter.newLine();
        SharewareGame sharewareGame = null;
        Iterator iterator = this.ivSharewareGames.values().iterator();
        while (iterator.hasNext()) {
            sharewareGame = (SharewareGame)iterator.next();
            bufferedWriter.write(String.valueOf(sharewareGame.ivName) + "=" + sharewareGame.ivLeft);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        outputStreamWriter.close();
        deflaterOutputStream.close();
        bufferedOutputStream.close();
        fileOutputStream.close();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(2, -1);
        this.ivFile.setLastModified(gregorianCalendar.getTime().getTime());
    }

    private void generateFile() throws Exception {
        this.ivFile.createNewFile();
        Random random = new Random();
        int n = random.nextInt(10);
        int n2 = random.nextInt(36);
        int n3 = random.nextInt(36);
        int n4 = random.nextInt(36);
        int n5 = random.nextInt(36);
        this.ivCode = new String(String.valueOf(n) + "." + n2 + "." + n3 + "." + n4 + "." + n5);
        this.ivKey = "00000";
        Iterator iterator = this.ivStats.values().iterator();
        while (iterator.hasNext()) {
            Stat stat = (Stat)iterator.next();
            int n6 = Math.max(0, 5 - (int)stat.getPlayed());
            this.ivSharewareGames.put(stat.getGame(), new SharewareGame(stat.getGame(), n6));
        }
        this.ivSharewareGames.put("Klondike", new SharewareGame("Klondike", -999));
        this.ivSharewareGames.put("Freecell", new SharewareGame("Freecell", -999));
        this.ivSharewareGames.put("Canfield", new SharewareGame("Canfield", -999));
        this.ivSharewareGames.put("Yukon", new SharewareGame("Yukon", -999));
        this.encode();
    }

    public String getCode() {
        return this.ivCode;
    }

    public int getGameLeftPlay(String string) {
        SharewareGame sharewareGame;
        int n;
        if (this.isRegistered()) {
            return 999;
        }
        if (!this.ivSharewareGames.containsKey(string)) {
            this.ivSharewareGames.put(string, new SharewareGame(string, 5));
        }
        if ((n = (sharewareGame = (SharewareGame)this.ivSharewareGames.get(string)).ivLeft) == -999) {
            return 999;
        }
        return n;
    }

    public String getKey() {
        return this.ivKey;
    }

    public String getTitle() {
        return this.ivTitle;
    }

    public String getVersion() {
        return this.ivVersion;
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        System.out.println(throwable);
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
        System.exit(-1);
    }

    private void initialize() throws Exception {
        File file = new File(String.valueOf(Tools.DIR_USER) + "Game.dat");
        if (!file.exists()) {
            throw new Exception("Can't find file " + file.getAbsolutePath());
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inflaterInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.ivTitle = bufferedReader.readLine();
        this.ivVersion = bufferedReader.readLine();
        this.ivFile = new File(String.valueOf(Tools.DIR_HOME) + bufferedReader.readLine());
        int n = 0;
        while (n < 10) {
            this.ivChars[n] = bufferedReader.readLine().toCharArray();
            ++n;
        }
        bufferedReader.close();
        inputStreamReader.close();
        inflaterInputStream.close();
        bufferedInputStream.close();
        fileInputStream.close();
        if (!this.ivFile.exists()) {
            this.generateFile();
        } else {
            this.decode();
        }
        this.checkRegistration();
    }

    public boolean isRegistered() {
        if (this.ivVersion.equals("R")) {
            return true;
        }
        return this.ivRegistered;
    }

    public static void main(String[] stringArray) throws IOException {
        Shareware shareware = new Shareware(new StatCodec().getStats());
        System.exit(0);
    }

    public boolean setKey(String string) {
        block3: {
            if (this.ivRegistered) {
                return true;
            }
            if (string == null || string.equals(this.ivKey)) break block3;
            this.ivKey = string;
            this.checkRegistration();
            try {
                this.encode();
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
        return this.ivRegistered;
    }

    public void useGame(String string) {
        block4: {
            SharewareGame sharewareGame;
            int n;
            if (this.isRegistered()) {
                return;
            }
            if (!this.ivSharewareGames.containsKey(string)) {
                this.ivSharewareGames.put(string, new SharewareGame(string, 5));
            }
            if ((n = (sharewareGame = (SharewareGame)this.ivSharewareGames.get(string)).ivLeft) == -999) break block4;
            sharewareGame.ivLeft = n - 1;
            try {
                this.encode();
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
    }

    private final class SharewareGame {
        private String ivName;
        private int ivLeft;

        public SharewareGame(String string, int n) {
            this.ivName = string;
            this.ivLeft = n;
        }
    }
}

