/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.io;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.zip.InflaterInputStream;
import kgd.card.player.data.Card;
import kgd.card.player.data.Discard;
import kgd.card.player.data.Foundation;
import kgd.card.player.data.Game;
import kgd.card.player.data.Reserve;
import kgd.card.player.data.Stock;
import kgd.card.player.data.Tableau;
import kgd.card.player.data.Waste;
import kgd.card.player.gui.CardUI;
import kgd.card.player.gui.GameUI;
import kgd.card.player.gui.PileUI;
import kgd.card.player.gui.Tools;

public final class GameCodec {
    private Game ivGame = null;
    private GameUI ivGameUI = null;

    public GameCodec(Game game, GameUI gameUI) {
        this.ivGame = game;
        this.ivGameUI = gameUI;
    }

    public void decode(File file) throws Exception {
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(inflaterInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                Parm parm = new Parm(string, ":");
                if (parm.ivKey.equals("GAME")) {
                    this.decodeGame(parm.ivValue);
                    continue;
                }
                if (parm.ivKey.equals("STOCK")) {
                    this.decodeStock(parm.ivValue);
                    continue;
                }
                if (parm.ivKey.equals("WASTE")) {
                    this.decodeWaste(parm.ivValue);
                    continue;
                }
                if (parm.ivKey.equals("TABLEAU")) {
                    this.decodeTableau(parm.ivValue);
                    continue;
                }
                if (parm.ivKey.equals("RESERVE")) {
                    this.decodeReserve(parm.ivValue);
                    continue;
                }
                if (parm.ivKey.equals("DISCARD")) {
                    this.decodeDiscard(parm.ivValue);
                    continue;
                }
                if (!parm.ivKey.equals("FOUNDATION")) continue;
                this.decodeFoundation(parm.ivValue);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inflaterInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            throw new Exception("Unable to decode Game file");
        }
    }

    public void decode(String string) throws Exception {
        this.decode(new File(String.valueOf(Tools.DIR_GAMES) + string));
    }

    private void decodeDiscard(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = null;
        String string5 = null;
        int n2 = -1;
        String string6 = null;
        int n3 = -1;
        String string7 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Drag")) {
                string2 = parm.ivValue;
            }
            if (parm.ivKey.equals("Stack")) {
                string3 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackMax")) {
                n = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("StackPiles")) {
                string4 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackCards")) {
                string5 = parm.ivValue;
            }
            if (parm.ivKey.equals("Fill")) {
                n2 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("FillPile")) {
                string6 = parm.ivValue;
            }
            if (parm.ivKey.equals("Visibility")) {
                n3 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Setup")) {
                string7 = parm.ivValue;
            }
            if (parm.ivKey.equals("Col")) {
                n4 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Row")) {
                n5 = Integer.parseInt(parm.ivValue);
            }
            if (!parm.ivKey.equals("Piling")) continue;
            n6 = Integer.parseInt(parm.ivValue);
        }
        Discard discard = new Discard(string2, string3, n, string4, string5, n2, string6, n3, string7);
        this.ivGame.addWidget(discard);
        PileUI pileUI = new PileUI(discard, new Point(n4, n5), n6);
        this.ivGameUI.addWidgetUI(pileUI);
        discard.setListener(pileUI);
    }

    private void decodeFoundation(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = null;
        String string5 = null;
        int n2 = -1;
        String string6 = null;
        int n3 = -1;
        String string7 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Drag")) {
                string2 = parm.ivValue;
            }
            if (parm.ivKey.equals("Stack")) {
                string3 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackMax")) {
                n = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("StackPiles")) {
                string4 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackCards")) {
                string5 = parm.ivValue;
            }
            if (parm.ivKey.equals("Fill")) {
                n2 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("FillPile")) {
                string6 = parm.ivValue;
            }
            if (parm.ivKey.equals("Visibility")) {
                n3 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Setup")) {
                string7 = parm.ivValue;
            }
            if (parm.ivKey.equals("Col")) {
                n4 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Row")) {
                n5 = Integer.parseInt(parm.ivValue);
            }
            if (!parm.ivKey.equals("Piling")) continue;
            n6 = Integer.parseInt(parm.ivValue);
        }
        Foundation foundation = new Foundation(string2, string3, n, string4, string5, n2, string6, n3, string7);
        this.ivGame.addWidget(foundation);
        PileUI pileUI = new PileUI(foundation, new Point(n4, n5), n6);
        this.ivGameUI.addWidgetUI(pileUI);
        foundation.setListener(pileUI);
    }

    private void decodeGame(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        int n = 0;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Name")) {
                string2 = parm.ivValue;
            }
            if (parm.ivKey.equals("Decks")) {
                n = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("LockCards")) {
                string3 = parm.ivValue;
            }
            if (parm.ivKey.equals("Freecell")) {
                bl = new Boolean(parm.ivValue);
            }
            if (parm.ivKey.equals("SynchronizedFoundations")) {
                bl2 = new Boolean(parm.ivValue);
            }
            if (parm.ivKey.equals("Grid")) {
                n2 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Columns")) {
                n3 = Integer.parseInt(parm.ivValue);
            }
            if (!parm.ivKey.equals("Rows")) continue;
            n4 = Integer.parseInt(parm.ivValue);
        }
        this.ivGame.initialize(string2, string3, bl, bl2);
        this.ivGameUI.initialize(n2, n3, n4);
        if (n > 0) {
            this.generateCards(n);
        }
    }

    private void decodeReserve(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = null;
        String string5 = null;
        int n2 = -1;
        String string6 = null;
        int n3 = -1;
        String string7 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Drag")) {
                string2 = parm.ivValue;
            }
            if (parm.ivKey.equals("Stack")) {
                string3 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackMax")) {
                n = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("StackPiles")) {
                string4 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackCards")) {
                string5 = parm.ivValue;
            }
            if (parm.ivKey.equals("Fill")) {
                n2 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("FillPile")) {
                string6 = parm.ivValue;
            }
            if (parm.ivKey.equals("Visibility")) {
                n3 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Setup")) {
                string7 = parm.ivValue;
            }
            if (parm.ivKey.equals("Col")) {
                n4 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Row")) {
                n5 = Integer.parseInt(parm.ivValue);
            }
            if (!parm.ivKey.equals("Piling")) continue;
            n6 = Integer.parseInt(parm.ivValue);
        }
        Reserve reserve = new Reserve(string2, string3, n, string4, string5, n2, string6, n3, string7);
        this.ivGame.addWidget(reserve);
        PileUI pileUI = new PileUI(reserve, new Point(n4, n5), n6);
        this.ivGameUI.addWidgetUI(pileUI);
        reserve.setListener(pileUI);
    }

    private void decodeStock(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = null;
        String string5 = null;
        int n2 = -1;
        String string6 = null;
        int n3 = -1;
        String string7 = null;
        int n4 = -1;
        int n5 = -1;
        String string8 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Drag")) {
                string2 = parm.ivValue;
            }
            if (parm.ivKey.equals("Stack")) {
                string3 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackMax")) {
                n = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("StackPiles")) {
                string4 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackCards")) {
                string5 = parm.ivValue;
            }
            if (parm.ivKey.equals("Fill")) {
                n2 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("FillPile")) {
                string6 = parm.ivValue;
            }
            if (parm.ivKey.equals("Visibility")) {
                n3 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Setup")) {
                string7 = parm.ivValue;
            }
            if (parm.ivKey.equals("Mode")) {
                n4 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("MaxRedeals")) {
                n5 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("PilesToDeal")) {
                string8 = parm.ivValue;
            }
            if (parm.ivKey.equals("Col")) {
                n6 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Row")) {
                n7 = Integer.parseInt(parm.ivValue);
            }
            if (!parm.ivKey.equals("Piling")) continue;
            n8 = Integer.parseInt(parm.ivValue);
        }
        Stock stock = new Stock(string2, string3, n, string4, string5, n2, string6, n3, string7);
        stock.updateStock(n4, n5, string8);
        this.ivGame.addWidget(stock);
        PileUI pileUI = new PileUI(stock, new Point(n6, n7), n8);
        this.ivGameUI.addWidgetUI(pileUI);
        stock.setListener(pileUI);
    }

    private void decodeTableau(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = null;
        String string5 = null;
        int n2 = -1;
        String string6 = null;
        int n3 = -1;
        String string7 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Drag")) {
                string2 = parm.ivValue;
            }
            if (parm.ivKey.equals("Stack")) {
                string3 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackMax")) {
                n = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("StackPiles")) {
                string4 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackCards")) {
                string5 = parm.ivValue;
            }
            if (parm.ivKey.equals("Fill")) {
                n2 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("FillPile")) {
                string6 = parm.ivValue;
            }
            if (parm.ivKey.equals("Visibility")) {
                n3 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Setup")) {
                string7 = parm.ivValue;
            }
            if (parm.ivKey.equals("Col")) {
                n4 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Row")) {
                n5 = Integer.parseInt(parm.ivValue);
            }
            if (!parm.ivKey.equals("Piling")) continue;
            n6 = Integer.parseInt(parm.ivValue);
        }
        Tableau tableau = new Tableau(string2, string3, n, string4, string5, n2, string6, n3, string7);
        this.ivGame.addWidget(tableau);
        PileUI pileUI = new PileUI(tableau, new Point(n4, n5), n6);
        this.ivGameUI.addWidgetUI(pileUI);
        tableau.setListener(pileUI);
    }

    private void decodeWaste(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = null;
        String string5 = null;
        int n2 = -1;
        String string6 = null;
        int n3 = -1;
        String string7 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Drag")) {
                string2 = parm.ivValue;
            }
            if (parm.ivKey.equals("Stack")) {
                string3 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackMax")) {
                n = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("StackPiles")) {
                string4 = parm.ivValue;
            }
            if (parm.ivKey.equals("StackCards")) {
                string5 = parm.ivValue;
            }
            if (parm.ivKey.equals("Fill")) {
                n2 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("FillPile")) {
                string6 = parm.ivValue;
            }
            if (parm.ivKey.equals("Visibility")) {
                n3 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Setup")) {
                string7 = parm.ivValue;
            }
            if (parm.ivKey.equals("Col")) {
                n4 = Integer.parseInt(parm.ivValue);
            }
            if (parm.ivKey.equals("Row")) {
                n5 = Integer.parseInt(parm.ivValue);
            }
            if (!parm.ivKey.equals("Piling")) continue;
            n6 = Integer.parseInt(parm.ivValue);
        }
        Waste waste = new Waste(string2, string3, n, string4, string5, n2, string6, n3, string7);
        this.ivGame.addWidget(waste);
        PileUI pileUI = new PileUI(waste, new Point(n4, n5), n6);
        this.ivGameUI.addWidgetUI(pileUI);
        waste.setListener(pileUI);
    }

    private void generateCards(int n) {
        if (this.ivGame == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 4) {
                int n4 = 0;
                while (n4 < 13) {
                    Card card = new Card(n3, n4);
                    CardUI cardUI = new CardUI(card);
                    card.setListener(cardUI);
                    this.ivGame.addWidget(card);
                    this.ivGameUI.addWidgetUI(cardUI);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public Game getGame() {
        return this.ivGame;
    }

    public GameUI getGameUI() {
        return this.ivGameUI;
    }

    private final class Parm {
        private String ivKey;
        private String ivValue;

        public Parm(String string, String string2) {
            int n = string.indexOf(string2);
            if (n > 0) {
                this.ivKey = string.substring(0, n);
                this.ivValue = string.substring(n + 1);
            }
        }
    }
}

