/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public final class Tools {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DIR_HOME = String.valueOf(System.getProperty("user.home")) + FILE_SEPARATOR;
    public static final String DIR_USER = String.valueOf(System.getProperty("user.dir")) + FILE_SEPARATOR;
    public static final String DIR_GAMES = String.valueOf(DIR_USER) + "games" + FILE_SEPARATOR;
    public static final String DIR_IMAGES = String.valueOf(DIR_USER) + "images" + FILE_SEPARATOR;
    public static final String DIR_PILES = String.valueOf(DIR_IMAGES) + "piles" + FILE_SEPARATOR;
    public static final String DIR_BACKS = String.valueOf(DIR_IMAGES) + "backs" + FILE_SEPARATOR;
    public static final String DIR_CARDS = String.valueOf(DIR_IMAGES) + "cards" + FILE_SEPARATOR;
    public static final String DIR_MISCS = String.valueOf(DIR_IMAGES) + "miscs" + FILE_SEPARATOR;
    public static final String DIR_SOUNDS = "file:" + DIR_USER + "sounds" + FILE_SEPARATOR;
    public static final String DIR_ICONS = String.valueOf(DIR_USER) + "icons" + FILE_SEPARATOR;
    public static final String DIR_DOC = String.valueOf(DIR_USER) + "doc" + FILE_SEPARATOR + Locale.getDefault().getLanguage() + FILE_SEPARATOR;
    private static ResourceBundle ivResStrings;
    public static final int NOT_REGISTERED = -1;
    public static final int UNKNOWN_REGISTERED = 0;
    public static final int ANONYMOUS_REGISTERED = 1;
    public static final int PRIVATE_REGISTERED = 2;
    private static int cvRegistrationStatus;
    public static final String PROGRAM_TITLE = "Card Player";
    public static final String PROGRAM_VERSION = "1.0";
    public static final String PROGRAM_COPYRIGHT = "(C) 2000 - KWD";
    public static final String PROGRAM_AUTHOR = "Bertrand Vauthier";
    public static final Color COLOR_GOLD;
    public static final Color COLOR_SILVER;
    private static Color[] cvBackgroundColors;
    private static Color cvBackgroundColor;
    private static ImageIcon[][] cvCardImages;
    private static ImageIcon cvPileImage;
    private static ImageIcon cvPileInactiveImage;
    private static ImageIcon cvStockImage;
    private static ImageIcon cvStockInactiveImage;
    private static ImageIcon cvFoundationImage;
    private static ImageIcon cvFoundationInactiveImage;
    private static ImageIcon cvBackImage;
    private static ImageIcon cvDragOverImage;
    private static boolean ivPlayingSounds;
    private static Map cvSounds;
    private static String ivBrowser;

    static {
        cvRegistrationStatus = 0;
        COLOR_GOLD = new Color(255, 255, 192);
        COLOR_SILVER = new Color(224, 224, 224);
        cvCardImages = new ImageIcon[4][13];
        ivPlayingSounds = true;
        cvSounds = new HashMap(20);
    }

    public static Image getBackImage() {
        return cvBackImage.getImage();
    }

    public static Color getBackgroundColor() {
        if (cvBackgroundColor == null) {
            cvBackgroundColor = Tools.getBackgroundColors()[0];
        }
        return cvBackgroundColor;
    }

    public static Color[] getBackgroundColors() {
        if (cvBackgroundColors == null) {
            cvBackgroundColors = new Color[3];
            Tools.cvBackgroundColors[0] = new Color(10, 40, 70);
            Tools.cvBackgroundColors[1] = new Color(10, 70, 40);
            Tools.cvBackgroundColors[2] = new Color(40, 40, 40);
        }
        return cvBackgroundColors;
    }

    public static String getBrowser() {
        return ivBrowser;
    }

    public static Image getCardImage(int n, int n2) {
        return cvCardImages[n][n2].getImage();
    }

    public static List getCardPreviews(int n) {
        return Tools.getCardPreviews3(n);
    }

    private static List getCardPreviews1(int n) {
        File file = new File(String.valueOf(DIR_CARDS) + "Default" + FILE_SEPARATOR);
        File[] fileArray = file.listFiles();
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            String string = file2.getName();
            if (file2.isFile() && string.equals("0-12-" + n + ".gif")) {
                try {
                    arrayList.add(new ImageIcon(file2.getPath(), "Default"));
                }
                catch (Throwable throwable) {}
            }
            ++n2;
        }
        return arrayList;
    }

    private static List getCardPreviews2(int n) {
        File file = new File(DIR_CARDS);
        File[] fileArray = file.listFiles();
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            String string = file2.getName();
            if (file2.isFile() && string.endsWith("-" + n + ".jpg")) {
                try {
                    ImageIcon imageIcon = new ImageIcon(file2.getPath());
                    int n3 = imageIcon.getIconWidth() / 52;
                    int n4 = imageIcon.getIconHeight();
                    int n5 = 12 * n3;
                    CropImageFilter cropImageFilter = new CropImageFilter(n5, 0, n3, n4);
                    FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), cropImageFilter);
                    Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                    arrayList.add(new ImageIcon(image, string.substring(0, string.length() - 6)));
                }
                catch (Throwable throwable) {}
            }
            ++n2;
        }
        return arrayList;
    }

    private static List getCardPreviews3(int n) {
        File file = new File(DIR_CARDS);
        File[] fileArray = file.listFiles();
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        File[] fileArray2 = file.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            String string = file2.getName();
            if (file2.isDirectory()) {
                File[] fileArray3 = file2.listFiles();
                int n3 = 0;
                while (n3 < fileArray3.length) {
                    File file3 = fileArray3[n3];
                    if (file3.isFile() && file3.getName().equals("0-12-" + n + ".gif")) {
                        try {
                            arrayList.add(new ImageIcon(file3.getPath(), string));
                        }
                        catch (Throwable throwable) {}
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public static List getCardbackPreviews(int n) {
        File file = new File(DIR_BACKS);
        File[] fileArray = file.listFiles();
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            String string = file2.getName();
            if (file2.isFile() && string.endsWith("-" + n + ".gif")) {
                try {
                    arrayList.add(new ImageIcon(file2.getPath(), string.substring(0, string.length() - 6)));
                }
                catch (Throwable throwable) {}
            }
            ++n2;
        }
        return arrayList;
    }

    public static Image getDragOverImage() {
        return cvDragOverImage.getImage();
    }

    public static Image getFoundationImage() {
        return cvFoundationImage.getImage();
    }

    public static Image getFoundationInactiveImage() {
        return cvFoundationInactiveImage.getImage();
    }

    public static ImageIcon getIcon(String string) {
        return new ImageIcon(String.valueOf(DIR_ICONS) + string);
    }

    public static Image getPileImage() {
        return cvPileImage.getImage();
    }

    public static Image getPileInactiveImage() {
        return cvPileInactiveImage.getImage();
    }

    public static Image getProgramIconImage() {
        ImageIcon imageIcon = Tools.getIcon("ProgramIcon.gif");
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    public static Image getStockImage() {
        return cvStockImage.getImage();
    }

    public static Image getStockInactiveImage() {
        return cvStockInactiveImage.getImage();
    }

    public static boolean isPlayingSounds() {
        return ivPlayingSounds;
    }

    public static void loadImages(String string, String string2, int n) {
        cvPileImage = new ImageIcon(String.valueOf(DIR_PILES) + "Pile" + "-" + n + ".gif");
        cvPileInactiveImage = new ImageIcon(String.valueOf(DIR_PILES) + "PileInactive" + "-" + n + ".gif");
        cvStockImage = new ImageIcon(String.valueOf(DIR_PILES) + "Stock" + "-" + n + ".gif");
        cvStockInactiveImage = new ImageIcon(String.valueOf(DIR_PILES) + "StockInactive" + "-" + n + ".gif");
        cvFoundationImage = new ImageIcon(String.valueOf(DIR_PILES) + "Foundation" + "-" + n + ".gif");
        cvFoundationInactiveImage = new ImageIcon(String.valueOf(DIR_PILES) + "FoundationInactive" + "-" + n + ".gif");
        cvDragOverImage = new ImageIcon(String.valueOf(DIR_MISCS) + "DragOver" + "-" + n + ".gif");
        Tools.loadImagesBack(string2, n);
        Tools.loadImagesSet(string, n);
    }

    public static void loadImagesBack(String string, int n) {
        cvBackImage = new ImageIcon(String.valueOf(DIR_BACKS) + string + "-" + n + ".gif");
    }

    public static void loadImagesSet(String string, int n) {
        long l = System.currentTimeMillis();
        Tools.loadImagesSet1(string, n);
        long l2 = System.currentTimeMillis();
    }

    private static void loadImagesSet1(String string, int n) {
        String string2 = String.valueOf(DIR_CARDS) + string + FILE_SEPARATOR;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 13) {
                Tools.cvCardImages[n2][n3] = new ImageIcon(String.valueOf(string2) + n2 + "-" + n3 + "-" + n + ".gif");
                ++n3;
            }
            ++n2;
        }
    }

    private static void loadImagesSet2(String string, int n) {
        ImageIcon imageIcon = new ImageIcon(String.valueOf(DIR_CARDS) + string + "-" + n + ".jpg");
        int n2 = imageIcon.getIconWidth();
        int n3 = imageIcon.getIconHeight();
        int n4 = n2 / 52;
        int n5 = n3;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), null, null);
        Color color = new Color(0, 0, 0, 0);
        int n6 = color.getRGB();
        int n7 = 0;
        while (n7 < 4) {
            int n8 = 0;
            while (n8 < 13) {
                int n9 = 13 * n4 * n7 + n4 * n8;
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(n9, 0, n4, n5);
                bufferedImage2.setRGB(0, 0, n6);
                bufferedImage2.setRGB(0, 1, n6);
                bufferedImage2.setRGB(0, 2, n6);
                bufferedImage2.setRGB(0, 3, n6);
                bufferedImage2.setRGB(0, 4, n6);
                bufferedImage2.setRGB(1, 0, n6);
                bufferedImage2.setRGB(1, 1, n6);
                bufferedImage2.setRGB(1, 2, n6);
                bufferedImage2.setRGB(2, 0, n6);
                bufferedImage2.setRGB(2, 1, n6);
                bufferedImage2.setRGB(3, 0, n6);
                bufferedImage2.setRGB(4, 0, n6);
                bufferedImage2.setRGB(n4 - 1, 0, n6);
                bufferedImage2.setRGB(n4 - 1, 1, n6);
                bufferedImage2.setRGB(n4 - 1, 2, n6);
                bufferedImage2.setRGB(n4 - 1, 3, n6);
                bufferedImage2.setRGB(n4 - 1, 4, n6);
                bufferedImage2.setRGB(n4 - 2, 0, n6);
                bufferedImage2.setRGB(n4 - 2, 1, n6);
                bufferedImage2.setRGB(n4 - 2, 2, n6);
                bufferedImage2.setRGB(n4 - 3, 0, n6);
                bufferedImage2.setRGB(n4 - 3, 1, n6);
                bufferedImage2.setRGB(n4 - 4, 0, n6);
                bufferedImage2.setRGB(n4 - 5, 0, n6);
                bufferedImage2.setRGB(n4 - 1, n5 - 1, n6);
                bufferedImage2.setRGB(n4 - 1, n5 - 2, n6);
                bufferedImage2.setRGB(n4 - 1, n5 - 3, n6);
                bufferedImage2.setRGB(n4 - 1, n5 - 4, n6);
                bufferedImage2.setRGB(n4 - 1, n5 - 5, n6);
                bufferedImage2.setRGB(n4 - 2, n5 - 1, n6);
                bufferedImage2.setRGB(n4 - 2, n5 - 2, n6);
                bufferedImage2.setRGB(n4 - 2, n5 - 3, n6);
                bufferedImage2.setRGB(n4 - 3, n5 - 1, n6);
                bufferedImage2.setRGB(n4 - 3, n5 - 2, n6);
                bufferedImage2.setRGB(n4 - 4, n5 - 1, n6);
                bufferedImage2.setRGB(n4 - 5, n5 - 1, n6);
                bufferedImage2.setRGB(0, n5 - 1, n6);
                bufferedImage2.setRGB(0, n5 - 2, n6);
                bufferedImage2.setRGB(0, n5 - 3, n6);
                bufferedImage2.setRGB(0, n5 - 4, n6);
                bufferedImage2.setRGB(0, n5 - 5, n6);
                bufferedImage2.setRGB(1, n5 - 1, n6);
                bufferedImage2.setRGB(1, n5 - 2, n6);
                bufferedImage2.setRGB(1, n5 - 3, n6);
                bufferedImage2.setRGB(2, n5 - 1, n6);
                bufferedImage2.setRGB(2, n5 - 2, n6);
                bufferedImage2.setRGB(3, n5 - 1, n6);
                bufferedImage2.setRGB(4, n5 - 1, n6);
                Tools.cvCardImages[n7][n8] = new ImageIcon(bufferedImage2);
                ++n8;
            }
            ++n7;
        }
    }

    private static void loadImagesSet3(String string, int n) {
        ImageIcon imageIcon = new ImageIcon(String.valueOf(DIR_CARDS) + string + "-" + n + ".jpg");
        int n2 = imageIcon.getIconWidth() / 52;
        int n3 = imageIcon.getIconHeight();
        Color color = new Color(0, 0, 0, 0);
        int n4 = color.getRGB();
        int n5 = 0;
        while (n5 < 4) {
            int n6 = 0;
            while (n6 < 13) {
                int n7 = 13 * n2 * n5 + n2 * n6;
                CropImageFilter cropImageFilter = new CropImageFilter(n7, 0, n2, n3);
                FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), cropImageFilter);
                Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(imageIcon.getImage(), null, null);
                bufferedImage.setRGB(0, 0, n4);
                bufferedImage.setRGB(0, 1, n4);
                bufferedImage.setRGB(0, 2, n4);
                bufferedImage.setRGB(0, 3, n4);
                bufferedImage.setRGB(0, 4, n4);
                bufferedImage.setRGB(1, 0, n4);
                bufferedImage.setRGB(1, 1, n4);
                bufferedImage.setRGB(1, 2, n4);
                bufferedImage.setRGB(2, 0, n4);
                bufferedImage.setRGB(2, 1, n4);
                bufferedImage.setRGB(3, 0, n4);
                bufferedImage.setRGB(4, 0, n4);
                bufferedImage.setRGB(n2 - 1, 0, n4);
                bufferedImage.setRGB(n2 - 1, 1, n4);
                bufferedImage.setRGB(n2 - 1, 2, n4);
                bufferedImage.setRGB(n2 - 1, 3, n4);
                bufferedImage.setRGB(n2 - 1, 4, n4);
                bufferedImage.setRGB(n2 - 2, 0, n4);
                bufferedImage.setRGB(n2 - 2, 1, n4);
                bufferedImage.setRGB(n2 - 2, 2, n4);
                bufferedImage.setRGB(n2 - 3, 0, n4);
                bufferedImage.setRGB(n2 - 3, 1, n4);
                bufferedImage.setRGB(n2 - 4, 0, n4);
                bufferedImage.setRGB(n2 - 5, 0, n4);
                bufferedImage.setRGB(n2 - 1, n3 - 1, n4);
                bufferedImage.setRGB(n2 - 1, n3 - 2, n4);
                bufferedImage.setRGB(n2 - 1, n3 - 3, n4);
                bufferedImage.setRGB(n2 - 1, n3 - 4, n4);
                bufferedImage.setRGB(n2 - 1, n3 - 5, n4);
                bufferedImage.setRGB(n2 - 2, n3 - 1, n4);
                bufferedImage.setRGB(n2 - 2, n3 - 2, n4);
                bufferedImage.setRGB(n2 - 2, n3 - 3, n4);
                bufferedImage.setRGB(n2 - 3, n3 - 1, n4);
                bufferedImage.setRGB(n2 - 3, n3 - 2, n4);
                bufferedImage.setRGB(n2 - 4, n3 - 1, n4);
                bufferedImage.setRGB(n2 - 5, n3 - 1, n4);
                bufferedImage.setRGB(0, n3 - 1, n4);
                bufferedImage.setRGB(0, n3 - 2, n4);
                bufferedImage.setRGB(0, n3 - 3, n4);
                bufferedImage.setRGB(0, n3 - 4, n4);
                bufferedImage.setRGB(0, n3 - 5, n4);
                bufferedImage.setRGB(1, n3 - 1, n4);
                bufferedImage.setRGB(1, n3 - 2, n4);
                bufferedImage.setRGB(1, n3 - 3, n4);
                bufferedImage.setRGB(2, n3 - 1, n4);
                bufferedImage.setRGB(2, n3 - 2, n4);
                bufferedImage.setRGB(3, n3 - 1, n4);
                bufferedImage.setRGB(4, n3 - 1, n4);
                Tools.cvCardImages[n5][n6] = new ImageIcon(bufferedImage);
                ++n6;
            }
            ++n5;
        }
    }

    private static void loadImagesSet4(String string, int n) {
        ImageIcon imageIcon = new ImageIcon(String.valueOf(DIR_CARDS) + string + "-" + n + ".jpg");
        int n2 = imageIcon.getIconWidth() / 52;
        int n3 = imageIcon.getIconHeight();
        Color color = new Color(0, 0, 0, 0);
        int n4 = color.getRGB();
        int n5 = 0;
        while (n5 < 4) {
            int n6 = 0;
            while (n6 < 13) {
                int n7 = 13 * n2 * n5 + n2 * n6;
                CropImageFilter cropImageFilter = new CropImageFilter(n7, 0, n2, n3);
                FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), cropImageFilter);
                Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                Tools.cvCardImages[n5][n6] = new ImageIcon(image);
                ++n6;
            }
            ++n5;
        }
    }

    public static void loadSounds() {
        try {
            URL uRL = new URL(DIR_SOUNDS);
            URL uRL2 = new URL(uRL, "Drag.wav");
            AudioClip audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Drag", audioClip);
            uRL2 = new URL(uRL, "Fast.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Fast", audioClip);
            uRL2 = new URL(uRL, "Abort1.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Abort1", audioClip);
            uRL2 = new URL(uRL, "Abort2.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Abort2", audioClip);
            uRL2 = new URL(uRL, "Undo1.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Undo1", audioClip);
            uRL2 = new URL(uRL, "Undo2.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Undo2", audioClip);
            uRL2 = new URL(uRL, "Wrong1.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Wrong1", audioClip);
            uRL2 = new URL(uRL, "Wrong2.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Wrong2", audioClip);
            uRL2 = new URL(uRL, "Fill.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Fill", audioClip);
            uRL2 = new URL(uRL, "Deal1.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Deal1", audioClip);
            uRL2 = new URL(uRL, "Deal3.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Deal3", audioClip);
            uRL2 = new URL(uRL, "Deal9.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Deal9", audioClip);
            uRL2 = new URL(uRL, "Setup52.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Setup52", audioClip);
            uRL2 = new URL(uRL, "Setup104.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Setup104", audioClip);
            uRL2 = new URL(uRL, "Shuffle.wav");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Shuffle", audioClip);
            uRL2 = new URL(uRL, "Victory.mid");
            audioClip = Applet.newAudioClip(uRL2);
            cvSounds.put("Victory", audioClip);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static void playSound(String string) {
        if (!ivPlayingSounds) {
            return;
        }
        if (string.equals("Abort") || string.equals("Undo") || string.equals("Wrong")) {
            string = String.valueOf(string) + (new Random().nextInt(2) + 1);
        }
        if (cvSounds.containsKey(string)) {
            ((AudioClip)cvSounds.get(string)).play();
        }
    }

    public static void setBrowser(String string) {
        if (string.equals("NULL")) {
            string = null;
        }
        ivBrowser = string;
    }

    public static void setPlayingSounds(boolean bl) {
        ivPlayingSounds = bl;
    }

    public static void startSoundLoop(String string) {
        if (!ivPlayingSounds) {
            return;
        }
        if (cvSounds.containsKey(string)) {
            ((AudioClip)cvSounds.get(string)).loop();
        }
    }

    public static void stopSoundLoop(String string) {
        if (!ivPlayingSounds) {
            return;
        }
        if (cvSounds.containsKey(string)) {
            ((AudioClip)cvSounds.get(string)).stop();
        }
    }

    public static String translate(String string) {
        if (ivResStrings == null) {
            ivResStrings = ResourceBundle.getBundle("i18n/Strings");
        }
        try {
            return ivResStrings.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing translation " + string + "\n" + missingResourceException);
            return "???";
        }
    }
}

