/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kgd.card.player.gui.Stat;
import kgd.card.player.gui.Tools;

public final class StatTableModel
extends AbstractTableModel {
    private List data;

    public StatTableModel(Collection collection) {
        this.data = new ArrayList(collection);
    }

    public void deleteRow(int n) {
        if (n >= this.data.size()) {
            return;
        }
        this.data.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return Tools.translate("StatModel-Game");
            }
            case 1: {
                return Tools.translate("StatModel-Played");
            }
            case 2: {
                return Tools.translate("StatModel-Won");
            }
            case 3: {
                return Tools.translate("StatModel-AvgScore");
            }
            case 4: {
                return Tools.translate("StatModel-Success");
            }
        }
        return "";
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(int n, int n2) {
        Stat stat = (Stat)this.data.get(n);
        switch (n2) {
            case 0: {
                return stat.getGame();
            }
            case 1: {
                return new Long(stat.getPlayed());
            }
            case 2: {
                return new Long(stat.getWon());
            }
            case 3: {
                return new Long(stat.getAverageScore());
            }
            case 4: {
                return new Long(stat.getSuccessRate());
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void sort(int n, boolean bl) {
        Comparator comparator = null;
        switch (n) {
            case 0: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        String string = ((Stat)object).getGame();
                        String string2 = ((Stat)object2).getGame();
                        return string.compareTo(string2);
                    }
                };
                break;
            }
            case 1: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        return (int)(((Stat)object2).getPlayed() - ((Stat)object).getPlayed());
                    }
                };
                break;
            }
            case 2: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        return (int)(((Stat)object2).getWon() - ((Stat)object).getWon());
                    }
                };
                break;
            }
            case 3: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        return (int)(((Stat)object2).getAverageScore() - ((Stat)object).getAverageScore());
                    }
                };
                break;
            }
            case 4: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        return (int)(((Stat)object2).getSuccessRate() - ((Stat)object).getSuccessRate());
                    }
                };
                break;
            }
        }
        if (comparator != null) {
            Collections.sort(this.data, comparator);
            if (bl) {
                Collections.reverse(this.data);
            }
            this.fireTableDataChanged();
        }
    }
}

