/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

public final class Stat {
    private String ivGame;
    private long ivPlayed = 0L;
    private long ivWon = 0L;
    private long ivWonScore = 0L;
    private long ivLost = 0L;
    private long ivLostScore = 0L;

    public Stat() {
    }

    public Stat(String string) {
        this.ivGame = string;
    }

    protected void addLost(int n) {
        ++this.ivPlayed;
        ++this.ivLost;
        this.ivLostScore += (long)n;
    }

    protected void addWon(int n) {
        ++this.ivPlayed;
        ++this.ivWon;
        this.ivWonScore += (long)n;
    }

    public long getAverageLostScore() {
        if (this.ivLost == 0L) {
            return 0L;
        }
        return this.ivLostScore / this.ivLost;
    }

    public long getAverageScore() {
        if (this.ivPlayed == 0L) {
            return 0L;
        }
        return (this.ivLostScore + this.ivWonScore) / this.ivPlayed;
    }

    public long getAverageWonScore() {
        if (this.ivWon == 0L) {
            return 0L;
        }
        return this.ivWonScore / this.ivWon;
    }

    public String getGame() {
        return this.ivGame;
    }

    public long getLost() {
        return this.ivLost;
    }

    public long getLostScore() {
        return this.ivLostScore;
    }

    public long getPlayed() {
        return this.ivPlayed;
    }

    public long getSuccessRate() {
        if (this.ivPlayed == 0L) {
            return 0L;
        }
        double d = this.ivWon;
        double d2 = this.ivPlayed;
        return (long)(d / d2 * 100.0);
    }

    public long getWon() {
        return this.ivWon;
    }

    public long getWonScore() {
        return this.ivWonScore;
    }

    public void setGame(String string) {
        this.ivGame = string;
    }

    public void setLost(long l) {
        this.ivLost = l;
    }

    public void setLostScore(long l) {
        this.ivLostScore = l;
    }

    public void setPlayed(long l) {
        this.ivPlayed = l;
    }

    public void setWon(long l) {
        this.ivWon = l;
    }

    public void setWonScore(long l) {
        this.ivWonScore = l;
    }
}

