/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kgd.card.player.gui.Header;
import kgd.card.player.gui.Tools;
import kgd.card.player.io.HeaderCodec;

public final class HeaderTableModel
extends AbstractTableModel {
    private HeaderCodec ivHeaderCodec;
    private List allData;
    private List ivFilterTypes;
    private boolean ivFilterFavorite = false;
    private List data = new ArrayList();

    public HeaderTableModel() {
        this.ivHeaderCodec = new HeaderCodec();
        this.ivFilterTypes = new ArrayList(1);
        this.allData = new ArrayList(this.ivHeaderCodec.getHeaders());
        this.sort(0, false);
    }

    public void filter(List list, boolean bl) {
        this.ivFilterFavorite = bl;
        this.ivFilterTypes = list;
        this.data.clear();
        Iterator iterator = this.allData.iterator();
        block0: while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            if (bl && !header.isFavorite()) continue;
            if (list.isEmpty()) {
                this.data.add(header);
                continue;
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (!string.equals(header.getType())) continue;
                this.data.add(header);
                continue block0;
            }
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return Tools.translate("HeaderModel-Game");
            }
            case 1: {
                return Tools.translate("HeaderModel-Type");
            }
            case 2: {
                return Tools.translate("HeaderModel-Decks");
            }
            case 3: {
                return Tools.translate("HeaderModel-Open");
            }
            case 4: {
                return Tools.translate("HeaderModel-level");
            }
            case 5: {
                return Tools.translate("HeaderModel-Favorite");
            }
        }
        return "";
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(int n, int n2) {
        Header header = (Header)this.data.get(n);
        switch (n2) {
            case 0: {
                return header.getName();
            }
            case 1: {
                return header.getType();
            }
            case 2: {
                return new Integer(header.getDecks());
            }
            case 3: {
                return new Boolean(header.isOpen());
            }
            case 4: {
                return new Integer(header.getLevel());
            }
            case 5: {
                return new Boolean(header.isFavorite());
            }
            case 6: {
                return header.getFile();
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 5;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 5) {
            return;
        }
        Header header = (Header)this.data.get(n);
        header.setFavorite((Boolean)object);
        this.fireTableCellUpdated(n, n2);
        this.ivHeaderCodec.updateHeader(header);
    }

    public void sort(int n, boolean bl) {
        Comparator comparator = null;
        switch (n) {
            case 0: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        String string = ((Header)object).getName();
                        String string2 = ((Header)object2).getName();
                        return string.compareTo(string2);
                    }
                };
                break;
            }
            case 1: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        String string = ((Header)object).getType();
                        String string2 = ((Header)object2).getType();
                        return string.compareTo(string2);
                    }
                };
                break;
            }
            case 2: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        return ((Header)object2).getDecks() - ((Header)object).getDecks();
                    }
                };
                break;
            }
            case 3: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Boolean bl = new Boolean(((Header)object).isOpen());
                        Boolean bl2 = new Boolean(((Header)object2).isOpen());
                        return bl2.toString().compareTo(bl.toString());
                    }
                };
                break;
            }
            case 4: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        return ((Header)object2).getLevel() - ((Header)object).getLevel();
                    }
                };
                break;
            }
            case 5: {
                comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Boolean bl = new Boolean(((Header)object).isFavorite());
                        Boolean bl2 = new Boolean(((Header)object2).isFavorite());
                        return bl2.toString().compareTo(bl.toString());
                    }
                };
                break;
            }
        }
        if (comparator == null) {
            return;
        }
        Collections.sort(this.allData, comparator);
        if (bl) {
            Collections.reverse(this.allData);
        }
        this.filter(this.ivFilterTypes, this.ivFilterFavorite);
    }
}

