/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import kgd.card.player.gui.DlgHelp;
import kgd.card.player.gui.DlgMessage;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.Tools;
import kgd.card.player.io.Shareware;
import kgd.card.player.io.StatCodec;

public final class DlgShareware
extends JDialog {
    private JButton ivBttCancel;
    private JButton ivBttHelp;
    private JButton ivBttOK;
    private JTextField ivTxtKey;
    private Shareware ivShareware;

    private DlgShareware() {
        StatCodec statCodec = new StatCodec();
        try {
            statCodec.decode();
        }
        catch (Exception exception) {}
        this.ivShareware = new Shareware(statCodec.getStats());
        this.initialize();
    }

    public DlgShareware(Dialog dialog, Shareware shareware) {
        super(dialog, true);
        this.ivShareware = shareware;
        this.initialize();
    }

    public DlgShareware(Frame frame, Shareware shareware) {
        super(frame, true);
        this.ivShareware = shareware;
        this.initialize();
    }

    private void checkKey() {
        String string = this.ivShareware.setKey(this.ivTxtKey.getText()) ? Tools.translate("Shareware-GoodKey") : Tools.translate("Shareware-BadKey");
        DlgMessage.display(this, 4, string);
        if (this.ivShareware.isRegistered()) {
            this.dispose();
        }
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivBttOK) {
            this.checkKey();
        }
        if (actionEvent.getSource() == this.ivBttHelp) {
            DlgHelp dlgHelp = new DlgHelp(this);
            dlgHelp.showPage("AboutRegistration.htm");
        }
        if (actionEvent.getSource() == this.ivBttCancel) {
            this.dispose();
        }
    }

    private void initialize() {
        this.setTitle(Tools.translate("Shareware-Title"));
        this.setName("DlgShareware");
        this.getContentPane().setLayout(new FlowLayout(1, 4, 4));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgShareware.this.dispose();
            }
        });
        this.initializeComponents();
        int n = 320 + FrmMain.getFrameInsetsDimension().width;
        int n2 = 304 + FrmMain.getFrameInsetsDimension().height;
        int n3 = (Toolkit.getDefaultToolkit().getScreenSize().width - n) / 2;
        int n4 = (Toolkit.getDefaultToolkit().getScreenSize().height - n2) / 2;
        if (this.getParent() != null) {
            n3 = this.getParent().getX() + (this.getParent().getWidth() - n) / 2;
            n4 = this.getParent().getY() + (this.getParent().getHeight() - n2) / 2;
        }
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    private void initializeComponents() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 2, 2), false);
        jPanel.setPreferredSize(new Dimension(312, 200));
        jPanel.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setPreferredSize(new Dimension(304, 172));
        jTextArea.setFont(new Font("dialog.bold", 1, 12));
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(Tools.translate("Shareware-Note"));
        jPanel.add(jTextArea);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 2, 2), false);
        jPanel2.setPreferredSize(new Dimension(312, 48));
        jPanel2.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel2);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(212, 19));
        jLabel.setFont(new Font("dialog.bold", 1, 12));
        jLabel.setHorizontalAlignment(2);
        jLabel.setText(Tools.translate("Shareware-Code"));
        jPanel2.add(jLabel);
        JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(90, 19));
        jTextField.setFont(new Font("dialog.bold", 1, 12));
        jTextField.setHorizontalAlignment(0);
        jTextField.setEditable(false);
        jTextField.setText(this.ivShareware.getCode());
        jPanel2.add(jTextField);
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(new Dimension(212, 19));
        jLabel2.setFont(new Font("dialog.bold", 1, 12));
        jLabel2.setHorizontalAlignment(2);
        jLabel2.setText(Tools.translate("Shareware-Key"));
        jPanel2.add(jLabel2);
        this.ivTxtKey = new JTextField();
        this.ivTxtKey.setPreferredSize(new Dimension(90, 19));
        this.ivTxtKey.setFont(new Font("dialog.bold", 1, 12));
        this.ivTxtKey.setHorizontalAlignment(0);
        this.ivTxtKey.setText("");
        jPanel2.add(this.ivTxtKey);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 2, 2), false);
        jPanel3.setPreferredSize(new Dimension(312, 40));
        jPanel3.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel3);
        this.ivBttOK = new JButton();
        this.ivBttOK.setPreferredSize(new Dimension(100, 32));
        this.ivBttOK.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttOK.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setToolTipText(Tools.translate("Shareware-OK"));
        this.ivBttOK.setFocusPainted(false);
        this.ivBttOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgShareware.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttOK);
        this.ivBttHelp = new JButton();
        this.ivBttHelp.setPreferredSize(new Dimension(100, 32));
        this.ivBttHelp.setIcon(Tools.getIcon("Help.gif"));
        this.ivBttHelp.setRolloverIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setPressedIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setToolTipText(Tools.translate("Shareware-Help"));
        this.ivBttHelp.setFocusPainted(false);
        this.ivBttHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgShareware.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttHelp);
        this.ivBttCancel = new JButton();
        this.ivBttCancel.setPreferredSize(new Dimension(100, 32));
        this.ivBttCancel.setIcon(Tools.getIcon("Cancel.gif"));
        this.ivBttCancel.setRolloverIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setPressedIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setToolTipText(Tools.translate("Shareware-Cancel"));
        this.ivBttCancel.setFocusPainted(false);
        this.ivBttCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgShareware.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttCancel);
    }

    public static void main(String[] stringArray) {
        try {
            DlgShareware dlgShareware = new DlgShareware();
            dlgShareware.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((Component)dlgShareware).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

