@REM ----------
@REM INSTALL - Written by Anthony L. Sommers and Dieter Martin
@REM ----------

@echo off
if "%windir%"=="" goto E_win_not_running

if not "%1"=="" goto L_parameter

:L_start
SET SH=FALSE
SET SM=FALSE

cls
echo Wing Commander IV for Windows 95 (WC4WIN95) [TM]
echo (c) 1996, Origin Systems
echo.
echo You have chosen to install the Wing Commander IV for Windows 95.
echo WC4WIN95 requires that you have the release version of Wing
echo Commander IV for MS-DOS.
echo.
echo For ease in installation, we will ask you a series of questions.
echo Simply press [Y] to answer YES, and [N] to answer NO.
echo.
choice Do you have Wing Commander IV for MS-DOS 
if errorlevel==2 goto E_no_wc4

echo.
choice Is Wing Commander IV installed 
if errorlevel==2 goto E_not_installed

echo.
choice Is Wing Commander IV installed in the default directory (C:\WC4) 
if errorlevel==2 goto E_dir_not_specified

if not exist "c:\wc4\wc4.exe" goto E_dir

:L_shortcut
echo.
echo Would you like a shortcut placed on your desktop to run
choice Wing Commander IV for Windows 95 
if errorlevel==2 goto L_start_menu

if exist c:\win95\explorer.exe goto L_cs_95
if exist c:\windows\explorer.exe goto L_cs_dows
if exist c:\win31\explorer.exe goto L_cs_31

echo INSTALL was unable to find your Windows 95 directory. A shortcut
echo was not created. Consult the HELP_WC4.TXT file for information
echo on how to create a shortcut manually.
goto L_install

:L_cs_95
SET SH=TRUE
copy wingco~1.$$$ "c:\win95\desktop\Wing Commander IV for Windows 95.lnk" > NUL
goto L_start_menu

:L_cs_dows
SET SH=TRUE
copy wingco~1.$$$ "c:\windows\desktop\Wing Commander IV for Windows 95.lnk" > NUL
goto L_start_menu

:L_cs_31
SET SH=TRUE
copy wingco~1.$$$ "c:\win31\desktop\Wing Commander IV for Windows 95.lnk" > NUL
goto L_start_menu

:L_start_menu
echo.
echo Would you like a program group for Wing Commander IV for Windows 95
choice listed under the Start Menu ("Programs\Origin") 
if errorlevel==2 goto L_install

if exist c:\win95\explorer.exe goto L_cpg_95
if exist c:\windows\explorer.exe goto L_cpg_dows
if exist c:\win31\explorer.exe goto L_cpg_31

echo INSTALL was unable to find your Windows 95 directory. A program
echo group was not created.
goto L_install

:L_cpg_95
SET SM=TRUE
md c:\win95\startm~1\Programs\Origin > NUL
copy wingco~1.$$$ "c:\win95\startm~1\Programs\Origin\Wing Commander IV for Windows 95.lnk" > NUL
copy wc4_ih.$$$ "c:\win95\startm~1\Programs\Origin\Wing Commander IV Install Help.lnk" > NUL
copy wc4_re.$$$ "c:\win95\startm~1\Programs\Origin\Wing Commander IV Readme.lnk" > NUL
goto L_install

:L_cpg_dows
SET SM=TRUE
md c:\windows\startm~1\Programs\Origin > NUL
copy wingco~1.$$$ "c:\windows\startm~1\Programs\Origin\Wing Commander IV for Windows 95.lnk" > NUL
copy wc4_ih.$$$ "c:\windows\startm~1\Programs\Origin\Wing Commander IV Install Help.lnk" > NUL
copy wc4_re.$$$ "c:\windows\startm~1\Programs\Origin\Wing Commander IV Readme.lnk" > NUL
goto L_install

:L_cpg_31
SET SM=TRUE
md c:\win31\startm~1\Programs\Origin > NUL
copy wingco~1.$$$ "c:\win31\startm~1\Programs\Origin\Wing Commander IV for Windows 95.lnk" > NUL
copy wc4_ih.$$$ "c:\win31\startm~1\Programs\Origin\Wing Commander IV Install Help.lnk" > NUL
copy wc4_re.$$$ "c:\win31\startm~1\Programs\Origin\Wing Commander IV Readme.lnk" > NUL
goto L_install

:L_install
echo.
echo Installing...
copy wc4w.exe c:\wc4 > NUL
copy xanlib.dll c:\wc4 > NUL
copy help_wc4.txt c:\wc4 > NUL
copy readme95.txt c:\wc4 > NUL
goto L_complete

:L_parameter
if not exist "%1\wc4.exe" goto E_dir
echo.
echo Installing...
copy wc4w.exe %1 > NUL
copy xanlib.dll %1 > NUL
copy help_wc4.txt %1 > NUL
copy readme95.txt %1 > NUL
echo.
echo Installation complete.
goto L_done

:L_complete
echo.
echo Installation complete.

:L_sh
if "%SH%"=="FALSE" goto L_sm
echo.
echo You may run Wing Commander IV for Windows 95 by double-clicking
echo the shortcut created on your Desktop.

:L_sm
if "%SM%"=="FALSE" goto L_done
echo.
echo You may run Wing Commander IV for Windows 95 by clicking on 
echo Start/Programs/Origin/Wing Commander IV for Windows 95.

:L_done
echo.
echo You may run Wing Commander IV for Windows 95 by executing WC4W.EXE
echo in the Wing Commander IV directory (folder).
goto end

REM ----------
REM Error statements
REM ----------

:E_win_not_running
cls 
echo Exiting INSTALL :
echo.
echo INSTALL requires Windows 95. Please run Windows 95 and restart
echo the installation.
echo.
goto end

:E_no_wc4
cls 
echo Exiting INSTALL :
echo.
echo Please run down to your local software store and BUY it! :)
echo.
goto end

:E_not_installed
cls 
echo Exiting INSTALL :
echo.
echo You must install the DOS version of Wing Commander IV before 
echo installing the Windows 95 version. Please consult the 
echo Wing Commander IV Install Guide for instructions on installing
echo the DOS version.
echo.
goto end

:E_dir_not_specified
cls 
echo Exiting INSTALL :
echo.
echo You must specify a directory where Wing Commander IV is installed.
echo For example :
echo.
echo     INSTALL C:\GAMES\WC4
echo.
echo In this example, 
echo.
echo     C:          is the hard drive letter
echo     \GAMES\WC4  is the directory or folder for Wing Commander IV
echo.
goto end

:E_dir
cls 
echo Exiting INSTALL :
echo.
echo Wing Commander IV could not be found in the directory 
echo %1. Check the directory spelling and try again.
echo.
echo For example :
echo.
echo     INSTALL C:\GAMES\WC4
echo.
echo In this example, 
echo.
echo     C:          is the hard drive letter
echo     \GAMES\WC4  is the directory or folder for Wing Commander IV
echo.
goto end

:end



