@echo off

cls
echo.
echo. 
echo Welcome to Phantasmagoria: A Puzzle of Flesh
echo DOS Patch Install
echo.
echo.
echo This utility will convert your Windows-95 version
echo of Phantasmagoria: A Puzzle of Flesh to the DOS
echo version.  If at any point you decide that you wish
echo abort this process, press CONTROL-C.
echo.
echo.
pause

REM **************************************************
REM Test for dos v7, and warn user of possible problems
REM **************************************************
what d>nul
if not errorlevel 70 goto nowarn
cls
echo.
echo You are running DOS version 7 or higher.  If you are running
echo DOS from a window in Windows 95, you may encounter problems
echo installing this patch.  We recomend you run this program in
echo from MS-DOS mode.  You may do this by clicking on the
echo "Start" button in Windows 95, and choosing "Shutdown", then
echo "Restart the computer in MS-DOS mode."  For further
echo information, please see DOSPATCH.TXT.
echo.
echo If you are already in MS-DOS mode, or you wish to attempt the
echo installation anyway, press Y, otherwise, press N to abort the
echo patch install program.
echo.
choice Do you wish to continue with Patch Install?
if errorlevel 2 goto abort

:nowarn

REM **************************************************
REM init error tracking var
REM **************************************************
set patcherr=none

REM **************************************************
REM save off current directory in install dir variable
REM **************************************************

cd>install.dat
what s<install.dat>nul
set p2instdir=%what%
del install.dat

REM **************************************************
REM ask for CDROM drive letter
REM **************************************************

:askcd
cls
echo.
echo.
echo.
echo Please insert DISK ONE of Phantasmagoria: A Puzzle of Flesh
echo in your CD-ROM drive.  After you have done so, please
pause
echo.
echo.
echo.
echo Please type the drive letter of your CD-ROM.
what c>nul
set p2sourcedrive=%what%

REM **************************************************
REM check for P2 in that drive
REM **************************************************

echo.
echo.
echo.
echo Checking for Phantasmagoria: A Puzzle of Flesh CD in drive %p2sourcedrive%:
if not exist %p2sourcedrive%:\ressci.001 goto cderr
echo.
echo Found in drive %p2sourcedrive%:
echo.
pause
goto askdrive

:cderr
cls
echo.
echo.
echo.
echo Unable to detect the Phantasmagoria: A Puzzle of Flesh CD#1
echo in drive %p2sourcedrive%:.  The drive letter may be incorrect,
echo or the CD may not inserted in it, or the drive may not have been ready.
pause
goto askcd

REM **************************************************
REM ask for install drive
REM **************************************************

:askdrive
cls
echo.
echo.
echo.
echo Please type the letter of the hard drive you wish
echo to install Phantasmagoria - A Puzzle of Flesh to.
what c>nul
set p2destdrive=%what%
if not exist %p2destdrive%:\nul goto driveerr
what ke %p2destdrive%>nul
if errorlevel 100 goto driveok

:driveerr
echo.
echo.
echo The drive you have chosen does not have enough space
echo or does not exist.  Do you wish to:
echo (C)hoose another drive, or
echo (E)xit install?
choice /c:ec /n
if errorlevel 2 goto askdrive
goto abort

:driveok
cls
echo.
echo.
echo Drive %p2destdrive%: appears to have sufficient space for install.
echo.
echo.
pause

REM **************************************************
REM ask for the install path
REM **************************************************

:askpath
cls
echo.
echo.
echo.
echo Please enter the path (directory) you wish to install
echo the game to.  If you do not wish to select a directory,
echo just press ENTER, and the default \SIERRA\P2DOS will
echo be used.
echo .
what s
echo.
echo Working...  Please wait.
echo.
set p2destpath=%what%
if not errorlevel 1 goto skipadd

REM **************************************************
REM check for a leading "\", and add if needed
REM **************************************************

echo %p2destpath%>install.dat
what c<install.dat>nul
if not "%what%" == "\" set p2destpath=\%p2destpath%
del install.dat
:skipadd

REM **************************************************
REM check for a trailing "\", and add if needed
REM **************************************************
echo %p2destpath%>install.dat
REM now reverse it...
set p2rev=

:dorev
what c<install.dat>nul
set p2rev=%what%%p2rev%
popchar<install.dat>install.tmp
if not errorlevel 1 goto revdone
del install.dat
ren install.tmp install.dat
goto dorev

:revdone
echo %p2rev%>install.dat
what c<install.dat>nul
if not "%what%" == "\" set p2destpath=%p2destpath%\
del install.dat
set p2rev=

REM **************************************************
REM now, check for doubled "\"s, and remove them.
REM **************************************************
echo %p2destpath%>install.dat
set p2destpath=

:lffs
REM looking for first slash
what c<install.dat>nul
popchar<install.dat>install.tmp
if not errorlevel 1 goto cdsdone
del install.dat
ren install.tmp install.dat
set p2destpath=%p2destpath%%what%
if not "%what%" == "\" goto lffs

:lfss
REM look for subsequent slashes, and ignore them
popchar<install.dat>nul
if not errorlevel 1 goto cdsdone
what c<install.dat>nul
if not "%what%" == "\" goto lffs
popchar<install.dat>install.tmp
del install.dat
ren install.tmp install.dat
goto lfss

:cdsdone
del install.dat
if exist install.tmp del install.tmp
REM **************************************************
REM check for existance of path
REM **************************************************

set p2dpf=unused

:checkpath
if exist %p2destdrive%:%p2destpath%nul goto pathok

REM otherwise, lets make it for them

if "%p2dpf%" == "unused" goto makepath
set patcherr=Error creating install directory.
set p2dpf=
rem ------------------------------------
cls
echo %patcherr%
echo "%p2destpath%"
rem *** goto patchfailed
pause
goto askpath
rem ------------------------------------

:makepath
echo %p2destpath%>install.dat
set p2dpf=%p2destdrive%:

:builddir
popchar<install.dat>nul
if not errorlevel 1 goto wholepathread
what c< install.dat>nul
if not "%what%" == "\" set p2dpf=%p2dpf%%what%
popchar<install.dat>install.tmp
del install.dat
ren install.tmp install.dat
if "%what%" == "\" goto dirbuilt
goto builddir

:dirbuilt
if exist %p2dpf%\nul goto dbdone
md %p2dpf%
:dbdone
set p2dpf=%p2dpf%\
goto builddir

:wholepathread
if not exist %p2dpf%\nul md %p2dpf%
set p2dpf=
del install.dat
del install.tmp
goto checkpath

:pathok
cls
if exist %p2destdrive%:%p2destpath%sierra\nul goto skipmdsierra
md %p2destdrive%:%p2destpath%sierra

:skipmdsierra
if exist %p2destdrive%:%p2destpath%sierra\p2dos\nul goto skipmdp2dos
md %p2destdrive%:%p2destpath%sierra\p2dos

:skipmdp2dos
set p2destpath=%p2destpath%sierra\p2dos
if exist %p2destdrive%:%p2destpath%\nul goto pathdone
set patcherr=Error creating install directory.
rem ------------------------------------
cls
echo %patcherr%
echo "%p2destpath%"
rem *** goto patchfailed
pause
goto askpath
rem ------------------------------------

:pathdone
echo.
echo.
echo Phantasmagoria: A Puzzle of Flesh will be installed in
echo %p2destdrive%:%p2destpath%
echo.
echo.
pause

REM **************************************************
REM start the installation process
REM **************************************************

:begininstall
cls
rem ------------------------------------
copy what.exe %p2destdrive%:%p2destpath%
rem ------------------------------------
call patch2.bat %p2destdrive% %p2sourcedrive% foo %p2destpath% %p2instdir%
cls
if %patcherr% == user_aborted goto abort
if not %patcherr% == none goto patchfailed
rem ------------------------------------
goto end
rem ------------------------------------

:abort
cls
echo.
echo.
echo DOS Patch Install has been aborted.
echo.
echo.
goto done

:patchfailed
cls
echo.
echo.
echo DOS Patch Install has failed.
echo.
echo %patcherr%
echo "%p2destpath%"
echo.
goto done

:end
cls
echo.
echo.
echo Phantasmagoria: A Puzzle of Flesh
echo DOS Patch Install has been completed.
echo.
echo.
echo Preparing to run INSTALL for driver setup
echo.
echo.
pause
rem ------------------------------------
rem *** %p2destdrive%:
rem ------------------------------------
cd %p2destpath%
call install.bat

:done
set p2instdir=
set p2destdrive=
set p2sourcedrive=
set p2destpath=
set patcherr=
