@echo off
cls
Rem /  Batch File Installer for
Rem /      Creature Shock SET file
Rem /      version 1.00a
Rem /  (c) 1994 Virgin Interactive Entertainment
Rem /  DH12.19

if exist CREATURE.SET goto NOERR
goto ERR3

:NOERR
if %1x==x goto TryDefault
if exist %1\SHOCK.EXE goto DO_IT
goto ERR

:TryDefault
if exist c:\crshock\shock.exe goto CONTINUE
goto usage

:CONTINUE
echo Detected default install directory. 
echo.
set CRSHOCKPATH=C:\CRSHOCK
if %CRSHOCKPATH%==C:\CRSHOCK goto DO_IT2
goto ERR2

:DO_IT
set CRSHOCKPATH=%1
if %CRSHOCKPATH%==%1 goto DO_IT2 
goto ERR2

:DO_IT2
echo One moment please...
echo.
echo Copying level select file...
copy creature.set %CRSHOCKPATH% /Y > NUL
echo.
pause
if exist %CRSHOCKPATH%\creature.set goto SUCCESS
goto ERROR

:ERR3
echo.
echo             CREATURE.SET file not found  
echo.
echo           Please ensure that the install is run from the 
echo           floppy disk drive.
echo.
echo           For example, you should be typing:
echo           A:
echo           CRSET
echo.
echo.
goto ERROR

:ERR2
echo.
echo             Not enough environment space   
echo                  to finish installation of update.
echo.
echo            Please increase the environment space before 
echo            running the install. 
echo.
echo            For example, add: 
echo            SHELL=C:\DOS\COMMAND.COM C:\DOS\ /p /e:256
echo            to your CONFIG.SYS file.
echo.
echo            Do NOT run the install from Windows.
echo.
echo.
goto ERROR

:ERR
echo. 
echo      *** Could not find the Creature Shock files in: 
echo          %1 
echo          please check path.

:USAGE
echo. 
echo      To update your installation of Creature Shock, type "CRSET"
echo      followed by a space and the name of the directory where the
echo      Creature Shock files were originally installed.
echo. 
echo      For example, if the update files are located on a disk in
echo      drive A:, and Creature Shock was originally installed to D:\CRSHOCK, 
echo      the commands would look like this:
echo. 
echo      A:
echo      CRSET D:\CRSHOCK
echo. 
goto end

:ERROR
echo            Failed attempt to update Creature Shock 
echo.
echo                  For assistance, please contact 
echo                Virgin Interactive Entertainment's
echo                        Technical Support
echo                         (714) 833-1999
goto end

:SUCCESS
cls
echo       Level Select File installed successfully 
echo.
echo      To run the game, just change to the %CRSHOCKPATH% 
echo      directory and type SHOCK
echo.
echo      After selecting "Play", you can now choose to start from any
echo      of the five levels.
echo.
echo.

:END
set CRSHOCKPATH=
echo.
