//=============================================================================
//
// TALES OF CHIVALRY: Script Dcor
//
//=============================================================================
//
// Volet	: 1
// Qute	: 4
//
//=============================================================================
//
// Comprend :
// 	Camelot (a faire)
//	Uffington (a reprendre de Q0)
//	Arden (idem)
// 	Avallon (a faire)
//	Magovenium (a reprendre Q0 + Catacombes L2)
//	Tintagel (pas pret...)
//	Monde des ombres ??

SCRIPT_DECOR

section IN

	[def, 1]
		// landscape de depart
//		AREA	0 104
		AREA 0 104

section END



//=================================================================================
//
// LANDSCAPES :
// Uffington 	100
// Arden	101
// Magovenium	102
// Camelot EN COURS 	104  (TODO)
//
//=================================================================================

section LAND

	[def, 1]

		ID	100			// id landscape
		NAME	"Landscape Uffington"
		NUM	1			// nbre de modules
		REGION	"Uffington"
		ICON	"ufingt"

		//-------------------------------------------------------------------
		// destination landscape: id, destination, entre, active
		//-------------------------------------------------------------------

		TOLAND	102 102 0 1
		TOLAND	101 101 0 1
		TOLAND	105 105 4 1	//pres camp chevalier noir

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lUfg"
		
		ZFAR	25000
		AENV	2

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	0 1 0
		IN	1 4 0
		IN	2 2 0
		IN	3 3 0
		IN	4 5 0
		IN	6 7 0
		IN	7 8 0
		IN	8 9 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1002 10 0
		PBOX	1003 11 0
		PBOX	1004 12 0
		PBOX	1006 14 0
		PBOX	1007 15 0
		PBOX	1008 16 0

		PBOX	11 17 0
		PBOX	12 18 0
		PBOX	13 19 0
		PBOX	14 20 0
		PBOX	15 21 0
		PBOX	16 22 0
		PBOX	17 23 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		//TOZI	1 2 5 2 1	//route 2
		//TOZI	2 3 1 1 1	//VILLA lUCIUS
		//TOZI	3 5 5 1 1	//route
		//TOZI	5 7 2 1 1	//chateau
		TOZI	6 8 4 1 1
		TOZI	7 9 3 1 1
		
		//-------------------------------------------------------------------
		// teleports: id, polytope, boite dest, actif
		//-------------------------------------------------------------------

		TELEP	1 15 4 1
		TELEP	2 16 2 1		
		
		//-------------------------------------------------------------------
		// collisions interactives: id, index objet, active
		//-------------------------------------------------------------------

		COLLI	1 1 0
		COLLI	2 2 0
		COLLI	3 3 0
		COLLI	4 4 0
		COLLI	5 5 0

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	0 10 1
		TRIG	1 11 1
		TRIG	2 12 1
		TRIG	4 13 1
		TRIG	5 14 1

		//-------------------------------------------------------------------
		// lampe permanente: id, index light DB
		//-------------------------------------------------------------------

		LIGHT	1 1 1

		PBOX	2000 100 0
		PBOX	2001 101 0
		PBOX	2002 102 0
		PBOX	2003 103 0
		PBOX	2004 104 0
		PBOX	2005 105 0
		PBOX	2006 106 0


		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		1 30 100 0 1 "A_Uff"
		  ASND		2 40 70 60 1 "A_loup2"
		  ASND		3 35 70 60 1 "A_Maraf1"
		  ASND		4 35 70 60 1 "A_Maraf2"
		  ASND		5 35 70 60 1 "A_Maraf3"
		  ASND		6 30 60 60 1 "A_Corbx"
		 //ASND		7 100 100 0 1 "vox"
                                        
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------

//gab debut                                                     
   		BSNDD	19 2000 100 50 45 1 "O_loup2" 2000 7000 
   		BSNDD	20 2000 100 40 45 1 "O_oise3" 2000 7000    
 	
 		BSNDD	21 2001 100 50 45 1 "O_loup" 2000 7000     
		BSNDD	20 2001 100 50 45 1 "O_Aigle" 2000 7000		
		
 		BSNDD	22 2002 100 50 45 1 "O_loup3" 2000 7000    
		BSNDD	23 2002 100 50 45 1 "O_oise3" 2000 7000    
   	
   		BSNDD	24 2003 100 60 45 1 "O_loup2" 2000 7000         
   		BSNDD	25 2003 100 60 45 1 "O_loup2" 2000 7000          
 
   
   	  	BSNDD	26 2004 100 40 10 1 "O_loup" 2000 7000       
   	  	BSNDD	27 2004 100 40 10 1 "O_oise3" 2000 7000       

   
   	  	BSNDD	28 2005 100 70 15 1 "O_loup3" 2000 7000    
   	  	BSNDD	29 2005 100 70 15 1 "O_oise3" 2000 7000    

   		BSNDD	30 2006 100 50 10 1 "O_loup2" 2000 7000    
   		BSNDD	31 2006 100 50 10 1 "O_Aigle" 2000 7000    
//gab fin                                                       
   		
   		
   		BSNDD_E	19 2000 40 50 45 1 "O_loup2" 2000 7000
   		BSNDD_E	20 2000 40 40 45 1 "O_oise3" 2000 7000
 	
 		BSNDD_E	21 2001 30 50 45 1 "O_loup" 2000 7000
		BSNDD_E	20 2001 30 50 45 1 "O_Aigle" 2000 7000	
		
 		BSNDD_E	22 2002 40 50 45 1 "O_loup3" 2000 7000
		BSNDD_E	23 2002 40 50 45 1 "O_oise3" 2000 7000
   	
   		BSNDD_E	24 2003 50 60 45 1 "O_loup2" 2000 7000     
   		BSNDD_E	25 2003 50 60 45 1 "O_loup2" 2000 7000      

   
   	  	BSNDD_E	26 2004 40 40 10 1 "O_loup" 2000 7000   
   	  	BSNDD_E	27 2004 40 40 10 1 "O_oise3" 2000 7000   

   
   	  	BSNDD_E	28 2005 40 70 15 1 "O_loup3" 2000 7000
   	  	BSNDD_E	29 2005 40 70 15 1 "O_oise3" 2000 7000

   		BSNDD_E	30 2006 70 50 10 1 "O_loup2" 2000 7000
   		BSNDD_E	31 2006 50 50 10 1 "O_Aigle" 2000 7000

section END

section LAND

	[def, 1]

		ID	101			// id landscape
		NAME	"Landscape Arden"
		NUM	1			// nbre de modules
		REGION	"Arden"
		ICON	"arden"

		//-------------------------------------------------------------------
		// destination landscape: id, destination, entre, active
		//-------------------------------------------------------------------

		TOLAND	100 100 0 1
		TOLAND	104 104 0 1		// vers Camelot
		//TOLAND	102 102 99 1
		TOLAND	102 102 0 1
	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lArd"
		
		ZFAR	25000
		AENV	3

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	0 1 0
		IN	1 2 0
		IN	2 3 0
		IN	3 4 0
		IN	4 5 0
		IN	5 6 0
		IN	6 7 0
		IN	7 8 0
		IN	8 9 0
		IN	9 10 0
		IN	10 11 0
		IN	11 12 0
		IN	12 13 0
		IN	13 29 0
		IN	14 30 0
		IN	15 32 0
		IN	16 33 0
		IN	17 34 0
		IN	18 35 0
		IN	19 36 0
		IN	20 37 0
		IN	21 38 0
		IN	22 39 0
		IN	23 40 0
		IN	24 41 0
		

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 2 9 1 1
		TOZI	2 3 7 1 1
		TOZI	3 4 6 3 1
		TOZI	4 5 6 2 1
		TOZI	5 6 6 1 1
		TOZI	6 7 6 7 1
		TOZI	7 8 6 6 1
		TOZI	8 9 6 4 1
		TOZI	9 10 8 1 1
		TOZI	10 11 6 5 1
		TOZI	11 12 10 1 1
		TOZI	12 13 11 1 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1001 25 0
		PBOX	1002 24 0
		PBOX	1003 16 0
		PBOX	1004 15 0
		PBOX	1005 14 0
		PBOX	1006 20 0
		PBOX	1007 19 0
		PBOX	1008 17 0
		PBOX	1009 21 0
		PBOX	1010 18 0
		PBOX	1011 22 0
		PBOX	1012 23 0
		PBOX	14 26 0
		PBOX	15 27 0
		PBOX	16 28 0
		PBOX	55 86 0
		PBOX	56 85 0
		PBOX	57 87 0
		
		PBOX	20 50 0
		PBOX	21 51 0
		PBOX	22 52 0
		PBOX	23 53 0
		PBOX	24 54 0
		PBOX	25 55 0
		PBOX	26 56 0
		PBOX	27 57 0
		PBOX	28 58 0
		PBOX	29 59 0
		PBOX	30 60 0
		PBOX	31 61 0
		PBOX	32 62 0
		PBOX	33 63 0
		PBOX	34 64 0
		PBOX	35 65 0
		PBOX	36 66 0
		PBOX	37 67 0
		PBOX	38 68 0
		PBOX	39 69 0
		PBOX	40 70 0
		PBOX	41 71 0
		PBOX	42 72 0
		PBOX	43 73 0
		PBOX	44 74 0
		PBOX	45 75 0
		PBOX	46 76 0
		PBOX	47 77 0
		PBOX	48 78 0
		PBOX	49 79 0
		PBOX	50 80 0
		PBOX	51 81 0
		PBOX	52 82 0
		PBOX	53 83 0
		PBOX	54 84 0

		PBOX	60 31 0
		PBOX	61 88 0

		//-------------------------------------------------------------------
		// teleports: id, polytope, boite dest, actif
		//-------------------------------------------------------------------

		TELEP	1 16 15 1
		TELEP	2 17 16 1
		TELEP	3 18 17 1
		TELEP	4 19 18 1
		TELEP	5 20 19 1
		TELEP	6 21 20 1
		TELEP	7 22 21 1
		TELEP	8 23 22 1
		TELEP	9 24 23 1
		TELEP	10 25 24 1
		
		//-------------------------------------------------------------------
		// objets decor: id, entite, boite, etat
		//-------------------------------------------------------------------

		OBJF	1 "Tronc darbre" 60 1
		OBJF	2 "Tronc darbre 2" 61 1

		COLLI 1 1 0 
		COLLI 2 2 0 

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 14 1

		
		PBOX	2000  150 0
		PBOX	2001 151 0
		PBOX	2002 152 0
		PBOX	2003 153 0
		PBOX	2005 155 0
		PBOX	2004 154 0
		PBOX	2006 156 0

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		5 60 100 0 1 "A_venArd"                             "
		  ASND		1 65 50 80 1 "A_geai"
		  ASND		2 90 50 80 1 "A_neige"
		  ASND		4 50 30 60 1 "A_branch"
		  ASND		6 40 30 80 1 "A_envol"
		  ASND		7 30 30 60 1 "A_oise1"
		  ASND		8 40 30 60 1 "A_oise2"
		  ASND		9 30 30 60 1 "A_oise3"
		  ASND		3 40 30 60 1 "A_envol2"
		  ASND		10 40 30 80 1 "A_oise4"
		  ASND		11 40 30 80 1 "A_oise5"
		  ASND		12 80 30 60 1 "A_grince"
		  //ASND		13 100 100 0 1 "vox"
                                        
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------

//gab debut	                                                                                                                                                                                                                     		
   		BSNDD	19 2000 100 50 10 1 "O_dragon" 6000 7100 
   		                                                                                                                                                 
   		BSNDD	20 2000 100 50 10 1 "O_drago2" 6000 7100 
		BSNDD	21 2001 100 50 5 1 "O_loup" 3000 4200                                                                                                                                                                        		
		BSNDD	22 2002 100 50 0 1 "O_corb" 2900 3600                                                                                                                                                                         		
		BSNDD	23 2002 100 100 0 1 "O_fanto"    2900 3600                                                                                                                                                                
   		BSNDD	24 2003 100 60 10 1 "O_riref5" 6500 7800
   		//gab fin 4/10
   	  	BSNDD	26 2003 100 60 10 1 "O_riref4" 6500 7800                                                                                                                                                                      	  	
   	  	BSNDD	27 2004 100 40 5 1 "O_loup" 5200 8500                                                                                                                                                                          	  	
   	  	BSNDD	28 2004 100 40 10 1 "O_sang2" 5200 8500                                                                                                                                                                       	  	
   	  	BSNDD	29 2004 100 60 5 1 "O_loup2" 5200 8500                                                                                                                                                                          	  	
   	  	BSNDD	30 2004 100 50 5 1 "O_loup3" 5200 8500                                                                                                                                                                        		
   	  	BSNDD	31 2005 100 60 10 1 "O_offr" 4200 5500                                                                                                                                                                        		
   	  	BSNDD	32 2005 100 60 10 1 "O_esprit" 4200 5500                                                                                                                                                                       		
   	  	BSNDD	34 2006 100 50 10 1 "O_riref2" 2000 7200                                                                                                                                                                       		
   	  	BSNDD	35 2006 100 50 10 1 "O_riref3" 2000 7200                                                                                                                                                                       		
   	  	BSNDD	36 2006 100 50 10 1 "O_riref4" 2000 7200                                                                                                                                                                     
   	  	//gab fin             
		BSNDD_E	19 2000 100 50 10 1 "O_dragon" 6000 7100
		BSNDD_E	20 2000 100 50 10 1 "O_drago2" 6000 7100
   		BSNDD_E	21 2001 100 50 5 1 "O_loup" 3000 4200
  		BSNDD_E	22 2002 100 50 20 1 "O_corb" 2900 3600
 		BSNDD_E	23 2002 100 100 0 1 "O_fanto"    2900 3600
 		BSNDD_E	24 2003 100 60 10 1 "O_riref5" 6500 7800      
 	  	BSNDD_E	25 2003 100 60 10 1 "O_riref2" 6500 7800  
 	  	BSNDD_E	26 2003 100 60 10 1 "O_riref4" 6500 7800 
	  	BSNDD_E	27 2004 100 40 5 1 "O_loup" 5200 8500   
  	  	BSNDD_E	28 2004 100 40 10 1 "O_sang2" 5200 8500  
 	  	BSNDD_E	29 2004 100 60 5 1 "O_loup2" 5200 8500
  	  	BSNDD_E	30 2004 100 50 5 1 "O_loup3" 5200 8500
 		BSNDD_E	31 2005 100 60 10 1 "O_offr" 4200 5500
 		BSNDD_E	32 2005 100 60 10 1 "O_esprit" 4200 5500
 		BSNDD_E	34 2006 100 50 10 1 "O_riref2" 2000 7200
   		BSNDD_E	35 2006 100 50 10 1 "O_riref3" 2000 7200
   		BSNDD_E	36 2006 100 50 10 1 "O_riref4" 2000 7200

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		//ACT	1 "CA licorne 1" 20 "" 100
		ACT	2 "CA loup noir 1" 21 "" 100
		ACT	3 "CA loup blanc 6" 22 "" 100
		ACT	4 "CA mini fee 1" 23 "" 100
		ACT	5 "CA corbeau 6" 24 "" 100
		ACT	6 "CA mini fee 2" 25 "" 100
		ACT	7 "CA mini fee 3" 26 "" 100
		ACT	8 "CA corbeau 1" 27 "" 100
		ACT	9 "CA loup noir 5" 28 "" 100
		ACT	10 "CA loup noir 2" 29 "" 100
		//ACT	11 "CA licorne 2" 30 "" 100
		ACT	12 "CA loup blanc 8" 31 "" 100
		//ACT	13 "CA licorne 3" 32 "" 100
		//ACT	14 "CA licorne 4" 33 "" 100
		ACT	15 "CA loup blanc 4" 34 "" 100
		ACT	16 "CA loup blanc 5" 35 "" 100
		
		ACT	17 "CA loup noir 9" 36 "" 100
		
		ACT	18 "CA corbeau 5" 37 "" 100
		ACT	19 "CA colombe 1" 38 "" 100
		ACT	20 "CA corbeau 4" 39 "" 100
		ACT	21 "CA ourson 1" 40 "" 100
		ACT	22 "CA papillon 11" 41 "" 100
		ACT	23 "CA papillon 12" 42 "" 100
		ACT	24 "CA papillon 13" 43 "" 100
		ACT	25 "CA papillon 14" 44 "" 100
		ACT	26 "CA papillon 15" 45 "" 100
		ACT	27 "CA papillon 16" 46 "" 100
		ACT	28 "CA papillon 17" 47 "" 100
		ACT	29 "CA papillon 18" 48 "" 100
		ACT	30 "CA papillon 19" 49 "" 100
		ACT	31 "CA cerf 5" 50 "" 100
		ACT	32 "CA papillon 20" 51 "" 100
		ACT	33 "CA papillon 21" 52 "" 100
		ACT	34 "CA papillon 22" 53 "" 100
		ACT	35 "CA loup blanc 7" 54 "" 100

section END

section LAND

	[def, 1]

		ID	102			// id landscape
		NAME	"Landscape Magovenium"
		NUM	5			// nbre de modules
		REGION	"Magovenium"
		ICON	"mago"

		//-------------------------------------------------------------------
		// destination landscape: id, destination, entre, active
		//-------------------------------------------------------------------

		TOLAND	100 100 1 1
		TOLAND	101 101 0 1
		TOLAND	104 104 0 1


	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lMah"
		AENV 	2
		ZFAR	20000
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------
		
		IN	1 11 0	// depuis lmeh (personnage hors zone...: on est hors mesh)
		IN	2 14 0  // depuis lmch
		IN	511 1 0  //depuis zprh
		IN	99 15 0

		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	2 15 1
		
		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1011 2 0

		PBOX	3 3 0
		PBOX	4 4 0
		PBOX	5 5 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 1 12 1 1

		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		TODEC	2 12 4 1 1
		TODEC	3 13 5 1 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//PBOX	2000  150 0
		//PBOX	2001 151 0
		//PBOX	2002 152 0
		//PBOX	2003 153 0
		//PBOX	2005 155 0
		//PBOX	2004 154 0
		//PBOX	2006 156 0
		

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		1 40 100 0 1 "A_ventMa"
		  ASND		2 35 50 10 1 "A_Raf1"
		  ASND		3 35 50 20 1 "A_Raf2"
		  ASND		4 35 30 15 1 "A_Raf3"
		  ASND		5 30 30 15 1 "A_envol2"
		  ASND		6 50 40 10 1 "A_oise3"
		  ASND		7 50 50 10 1 "A_Corbx"
		  ASND		8 40 40 50 1 "O_volet"
		  //ASND		11 100 100 0 1 "vox"
                                        
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 14" 3 "" 100
		ACT	2 "CA corbeau 15" 4 "" 100
		ACT	3 "CA chat 5" 5 "" 100

	[mod, 2]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lMbh"
		AENV 	2
		ZFAR	20000
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	9 17 0
		IN	10 2 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1010 3 0
		
		PBOX	6 4 0
		PBOX	7 5 0
		PBOX	8 6 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	3 2 12 2 1

		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		TODEC	10 18 8 1 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	9 11
		SLIGHT	10 12
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		9 40 100 0 1 "A_ventMa"
		  ASND		10 35 50 10 1 "A_Raf1"
		  ASND		11 35 50 20 1 "A_Raf2"
		  ASND		12 35 30 15 1 "A_Raf3"
                                     
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------


		ACT	1 "CA corbeau 14" 6 "" 100
		ACT	2 "CA corbeau 15" 7 "" 100
		ACT	3 "CA chien 2" 8 "" 100
		
	[mod, 3]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lMch"
		
		AENV	2
		ZFAR	20000
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	0 17 0	//entree landscape
		IN	5 13 0	//depuis lmah
		IN	6 16 0	


		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	9 4 0
		PBOX	10 5 0
		PBOX	11 6 0
		PBOX	12 7 0
		PBOX	13 8 0
		PBOX	14 9 0

		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		TODEC	6 14 2 1 1
		TODEC	7 15 7 1 1
		
		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 16 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	5 01
		SLIGHT	6 11


		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		13 40 100 0 1 "A_ventMa"                             "
		  ASND		14 35 50 10 1 "A_Raf1"
		  ASND		15 35 50 20 1 "A_Raf2"
		  ASND		16 35 30 15 1 "A_Raf3"
		  
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------

   	

		ACT	1 "CA corbeau 14" 9 "" 100
		ACT	2 "CA corbeau 15" 10 "" 100
		ACT	3 "CA corbeau 13" 11 "" 100
		ACT	4 "CA enfant chretien 2" 12 "" 100
		ACT	5 "CA chien 3" 13 "" 100
		ACT	6 "CA chien 1" 14 "" 100

	[mod, 4]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lMdh"
		AENV 	2
		ZFAR	20000
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	7 15 0
		IN	8 18 0
		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	15 2 0
		PBOX	16 3 0
		PBOX	17 4 0
		PBOX	18 5 0
		PBOX	19 6 0

		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		TODEC	8 16 6 1 1
		TODEC	9 17 9 1 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	7 11
		SLIGHT	8 12
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		17 40 100 0 1 "A_ventMa"
		  ASND		18 35 50 10 1 "A_Raf1"
		  ASND		19 35 50 20 1 "A_Raf2"
		  ASND		20 35 30 15 1 "A_Raf3"
		  
		// ASND		25 100 100 0 1 "N_tocsex"
                                        
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 14" 15 "" 100
		ACT	2 "CA corbeau 15" 16 "" 100
		ACT	3 "CA fille celte 2" 17 "" 100
		ACT	4 "CA enfant chretien 1" 18 "" 100
		ACT	5 "CA chien 2" 19 "" 100

	[mod, 5]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lMeh"
		AENV 	2
		ZFAR	20000
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	3 5 0
		IN	4 12 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1003 3 0

		PBOX	  1 13 0
		PBOX	  2 14 0

		PBOX	20 15 0
		PBOX	21 16 0
		PBOX	22 17 0
		PBOX	23 18 0
		PBOX	24 19 0
		PBOX	25 20 0
		PBOX	26 21 0
		PBOX	27 22 0

		//-------------------------------------------------------------------
		// objets decor: id, entite, boite, etat
		//-------------------------------------------------------------------

		//OBJF	1 "Barre piques 1" 1 1
		//OBJF	2 "Barre piques 2" 2 1


		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	2 3 14 1 1

		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		TODEC	5 11 1 1 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	3 11
		SLIGHT	4 12

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
  		
   		  ASND		21 40 100 0 1 "A_ventMa"
		  ASND		22 35 50 10 1 "A_Raf1"
		  ASND		23 35 50 20 1 "A_Raf2"
		  ASND		24 35 30 15 1 "A_Raf3"
 
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 14" 20 "" 100
		ACT	2 "CA chat 5" 21 "" 100
		ACT	3 "CA paysan chretien 2" 22 "" 100
		ACT	4 "CA paysan chretien 3" 23 "" 100
		ACT	5 "CA chien 1" 24 "" 100
		ACT	6 "CA rat 2" 25 "" 100
		ACT	7 "CA colombe 2" 26 "" 100
		ACT	8 "CA loup noir 10" 27 "" 100


section END

section LAND

	[def, 1]
	
		ID	104
		NAME	"Camelot"
		NUM 	1
		REGION	"Camelot" 
		ICON	"camelot" 
		
//		DESTINATIONS LANDSCAPE		id , land, box, active
		TOLAND	101 101 0 1		// id = lieu !!!
		//TOLAND	102 102 99 1
		TOLAND	102 102 0 1

		
	// fin de la definition
	
	//premier module
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------
		FILE 	"lCam"
		AENV 	3
		ZFAR	100000
		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN 0 1 0	
		IN 1 11 0	
		IN 2 3 0	
		IN 3 4 0	
		IN 4 5 0	
		IN 5 2 0 	

		//teleports
		IN 6 37 0
		IN 7 38 0
		IN 8 39 0
		IN 9 40 0
		IN 10 41 0
		IN 11 42 0
		IN 12 43 0
		IN 13 44 0
		IN 14 45 0
		IN 15 46 0
		IN 16 47 0
		IN 17 48 0
		IN 18 49 0
		IN 19 50 0

		//-------------------------------------------------------------------
		// teleports: id, polytope, boite dest, actif
		//-------------------------------------------------------------------

		TELEP	1 8 6 1
		TELEP	2 9 7 1
// ce qui ya dans le script decor :		
//		TELEP	3 10 8 0
//		TELEP	4 11 9 0
//		TELEP	5 12 10 0
//		TELEP	6 13 11 0
//		TELEP	7 14 12 0
//		TELEP	8 15 13 0
//		TELEP	9 16 14 0
//		TELEP	10 17 15 0
//		TELEP	11 18 16 0
//		TELEP	12 19 17 0
//		TELEP	13 20 18 0
//		TELEP	14 21 19 0
// ce qui marche :
		TELEP	3 10 9 1
		TELEP	4 11 8 1
		TELEP	5 12 11 1
		TELEP	6 13 10 1
		TELEP	7 14 13 1
		TELEP	8 15 12 1
		TELEP	9 16 15 1
		TELEP	10 17 14 1
		TELEP	11 18 17 1
		TELEP	12 19 16 1
		TELEP	13 20 19 1
		TELEP	14 21 18 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------
		PBOX 0 1 0 
		
		//CA
		//boites 1 a 5 deja utilisees
		PBOX 31 12 0 	//P012	B1
		PBOX 32 13 0	//B2
		PBOX 33 14 0	//B3
		PBOX 34 15 0	//B4
		PBOX 35 16 0	//B5
		PBOX 6 17 0
		PBOX 7 18 0
		PBOX 8 19 0
		PBOX 9 20 0
		PBOX 10 21 0
		PBOX 11 22 0
		PBOX 12 23 0
		PBOX 14 25 0
		PBOX 15 26 0
		PBOX 16 27 0
		PBOX 19 30 0
		PBOX 20 31 0
		PBOX 21 32 0
		PBOX 22 33 0
		PBOX 23 34 0
		PBOX 24 35 0
		PBOX 25 36 0
		
		


		//CORWYN
		PBOX 1004 6 0	
		PBOX 1003 7 0
		PBOX 1005 8 0
		PBOX 1002 9 0
		PBOX 1001 10 0	

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------
		//TOZI 2 2 29 5 1	  //boite entree 5 inexistante (ID 29). Remplace par :(1 ou 2) 
		TOZI 2 2 29 1 1	  
		
		//TOZI 3 3 25 2 1  //boite entree 2 inexistante (ID 25). Remplace par :
		TOZI 3 3 25 1 1  
		
		//TOZI 4 4 28 3 1  //boite entree 3 inexistante (ID 28). Remplace par :
		TOZI 4 4 28 1 1  
		
		//TOZI 5 5 27 4 1  //boite entree 4 inexistante (ID 27). Remplace par :
		TOZI 5 5 27 1 1  
		
		TOZI 6 6 26 1 1		//camp saxon
		
				
		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG 3 7 1	// commentaire debut quete 

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 40 100 0 1 "A_Uff"
		  ASND		2 60 50 20 1 "A_loup2"
		  ASND		3 30 30 15 1 "A_Maraf1"
		  ASND		4 30 30 15 1 "A_Maraf2"
		  ASND		5 30 30 15 1 "A_Maraf3"
		  ASND		6 60 30 15 1 "A_Corbx"
		//ASND		7 100 100 0 1 "vox"
  		ASND		8 30 50 10 1 "A_neige" 
  		  ASND		9 30 30 20 1 "A_oise4"
		  ASND		10 25 40 20 1 "A_oise5"
  		ASND		11 40 60 10 1 "A_loup3"                             "
		ASND		13 55 30 10 1 "A_oise2"
		ASND		14 90 50 20 1 "A_neige"
		ASND		15 50 20 15 1 "A_envol2"
		
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA cerf 5" 		31 "" 100
		ACT	2 "CA cerf 6" 		32 "" 100
		ACT	3 "CA corbeau 2" 	33 "" 100
		ACT	4 "CA corbeau 22" 	34 "" 100
		//ACT	5 "CA corbeau 23" 	35 "" 100
		ACT	6 "CA loup noir 12" 	6 "" 100
		ACT	7 "CA loup blanc 8" 	7 "" 100
		ACT	8 "CA loup 3" 		8 "" 100
		ACT	9 "CA corbeau 3" 	9 "" 100
		ACT	10 "CA corbeau 24" 	10 "" 100
		ACT	11 "CA corbeau 25" 	11 "" 100
		ACT	12 "CA corbeau 26" 	12 "" 100
		ACT	14 "CA loup 4" 		14 "" 100
		ACT	15 "CA loup blanc 6" 	15 "" 100
		ACT	16 "CA corbeau 4" 	16 "" 100
		ACT	19 "CA loup noir 9" 	19 "" 100
		ACT	20 "CA loup noir 7" 	20 "" 100
		ACT	21 "CA loup noir 8" 	21 "" 100
		ACT	22 "CA loup blanc 1" 	22 "" 100
		ACT	23 "CA loup noir 2" 	23 "" 100
		ACT	24 "CA loup noir 4" 	24 "" 100
		ACT	25 "CA ours 5" 		25 "" 100

				
section END	

//=================================================================================
//	
// zones Interactives
//	
//=================================================================================

//
// ZIs Camelot : TODO : A TESTER
// Camp Marcus 		27
// Camp Atrebates	28
// Camp Sagramor	25
// Camp Saxon 		26
// Cour Camelot		29
// Table Ronde		30
//

section ZINTER
	[def, 1]
	
		ID	27
		NAME	"Camp Marcus"
		NUM 	1
		REGION	"Camelot"
		ICON	"camelot"
		PARENT	104
		//destinations landscapes ?
		
	// fin de la definition
	
	//premier module
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------
		FILE 	"zMar"
		AENV	 1
		ZFAR	10000
		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------
		IN 1 1 0


		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------
		PBOX 1 2 0
		PBOX 2 4 0
		PBOX 3 5 0
		PBOX 4 7 0
		PBOX 5 3 0
		PBOX 6 8 0
		PBOX 7 9 0
		//CA
		PBOX 8 10 0
		PBOX 9 11 0
		PBOX 10 12 0
		PBOX 11 13 0
		PBOX 12 14 0
		PBOX 13 15 0
		PBOX 14 16 0
		PBOX 15 17 0
		PBOX 16 18 0
		PBOX 17 19 0
		PBOX 18 20 0
		PBOX 19 21 0
		PBOX 20 22 0
		PBOX 21 23 0
		PBOX 22 24 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------
		BACK 1 1 4 1
		
		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------
		TRIG 1 2 1
		
		//collision
		COLLI 1 1 0		// entree camp. desactivee : porte ouverte
		COLLI 2 2 0		// tente
				
		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------
		SLIGHT 1 11
		SLIGHT 2 12
		
		//cameras
		///CAM id Cid_cam etat
		CAM 1 5 1
		CAM 2 3 1
		CAM 3 4 1

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

  	//gab debut 26/09/00
  		ASND		6 30 50 60 1 "A_oise2" 
  		ASND		7 40 60 70 1 "A_oise3" 
		ASND		20 50 100 0 1 "A_arden"      
  		ASND		21 10 80 40 1 "A_ferrer" 
  		ASND		22 40 50 80 1 "A_chien1" 
		ASND		23 30 50 50 1 "O_chvl2"     
		ASND		24 30 60 90 1 "A_passa2"
		ASND		25 30 60 70 1 "A_passa"
		ASND		26 50 30 70 1 "A_charr2"
		ASND		27 30 50 40 1 "O_Henni"
		 ASND		10 60 40 15 1 "A_poule1"
		 ASND		11 55 30 10 1 "A_chat1"
		 ASND		12 30 40 20 1 "A_chien2"
		 ASND		13 20 100 0 1 "A_marke2"
		 ASND		14 40 60 80 1 "A_chien4"
		 ASND		15 30 50 90 1 "A_chien3"
		 ASND		17 50 90 100 1 "A_Charr"
		 ASND		18 30 50 60 1 "A_oise4"
		 ASND		19 25 50 50 1 "A_oise5"
//gab debut 26/09/00
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA garde 6" 8 "" 100
		ACT	2 "CA garde 4" 9 "" 100
		ACT	3 "CA cheval 5" 10 "" 100
		ACT	4 "CA cheval 6" 11 "" 100
		ACT	5 "CA cochon 2" 12 "" 100
		ACT	6 "CA cochon 3" 13 "" 100
		ACT	7 "CA paysan chretien 5" 14 "" 100
		ACT	8 "CA paysan chretien 2" 15 "" 100
		ACT	9 "CA paysan chretien 3" 16 "" 100
		ACT	10 "CA poule 8" 17 "" 100
		ACT	11 "CA poule 9" 18 "" 100
		ACT	12 "CA poule 10" 19 "" 100
		ACT	13 "CA paysanne celte 5" 20 "" 100
		ACT	14 "CA paysanne 7" 21 "" 100
		ACT	15 "CA garde 3" 22 "" 100

section END

section ZINTER
	[def, 1]
	
		ID	28
		NAME	"Camp Atrebates"
		NUM 	1
		REGION	"Camelot"
		ICON	"camelot"
		PARENT	104
		
		//destinations landscapes ?
		
	// fin de la definition
	
	//premier module
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------
		FILE 	"zAtr"
		AENV 	1
		ZFAR	9000
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------
		BACK 1 1 3 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------
		IN 1 1 0
		
		//collisions
		COLLI 1 1 0 // portes

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------
		PBOX 1 2 0
		PBOX 2 6 0
		PBOX 3 3 0
		PBOX 4 4 0
		PBOX 5 5 0

		//CA
//		PBOX 6 6 0
		PBOX 7 7 0
		PBOX 8 8 0
		PBOX 9 9 0
		PBOX 10 10 0
		PBOX 11 11 0
		PBOX 12 12 0
		PBOX 13 13 0
		PBOX 14 14 0
		PBOX 15 15 0
		PBOX 16 16 0
		PBOX 17 17 0
		PBOX 18 18 0


		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------
		SLIGHT 1 11
		SLIGHT 2 12
		
		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG 1 2 1		//commentaire
		TRIG 2 3 1	//ENTREE
		TRIG 3 4 1 	//dialogue
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

  	//gab debut 9/10
  		ASND		6 30 50 60 1 "A_oise2" 
  		ASND		7 40 60 70 1 "A_oise3" 
		ASND		20 50 100 0 1 "A_arden"      
  		ASND		21 10 80 40 1 "A_ferrer" 
  		ASND		22 40 50 80 1 "A_chien1" 
		ASND		23 30 50 50 1 "O_chvl2"     
		ASND		24 30 60 90 1 "A_passa2"
		ASND		25 30 60 70 1 "A_passa"
		ASND		26 50 30 70 1 "A_charr2"
		ASND		27 30 50 40 1 "O_Henni"
		 ASND		10 60 40 15 1 "A_poule1"
		 ASND		11 40 30 10 1 "A_chat1"
		 ASND		12 30 40 20 1 "A_chien2"
		 ASND		13 20 100 0 1 "A_marke2"
		 ASND		14 40 60 80 1 "A_chien4"
		 ASND		15 30 50 90 1 "A_chien3"
		 ASND		17 50 90 100 1 "A_Charr"
		 ASND		18 30 50 60 1 "A_oise4"
		 ASND		19 25 50 50 1 "A_oise5"
//gab fin 26/09/00
		

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

//		ACT	1 "CA paysan celte 2" 6 "" 100
		ACT	2 "CA paysan celte 3" 7 "" 100
		ACT	3 "CA paysanne 8" 8 "" 100
		ACT	4 "CA garde celte 3" 9 "" 100
		ACT	5 "CA garde celte 4" 10 "" 100
		ACT	6 "CA garde celte 5" 11 "" 100
		ACT	7 "CA garde celte 6" 12 "" 100
		ACT	8 "CA garde celte 7" 13 "" 100
		ACT	9 "CA cheval 5" 14 "" 100
		ACT	10 "CA cheval 6" 15 "" 100
		ACT	11 "CA chien 6" 16 "" 100
		ACT	12 "CA chien 4" 17 "" 100
		ACT	13 "CA corbeau 27" 18 "" 100

	
section END


section ZINTER
	[def, 1]
	
		ID	26
		NAME	"Camp Saxon"
		NUM 	1
		REGION	"Camelot"
		ICON	"camelot"
		PARENT	104
		
		//destinations landscapes ?
		
	// fin de la definition
	
	//premier module
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------
		FILE 	"zSax"
		AENV 	1
		ZFAR	13000
		
		IN 1 1 0
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------
		BACK 1 1 1 1

		COLLI 1 1 0
		
		PBOX 1 2 0
		PBOX 2 4 0 
		PBOX 3 3 0
		//CA
		PBOX 50 5 0
		PBOX 51 6 0
		PBOX 52 7 0
		PBOX 53 8 0
		PBOX 54 9 0
		PBOX 55 10 0
		PBOX 56 11 0
		PBOX 57 12 0	// B1 used
		PBOX 58 13 0	// B2 used
		PBOX 59 14 0	// B3 used
		PBOX 60 15 0	// B4 used
		PBOX 61 16 0	// B5 used
		PBOX 62 17 0	// B6 used

		SLIGHT 1 11
		SLIGHT 2 12
		
		CAM 2 6 1
		CAM 3 4 1
		
		TRIG 1 2 1 //commentaire
		TRIG 2 3 1 //dialogue
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

  	//gab debut 26/09/00
  		ASND		6 30 50 60 1 "A_oise2" 
  		ASND		7 40 60 70 1 "A_oise3" 
		ASND		20 50 100 0 1 "A_arden"      
  		ASND		21 10 80 40 1 "A_ferrer" 
  		ASND		22 40 50 80 1 "A_chien1" 
		ASND		23 30 50 50 1 "O_chvl2"     
		ASND		24 30 60 90 1 "A_passa2"
		ASND		25 30 60 70 1 "A_passa"
		ASND		26 50 30 70 1 "A_charr2"
		ASND		27 30 50 40 1 "O_Henni"
		 ASND		10 60 40 15 1 "A_poule1"
		 ASND		11 55 30 10 1 "A_chat1"
		 ASND		12 30 40 20 1 "A_chien2"
		 ASND		13 20 100 0 1 "A_marke2"
		 ASND		14 40 60 80 1 "A_chien4"
		 ASND		15 30 50 90 1 "A_chien3"
		 ASND		17 50 90 100 1 "A_Charr"
		 ASND		18 30 50 60 1 "A_oise4"
		 ASND		19 25 50 50 1 "A_oise5"
//gab fin 26/09/00
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA guerrier saxon 1" 50 "" 100
		ACT	2 "CA guerrier saxon 2" 51 "" 100
		ACT	3 "CA garde saxon 1" 	52 "" 100
		ACT	4 "CA garde saxon 2" 	53 "" 100
		ACT	5 "CA cochon 2" 	54 "" 100
		ACT	6 "CA paysanne 6" 	55 "" 100
		ACT	7 "CA cheval 5" 	56 "" 100
		ACT	8 "CA guerrier saxon 3" 57 "" 100
		ACT	9 "CA guerrier saxon 4" 58 "" 100
		ACT	10 "CA chien 4" 	59 "" 100
		ACT	11 "CA chien 5" 	60 "" 100
		ACT	12 "CA cheval 6" 	61 "" 100
		ACT	13 "CA corbeau 27" 	62 "" 100

		 
section END

section ZINTER
	[def, 1]
	
		ID	25
		NAME	"Camp Sagramor"
		NUM 	1
		REGION	"Camelot"
		ICON	"camelot"
		PARENT	104
		
		//destinations landscapes ?
		
	// fin de la definition
	
	//premier module
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------
		FILE 	"zSag"
		AENV 	1
		ZFAR	10000
		DOORANGLE  120
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------
		BACK 1 1 2 1
		
		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------
		IN 1 1 0
		
		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------
		PBOX 1 2 0
		PBOX 3 5 0
		PBOX 4 3 0
		PBOX 5 4 0
		PBOX 6 6 0
	
		PBOX 14 17 0
		PBOX 15 18 0
		PBOX 16 19 0
		PBOX 17 20 0
		PBOX 18 21 0
		PBOX 19 22 0
		PBOX 20 23 0
		PBOX 21 24 0
		PBOX 22 25 0
		PBOX 23 26 0
		PBOX 24 27 0
		PBOX 25 28 0
		PBOX 26 29 0
		PBOX 27 30 0
		PBOX 28 31 0

		TRIG 1 2 1

		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------
		DOOR 1 "Porte Sagramor" 6 1 0 0 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------
		SLIGHT 1 11
		SLIGHT 2 12


		CAM 1 5 1


		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

  	//gab debut 26/09/00
  		ASND		6 30 50 60 1 "A_oise2" 
  		ASND		7 40 60 70 1 "A_oise3" 
		ASND		20 50 100 0 1 "A_arden"      
  		ASND		21 10 80 40 1 "A_ferrer" 
  		ASND		22 40 50 80 1 "A_chien1" 
		ASND		23 30 50 50 1 "O_chvl2"     
		ASND		24 30 60 90 1 "A_passa2"
		ASND		25 30 60 70 1 "A_passa"
		ASND		26 50 30 70 1 "A_charr2"
		ASND		27 30 50 40 1 "O_Henni"
		 ASND		10 60 40 15 1 "A_poule1"
		 ASND		11 55 30 10 1 "A_chat1"
		 ASND		12 30 40 20 1 "A_chien2"
		 ASND		13 20 100 0 1 "A_marke2"
		 ASND		14 40 60 80 1 "A_chien4"
		 ASND		15 30 50 90 1 "A_chien3"
		 ASND		17 50 90 100 1 "A_Charr"
		 ASND		18 30 50 60 1 "A_oise4"
		 ASND		19 25 50 50 1 "A_oise5"
//gab debut 26/09/00

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA garde 6" 14 "" 100
		ACT	2 "CA garde 4" 15 "" 100
		ACT	3 "CA garde 3" 16 "" 100
		ACT	4 "CA garde 1" 17 "" 100
		ACT	5 "CA cheval 4" 18 "" 100
		ACT	6 "CA garde chretien 1" 19 "" 100
		ACT	7 "CA cheval 5" 20 "" 100
		ACT	8 "CA cheval 6" 21 "" 100
		ACT	9 "CA garde 2" 22 "" 100
		ACT	10 "CA paysan chretien 1" 23 "" 100
		ACT	11 "CA paysanne 1" 24 "" 100
		ACT	12 "CA paysan chretien 6" 25 "" 100
		ACT	13 "CA paysan chretien 5" 26 "" 100
		
		ACT	15 "CA chien 4" 28 "" 100		

section END

section ZINTER
	[def, 1]
	
		ID	29
		NAME	"Cour Camelot"
		NUM 	1
		REGION	"Camelot"
		ICON	"camelot"
		PARENT	104
		
		//destinations landscapes ?
		
	// fin de la definition
	
	//premier module
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------
		FILE 	"zCht"
		AENV 	1
		ZFAR	13000
		DOORANGLE  120
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------
		BACK 1 1 5 1
		
//T002	ZW1	E1 table ronde
//cekoica 
		TOZI 1 2 30 1 1 //table ronde
		
		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------
		IN 1 1 0		// from landscape
		IN 2 2 0		// from table ronde Si on met celle-ci en premier, ca fait qqch de VRAIMENT bizarre !!!
		
		//-------------------------------------------------------------------
		// boites positions: id, polytope PBOX [Bid] [Pid_polytope] 0
		//-------------------------------------------------------------------
		PBOX 1 8 0
		PBOX 2 12 0
		PBOX 3 6 0
		PBOX 4 7 0
		PBOX 5 9 0
		PBOX 6 10 0
		PBOX 7 5 0
		PBOX 8 11 0
		PBOX 9 13 0
		PBOX 10 3 0
		PBOX 11 4 0
		PBOX 12 15 0
		PBOX 13 16 0
		PBOX 17 17 0	//CA
		PBOX 18 18 0	//CA
		PBOX 19 19 0	//CA
		PBOX 20 20 0	//CA
		PBOX 21 21 0	//CA
		PBOX 22 22 0	//CA
		PBOX 23 23 0	//CA
		PBOX 24 24 0	//CA
		PBOX 25 25 0	//CA
		PBOX 26 26 0	//CA
		PBOX 27 27 0	//CA
		PBOX 28 28 0	//CA
		PBOX 29 29 0	//CA
		PBOX 30 30 0	//CA
		PBOX 31 31 0	//CA
		PBOX 32 32 0	//CA
		PBOX 33 33 0	//CA
		PBOX 34 34 0	//CA
		PBOX 35 35 0	//CA
		PBOX 36 36 0	// drapeaux
		PBOX 37 37 0
		PBOX 38 38 0
		PBOX 39 39 0
		PBOX 40 40 0

		PBOX 41 41 0	//fx forgeron
		PBOX 42 42 0	//TARGET forgeron
		
		
		TRIG 1 4 1
		TRIG 2 5 1
		TRIG 3 6 1
		TRIG 4 7 1
		TRIG 5 8 1 // changement chapitre
		TRIG 6 3 1
		TRIG 7 9 1 // commentaire
		TRIG 8 10 1 // ouverture portes
		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------
		DOOR 1 "Porte Camelot" 		10 3 0 0 1
		DOOR 2 "Porte Cour Camelot" 	11 4 0 0 1	// FERMER LA PORTE !!! 001

		//CAM 1 18 1
	
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
	//gab debut 26/09/00
    		ASND		1 100 55 50 1 "A_cons1"   
  		ASND		2 100 60 60 1 "A_cons2"   
  		ASND		3 100 55 70 1 "A_cons3"   
  		ASND		4 100 50 80 1 "A_cons4"   
  		ASND		5 100 50 50 1 "A_cons5"   
  		ASND		6 30 50 60 1 "A_oise2" 
  		ASND		7 40 60 70 1 "A_oise3" 
  		ASND		8 40 60 80 1 "A_oise4"
  	
  		ASND		9 40 60 90 1 "A_oise5"

		ASND		20 50 100 0 1 "A_arden"      
		
  		ASND		21 10 80 40 1 "A_ferrer" 
  		ASND		22 40 50 80 1 "A_chien1" 
		ASND		23 30 50 50 1 "O_chvl2"     
		ASND		24 30 60 90 1 "A_passa2"
		ASND		25 30 60 70 1 "A_passa"
		ASND		26 50 30 70 1 "A_charr2"
		ASND		27 30 50 40 1 "O_Henni"
		 ASND		10 60 40 15 1 "A_poule1"
		 ASND		11 55 30 10 1 "A_chat1"
		 ASND		12 30 40 20 1 "A_chien2"
		 ASND		13 20 100 0 1 "A_marke2"
		 ASND		14 40 60 80 1 "A_chien4"
		 ASND		15 30 50 90 1 "A_chien3"
		 ASND		17 50 90 100 1 "A_Charr"
		 ASND		18 30 50 60 1 "A_oise4"
		 ASND		19 25 50 50 1 "A_oise5"
	//gab fin 26/09/00		
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA cheval 3" 17 "" 100
		ACT	2 "CA cheval 4" 18 "" 100
		ACT	3 "CA chien 4" 19 "" 100
		ACT	4 "CA garde camelot 4" 20 "" 100
		ACT	5 "CA garde 2" 21 "" 100
		ACT	6 "CA garde 3" 22 "" 100
		ACT	7 "CA paysan chretien 1" 23 "" 100
		ACT	8 "CA cheval 8" 24 "" 100
		ACT	9 "CA paysan chretien 6" 25 "" 100
		ACT	10 "CA paysanne celte 5" 26 "" 100
		ACT	11 "CA chien 5" 27 "" 100
		ACT	12 "CA cheval 5" 28 "" 100
		ACT	13 "CA cheval 6" 29 "" 100
		ACT	14 "CA cheval 7" 30 "" 100
		ACT	15 "CA garde camelot 1" 31 "" 100
		ACT	16 "CA chat 1" 32 "" 100
		ACT	17 "CA chat 2" 33 "" 100
		ACT	18 "CA garde camelot 2" 34 "" 100
		ACT	19 "CA garde camelot 3" 35 "" 100
		ACT	20 "CA etendard 1" 36 "" 100
		ACT	21 "CA etendard 2" 37 "" 100
		ACT	22 "CA etendard 3" 38 "" 100
		ACT	23 "CA etendard 4" 39 "" 100
		ACT	24 "CA etendard 5" 40 "" 100
		
section END

section ZINTER
	[def, 1]
	
		ID	30
		NAME	"Table ronde"
		NUM 	1
		REGION	"Camelot"
		ICON	"camelot"
		PARENT	104
		
		//destinations landscapes ?
		
	// fin de la definition
	
	//premier module
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------
		FILE 	"zTab"

		IN 1 1 0 	// from cour camelot
		AENV 	4
		ZFAR	5000
		//-------------------------------------------------------------------
		// sorties ZI
		//id, polytope, zi, entre, active
		//-------------------------------------------------------------------
		TOZI 1 1 29 2 1 

		PBOX 1 7 0
		PBOX 2 5 0
		PBOX 3 14 0
		PBOX 4 4 0
		PBOX 5 17 0
		PBOX 6 6 0
		PBOX 7 2 0
		PBOX 8 18 0
		PBOX 9 16 0
		PBOX 10 3 0
		PBOX 11 15 0
		PBOX 12 10 0
		PBOX 13 12 0
		PBOX 14 19 0
		PBOX 15 20 0
		PBOX 16 21 0
		PBOX 17 22 0
		PBOX 18 23 0
		
		//CA : fx feux		
		PBOX 24	24 0
		PBOX 25	25 0
		PBOX 26	26 0
		PBOX 27	27 0
		PBOX 28	28 0
		PBOX 29	29 0
		PBOX 30	30 0
		PBOX 31	31 0
		PBOX 32	32 0
		PBOX 33	33 0
		PBOX 34	34 0

		COLLI 1 1 0

		CAM 1 3 1
		
		TRIG 1 2 1	// CTR
		TRIG 2 3 1 	// chgt chapitre
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

  		ASND		1 20 100 0 1 "A_feufor"   		
		
		
section END

// ZI d'Avallon : Colline Morgane
section ZINTER

	[def, 1]
		ID	24
		NAME	"Colline Morgane"
		NUM	1
		REGION	"Avalon"
		ICON	"Avallon"
		PARENT	103

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCmo"
		IN 1 1 0
		AENV 	0
		ZFAR	4000
		
//TRIG SORTIES	Module	POLYTOPE	ID	nom
//		ZCMO	T001		SW1	vers labyrinthe
		
		COLLI 1 1 0	// feu morgane
		
		PBOX 1 2 0	// fiachra
		PBOX 2 3 0	// fhola
		PBOX 7 4 0 	// Bradwen CTR
		
		PBOX 20 5 0
		PBOX 21 6 0
		PBOX 22 7 0
		PBOX 23 8 0
		PBOX 24 9 0

		LIGHT 1 1 1
		LIGHT 2 2 1	

		//-------------------------------------------------------------------                                                                                                
		// sons ambiants; ID, vol, rnd, delai, etat, fichier                                                                                                                 
		//-------------------------------------------------------------------                                                                                                
                                                                                                                                                                                     
		ASND		1 10 30 20 1 "A_0001"                                                                                                                                
		ASND		2 70 100 0 1 "A_avalon"                                                                                                                              
		ASND		10 05 100 0 1 "A_morg"    
                                                                                                                           
		ASND		3 03 50 30 1 "A_0003"                                                                                                                                
		ASND		4 05 50 30 1 "A_0004"                                                                                                                                
		ASND		5 05 30 20 1 "A_esprit"   
		ASND		6 10 30 20 1 "A_rireF4"                                                                                                                              
		ASND		7 10 30 20 1 "A_oisete"                                                                                                                              
		ASND		8 10 30 20 1 "A_oiset2"                                                                                                                             
		ASND		9 10 30 20 1 "A_oiset3" 
	
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA papillon avalon 1" 20 "" 100
		ACT	2 "CA papillon avalon 2" 21 "" 100
		ACT	3 "CA papillon avalon 3" 22 "" 100
		ACT	4 "CA papillon avalon 4" 23 "" 100
		ACT	5 "CA papillon avalon 5" 24 "" 100

section END



//
// ZONES d'UFFINGTON :
// Colline du dragon
// Colline St Georges

//=================================================================================
//
// COLLINE DU DRAGON ROUGE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	4
		NAME	"Colline Dragon Rouge"
		NUM	1
		REGION	"Uffington"
		ICON	"ufingt"
		PARENT	100

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCdr"
		
		ZFAR	20000
AENV 3
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 7 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 13 0
		PBOX	2 14 0
		PBOX	3 15 0
		PBOX	4 16 0
		PBOX	5 17 0
		PBOX	6 18 0
		PBOX	7 19 0
		PBOX	8 20 0
		PBOX	9 21 0
		PBOX	10 22 0
		PBOX	11 23 0
		
		PBOX	12 24 0
		PBOX	13 25 0
		PBOX	14 26 0
		PBOX	15 27 0
		PBOX	16 28 0
		PBOX	17 29 0


		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 2 1

		//-------------------------------------------------------------------
		// lampe permanente: id, index light DB
		//-------------------------------------------------------------------

		LIGHT	1 1 1

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		1 20 100 0 1 "A_Uff"
		  ASND		2 70 20 80 1 "A_loup2"
		  ASND		3 35 70 60 1 "A_Maraf1"
		  ASND		4 35 70 60 1 "A_Maraf2"
		  ASND		5 35 70 60 1 "A_Maraf3"
		  ASND		6 40 70 45 0 "A_drag2"
		  ASND		2 40 20 80 1 "A_loup"
		  //ASND	6 100 100 0 1 "vox"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 11" 12 "" 100
		ACT	2 "CA corbeau 12" 13 "" 100
		ACT	3 "CA loup blanc 6" 14 "" 100
		ACT	4 "CA loup blanc 5" 15 "" 100
		ACT	5 "CA loup noir 6" 16 "" 100
		ACT	6 "CA cerf 6" 17 "" 100		

section END



//=================================================================================
//
// COLLINE ST GEORGE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	3
		NAME	"Colline St George"
		NUM	1
		REGION	"Uffington"
		ICON	"ufingt"
		PARENT	100

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zStg"
		
		ZFAR	25000
AENV 3
		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 49 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 8 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 15 0
		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 8 0
		PBOX	2 9 0
		PBOX	3 10 0
		PBOX	4 11 0
		PBOX	5 12 0
		PBOX	6 13 0
		PBOX	9 14 0 	// dummy croix
		PBOX	10 15 0	// arrivee teleport
		
		//CA
		PBOX	45 45 0
		PBOX	46 46 0
		PBOX	47 47 0
		PBOX	48 48 0
		PBOX	49 49 0
		PBOX	50 50 0
		PBOX	51 51 0
		PBOX	60 60 0
		PBOX	61 61 0
		PBOX	65 65 0
		PBOX	66 66 0
		PBOX	67 67 0
		PBOX	68 68 0

		//-------------------------------------------------------------------
		// lampe permanente: id, index light DB
		//-------------------------------------------------------------------
		//A PU
		//LIGHT	1 1 1

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG 1 2 1
		TRIG 2 3 1
		

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
  	
		ASND		1 40 100 0 1 "A_venArd"
		ASND		3 35 70 60 1 "A_Maraf1"
		ASND		4 35 70 60 1 "A_Maraf2"
		ASND		5 35 70 60 1 "A_Maraf3"
		ASND		2 70 30 50 1 "A_loup2"
		ASND		2 20 50 50 0 "A_loup3"
		ASND		4 60 30 50 0 "A_loup"
		ASND		3 40 30 30 1 "A_Corb2"
		ASND		3 50 30 15 1 "A_Corbx"
		  //ASND		6 100 100 0 1 "vox"
   		
  		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA mouton 1" 45 "" 100
		ACT	2 "CA mouton 2" 46 "" 100
		ACT	3 "CA mouton 3" 47 "" 100
		ACT	4 "CA mouton 4" 48 "" 100
		ACT	5 "CA mouton 5" 49 "" 100
		ACT	6 "CA mouton 6" 50 "" 100
		ACT	7 "CA mouton 7" 51 "" 100
		ACT	8 "CA corbeau 2" 60 "" 100
		ACT	9 "CA corbeau 3" 61 "" 100
		ACT	10 "CA corbeau 9" 65 "" 100
		ACT	11 "CA corbeau 10" 66 "" 100
		ACT	12 "CA corbeau 11" 67 "" 100
		ACT	13 "CA corbeau 12" 68 "" 100
		
section END



//
// ZIs Arden
//
// ARbre Merlin
// Lac Offrandes


//=================================================================================
//
// ARBRE MERLIN
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	6
		NAME	"Arbre Merlin"
		NUM	1
		REGION	"Arden"
		ICON	"arden"
		PARENT	101

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zMeh"
		
		ZFAR	10000
		AENV 3

		//-------------------------------------------------------------------
		// collisions interactives: id, index objet, active
		//-------------------------------------------------------------------

		COLLI	1 1 0
		COLLI	2 2 0
		COLLI	3 3 0
		COLLI	4 4 0
		COLLI	5 5 0
		COLLI	6 6 0

		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 8 1

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	3 1 5 1
		BACK	4 7 4 1
		BACK	5 6 3 1
		BACK	6 5 8 1
		BACK	7 4 10 1
		BACK	8 3 7 1
		BACK	9 2 6 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 7 0
		IN	3 6 0
		IN	4 5 0
		IN	5 4 0
		IN	6 3 0
		IN	7 2 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	2 18 0
		PBOX	3 21 0
		PBOX	4 26 0
		PBOX	5 16 0
		PBOX	6 27 0
		PBOX	7 22 0
		PBOX	8 23 0
		PBOX	9 24 0
		PBOX	10 17 0
		PBOX	11 25 0
		PBOX	12 9 0
		PBOX	13 10 0
		PBOX	14 11 0
		PBOX	15 12 0
		PBOX	16 13 0
		PBOX	17 14 0
		PBOX	18 28 0
		PBOX	19 29 0

		PBOX	20 50 0
		PBOX	21 51 0
		PBOX	22 52 0
		PBOX	23 53 0
		PBOX	24 54 0
		PBOX	25 55 0
		PBOX	26 56 0
		PBOX	27 57 0
		PBOX	28 58 0
		PBOX	29 59 0
		PBOX	30 60 0
		PBOX	31 61 0
		PBOX	32 62 0

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 8 1
		TRIG	2 9 1
		TRIG	3 10 1
		TRIG	4 11 1
		TRIG	5 12 1	//chgt chapitre
		
		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12
	// boites test sons

		//PBOX	2000 100 0
		PBOX	2001 101 0
		PBOX	2002 102 0
		PBOX	2003 103 0
		PBOX	2004 104 0
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------


		 
		  ASND		5 20 100 0 1 "A_arden"
		  ASND		1 65 30 15 1 "A_geai"
		  ASND		2 80 40 20 1 "A_neige"
		  ASND		3 40 40 25 1 "A_espbas"
		  ASND		4 40 40 30 1 "A_espleg"
		  ASND		5 40 40 20 1 "A_esple2"
		 
                ASND		6 80 30 15 1 "A_vol"      
                ASND		7 30 30 15 1 "A_oise1"
		  ASND		8 40 30 15 1 "A_oise2"
		  ASND		9 30 30 15 1 "A_oise3"
		  ASND		10 40 30 15 1 "A_oise4"  

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA cheval 8" 20 "" 100
		ACT	2 "CA loup noir 1" 21 "" 100
		ACT	3 "CA loup blanc 6" 22 "" 100
		ACT	4 "CA mini fee 1" 23 "" 100
		ACT	5 "CA corbeau 1" 24 "" 100
		ACT	6 "CA papillon avalon 1" 25 "" 100
		ACT	7 "CA papillon avalon 2" 26 "" 100
		ACT	8 "CA papillon avalon 3" 27 "" 100
		ACT	9 "CA ecureuil b 1" 28 "" 100
		ACT	10 "CA ecureuil b 2" 29 "" 100
		ACT	11 "CA ecureuil b 3" 30 "" 100
		ACT	12 "CA cerf 2" 31 "" 100
		ACT	13 "CA faucon 5" 32 "" 100

section END


//=================================================================================
//
// LAC DES OFFRANDES
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	8
		NAME	"Lac Offrandes"
		NUM	1
		REGION	"Arden"
		ICON	"arden"
		PARENT	101

	[mod, 1]


		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE "zOff"
		
		ZFAR	8000
		AENV 3
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	10 2 9 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// collisions interactives: id, index objet, active
		//-------------------------------------------------------------------

		COLLI	1 1 0
		COLLI	2 2 0
		COLLI	3 3 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 7 0
		PBOX	2 8 0
		PBOX	3 6 0
		PBOX	4 2 0
		PBOX	5 4 0
		PBOX	6 5 0
		PBOX	7 3 0
		PBOX	9 14 0
		PBOX	10 12 0
		PBOX	11 15 0
		PBOX	13 16 0
		PBOX	12 17 0
		
		PBOX	20 20 0
		PBOX	21 21 0
		PBOX	22 22 0
		PBOX	23 23 0
		PBOX	24 24 0
		PBOX	25 25 0
		PBOX	26 26 0
		PBOX	27 27 0
		PBOX	28 28 0
		PBOX	29 29 0
		PBOX	30 30 0
		PBOX	31 31 0
		PBOX	32 32 0
		PBOX	33 33 0

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	2 3 1
		TRIG	3 4 1
		TRIG	4 5 1
		TRIG	5 6 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11

		PBOX	2000 100 0

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
		 
		  ASND		5 40 100 0 1 "A_arden"                             "
		  ASND		3 65 50 10 1 "A_geai"
		  ASND		4 65 40 15 1 "A_oise4"
		  ASND		6 65 40 10 1 "A_oise5"
		  ASND		2 90 50 20 1 "A_neige"
		
		   
                          
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------

//gab debut
   		BSNDD	1 2000 80 40 10 1 "O_offr" 800 4000
   		BSNDD	2 2000 100 40 10 1 "O_esprit" 800 4000

   		BSNDD_E	1 2000 80 40 10 1 "O_offr" 800 4000
   		BSNDD_E	2 2000 100 40 10 1 "O_esprit" 800 4000
//gab fin

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA mini fee 1" 20 "" 100
		ACT	2 "CA mini fee 2" 21 "" 100
		ACT	3 "CA mini fee 3" 22 "" 100
		ACT	4 "CA mini fee 4" 23 "" 100
		ACT	5 "CA mini fee 5" 24 "" 100
		ACT	6 "CA cerf 2" 25 "" 100
		ACT	7 "CA cerf 4" 26 "" 100
		ACT	8 "CA cerf 3" 27 "" 100
		ACT	9 "CA mini fee 6" 28 "" 100
		ACT	10 "CA colombe 2" 29 "" 100
		ACT	11 "CA colombe 3" 30 "" 100
		ACT	11 "CA poisson volant 1" 31 "" 100
		ACT	12 "CA poisson volant 2" 32 "" 100
		ACT	13 "CA poisson volant 3" 33 "" 100
	
section END


//=================================================================================
//
// GRANDE CHASSE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	7
		NAME	"Grande Chasse"
		NUM	1
		REGION	"Arden"
		ICON	"arden"
		PARENT	101

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCha"
		AENV 	3
		ZFAR	7500
		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 3 0
		CAM	3 7 0
		CAM	4 13 0
		//camera combat CAM 15

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 2 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0
		
		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 2 1
		TRIG 	2 3 1
		TRIG 	3 4 1	//chgt chapitre
		TRIG	4 5 1
		TRIG	5 6 1
		TRIG	6 7 1  //chgt chapitre
		
		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 4 0 
		PBOX	2 5 0
		PBOX	4 11 0
		PBOX	5 6 0
		PBOX	6 7 0
		PBOX	7 8 0
		PBOX	8 9 0
		PBOX	9 12 0
		PBOX	11 2 0
		PBOX	10 10 0
		PBOX	12 13 0
		PBOX	13 14 0
		PBOX	14 15 0
		PBOX	15 16 0
		PBOX	16 17 0
		PBOX	17 18 0
		PBOX	27 27 0
		
		PBOX	28 28 0
		
		// boxs couche active
		
		PBOX	20 20 0
		PBOX	21 21 0
		PBOX	22 22 0
		PBOX	23 23 0
		PBOX	24 24 0
		PBOX	25 25 0
		PBOX	26 26 0
		
		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12


		PBOX	2006 100 0
		PBOX	2007 101 0
		PBOX	2008 102 0
		PBOX	2009 103 0
		
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
//gab debut 4/10
  		ASND		1 60 40 25 1 "A_loup"   
  		ASND		2 60 50 30 1 "A_loup2" 
  		ASND		3 60 60 15 1 "A_loup3" 
//gab fin 4/10	

  		ASND		1 60 40 5 1 "A_loup"   
  		ASND		2 60 50 10 1 "A_loup2" 
  		ASND		3 60 60 10 1 "A_loup3" 
		  ASND		4 60 100 0 1 "A_arden"                             "
		ASND		5 55 30 10 1 "A_geai"
		ASND		10 55 30 10 1 "A_oise2"
		  ASND		6 90 50 20 1 "A_neige"
		  ASND		7 50 30 15 1 "A_branch"
		  ASND		8 60 20 15 1 "A_envol2"
		  //ASND	9 100 100 0 1 "vox"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA loup blanc 1" 20 "" 100
		ACT	2 "CA loup blanc 4" 21 "" 100
		ACT	3 "CA loup blanc 8" 22 "" 100
		ACT	4 "CA ours 3" 23 "" 100
		ACT	5 "CA corbeau 4" 24 "" 100
		ACT	6 "CA corbeau 3" 25 "" 100
		ACT	7 "CA faucon 4" 26 "" 100

section END



//=================================================================================
//
// ROCHE NOIRE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	10
		NAME	"Roche Noire"
		NUM	1
		REGION	"Arden"
		ICON	"arden"
		PARENT	101

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zRoe"
		AENV 	3
		ZFAR	8000
		//-------------------------------------------------------------------
		// camras de combat: id, index camra, tat
		//-------------------------------------------------------------------

//		CAM	4 12 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 11 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// collisions interactives: id, index objet, active
		//-------------------------------------------------------------------

		COLLI 373 1 0

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 2 1
		TRIG	2 3 1
		
		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 10 0
		PBOX	2 11 0
		PBOX	3 12 0	// poignee epee
		PBOX	4 13 0
		PBOX	5 14 0
		PBOX	6 15 0
		PBOX	7 16 0
		PBOX	8 17 0
		//PBOX	9 18 0
		PBOX	10 19 0
		PBOX	11 20 0
		PBOX	12 22 0
		//PBOX	13 23 0  //jeu 2
		PBOX	14 24 0
		PBOX	15 25 0
		PBOX	16 26 0
		PBOX	17 27 0
		PBOX	18 28 0
		PBOX	19 29 0
		PBOX	20 30 0
		PBOX	21 31 0
		PBOX	22 33 0
		PBOX	23 2 0
		PBOX	24 3 0
		PBOX	25 6 0
		PBOX	26 21 0
		PBOX	27 32 0
		PBOX	28 36 0
		PBOX	29 34 0
		PBOX	30 37 0
		PBOX	31 38 0
		PBOX	32 39 0
		PBOX	33 40 0
		PBOX	34 41 0
		PBOX	41 7 0		//was 35
		//PBOX 	38 1 0 // was 36
		PBOX 	42 4 0 // was 37
		PBOX 	40 5 0 // was 38
		PBOX 	39 42 0 //excalibur
		PBOX	57 57 0	//plomb
		PBOX	58 58 0
		PBOX	59 59 0
		PBOX	60 60 0	//dummy cam
		PBOX	61 61 0
		PBOX	62 62 0
		
		//fx
		PBOX	35 54 0 
		PBOX 	36 55 0
		PBOX	37 56 0
		
		
		//CA
		PBOX	43 43 0
		PBOX	44 44 0
		PBOX	45 45 0
		PBOX	46 46 0
		PBOX	47 47 0
		PBOX	48 48 0
		PBOX	49 49 0
		PBOX	50 50 0
		PBOX	51 51 0
		PBOX	52 52 0
		PBOX	53 53 0

		
		//-------------------------------------------------------------------
		// lampe permanente: id, index light DB
		//-------------------------------------------------------------------

		LIGHT	1 1 1
		LIGHT	2 2 1
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		5 60 100 0 1 "A_arden"                             "
		  ASND		1 30 100 0 1 "A_lave"
		  ASND		6 80 60 10 1 "A_drag2"
		  ASND		2 80 30 12 1 "A_drag3"
		   ASND		3 30 20 15 1 "A_ricane"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA loup noir 1" 43 "" 100
		ACT	2 "CA loup noir 2" 44 "" 100
		ACT	3 "CA loup noir 3" 45 "" 100
		ACT	4 "CA loup noir 4" 46 "" 100
		ACT	5 "CA loup noir 5" 47 "" 100
		ACT	6 "CA loup noir 6" 48 "" 100
		ACT	7 "CA loup noir 7" 49 "" 100
		ACT	8 "CA loup noir 8" 50 "" 100
		ACT	9 "CA corbeau 2" 51 "" 100
		ACT	10 "CA corbeau 3" 52 "" 100
		ACT	11 "CA corbeau 4" 53 "" 100


section END

//=================================================================================
//
// ENTREE ARDEN
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	65
		NAME	"Entree Arden"
		NUM	1
		REGION	"Arden"
		ICON	"arden"
		PARENT	101

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zAre"
		AENV 	3
		ZFAR	9000
		//-------------------------------------------------------------------
		// camras de combat: id, index camra, tat
		//-------------------------------------------------------------------

//		CAM	1 53 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

//		BACK	1 1 1 1
		BACK	2 2 13 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 26 0
		PBOX	2 27 0
		PBOX	3 28 0
		PBOX	4 29 0

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		5 60 100 0 1 "A_venArd"                             "
		  ASND		1 65 50 80 1 "A_geai"
		  ASND		2 90 50 80 1 "A_neige"
		  ASND		4 50 30 60 1 "A_branch"
		  ASND		6 40 30 80 1 "A_envol"
		  ASND		7 30 30 60 1 "A_oise1"
		  ASND		8 40 30 60 1 "A_oise2"
		  ASND		9 30 30 60 1 "A_oise3"
		  ASND		3 40 30 60 1 "A_envol2"
		  ASND		10 40 30 80 1 "A_oise4"
		  ASND		11 40 30 80 1 "A_oise5"
		  ASND		12 80 30 60 1 "A_grince"
		  //ASND		13 100 100 0 1 "vox"

section END

//=================================================================================
//
// TERTRES
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	9
		NAME	"Tertre des rois morts"
		NUM	1
		REGION	"Arden"
		ICON	"arden"
		PARENT	101

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zTer"
		AENV 	3
		ZFAR	6500
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 1 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------
		PBOX	1 8 0
		PBOX	2 3 0
		PBOX	3 4 0
		PBOX	4 5 0
		PBOX	5 6 0
		PBOX	6 7 0
		
		PBOX	10 20 0
		PBOX	11 21 0
		PBOX	12 22 0
		PBOX	13 23 0
		PBOX	14 24 0
		PBOX	15 25 0
		PBOX	16 26 0
		PBOX	17 27 0
		PBOX	18 28 0
		PBOX	19 29 0
		PBOX	20 30 0
		PBOX	21 31 0

	//SONS ...

		  ASND		1 30 60 20 1 "A_Corb3"
		  ASND		2 40 50 10 1 "A_Corb2"   
		   ASND		2 30 50 10 1 "A_Corbx"                            
		  ASND		3 50 100 0 1 "A_vent"
		  ASND		3 40 60 10 1 "A_fanto"
		   ASND		2 40 50 10 1 "A_Corb1"  

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA ecureuil b 1" 	10 "" 100
		ACT	2 "CA ecureuil e 1" 	11 "" 100
		ACT	3 "CA ecureuil b 3" 	12 "" 100
		ACT	4 "CA faucon 5" 	13 "" 100
		ACT	5 "CA loup blanc 1" 	14 "" 100
		ACT	6 "CA loup blanc 9" 	15 "" 100
		ACT	7 "CA loup blanc 10" 	16 "" 100
		ACT	8 "CA loup blanc 4" 	17 "" 100
		ACT	9 "CA ours 9" 		18 "" 100
		ACT	10 "CA corbeau 29" 	19 "" 100
		ACT	11 "CA corbeau 30" 	20 "" 100
		ACT	12 "CA corbeau 1" 	21 "" 100
		
		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

section END

//=================================================================================
//
// AUTEL RHIANNON
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	11
		NAME	"Autel Rhiannon"
		NUM	1
		REGION	"Arden"
		ICON	"arden"
		PARENT	101

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zRhi"
		AENV 	3
		ZFAR	12000
		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	13 1 12 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 2 0
		PBOX	2 3 0
		PBOX	3 4 0
		PBOX	4 5 0
		PBOX	5 6 0
		PBOX	6 7 0
		PBOX	7 8 0
		PBOX	8 10 0
 		PBOX	9 9 0
		PBOX	10 11 0
		PBOX	11 12 0
		PBOX	12 13 0
		PBOX	13 15 0
		PBOX	14 16 0
		PBOX	15 17 0
		PBOX	17 14 0
		PBOX	18 18 0
		PBOX	19 19 0
		PBOX	20 20 0

		PBOX	21 21 0
		PBOX	22 22 0
		PBOX	23 23 0
		PBOX	24 24 0
		PBOX	25 25 0
		PBOX	26 26 0
		PBOX	27 27 0
		PBOX	28 28 0
		PBOX	29 29 0
		PBOX	30 30 0
		PBOX	31 31 0
		PBOX	32 32 0
		
		PBOX	33 33 0
		PBOX	34 34 0
		PBOX	35 35 0
		PBOX	36 36 0
		PBOX	37 37 0

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		PBOX	2000 100 0
		
		
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

  		ASND		1 40 30 10 1 "O_riref5"   
  		ASND		2 100 50 10 1 "A_0002" 
		ASND		3 20 100 0 1 "A_arden"                             "
		ASND		4 30 20 15 1 "A_envol2"
		//ASND		5 100 100 0 1 "vox"
                                        
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------

// gab debut   		
   	  	BSNDD	1 2000 100 40 10 1 "O_esprit" 500 2000   
   	  	BSNDD	2 2000 100 40 5 1 "O_riref2" 500 2000
   	  	BSNDD	3 2000 100 30 10 1 "O_riref3" 500 2000
   	  	BSNDD	4 2000 100 40 5 1 "O_riref4" 500 2000
// gab fin

   	  	BSNDD_E	1 2000 100 40 10 1 "O_esprit" 500 2000   
   	  	BSNDD_E	2 2000 100 40 5 1 "O_riref2" 500 2000
   	  	BSNDD_E	3 2000 100 30 10 1 "O_riref3" 500 2000
   	  	BSNDD_E	4 2000 100 40 5 1 "O_riref4" 500 2000

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA papillon avalon 1" 21 "" 100
		ACT	2 "CA papillon avalon 2" 22 "" 100
		ACT	3 "CA papillon avalon 3" 23 "" 100
		ACT	4 "CA papillon avalon 4" 24 "" 100
		ACT	5 "CA papillon avalon 5" 25 "" 100
		ACT	6 "CA papillon avalon 6" 26 "" 100
		ACT	7 "CA papillon avalon 7" 27 "" 100
		ACT	8 "CA papillon avalon 8" 28 "" 100
		ACT	9 "CA mini fee 1" 29 "" 100
		ACT	10 "CA mini fee 2" 30 "" 100
		ACT	11 "CA colombe 1" 31 "" 100
		//ACT	12 "CA licorne 1" 32 "" 100

section END



//
//ZIs Magovenium
//


//=================================================================================
//
// ENTREE CIRQUE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	12
		NAME	"Entree cirque"
		NUM	1
		REGION	"Magovenium"
		ICON	"mago"
		PARENT	102

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zPrh"
		ZFAR	12000
		AENV 	2
		DOORANGLE  90
		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 9 1
		CAM	2 8 1

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 511 1
		BACK	2 2 10 1

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	2 3 13 1 1
		TOZI	1 4 16 1 1

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0
		IN	3 3 0
		IN	4 4 0

		//-------------------------------------------------------------------
		// trigger porte: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	5 5 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 26 0
		PBOX	2 28 0 
		PBOX	3 27 0 
		PBOX	4 29 0 
		PBOX	5 30 0
		PBOX	6 32 0
		PBOX	7 31 0
		PBOX	8 33 0
		PBOX	9 34 0

		PBOX	10 35 0
		PBOX	11 36 0
		PBOX	12 37 0
		PBOX	13 38 0
		PBOX	14 39 0
		PBOX	15 40 0
		PBOX	16 41 0
	
		
		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte cirque ext" 8 5 0 0 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12
	// boites test sons

		//PBOX	2000  150 0
		//PBOX	2001 151 0
		//PBOX	2002 152 0
		//PBOX	2003 153 0
		//PBOX	2005 155 0
		//PBOX	2004 154 0
		//PBOX	2006 156 0
		

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		1 40 100 0 1 "A_ventMa"
		  ASND		2 35 50 10 1 "A_Raf1"
		  ASND		3 35 50 20 1 "A_Raf2"
		  ASND		4 35 30 15 1 "A_Raf3"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA chat 5" 10 "" 100
		ACT	2 "CA corbeau 14" 11 "" 100
		ACT	3 "CA corbeau 15" 12 "" 100
		ACT	4 "CA enfant chretien 2" 13 "" 100
		ACT	5 "CA corbeau 12" 14 "" 100
		ACT	6 "CA chat 6" 15 "" 100
		ACT	7 "CA corbeau 13" 16 "" 100

section END



//=================================================================================
//
// CIRQUE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	16
		NAME	"Cirque"
		NUM	1
		REGION	"Magovenium"
		ICON	"mago"
		PARENT	102

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCir"
		AENV 	1
		DOORANGLE	9000
		//-------------------------------------------------------------------
		// camra de combat: id, index camra, tat
		//-------------------------------------------------------------------

//		CAM	1 20 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 1 12 4 1
		TOZI	2 2 15 1 1
		TOZI	3 3 17 1 1	// vers catacombes niveau 1

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0
		IN	3 3 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 4 0
		PBOX	2 17 0
		PBOX	3 5 0
		PBOX	4 15 0
		PBOX	5 6 0
		PBOX	6 7 0
		PBOX	7 8 0
		PBOX	8 11 0
		PBOX	9 10 0
		PBOX	10 13 0
		PBOX	11 14 0
		PBOX	12 12 0
		PBOX	13 9 0
		PBOX	14 16 0
		PBOX	15 18 0
		PBOX	16 24 0
		PBOX	17 23 0
		PBOX	18 25 0
		PBOX	19 26 0
		PBOX	20 22 0
		PBOX	21 27 0
		PBOX	22 19 0
		PBOX	23 20 0
		PBOX	24 21 0
		PBOX	25 28 0
		PBOX	26 29 0
		PBOX	27  1 0

		PBOX	40 40 0
		PBOX	42 42 0
		PBOX	44 44 0
		PBOX	45 45 0
		PBOX	46 46 0
		PBOX	47 47 0
		PBOX	48 48 0
		PBOX	49 49 0
		PBOX	50 50 0
		PBOX	51 51 0
		PBOX	52 52 0
		PBOX	53 53 0
		PBOX	54 54 0
		PBOX	55 55 0
		PBOX	56 56 0
		PBOX	57 57 0
		PBOX	58 58 0
		PBOX	59 59 0
		PBOX	60 60 0
		PBOX	61 61 0
		PBOX	62 62 0
		PBOX	63 63 0
		PBOX	64 64 0
		PBOX	65 65 0
		PBOX	66 66 0

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 11 1
		TRIG	2 12 1
		TRIG	3 13 1
		TRIG	4 14 1
		TRIG	8 18 1
		TRIG	9 19 1
		
		//-------------------------------------------------------------------
		// triggers de portes: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	5 15 1
		TRIG	6 16 1
		TRIG	7 17 1
		
		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte cirque int"    22 5 0 0 1
		DOOR	2 "Porte monastere ext" 23 6 0 0 1
		DOOR	3 "Porte catacombe ext" 24 7 0 0 1


	
		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12


		PBOX	2000 100 0
		PBOX	2001 101 0

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		5 40 100 0 1 "A_arden"                             "
	
                                        
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------
//gab debut
   		BSNDD	19 2000 100 100 0 1 "O_Hell" 300 1200	
   		BSNDD	20 2001 100 100 0 1 "O_feufor" 300 1000

   		BSNDD_E	19 2000 100 100 0 1 "O_Hell" 300 1200
   		BSNDD_E	20 2001 100 100 0 1 "O_feufor" 300 1000
//gab fin

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA poule" 40 "" 100
		ACT	2 "CA poule 2" 42 "" 100
		ACT	3 "CA cheval 3" 44 "" 100
		ACT	4 "CA paysan chretien 2" 45 "" 100
		ACT	5 "CA paysan chretien 3" 46 "" 100
		ACT	6 "CA citadin 2" 47 "" 100
		ACT	7 "CA paysanne 1" 48 "" 100
		ACT	8 "CA citadin 3" 49 "" 100
		ACT	9 "CA citadin 4" 50 "" 100
		ACT	10 "CA paysanne 2" 51 "" 100
		ACT	11 "CA poule 3" 52 "" 100
		ACT	12 "CA poule 4" 53 "" 100
		ACT	13 "CA poule 5" 54 "" 100
		ACT	14 "CA citadin 1" 55 "" 100
		ACT	15 "CA poule 6" 56 "" 100
		ACT	16 "CA poule 7" 57 "" 100
		ACT	17 "CA poule 8" 58 "" 100
		ACT	18 "CA poule 9" 59 "" 100
		ACT	19 "CA poule 10" 60 "" 100
		ACT	20 "CA paysanne 3" 61 "" 100
		ACT	21 "CA paysanne 4" 62 "" 100
		ACT	22 "CA corbeau 15" 63 "" 100
		ACT	23 "CA corbeau 17" 64 "" 100
		ACT	24 "CA corbeau 18" 65 "" 100
		ACT	25 "CA corbeau 19" 66 "" 100

section END


//=================================================================================
//
// RUINES
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	14
		NAME	"Ruines"
		NUM	2
		REGION	"Magovenium"
		ICON	"mago"
		PARENT	102

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zReh"
		AENV 	2
		ZFAR	6000
		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 7 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	2 1 3 1

		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		TODEC	1 2 3 0 1

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 33 0
		PBOX	2 34 0
		PBOX	3 35 0
		PBOX	4 36 0
		PBOX	5 37 0
		PBOX	6 38 0
		PBOX	7 39 0
		
		PBOX	9 40 0
		PBOX	10 41 0
		PBOX	11 42 0
		PBOX	12 43 0

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		PBOX	2000  150 0
		

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		
		 ASND		1 40 100 0 1 "A_ventMa"                             "
		 ASND		2 40 30 10 1 "A_eboul2"                        
		 ASND		3 30 30 20 1 "A_eboul5"                        
		 ASND		4 30 30 15 1 "A_eboul6"                        
		 ASND		5 100 40 50 1 "A_0002"                              "
		 //ASND		7 100 100 0 1 "vox"
                                        
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------

//gab debut
   		BSNDD	19 2000 100 50 15 1 "A_oiset3" 600 1500
   		BSNDD	20 2000 100 45 20 1 "A_oiset2" 600 1500
   		BSNDD	21 2000 100 45 15 1 "A_oisete" 600 1500
//gab fin

   		BSNDD_E	50 2000 100 50 15 1 "A_oiset3" 600 1500
   		BSNDD_E	51 2000 100 45 20 1 "A_oiset2" 600 1500
   		BSNDD_E	52 2000 100 45 15 1 "A_oisete" 600 1500

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA rat 2" 9 "" 100
		ACT	2 "CA colombe 2" 10 "" 100
		ACT	3 "CA corbeau 14" 11 "" 100
		ACT	4 "CA colombe 4" 12 "" 100

	[mod, 2]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zRih"
		AENV 	1
		ZFAR	6000
		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		TODEC	2 1 2 0 1

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	3 1 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	5 2 0
		
		PBOX	13 3 0
		PBOX	14 4 0
		PBOX	15 5 0

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	3 11
		SLIGHT	4 12

		PBOX	2000  150 0
		PBOX	2001 151 0
		
		

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
		  ASND		6 10 100 0 1 "A_ventMa"                             
		  ASND		7 30 50 40 1 "A_eboul2"                        
		  ASND		8 25 50 25 1 "A_eboul5"                        
		  ASND		9 20 30 35 1 "A_eboul6"                        
                                     
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------

//gab debut
   		BSNDD	19 2000 100 70 5 1 "O_pign" 400 2000
   		BSNDD	22 2001 100 50 10 1 "A_oiset3" 400 1000
   		BSNDD	20 2001 100 45 10 1 "A_oiset2" 400 1000
   		BSNDD	21 2001 100 45 10 1 "A_oisete" 400 1000
//gab fin

   		BSNDD_E	53 2000 100 70 5 1 "O_pign" 400 2000
   		BSNDD_E	54 2001 100 50 10 1 "A_oiset3" 400 1000
   		BSNDD_E	55 2001 100 45 10 1 "A_oiset2" 400 1000
   		BSNDD_E	56 2001 100 45 10 1 "A_oisete" 400 1000

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA rat 3" 13 "" 100
		ACT	2 "CA rat" 14 "" 100
		ACT	3 "CA rat 2" 15 "" 100

section END


//=================================================================================
//
// CATACOMBES NIVEAU 1
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	17
		NAME	"Catacombes niveau 1"
		NUM	1
		REGION	"Magovenium"
		ICON	"mago"
		PARENT	102

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCat"
		AENV 5
		DOORANGLE	90
		ZFAR		6000
		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 1 16 3 1
		TOZI	2 3 18 1 1 // vers niveau 2

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1  1 0 //from cirque
		IN	2 13 0	//from lvl2
		

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 2 0
		PBOX	2 3 0
		PBOX	3 4 0
		PBOX	4 5 0
		PBOX	5 7 0
		PBOX	6 9 0
		PBOX	7 10 0
		PBOX	8 12 0
		PBOX	9 11 0
		PBOX	10 13 0
		PBOX	11 14 0
		PBOX	12 15 0
		
		PBOX 	15 20 0

		//CA
		PBOX 	16 16 0
		PBOX 	17 17 0
		PBOX 	18 18 0
		PBOX 	19 19 0
		
		//-------------------------------------------------------------------
		// trigger de porte: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 2 1
		TRIG	2 4 1
		
		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte catacombe int"		8 1 0 0 1
		DOOR	2 "Porte catacombe cellule"	9 2 0 0 1

		//-------------------------------------------------------------------
		// lampe permanente: id, index light DB
		//-------------------------------------------------------------------

		LIGHT	1 1 1
	// boites test sons

		//PBOX	2000  150 0
		//PBOX	2001 151 0
		//PBOX	2002 152 0
		//PBOX	2003 153 0
		//PBOX	2005 155 0
		//PBOX	2004 154 0
		//PBOX	2006 156 0
		

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		1 20 100 0 1 "A_feufor"                            
		  ASND		2 65 30 30 1 "A_bat_1"
		  ASND		3 70 30 30 1 "A_bat_2"
		  ASND		4 50 20 30 1 "A_bat_3"
		  ASND		5 40 30 15 1 "A_rat_1"
		  ASND		6 80 30 50 1 "A_eboul2"         
		  ASND		7 60 10 50 1 "A_eboul5" 		                             
		  ASND		8 50 10 50 1 "A_eboul6" 
		  ASND		7 30 10 50 1 "A_oise1"
		  ASND		9 40 20 50 1 "A_porte3"
		  ASND		10 30 20 50 1 "A_porte5"
		
		  //ASND		6 100 100 0 1 "vox"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA rat" 	16 "" 100
		ACT	2 "CA rat 1" 	17 "" 100
		ACT	3 "CA rat 2" 	18 "" 100
		ACT	4 "CA rat 3" 	19 "" 100

section END

//=================================================================================
//
// CATACOMBES NIVEAU 2
//
//=================================================================================

section ZINTER
	[def, 1]

		ID	18
		NAME	"Catacombes niveau 2"
		NUM	1
		REGION	"Magovenium"
		ICON	"mago"
		PARENT	102

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCar"
		AENV 	5		
		ZFAR	6000
		IN 1 1 0
		IN 2 10 0
		
		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------
		
		TOZI	1 1 17 2 1 // vers cata lvl 1
		
		PBOX 9 7 0	//statue oeil
		PBOX 2 3 0
		PBOX 3 4 0
		PBOX 4 2 0
		PBOX 6 5 0
		PBOX 8 6 0
		PBOX 10 8 0
		PBOX 11 9 0 // miroir
		PBOX 12 11 0 // statue
		PBOX 13 12 0 // chev noir
		PBOX 17 16 0 //larme 2
		PBOX 18 18 0 //flamme 

		PBOX 20 17 0 //FX DIABLE		
		
		//CA
		PBOX 14 13 0
		PBOX 15 14 0
		PBOX 16 15 0

		LIGHT 1 1 1
		
		TRIG 1 2 1

		PBOX	2000  100 0
		//PBOX	2001 151 0
		//PBOX	2002 152 0
		//PBOX	2003 153 0
		//PBOX	2005 155 0
		//PBOX	2004 154 0
		//PBOX	2006 156 0
		
		COLLI 1 1 0 //TOMBES

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		5 80 100 0 1 "A_feufor"                             "
		  ASND		1 65 30 10 1 "A_bat_1"
		  ASND		2 50 30 20 1 "A_bat_2"
		  ASND		4 50 30 15 1 "A_bat_3"
		  //ASND		6 100 100 0 1 "vox"
                  
                  //cris damnes :     
                  ASND		10 60 3 100 0 1 "O_Hell"
                  ASND		11 40 3 70 15 1 "O_cri1"
                  ASND		12 40 3 70 15 1 "O_cri2"
                  ASND		13 40 3 70 15 1 "O_cri3"
                  
                                        
		//-------------------------------------------------------------------
		// distances globales sons 3D du module: min, max (en centimtres)
		//-------------------------------------------------------------------

		// // snddist	200 1300

		//-------------------------------------------------------------------
		// rolloff du module: facteur (de 10  100, 10 = facteur 1)
		//-------------------------------------------------------------------

		//ROLLOFF	10


		//--------------------------------------------------------------------------------------
		// sons 3D avec distances: ID, box, vol, rnd, delai, etat, fichier, dist min, dist max
		//--------------------------------------------------------------------------------------


		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA rat"   14 "" 100
		ACT	2 "CA rat 1" 15 "" 100
		ACT	3 "CA rat 2" 16 "" 100


section END

//=================================================================================
//
// POTERNE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	13
		NAME	"Poterne"
		NUM	1
		REGION	"Magovenium"
		ICON	"mago"
		PARENT	102

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zPth"
		AENV  2
		DOORANGLE	90
		ZFAR		12000
		//-------------------------------------------------------------------
		// camra d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 2 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 1 12 3 1
		TOZI	2 2 15 2 1


		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 4 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	2 2 0
		PBOX	1 3 0
		PBOX	3 5 0

		PBOX	4 6 0
		PBOX	5 7 0
		PBOX	6 8 0
		PBOX	7 9 0
		PBOX	8 10 0

		//-------------------------------------------------------------------
		// trigger de porte: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 3 1
		
		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte poterne ext" 2 1 0 0 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		1 40 100 0 1 "A_ventMa"
		  ASND		2 35 50 10 1 "A_Raf1"
		  ASND		3 35 50 20 1 "A_Raf2"
		  ASND		4 35 30 15 1 "A_Raf3"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA chat 6" 4 "" 100
		ACT	2 "CA corbeau 13" 5 "" 100
		ACT	3 "CA chien 4" 6 "" 100
		ACT	4 "CA chien 5" 7 "" 100
		ACT	5 "CA chien 6" 8 "" 100

section END


//=================================================================================
//
// MONASTERE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	15
		NAME	"Monastere"
		NUM	1
		REGION	"Magovenium"
		ICON	"mago"
		PARENT	102

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zMon"
		AENV 	4
		ZFAR	4000
		DOORANGLE	9000
		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 2 13 2 1
		TOZI	2 1 16 2 1


		CAM 3 3 1
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 12 0
		IN	3 15 0
		
		//-------------------------------------------------------------------
		// triggers de portes: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 3 1
		TRIG	2 4 1
		TRIG	3 5 1
		TRIG	4 6 1
		TRIG	5 7 1
		TRIG	6 8 1
		TRIG	7 9 1
		TRIG	8 10 1
		TRIG	9 12 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 34 0
		PBOX	2 2 0
		PBOX	3 6 0
		PBOX	4 10 0
		PBOX	5 13 0
		PBOX	6 14 0
		PBOX	7 19 0
		PBOX	8 20 0
		PBOX	9 22 0
		PBOX	10 27 0
		PBOX	11 28 0
		PBOX	12 29 0
		PBOX	13 30 0
		PBOX	14 31 0
		PBOX	15 32 0
		PBOX	16 33 0
		PBOX	17 9 0
		PBOX	18 21 0
		PBOX	19 23 0
		PBOX	20 16 0
		PBOX	29 5 0
		PBOX	30 17 0
		PBOX	31 35 0
		PBOX	21 4 0
		PBOX	22 3 0
		PBOX	23 7 0
		PBOX	24 11 0
		PBOX	25 8 0
		PBOX	26 26 0
		PBOX	27 25 0
		PBOX	28 24 0
		PBOX    33 37 0
		PBOX	32 18 0
		
		PBOX	40 15 0
		

		PBOX	34 38 0
		PBOX	35 39 0
		PBOX	36 40 0
		PBOX	37 41 0
		PBOX	38 42 0
		PBOX	39 43 0
		PBOX	44 44 0
		PBOX	41 45 0
		PBOX	42 46 0

		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte monastere int" 21 2 0 0 1
		DOOR	2 "Porte poterne int"	22 1 0 0 1
		DOOR	3 "Porte etage ext"	23 4 0 0 1
		DOOR	4 "Porte chapelle"	24 5 0 0 1
		DOOR	5 "Porte novelius"	25 6 0 0 1
		DOOR	6 "Porte dionicus"	26 7 0 0 1
		DOOR	7 "Porte cornelius"	27 8 0 0 1
	
		//-------------------------------------------------------------------
		// lampe permanente: id, index light DB
		//-------------------------------------------------------------------

		LIGHT	1 1 1
	// boites test sons

		//PBOX	2000  150 0
		//PBOX	2001 151 0
		//PBOX	2002 152 0
		//PBOX	2003 153 0
		//PBOX	2005 155 0
		//PBOX	2004 154 0
		//PBOX	2006 156 0
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
		ASND		1 10 100 0 1 "A_monas"         
		ASND		2 60 30 50 1 "A_pasMon" 		                             
		ASND		4 50 10 40 1 "A_porte1" 		                       
		ASND		3 40 10 40 1 "A_porte2"                                         
		ASND		5 10 30 50 1 "A_rat_1"  
	      //ASND		6 100 100 0 1 "vox"
		  
		//ASND		9 100 100 0 1 "N_tocsin"
                      
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA chat 2" 	34 "" 100
		ACT	2 "CA rat 2" 	35 "" 100
		ACT	3 "CA chat 1" 	36 "" 100
		ACT	4 "CA chat 3" 	37 "" 100
		ACT	5 "CA chat 4" 	38 "" 100
		ACT	6 "CA rat" 	39 "" 100
		ACT	7 "CA rat 5" 	44 "" 100
		ACT	8 "CA rat 4" 	41 "" 100
		ACT	9 "CA rat 1" 	42 "" 100

section END




//
//  Test de chevalerie : monde des ombres
//

//=================================================================================
//
// TEST DE CHEVALERIE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	112			// id zi
		NAME	"TEST DE CHEVALERIE"
		NUM	1			// nbre de modules
		REGION	"Monde des ombres"
		ICON	"ombres"
		

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zTst"

		AENV 	1
		ZFAR	5000

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN		1 1 0
		IN		2 5 0
		IN		3 6 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

//		TOZI	1 1 44 1 0
//		TOZI	2 2 46 1 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 4 0
		PBOX	2 3 0
		PBOX	3 2 0

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 5 1
		

		//PBOX	2000  100 0
		//PBOX	2001 151 0
		

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
// a verifier choisir parmi sons ambiants ci-dessous

		  ASND		5 30 100 0 1 "A_feufor"  
		//	ASND		8 30 100 0 1 "A_rumble" 
		  ASND		1 20 100 0 1 "A_scary"
		 ASND		2 20 30 20 1 "A_cri1"
		 ASND		6 20 30 15 1 "A_cri2"
		 // ASND		7 100 100 0 1 "A_omin"

		//-------------------------------------------------------------------
		// lampes pnombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	1 12

section END


//=================================================================================
//
// ENFERS
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	115			// id zi
		NAME	"ENFERS"
		NUM	1			// nbre de modules
		REGION	"Monde des ombres"
		ICON	"ombres"

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zNas"
		AENV 	1
		ZFAR	5000
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN		1 1 0
		IN		2 5 0
		IN		3 6 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

//		TOZI	1 1 44 1 0
//		TOZI	2 2 46 1 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 4 0
		PBOX	2 3 0
		PBOX	3 2 0
		PBOX	4 7 0  //ecu
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
// a verifier choisir parmi sons ambiants ci-dessous

		  ASND		5 30 100 0 1 "A_feufor"  
		//	ASND		8 30 100 0 1 "A_rumble" 
		  ASND		1 20 100 0 1 "A_scary"
		 ASND		2 20 30 20 1 "A_cri1"
		 ASND		6 20 30 15 1 "A_cri2"
		 // ASND		7 100 100 0 1 "A_omin"

		//-------------------------------------------------------------------
		// triggers narratifs: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 5 1
		
		//-------------------------------------------------------------------
		// lampes pnombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	1 12

section END
//=================================================================================
//
// Tintagel : camp BK
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	36
		NAME	"Camp BK"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCcn"
		DOORANGLE	90
		ZFAR	25000
		AENV	3
		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		// CAM action
		CAM 6 6 0		
		
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 2 35 1 1

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 5 1


		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		//PBOX	1 ?? 0
		PBOX	2 5 0
		PBOX	3 3 0 //combat
		PBOX	4 8 0 //combat
		PBOX	16 7 0 //dummy cb
		
		PBOX	5 16 0
		PBOX	6 15 0
		PBOX	7 12 0
		PBOX	8 13 0
		PBOX	9 14 0
		PBOX	10 9 0
		PBOX	11 10 0
		PBOX	12 11 0
		PBOX	13 06 0
		PBOX 	14 17 0	
		PBOX    15  18 0
		PBOX	17 4 0
		PBOX    18 19 0
		PBOX 	21 20 0
		PBOX 	22 21 0
		PBOX	19 22 0
		PBOX	20 23 0
		
		PBOX	31 24 0
		PBOX	32 25 0
		PBOX	33 26 0
		PBOX	34 27 0
		PBOX	35 28 0
		
		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte sanctuaire" 13 3 0 1 1

		//-------------------------------------------------------------------
		// objets decor: id, entite, boite, etat
		//-------------------------------------------------------------------

		OBJF	1 "Tente 1" 15 1	//P018
		OBJF	2 "Tente 2" 18 1	//P019

		OBJF	3 "Pierre sorcier cristal camp BK" 14 1
		
		//-------------------------------------------------------------------
		// trigger porte: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	3 5 1

		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------
		
		TRIG	1 3 1
		TRIG	2 4 1


		//-------------------------------------------------------------------
		// lampe permanente: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12


		//PBOX	2000 100 0
		//PBOX	2001 101 0
		//PBOX	2002 102 0
		//PBOX	2003 103 0
		//PBOX	2004 104 0
		//PBOX	2005 105 0
		//PBOX	2006 106 0

	

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 40 100 0 1 "A_Uff"
		   ASND		2 20 50 60 1 "A_loup"
		  ASND		7 20 50 70 1 "A_loup2"
		  ASND		8 20 50 80 1 "A_loup3"
		  ASND		3 30 30 70 1 "A_Maraf1"
		  ASND		4 30 30 50 1 "A_Maraf2"
		  ASND		5 30 30 90 1 "A_Maraf3"
		  ASND		6 40 30 15 1 "A_Corbx"
		  //ASND		7 100 100 0 1 "vox"
		  	  ASND		8 65 50 10 1 "A_geai"
		  ASND		9 90 50 20 1 "A_neige"
		  ASND		10 50 30 75 1 "A_branch"
		  ASND		11 40 30 60 1 "A_envol"
		  ASND		12 30 30 60 1 "A_oise1"
		  ASND		13 40 30 50 1 "A_oise2"
		  ASND		14 30 30 60 1 "A_oise3"
		   ASND		15 40 30 75 1 "A_envol2"
		  ASND		16 40 30 40 1 "A_oise4"
		  ASND		17 40 30 30 1 "A_oise5"
		  ASND		18 80 30 40 1 "A_grince"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 12" 31 "" 100
		ACT	2 "CA corbeau 13" 32 "" 100
		ACT	3 "CA loup blanc 8" 33 "" 100
		ACT	4 "CA loup blanc 6" 34 "" 100
		ACT	5 "CA loup noir 12" 35 "" 100

		
section END



//=================================================================================
//
// CAMP DES ESCLAVES
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	34
		NAME	"Camp des Esclaves"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105		
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zEsc"
		ZFAR	25000
		AENV	3

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 1 200 2 1

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 2 4 1

		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 1 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1 3 0
		PBOX	2 4 0
		PBOX	3 5 0
		PBOX	4 6 0
		PBOX	5 7 0
		PBOX	6 8 0
		PBOX	7 9 0
		PBOX	8 10 0
		PBOX	9 11 0
		PBOX	10 12 0
		PBOX	11 13 0
		
		PBOX	12 14 0
		PBOX	13 15 0
		PBOX	14 16 0
		PBOX	15 17 0
		PBOX	16 18 0
		PBOX	17 19 0
		PBOX	18 20 0

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 40 100 0 1 "A_Uff"
		  ASND		2 10 50 60 1 "A_loup"
		  ASND		7 10 50 70 1 "A_loup2"
		  ASND		8 20 50 80 1 "A_loup3""
		  ASND		3 30 30 70 1 "A_Maraf1"
		  ASND		4 30 30 50 1 "A_Maraf2"
		  ASND		5 30 30 90 1 "A_Maraf3"
		  ASND		6 20 60 15 1 "A_Corbx"
		  //ASND		7 100 100 0 1 "vox"
	
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 9" 12 "" 100
		ACT	2 "CA corbeau 10" 13 "" 100
		ACT	3 "CA ours 7" 14 "" 100
		ACT	4 "CA ours 5" 15 "" 100
		ACT	5 "CA ours 6" 16 "" 100
		ACT	6 "CA cerf 6" 17 "" 100
		ACT	7 "CA corbeau 11" 18 "" 100
	
section END


//=================================================================================
//
// SANCTUAIRE OGRE EXT
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	35
		NAME	"Sanctuaire Ogre Ext"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105		
	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zOgr"
		ZFAR	10000
		AENV	3

		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 9 1
		CAM	2 10 1
		CAM	3 11 1

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0
		
		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 1 36 2 1
		TOZI	2 2 201 1 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 3 0
		PBOX	2 4 0
		PBOX	3 5 0
		PBOX	4 6 0
		PBOX	5 7 0
		PBOX	6 8 0
		PBOX	7 9 0
		PBOX	8 10 0
		PBOX	9 11 0
		PBOX	10 12 0
		PBOX	11 13 0
		PBOX	12 14 0
		PBOX	13 15 0
		PBOX	14 16 0
		
		PBOX	15 17 0
		PBOX	16 18 0
		PBOX	17 19 0
		PBOX	18 20 0
		PBOX	19 21 0


		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 3 1
		TRIG	2 4 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 40 100 0 1 "A_Uff"
		    ASND	2 20 50 60 1 "A_loup"
		  ASND		14 20 50 70 1 "A_loup2"
		  ASND		15 20 50 80 1 "A_loup3"
		  ASND		3 30 30 70 1 "A_Maraf1"
		  ASND		4 30 30 50 1 "A_Maraf2"
		  ASND		5 30 30 90 1 "A_Maraf3"
		  ASND		6 40 30 50 1 "A_Corbx"
		
		  ASND		9 10 100 20 1 "A_ogre3"
		  ASND		10 40 100 10 1 "A_ogre4"
		   ASND		11 50 100 05 1 "A_ogre5"
		 ASND		12 30 100 10 1 "A_ogre6"
		ASND		13 40 100 05 1 "A_ogre7"
		 ASND		14 05 100 0 1 "A_scary"
		  
		  //ASND		7 100 100 0 1 "vox"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA loup blanc 6" 15 "" 100
		ACT	2 "CA corbeau 13" 16 "" 100
		ACT	3 "CA loup 3" 17 "" 100
		ACT	4 "CA loup 4" 18 "" 100
		ACT	5 "CA loup blanc 1" 19 "" 100

section END


//=================================================================================
//
// ENTREE CAMP DES ESCLAVES
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	200
		NAME	"Entree Camp des Esclaves"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105	
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zEse"
		ZFAR	25000
		AENV	3

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 2 1

		//-------------------------------------------------------------------
		// collisions interactives: id, index objet, active
		//-------------------------------------------------------------------

		COLLI	1 1 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 2 34 1 1

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0
		
		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 3 0
		PBOX	2 4 0
		PBOX	3 5 0
		PBOX	4 6 0
		PBOX	5 7 0
		PBOX	6 8 0
		PBOX	7 9 0
		PBOX	8 10 0
		
		PBOX	9 15 0
		PBOX	10 11 0
		PBOX	11 12 0
		PBOX	12 13 0
//		PBOX	13 14 0

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 40 100 0 1 "A_Uff"
		  ASND		2 20 50 60 1 "A_loup"
		  ASND		7 20 50 70 1 "A_loup2"
		  ASND		8 20 50 80 1 "A_loup3"
		  ASND		3 30 30 70 1 "A_Maraf1"
		  ASND		4 30 30 50 1 "A_Maraf2"
		  ASND		5 30 30 90 1 "A_Maraf3"
		  ASND		6 40 30 15 1 "A_Corbx"
		//ASND		7 100 100 0 1 "vox"
		
		 ASND		9 10 100 20 1 "A_ogre3"
		  ASND		10 40 100 10 1 "A_ogre4"
		  ASND		11 50 100 05 1 "A_ogre5"
		  ASND		12 30 100 10 1 "A_ogre6"
		  ASND		13 40 100 05 1 "A_ogre7"

		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 3 1
		TRIG	2 4 1
		TRIG	3 5 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 8" 9 "" 100
		ACT	2 "CA corbeau 9" 10 "" 100
		ACT	3 "CA loup noir 10" 11 "" 100
		ACT	4 "CA corbeau 14" 12 "" 100
		ACT	5 "CA sanglier 1" 13 "" 100

section END


//=================================================================================
//
// SANCTUAIRE OGRE INT
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	201
		NAME	"Sanctuaire Ogre Int"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105		
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zOgg"
		ZFAR	10000
		AENV	3

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1 1 35 2 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 2 0
		PBOX	2 3 0
		PBOX	3 4 0
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 20 100 0 1 "A_scary"
		  ASND		7 40 30 80 1 "A_ogre1"
		  
		  ASND		9 40 30 70 1 "A_ogre3"
		 
		  ASND		11 30 30 50 1 "A_ogre5"
		  ASND		12 20 30 30 1 "A_ogre6"
		  ASND		13 40 30 40 1 "A_ogre7"
		
section END



		
		
//=================================================================================
//
// BOIS CYMERILL
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	38
		NAME	"Bois cymerill"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105		
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zCuf"
		ZFAR	25000
		AENV	3

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 13 1
		BACK	2 2 12 1
		BACK	3 3 14 1
		BACK	4 4 15 1

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0
		IN	3 3 0
		IN	4 4 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 5 0
		PBOX	2 6 0
		PBOX	3 7 0
		PBOX	4 8 0
		PBOX	5 9 0
		PBOX	6 10 0
		PBOX	7 11 0
		PBOX	8 12 0
		PBOX	9 13 0
		PBOX	10 14 0
		
		PBOX	11 16 0
		PBOX	12 19 0
		PBOX	13 15 0
		PBOX	14 17 0
		PBOX	15 18 0

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		5 20 100 0 1 "A_Uff"                             "
		  ASND		1 45 50 10 1 "A_geai"
		  ASND		2 60 50 20 1 "A_neige"
		  ASND		4 50 30 70 1 "A_branch"
		  ASND		6 40 30 80 1 "A_envol"
		  ASND		7 30 30 90 1 "A_oise1"
		  ASND		8 40 30 50 1 "A_oise2"
		  ASND		9 30 30 60 1 "A_oise3"
		  ASND		3 40 30 80 1 "A_envol2"
		  ASND		10 40 30 90 1 "A_oise4"
		  ASND		11 40 30 50 1 "A_oise5"
		  ASND		12 80 30 70 1 "A_grince"
		  //ASND		13 100 100 0 1 "vox"

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 11" 11 "" 100
		ACT	2 "CA loup noir 12" 12 "" 100
		ACT	3 "CA sanglier 1" 13 "" 100
		ACT	4 "CA loup blanc 5" 14 "" 100
		ACT	5 "CA loup blanc 8" 15 "" 100

section END


//=================================================================================
//
// CABANE CHARBONNIER
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	202
		NAME	"Cabane charbonnier"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105		
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zChn"
		DOORANGLE	90
		ZFAR		25000
		AENV	3
		
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 6 1
		
		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 2 0
		PBOX	2 3 0
		PBOX	3 4 0
		PBOX	4 5 0
		PBOX	5 6 0
		PBOX	6 7 0
		PBOX	7 8 0
		PBOX	8 9 0

		PBOX	9 10 0
		PBOX	10 11 0
		PBOX	11 12 0

		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte cabane charbonnier" 8 5 0 0 1

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		  ASND		5 20 100 0 1 "A_Uff"                             "
		  ASND		1 45 50 10 1 "A_geai"
		  ASND		2 60 50 20 1 "A_neige"
		  ASND		4 50 30 70 1 "A_branch"
		  ASND		6 40 30 80 1 "A_envol"
		  ASND		7 30 30 90 1 "A_oise1"
		  ASND		8 40 30 50 1 "A_oise2"
		  ASND		9 30 30 60 1 "A_oise3"
		  ASND		3 40 30 80 1 "A_envol2"
		  ASND		10 40 30 90 1 "A_oise4"
		  ASND		11 40 30 50 1 "A_oise5"
		  ASND		12 80 30 70 1 "A_grince"
		  
		  ASND		9 10 100 20 1 "A_ogre3"
		  ASND		10 30 80 10 1 "A_ogre4"
		  ASND		11 20 70 05 1 "A_ogre5"
		  ASND		12 30 80 10 1 "A_ogre6"
		  ASND		13 20 100 05 1 "A_ogre7"
		  //ASND		13 100 100 0 1 "vox"

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------


		SLIGHT	1 11
		SLIGHT	2 12

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA ours 2" 9 "" 100
		ACT	2 "CA corbeau 11" 10 "" 100
		ACT	3 "CA corbeau 19" 11 "" 100


section END


//=================================================================================
//
// CLAIRIERE NORD
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	205
		NAME	"Clairiere nord"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105	
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zNor"
		ZFAR	6000
		AENV	3

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 7 1
		
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 2 0
		PBOX	2 3 0

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 20 100 0 1 "A_Uff"
		  ASND		2 20 80 40 1 "A_loup"
		  ASND		7 20 70 30 1 "A_loup2"
		  ASND		8 20 70 20 1 "A_loup3"
		  ASND		3 30 30 70 1 "A_Maraf1"
		  ASND		4 30 30 50 1 "A_Maraf2"
		  ASND		5 30 30 90 1 "A_Maraf3"
		  ASND		6 40 80 05 1 "A_Corbx"
		  //ASND		9 100 100 0 1 "vox"

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA cerf 6" 2 "" 100

section END


//=================================================================================
//
// CLAIRIERE SUD
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	206
		NAME	"Clairiere sud"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105		
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zSud"
		ZFAR	6000
		AENV	3
		
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 8 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 2 0
		PBOX	2 3 0
		PBOX	3 4 0
		PBOX	4 5 0

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------

		                               
		  ASND		1 20 100 0 1 "A_Uff"
		  ASND		2 20 50 60 1 "A_loup"
		  ASND		7 20 50 70 1 "A_loup2"
		  ASND		8 20 50 80 1 "A_loup3"
		  ASND		3 30 30 70 1 "A_Maraf1"
		  ASND		4 30 30 50 1 "A_Maraf2"
		  ASND		5 30 30 90 1 "A_Maraf3"
		  ASND		6 40 30 15 1 "A_Corbx"
		  //ASND		7 100 100 0 1 "vox"
		
		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12

		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA ours 8" 2 "" 100
		ACT	2 "CA corbeau 11" 3 "" 100
		ACT	3 "CA corbeau 19" 4 "" 100

section END

//=================================================================================
//
// PONT DU VILLAGE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	207
		NAME	"Pont du village"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zPvi"
		ZFAR	25000
		AENV	3
		
		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0

		//-------------------------------------------------------------------
		// camras d'action: id, index camra, tat
		//-------------------------------------------------------------------

		CAM	1 35 1

		//-------------------------------------------------------------------
		// collisions interactives: id, index objet, active
		//-------------------------------------------------------------------

		COLLI	1 1 0

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 16 1
		BACK	2 2 17 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 3 0
		PBOX	2 4 0
		PBOX	3 5 0
		PBOX	4 6 0
		PBOX	5 7 0
		PBOX	6 8 0
		PBOX	7 9 0
			
		PBOX	8 10 0
		PBOX	9 11 0
		PBOX	10 12 0
		PBOX	11 13 0
		PBOX	12 14 0
		PBOX	13 15 0

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
   
		  ASND		1 20 100 0 1 "A_Uff"
		  ASND		2 70 50 60 1 "A_mouet1"
		  ASND		3 50 30 75 1 "A_mouet2"
		   ASND	4 50 30 120 1 "A_mouet3"
		  ASND		5 50 30 80 1 "A_mouet4"
		   ASND	6 50 30 90 1 "A_mouet5"
	
  		  ASND		7 30 50 70 1 "A_Maraf2" 
  		 ASND		8 30 50 50 1 "A_Maraf3" 
  		  ASND		9 30 40 80 1 "A_Maraf3" 

  		  ASND		10 20 50 60 1 "A_loup"
		  ASND		11 20 50 70 1 "A_loup2"
		  ASND		12 20 50 80 1 "A_loup3"

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12
		
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 7" 8 "" 100
		ACT	2 "CA loup blanc 6" 9 "" 100
		ACT	3 "CA loup blanc 7" 10 "" 100
		ACT	4 "CA cerf 3" 11 "" 100
		ACT	5 "CA cerf 4" 12 "" 100
		ACT	6 "CA corbeau 14" 13 "" 100
	
section END


//=================================================================================
//
// VILLAGE
//
//=================================================================================

section ZINTER

	[def, 1]

		ID	33
		NAME	"Village"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"
		PARENT	105		
	[mod, 1]
	
		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"zVil"
		DOORANGLE	90
		ZFAR	12000
		AENV	3

		//-------------------------------------------------------------------
		// sorties landscape: id, polytope, entre, active
		//-------------------------------------------------------------------

		BACK	1 1 1 1

		//-------------------------------------------------------------------
		// sorties vers modules: id, polytope, entre, module joint, active
		//-------------------------------------------------------------------

		//TODEC	1 2 3 0 1

		//-------------------------------------------------------------------
		// entres: id, polytope, type
		//-------------------------------------------------------------------

		IN	1 1 0
		IN	2 2 0

		//-------------------------------------------------------------------
		// boites positions: id, polytope, type
		//-------------------------------------------------------------------

		PBOX	1 3 0
		PBOX	2 4 0
		PBOX	3 5 0
		PBOX	4 6 0
		PBOX	5 7 0
		PBOX	6 8 0
		PBOX	7 9 0
		PBOX	8 10 0
		PBOX	9 11 0
		PBOX	10 12 0
		PBOX	14 13 0
		PBOX	15 14 0
		PBOX	16 15 0
		PBOX	17 16 0
		PBOX	18 17 0
		PBOX	19 18 0
		PBOX	21 20 0
		PBOX	22 21 0
		PBOX	23 22 0
		PBOX	24 23 0
		
		PBOX	28 25 0
		PBOX	29 26 0
		PBOX	30 27 0
		PBOX	31 28 0
		PBOX	32 29 0
		PBOX	33 30 0
		PBOX	34 31 0
		PBOX	35 32 0
		PBOX	36 33 0
		PBOX	37 34 0
		PBOX	38 35 0
		PBOX	39 36 0
		PBOX	40 37 0
		PBOX	41 38 0
		PBOX	42 39 0
		PBOX	43 40 0
		PBOX	44 41 0
		PBOX	45 42 0
		PBOX	46 43 0
		

		//-------------------------------------------------------------------
		// trigger porte: id, polytope, actif
		//-------------------------------------------------------------------
 
		TRIG	2 3 1

		//-------------------------------------------------------------------
		// portes: ID, entite, box, trigger, ouverte, verrouille, active
		//-------------------------------------------------------------------

		DOOR	1 "Porte eglise ext" 21 2 0 1 1

		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
		 ASND		1 05 100 0 1 "A_ocean"
		ASND		2 70 50 60 1 "A_mouet1"
		  ASND		7 50 30 30 1 "A_mouet2"
		   ASND	8 50 30 50 1 "A_mouet3"
		  ASND		9 50 30 40 1 "A_mouet4"
		   ASND	10 50 30 90 1 "A_mouet5"
                ASND		11 10 30 65 1 "A_vague1"
                ASND		12 10 30 50 1 "A_Vague3"
                ASND		13 10 30 40 1 "A_vague2"
                ASND		14 10 30 60 1 "A_vague4"

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12
		
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	2 "CA poule 9" 28 "" 100
		ACT	3 "CA poule 10" 29 "" 100
		ACT	4 "CA poule 8" 30 "" 100
		ACT	5 "CA paysan chretien 1" 31 "" 100
		ACT	6 "CA cheval 3" 32 "" 100
		ACT	7 "CA chat 1" 33 "" 100
		ACT	8 "CA chat 2" 34 "" 100
		ACT	9 "CA chien 1" 35 "" 100
		ACT	10 "CA paysanne 2" 36 "" 100
		ACT	11 "CA mouette" 37 "" 100
		ACT	12 "CA mouette 1" 38 "" 100
		ACT	13 "CA mouette 2" 39 "" 100
		ACT	14 "CA mouette 3" 40 "" 100
		ACT	15 "CA mouette 4" 41 "" 100
		ACT	16 "CA mouette 5" 42 "" 100
		ACT	17 "CA mouette 6" 43 "" 100
		ACT	18 "CA mouette 7" 44 "" 100
		ACT	19 "CA mouette 8" 45 "" 100
		ACT	20 "CA mouette 9" 46 "" 100
		

	
section END




//=================================================================================
//
// LANDSCAPE
//
//=================================================================================

section LAND

	[def, 1]
	
		ID	105
		NAME	"Landscape Tintagel"
		NUM	1
		REGION	"Tintagel"
		ICON	"tintagel"

		//-------------------------------------------------------------------
		// destination landscape: id, destination, entre, active
		//-------------------------------------------------------------------
		TOLAND	104 104 0 1

	[mod, 1]

		//-------------------------------------------------------------------
		// DB: nom du fichier
		//-------------------------------------------------------------------

		FILE	"lTin"
		DOORANGLE	90
		ZFAR	25000
		AENV	3

		//-------------------------------------------------------------------
		// entres: id, polytope
		//-------------------------------------------------------------------
		IN	0 1 0
		IN	1 2 0
		IN	2 3 0
		IN	3 4 0
		IN	4 5 0
		IN	5 6 0
		IN	6 7 0
		IN	7 8 0
		IN	8 9 0
		IN	12 13 0
		IN	13 14 0
		IN	14 15 0
		IN	15 16 0
		IN	16 17 0
		IN	17 18 0
		IN	18 38 0
		IN	19 40 0
		IN	20 41 0


		//-------------------------------------------------------------------
		// sorties vers ZI: id, polytope, zi, entre, active
		//-------------------------------------------------------------------

		TOZI	1  2  33 1 1
		TOZI	2  3  200 1 1
		//TOZI	3  4  31 1 1
//		TOZI	4  5  34 2 1
		TOZI	5  6  36 1 1
		TOZI	6  7  202 1 1
		TOZI	7  8  205 1 1
		TOZI	8  9  206 1 1
		TOZI	12 13 38 2 1
		TOZI	13 14 38 1 1
		TOZI	14 15 38 3 1
		TOZI	15 16 38 4 1
		TOZI	16 17 207 1 1
		TOZI	17 18 207 2 1

		//-------------------------------------------------------------------
		// teleports: id, polytope, boite dest, actif
		//-------------------------------------------------------------------

		TELEP	1 20 17 1
		TELEP	2 21 16 1
		TELEP	3 23 19 1
		TELEP	4 24 20 1

		//-------------------------------------------------------------------
		// boites positions: id, polytope
		//-------------------------------------------------------------------

		PBOX	1000 20 0
		PBOX	1001 21 0
		PBOX	1002 22 0
		PBOX	1003 23 0
		PBOX	1004 24 0
		PBOX	1005 25 0
		PBOX	1006 26 0
		PBOX	1007 27 0
		PBOX	1008 28 0
		PBOX	1012 32 0
		PBOX	1013 33 0
		PBOX	1014 34 0
		PBOX	1015 35 0
		PBOX	1016 36 0
		PBOX	1017 37 0

		PBOX	1 39 0
		
		PBOX	2 42 0
		PBOX	3 43 0
		PBOX	4 44 0
		PBOX	5 45 0
		PBOX	6 46 0
		PBOX	7 47 0
		PBOX	8 48 0
		PBOX	9 49 0
		PBOX	10 50 0
		PBOX	11 51 0
		PBOX	12 52 0
		PBOX	13 53 0
		PBOX	14 54 0
		PBOX	15 55 0
		PBOX	16 56 0
		PBOX	17 57 0
		PBOX	18 58 0
		PBOX	19 59 0
		PBOX	20 60 0
		PBOX	21 61 0
		PBOX	22 62 0
		PBOX	23 63 0
		PBOX	24 64 0
		PBOX	25 65 0
		PBOX	26 66 0
		PBOX	27 67 0
		PBOX	28 68 0
		PBOX	29 69 0

		PBOX 500 5 0
		
		//-------------------------------------------------------------------
		// trigger narratif: id, polytope, actif
		//-------------------------------------------------------------------

		TRIG	1 19 1
		TRIG	2 22 1
		TRIG	3 1 1

		//-------------------------------------------------------------------
		// lampes map ombre: id, index light DB
		//-------------------------------------------------------------------

		SLIGHT	1 11
		SLIGHT	2 12
		
		//-------------------------------------------------------------------
		// sons ambiants: ID, vol, rnd, delai, etat, fichier
		//-------------------------------------------------------------------
   
		 ASND		1 20 100 0 1 "A_Uff"
		 ASND		2 70 50 60 1 "A_mouet1"
		 ASND		3 50 30 75 1 "A_mouet2"
		 ASND		4 50 30 50 1 "A_mouet3"
		 ASND		5 50 30 80 1 "A_mouet4"
		 ASND		6 50 30 90 1 "A_mouet5"
	  	ASND		7 30 50 70 1 "A_Maraf2" 
  		ASND		8 30 50 50 1 "A_Maraf3" 
  		ASND		9 30 40 80 1 "A_Maraf3" 
		
		//--------------------------------------------------------------------------------------
		// couche active : id, entite, boite, prog, random
		//--------------------------------------------------------------------------------------

		ACT	1 "CA corbeau 7" 2 "" 100
		ACT	2 "CA corbeau 8" 3 "" 100
		ACT	3 "CA corbeau 9" 4 "" 100
		ACT	4 "CA corbeau 10" 5 "" 100
		ACT	5 "CA corbeau 11" 6 "" 100
		ACT	6 "CA loup blanc 6" 7 "" 100
		ACT	7 "CA loup blanc 7" 8 "" 100
		ACT	8 "CA loup noir 10" 9 "" 100
		ACT	9 "CA loup noir 11" 10 "" 100
		ACT	10 "CA loup noir 12" 11 "" 100
		ACT	11 "CA ours 7" 12 "" 100
		ACT	12 "CA ours 5" 13 "" 100
		ACT	13 "CA ours 6" 14 "" 100
		ACT	14 "CA cerf 2" 15 "" 100
		ACT	15 "CA cerf 3" 16 "" 100
		ACT	16 "CA cerf 6" 17 "" 100
		ACT	17 "CA corbeau 14" 18 "" 100
		ACT	18 "CA sanglier 1" 19 "" 100
		ACT	19 "CA loup blanc 5" 20 "" 100
		ACT	20 "CA loup blanc 8" 21 "" 100
		ACT	21 "CA cerf 4" 22 "" 100
		ACT	22 "CA cerf 7" 23 "" 100
		ACT	23 "CA loup noir 9" 24 "" 100
		ACT	24 "CA loup noir 5" 25 "" 100
		ACT	25 "CA loup noir 6" 26 "" 100
		ACT	26 "CA loup noir 7" 27 "" 100
		ACT	27 "CA loup noir 8" 28 "" 100
		ACT	28 "CA ours 2" 29 "" 100

section	END
