/*
 * Decompiled with CFR 0.152.
 */
package com.legowhore.q3;

import com.legowhore.q3.PercentLayout;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class InfoPanel
extends JPanel {
    protected JTextPane infoBox;
    protected JScrollPane scrollPane;
    protected boolean autoScroll = true;

    public InfoPanel() {
        this.setLayout(new PercentLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.infoBox = new JTextPane(new DefaultStyledDocument());
        this.infoBox.setForeground(Color.white);
        this.infoBox.setBackground(Color.black);
        this.infoBox.setEditable(false);
        this.scrollPane = new JScrollPane(this.infoBox);
        this.add("0 0 100 100", this.scrollPane);
    }

    public void appendInfo(String string, Color color) {
        if (this.infoBox != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, color);
            StyleConstants.setFontFamily(simpleAttributeSet, "SansSerif");
            StyledDocument styledDocument = this.infoBox.getStyledDocument();
            try {
                JScrollBar jScrollBar;
                styledDocument.insertString(styledDocument.getLength(), string, simpleAttributeSet);
                if (this.autoScroll && (jScrollBar = this.scrollPane.getVerticalScrollBar()) != null) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Caught Bad Location Exception (appendInfo)\n");
            }
            if (!this.infoBox.isVisible()) {
                System.out.println(string);
            }
        } else {
            System.out.println(string);
        }
    }

    public void clear() {
        StyledDocument styledDocument = this.infoBox.getStyledDocument();
        try {
            styledDocument.remove(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Caught Bad Location Exception (clear)\n");
        }
    }

    public void displayInfo(String string, Color color) {
        if (this.infoBox != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, color);
            StyleConstants.setFontFamily(simpleAttributeSet, "SansSerif");
            StyledDocument styledDocument = this.infoBox.getStyledDocument();
            try {
                JScrollBar jScrollBar;
                styledDocument.insertString(styledDocument.getLength(), String.valueOf(string) + "\n", simpleAttributeSet);
                if (this.autoScroll && (jScrollBar = this.scrollPane.getVerticalScrollBar()) != null) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Caught Bad Location Exception (displayInfo)\n");
            }
            if (!this.infoBox.isVisible()) {
                System.out.println(string);
            }
        } else {
            System.out.println(string);
        }
    }

    public void replace(String string, Color color) {
        StyledDocument styledDocument = this.infoBox.getStyledDocument();
        try {
            this.infoBox.invalidate();
            styledDocument.remove(0, styledDocument.getLength());
            this.displayInfo(string, color);
            this.infoBox.repaint();
            this.infoBox.validate();
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Caught Bad Location Exception (clear)\n");
        }
    }

    public void replaceInfo(String string, Color color) {
        if (this.infoBox != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, color);
            StyleConstants.setFontFamily(simpleAttributeSet, "SansSerif");
            StyledDocument styledDocument = this.infoBox.getStyledDocument();
            try {
                JScrollBar jScrollBar;
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.insertString(styledDocument.getLength(), String.valueOf(string) + "\n", simpleAttributeSet);
                if (this.autoScroll && (jScrollBar = this.scrollPane.getVerticalScrollBar()) != null) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Caught Bad Location Exception (replaceInfo)\n");
            }
            if (!this.infoBox.isVisible()) {
                System.out.println(string);
            }
        } else {
            System.out.println(string);
        }
    }

    public void setAutoScroll(boolean bl) {
        this.autoScroll = bl;
    }
}

