/*
  Implementation of all the little helpers and parsers.

  $Id: tool.c,v 1.6 2000/01/09 23:09:44 jacobs Exp jacobs $

  $Log: tool.c,v $
  Revision 1.6  2000/01/09 23:09:44  jacobs
  new option "-r"

  Revision 1.5  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.4  2000/01/05 03:43:25  jacobs
  *** empty log message ***

  Revision 1.3  2000/01/03 16:04:02  jacobs
  *** empty log message ***

  Revision 1.2  1999/12/30 01:26:21  jacobs
  *** empty log message ***

  Revision 1.1  1999/12/28 22:34:38  jacobs
  Initial revision

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tool.h"
#include "game.h"


char team_name[3][10]={"Both Teams", "Red Team", "Blue Team"};
char team_color[3][8]={"#550055", "#550000", "#000055"};
char color_suicide[8]="#440044";

char color_bgt_items[8]="#442200";
char color_bgt_weaps[8]="#442200";
char color_bgt_stats[8]="#000022";
char color_bgt_heads[8]="#000000";

char color_bgt_allweaps[8]="#000022";

char color_bg_index[8]="#000000";
char color_text_index[8]="#FFFFBB";
char color_link_index[8]="#FFFFAA";
char color_vlink_index[8]="#DDDDAA";

char color_bg_game[8]="#000000";
char color_text_game[8]="#DDDD99";
char color_bg_allgame[8]="#000000";
char color_text_allgame[8]="#DDDD99";
char color_bg_allplayers[8]="#000000";
char color_text_allplayers[8]="#DDDD99";

char color_bg_killtable[8]="#222222";



const char *html_colors[8] = {"#000000", "#FF0000", "#00FF00", "#FFFF00",
			      "#0000FF", "#00FFFF", "#FF00FF", "#FFFFFF"};
char funname[MAXFUNNAMELENGTH];
char b_funname=1;


/*
 *
 *
 First, some very often needed helpers ..
 *
 *
 */
char *my_strndup(char *mem, int len)
{
  char *m=(char *)malloc(len+1);
  strncpy(m, mem, len);
  m[len]=0;
  return m;
}

void exit_error(char *msg)
{
  fprintf(stderr, msg);
  exit(-1);
}

char *get_Line(FILE *fp)
{
  int   pos=1;
  char  *line=(char *)malloc(MAXLINELENGTH);
  if (line==NULL) exit_error("MALLOC failed");

  memset(line,0,MAXLINELENGTH);
  while(line[0]<32 && !feof(fp))
    fread(&line[0],1,1,fp);
  
  while(pos<MAXLINELENGTH && line[pos-1]>15 && !feof(fp))
    {
      fread(&line[pos],1,1,fp);
      pos++;
    }

  line[pos-1]=0;
  if (feof(fp))
    {if (line!=NULL) free(line);
    return NULL;}
  return line;
}


char *get_Keyword_char(char *mem, char *keyword)
{
  char *pos, *tmp;
  pos=strstr(mem, keyword);
  if (pos==NULL) return NULL;
  pos+=strlen(keyword);

  tmp=pos;
  while(*tmp!='\\' && *tmp!=0) tmp++;
  return my_strndup(pos, tmp-pos);
}


int get_Keyword_int(char *mem, char *keyword)
{
  char *pos, *tmp, *m;
  int   val;
  
  pos=strstr(mem, keyword);
  if (pos==NULL) return -1;
  pos+=strlen(keyword);
  
  tmp=pos;
  while(*tmp!='\\' && *tmp!=0) tmp++;
  m=my_strndup(pos, tmp-pos);
  sscanf(m,"%i", &val);
  if (m!=NULL) free(m);
  return val;
}


t_event *get_Event(char *mem)
{
  char    *a, *b;
  int      min=0, sec=-1;
  t_event *event;

  if (mem==NULL) return NULL;

  a=mem;

  while(*a==32 && *a!=0)
    a++;

  min=0;
  while(*a!=':' && *a!=0)
    {min=min*10 + (*a-'0'); a++;}

  if (*a==0) return NULL;
  a++;
  sec=(*(a)-'0')*10 + (*(a+1)-'0');

  a+=2;
  if (*a==0) return NULL;
  if (*a==32) a++;
  //fprintf(stderr, "%i:%i\n", min, sec);

  b=a;
  while(*b!=':' && *b!=0) b++;
  if (*b==0) b=a+1;//return NULL;

  event=(t_event *)malloc(sizeof(t_event));
  memset(event,0,sizeof(t_event));

  event->event=my_strndup(a, b-a);
  if (*(b+1) != 0)
    event->text=strdup(b+1);
  else
    event->text=NULL;
  event->time=min*60+sec;

#if (DEBUG_LEVEL > 1)
  fprintf(stderr, "%02i:%02i (%i) - *%s* -> %s\n", min, sec,
	  event->time, event->event, event->text);
#endif
  return event;
}




/* Sorting for all !!!
   I did not get it working with an additional text[][] - param, else
   the sort_weaps, sort_things could be wasted
*/
void sort_things(int *thing, int *sort, int len)
{
  int i,j, todo;

  for (i=0; i<len; i++)
    sort[i]=i;

  todo=1;
  while(todo)
    {
      todo=0;
      for (i=0; i<len-1; i++)
	{
	  if (thing[sort[i]]>thing[sort[i+1]]) continue;

	  if (thing[sort[i]]<thing[sort[i+1]])
	    {
	      j=sort[i];
	      sort[i]=sort[i+1];
	      sort[i+1]=j;
	      todo=1;
	    }
	}
    }
}

void sort_weaps(int weaps[NOF_WEAPS], int sort[NOF_WEAPS])
{
  int i,j, todo;

  for (i=0; i<NOF_WEAPS; i++)
    sort[i]=i;

  todo=1;
  while(todo)
    {
      todo=0;
      for (i=0; i<NOF_WEAPS-1; i++)
	{
	  if (weaps[sort[i]]>weaps[sort[i+1]]) continue;

	  if ( (weaps[sort[i]]<weaps[sort[i+1]]) ||
	       (strcmp(c_weaps[sort[i]], c_weaps[sort[i+1]])>0) )
	    {
	      j=sort[i];
	      sort[i]=sort[i+1];
	      sort[i+1]=j;
	      todo=1;
	    }
	}
    }
}


void sort_items(int items[NOF_ITEMS], int sort[NOF_ITEMS])
{
  int i,j, todo;

  for (i=0; i<NOF_ITEMS; i++)
    sort[i]=i;

  todo=1;
  while(todo)
    {
      todo=0;
      for (i=0; i<NOF_ITEMS-1; i++)
	{
	  if (items[sort[i]]>items[sort[i+1]]) continue;

	  if ( (items[sort[i]]<items[sort[i+1]]) ||
	       (strcmp(c_items_nice[sort[i]], c_items_nice[sort[i+1]])>0) )
	    {
	      j=sort[i];
	      sort[i]=sort[i+1];
	      sort[i+1]=j;
	      todo=1;
	    }
	}
    }
}









/*
 *
 *
 FUN-NAMEs should keep their color
 *
 *
 */
const char *make_funname(char *name)
{
  int   i=0, lastcolor=-1, color=7;
  char *b, *mem;

  memset(funname, 0, MAXFUNNAMELENGTH);
  if (name==NULL) return funname;
  mem=(char *)malloc(MAXFUNNAMELENGTH);
  memset(mem,0,MAXFUNNAMELENGTH);

  /* also if fun-names are not used, so we still want to get "<"">" for HTML*/
  b=mem;
  for (i=0; i<strlen(name)+1;i++)
    {
      while(*b!=0) b++;
      if(name[i]=='<')
	strcat(b,"&laquo;");
      else {
	if (name[i]=='>')
	  strcat(b,"&raquo;");
	else
	  *b=name[i];
      }
    }
  *b=0;

  //fprintf(stderr, "%s -> %s\n", name, mem);
  /* no funname used, exit now */
  if (strchr(mem, '^')==NULL)
    {
      strcpy(funname, mem);
      free(mem);
      return funname;
    }


  /* if people dont like fun-names, remove color-infos */
  if (!b_funname)
    {
      b=funname;
      for (i=0; i<strlen(mem); i++)
	{
	  if(mem[i]=='^')
	    { i++; continue;}
	  *(b++)=mem[i];
	}
      free(mem);
      return funname;
    }

  i=0;
  /* lets start the color-coding */
  if(mem[0]!='^' || mem[1]<'0' || mem[1]>'9')
    strcpy(funname, "<font color=\"#FFFFFF\">");
  else
    {
      color=mem[1]-'0';
      if (color<0 || color>7) color=7;
      sprintf(funname, "<font color=\"%s\">",html_colors[color]);
      lastcolor=color;
      i=2;
    }
  b=funname;
  for(; i<strlen(mem); i++)
    {
      if (mem[i]=='^' && (mem[i+1]>='0' && mem[i+1]<='9'))
	{color=mem[i+1]-'0'; i++; continue;}
      while(*b!=0)
	b++;
      if (mem[i]==0) break;
      if (color!=lastcolor && color<8 && color>-1)
	{
	  sprintf(b, "</font><font color=\"%s\">", html_colors[color]);
	  lastcolor=color;
	}
      while(*b!=0)
	b++;
      sprintf(b, "%c", mem[i]);
    }
  strcat(b, "</font>");
  free(mem);
  return funname;
}
