/*
  This tool generates some HTML-output from the Quake3 - "game.log"
  It has been written completely in C, starting with the free
  LCC-Win32 Compiler (GREAT !)

  This code can be reused or improved, but you have to keep all these remarks.
  And please update the versions-information and send the code back to me,
  so I can release another "official" release.

  Its a free project, but its not okay to make money with code or tool !

  !!!!!!!!!
  If you want to put the code or the tool on any electronical media to
  make money you have to ask me first !
  !!!!!!!!!

  Hans-Peter Jacobs <mailto: hanspete@cs.tu-berlin.de>

  $Id: main.c,v 1.8 2000/01/09 23:09:44 jacobs Exp jacobs $

  $Log: main.c,v $
  Revision 1.8  2000/01/09 23:09:44  jacobs
  new option "-r"

  Revision 1.7  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.6  2000/01/05 03:43:25  jacobs
  *** empty log message ***

  Revision 1.5  2000/01/03 16:04:02  jacobs
  *** empty log message ***

  Revision 1.4  1999/12/31 02:21:41  jacobs
  *** empty log message ***

  Revision 1.3  1999/12/30 01:26:21  jacobs
  *** empty log message ***

  Revision 1.2  1999/12/28 22:38:05  jacobs
  *** empty log message ***

  Revision 1.1  1999/12/28 22:33:36  jacobs
  Initial revision

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tool.h"
#include "game.h"
#include "html_creator_tpl.h"


/* needed for parsing the cmd-line-params*/
char show_all=0;
char *templdir=NULL, *outdir=NULL;
char  b_remove_strange=0;

/*
 *
 *
 Here we go !! Its gonna be a mess -> you've been warned !
 *
 *
 *
 *
 *
 *
 */
int parse_kill(t_event *event, t_game *game)
{
  int  cl, vic, weap, color, kc, t;
  
  sscanf(event->text, "%i %i %i:", &t, &vic, &weap);
  cl=getPlayerID(game, t);
  vic=getPlayerID(game, vic);
#ifdef DEBUG_LEVEL
  if (vic<0) {fprintf(stderr, "  KILL : Unknown client %i\n", t);exit(-1);}
#endif
  /* World */
  if (cl<0) cl=1022;

  /* check for the loss of enemies flag */
  for (color=1; color<3; color++)
    {
      if (vic==game->flag_carrier[color])
	{
	  //fprintf(stderr,"Flag_%i carrier(%i) killed by %i\n",color,vic,cl);
	  game->ctf_loss[game->player[vic]->team]++;
	  if (weap!=16 && weap!=22)
	    game->flag_carrier[color]=CTF_LEVEL;
	  else
	    game->flag_carrier[color]=CTF_BASE;
	  
	  if (cl<game->nof_players)
	    game->ctf_fkills[color]++;
	}
    }

  /* check for suicide */
  //fprintf(stderr, "KILL  -> %i -> %i with %i\n", cl, vic, weap);
  if (weap>NOF_WEAPS)
    {
      fprintf(stderr, "unknown weap : %i\n", weap);
      weap=0;
    }
  if (cl < game->nof_players && cl!=vic)
    {
      game->player[cl]->nof_kills++;
      game->player[cl]->nof_frags++;
      game->player[cl]->lst_kills[vic]++;
      game->player[vic]->nof_deaths++;
      game->weaps[weap]++;
      game->player[cl]->weaps[weap]++;

      game->nof_deaths++;
      game->nof_frags++;
      game->nof_kills++;

      /* check a team-kill */
      if (game->type > 2)
	{
	  color=game->player[cl]->team;
	  if ((game->player[vic]->team == game->player[cl]->team))
	    {
	      /* we just killed a friend */
	      game->player[cl]->nof_tkills++;
	      game->player[cl]->nof_frags-=2;
	      game->player[cl]->nof_kills--;
	      game->team_frags[color]--;
	      game->nof_frags-=2;
	      game->nof_kills--;
	      game->nof_tkills++;

	      game->weaps[weap]--;
	      game->player[cl]->weaps[weap]--;
	      game->wtkill[weap]++;
	      game->player[cl]->wtkill[weap]++;


	      game->team_tkills[color]++;
	    } else {
	      game->team_kills[color]++;
	      game->team_frags[color]++;
	    }
	  kc=++game->teamkillcounter[color];
	  if (kc>=MAXTEAMKILLS)
	    {
	      fprintf(stderr, "more than %i teamkills ... not enough space",\
		      MAXTEAMKILLS);
	      --game->teamkillcounter[color];
	    } else {
	      game->tl_team[color][kc]=game->team_frags[color];
	      game->tl_teamsec[color][kc]=event->time-game->startsec;
	    }
	}
      kc=++game->player[cl]->killcounter;
      if (kc>=MAXKILLS)
	{
	  fprintf(stderr, "more than %i kills ... not enough space",\
		  MAXKILLS);
	  --game->player[cl]->killcounter;
	} else {
	  game->player[cl]->tl_frags[kc]=game->player[cl]->nof_frags;
	  game->player[cl]->tl_fragsec[kc]=event->time-game->startsec;
	  game->player[cl]->tl_weaps[kc]=weap;
	  game->player[cl]->tl_whom[kc]=vic;
	}
    } else {
      /* The idiot killed himself (or jumped into something very deadly)*/
      game->player[vic]->lst_kills[vic]++;
      game->player[vic]->nof_suicides++;
      game->player[vic]->nof_deaths++;
      game->player[vic]->nof_frags--;
      game->wsui[weap]++;
      game->player[vic]->wsui[weap]++;
      game->nof_suicides++;
      game->nof_deaths++;
      game->nof_frags--;

      /* check the kills for the team */
      if (game->type > 2)
	{
	  color=game->player[vic]->team;
	  kc=++game->teamkillcounter[color];
	  game->team_suic[color]++;
	  game->team_frags[color]--;
	  if (kc>=MAXTEAMKILLS)
	    {
	      fprintf(stderr, "more than %i teamkills ... not enough space",\
		      MAXTEAMKILLS);
	      --game->teamkillcounter[color];
	    } else {
	      game->tl_team[color][kc]=game->team_frags[color];
	      game->tl_teamsec[color][kc]=event->time-game->startsec;
	    }
	}

      kc=++game->player[vic]->killcounter;
      if (kc>=MAXKILLS)
	{
	  fprintf(stderr, "more than %i teamkills ... not enough space",\
		  MAXKILLS);
	  --game->player[vic]->killcounter;
	} else {
	  game->player[vic]->tl_frags[kc]=game->player[vic]->nof_frags;
	  game->player[vic]->tl_fragsec[kc]=event->time-game->startsec;
	  game->player[vic]->tl_weaps[kc]=weap;
	  game->player[vic]->tl_whom[kc]=vic;
	}
    }
  return 1;
}



int parse_item(t_event *event, t_game *game)
{
  int cl, i, player, flag, eflag, t;

  game->nof_items++;
  sscanf(event->text, "%i", &cl);
  cl=getPlayerID(game, cl);
#ifdef DEBUG_LEVEL
  if (cl<0) {fprintf(stderr, "Unknown client\n");exit;}
#endif

  for (i=0; i<NOF_ITEMS; i++)
    if (strstr(event->text, c_items[i])!=NULL)
      break;

  game->player[cl]->nof_items++;
  if (i>=NOF_ITEMS)
    {
      fprintf(stderr, "Unknown item : %s\n", event->text);
      return 1;
    }
  if (strstr(event->text, "team_CTF")!=NULL)
    {
      /* we touched a flag !!!*/
      if (strstr(event->text, "redflag")!=NULL)
	flag=1;
      else flag=2;
      if (flag==2) eflag=1; else eflag=2;
      player=game->player[cl]->team;
      /* now we know the color of the player and the flag */
      
      if (flag!=player)
	{
	  /* enemy flag taken from base or level */
	  if (game->flag_carrier[flag]==CTF_BASE)
	    {
	      //fprintf(stderr, "%i flag stolen by %i\n", flag, cl);
	      game->ctf_steals[eflag]++;
	    }
	  else
	    {
	      //fprintf(stderr, "%i flag picked up by %i\n", flag, cl);
	      game->ctf_pickups[eflag]++;
	    }
	  game->flag_carrier[flag]=cl;
	} else {
	  if (game->flag_carrier[flag]==CTF_LEVEL)
	    {
	      //fprintf(stderr, "%i flag returned by %i\n", flag, cl);
	      game->flag_carrier[flag]=CTF_BASE;
	      game->ctf_returns[flag]++;
	    } else if (game->flag_carrier[eflag]==cl)
	      {
		//fprintf(stderr, "%i flag touchdown by %i\n", eflag, cl);
		game->flag_carrier[eflag]=CTF_BASE;
		t=++game->ctf_captures[flag];
		if (t>=MAXCTFEVENTS)
		  {
		    fprintf(stderr, "more than %i ctf-events ..",\
			    MAXCTFEVENTS);
		  } else {
		    game->tl_ctfsec[flag][t]=event->time - game->startsec;
		    game->tl_ctf[flag][t]=t;
		  }
	      }
	}
    }
  else
    {
      game->player[cl]->lst_items[i]++;
      game->lst_items[i]++;
    }
  return 1;
}


int parse_connection(t_event *event, t_game *game)
{
  int cl, pid;
  t_player **tmp;

  sscanf(event->text, "%i", &cl);
  if (getPlayerID(game, cl)>=0)
    {
      fprintf(stderr, "Client %i connected twice !\n", cl);
      return 1;
    }
  //fprintf(stderr, "%s -> *%s* (%i)\n", event->event, event->text, cl);
  pid=game->nof_players;

  if (game->nof_players==0 && game->startsec==0)
    game->startsec=event->time;
  tmp=(t_player **)realloc(game->player, sizeof(t_player *) * (pid+1));
  if (tmp==NULL) exit_error("REALLOC failed\n");
  game->player=tmp;
  game->nof_players=pid+1;
  game->player[pid]=new_player();
  game->player[pid]->c_id=cl;
  game->player[pid]->startsec=event->time;
#if (DEBUG_LEVEL>0)
  fprintf(stderr, " client %i for player %i added -- ", cl, pid);
#endif
  return 1;
}

int parse_disconnection(t_event *event, t_game *game)
{
  int cl, pid;
  sscanf(event->text, "%i", &cl);
  pid=getPlayerID(game, cl);
  if (pid>=0)
    {
      game->player[pid]->c_id=-2;
      game->player[pid]->secs=event->time - game->player[pid]->startsec;
    }
  else fprintf(stderr, "client %i disconnected before connecting\n", cl);
  return 1;
}


int parse_begin(t_event *event, t_game *game)
{
  int cl, pid;
  
  sscanf(event->text, "%i", &cl);
  pid=getPlayerID(game, cl);
  if (pid<0) {fprintf(stderr, "Unknown client\n");exit;}
  return 1;
}


int parse_uinfochanged(t_event *event, t_game *game)
{
  int   cl, team, skill, pid, i;
  char *name, c;
  
  sscanf(event->text, "%i", &cl);
  pid=getPlayerID(game, cl);
#ifdef DEBUG_LEVEL
  if (pid<0) {fprintf(stderr, "  UINFO: Unknown client %i\n",cl);exit(-1);}
#endif

  if (strstr(event->text, " n\\")!=NULL)
    {
      if (game->player[pid]->name!=NULL)
	free(game->player[pid]->name);
      if (game->player[pid]->i_name!=NULL)
	free(game->player[pid]->i_name);
      game->player[pid]->name=get_Keyword_char(event->text, "n\\");
      for (i=0; i<strlen(game->player[pid]->name);i++)
	{
	  c=game->player[pid]->name[i];
	  if (b_remove_strange)
	    if (c==32 || c=='<' || c=='>' || c=='*')
	      game->player[pid]->name[i]='_';

	  if (c<32 || c=='/' || c=='\\')
	    game->player[pid]->name[i]='_';
	}
      game->player[pid]->i_name=get_Keyword_char(event->text, "n\\");
      //fprintf(stderr, "%s\n", game->player[pid]->name);
    }
  else fprintf(stderr, "STRANGE : %s\n", event->text);

  team=get_Keyword_int(event->text, "\\t\\");
  game->player[pid]->handicap=get_Keyword_int(event->text+4, "\\hc\\");
  skill=get_Keyword_int(event->text+4, "\\skill\\");

  /* If skill-tag found, then its a bot */
  if (skill>-1 && skill<10)
    {
      name=(char *)malloc(strlen(game->player[pid]->name)+6);
      sprintf(name, "%s_[%i]", game->player[pid]->name, skill);
      free(game->player[pid]->name);
      game->player[pid]->name=name;
      game->player[pid]->skill=skill;
    }
  else game->player[pid]->skill=-1;

  if (team==1) game->player[pid]->b_red=1;
  if (team==2) game->player[pid]->b_blue=1;
  game->player[pid]->team=team;
  
#if (DEBUG_LEVEL>1)
  fprintf(stderr, "Player %s changed\n",game->player[pid]->name);
#endif
  return 1;
}

int parse_say(t_event *event, t_game *game)
{
  int  i;
  char who[256];

  sscanf(event->text+1, "%s", who);
  who[strlen(who)-1]=0;
  game->nof_says++;
  for (i=0; i<game->nof_players; i++)
    if ((game->player[i]->i_name) && (strcmp(who, game->player[i]->i_name)==0))
      game->player[i]->nof_says++;
  return 1;
}


int parse_teamscore(t_event *event, t_game *game)
{
  sscanf(event->text, "%i blue:%i", &game->team_score[1],
	 &game->team_score[2]);
  //fprintf(stderr, "%i <-> %i\n", game->red_score, game->blue_score);
  return 1;
}

int parse_score(t_event *event, t_game *game)
{
  int   cl, ping, score;
  char *t;

  t=strstr(event->text,"ping:");
  sscanf(t+strlen("ping:"), "%i ", &ping);

  sscanf(event->text, "%i ", &score);

  t=strstr(event->text,"client:");
  sscanf(t+strlen("client:"), "%i ", &cl);

  //fprintf(stderr, "%i : %i points %i ping\n", cl, score, ping);
  cl=getPlayerID(game, cl);
#ifdef DEBUG_LEVEL
  if (cl<0) {fprintf(stderr, "  SCORE: Unknown client %i\n", cl);exit;}
#endif
  game->player[cl]->ping=ping;
  game->player[cl]->score=score;
  if ((score!=game->player[cl]->nof_frags) && (game->type!=4))
    {
      fprintf(stderr,\
	      "\n%s : _score-calculation wrong (q3:%i - %i) <- ",\
	      game->player[cl]->name, score, game->player[cl]->nof_frags);
      /*
      fprintf(stderr, "%i frags <- %i k, %i s, %i tk\n",\
	      game->player[cl]->nof_frags, game->player[cl]->nof_kills,
	      game->player[cl]->nof_suicides, game->player[cl]->nof_tkills);
      */
    }
  return 1;
}

t_game *parse_game(FILE *fp)
{
  t_game  *game=NULL;
  t_event *event=NULL;
  char    *line=NULL, end=0;
  int      i,j;
  
  /* We start with finding the InitGame - Line */
  line=get_Line(fp);
  if (line!=NULL)
    {
      event=get_Event(line);
      free(line);
    }
  while(event!=NULL && strcmp(event->event, "InitGame")!=0)
    {
      //printf("%i %s\n", event->time, event->event);
      event=del_event(event);
      line=get_Line(fp);
      if (line!=NULL)
	{
	  event=get_Event(line);
	  free(line);
	}
    }
  if (event==NULL) return NULL;

  /* Now we can parse the InitGame - Line */
  game=new_game();
  game->mapname=get_Keyword_char(event->text, "\\mapname\\");
  game->servername=get_Keyword_char(event->text, "\\sv_hostname\\");
  game->fraglimit=get_Keyword_int(event->text, "\\fraglimit\\");
  game->timelimit=get_Keyword_int(event->text, "\\timelimit\\");
  game->capturelimit=get_Keyword_int(event->text, "\\capturelimit\\");
  game->type=get_Keyword_int(event->text, "\\g_gametype\\");

  game->startsec=event->time;
  game->flag_carrier[1]=CTF_BASE;
  game->flag_carrier[2]=CTF_BASE;

  /* run till "ShutDownGame" */
  while (!end)
    {
      line=get_Line(fp);
      event=del_event(event);
      if (line!=NULL)
	{
	  event=get_Event(line);
	  free(line);
	}
      if (line==NULL || event==NULL) {
	  end=1;break;
	}
      if (strcmp(event->event, "ShutdownGame")==0)
	{
	  if (game->secs==0)
	    game->secs=event->time - game->startsec;
	  for (i=0; i<game->nof_players; i++)
	    {
	      if (game->player[i]->secs==0)
		game->player[i]->secs=event->time - game->player[i]->startsec;
	      if (game->player[i]->name==NULL)
		fprintf(stderr,\
			"<null>-name ---> client %i on map %s at %i:%i\n",\
			game->player[i]->c_id, game->mapname,\
			game->startsec/60, game->startsec%60);
	    }

	  end=1;
	  continue;
	}
      if (strcmp(event->event, "Exit")==0)
	{
	  game->secs=event->time - game->startsec;
	  game->complete=1;
	  for (i=0; i<game->nof_players; i++)
	    {
	      if (game->player[i]->secs==0)
		game->player[i]->secs=event->time - game->player[i]->startsec;
	      j=game->player[i]->killcounter++;
	      game->player[i]->tl_frags[j]=game->player[i]->nof_frags;
	      game->player[i]->tl_fragsec[j]=event->time - game->startsec;
	    }
	  continue;
	}
      //fprintf(stdout, "+%s+ -%s-\n", event->event, event->text);
      if (strcmp(event->event, "Kill")==0)
	{parse_kill(event, game); continue;}
      if (strcmp(event->event, "Item")==0)
	{parse_item(event, game); continue;}
      if (strcmp(event->event, "ClientConnect")==0)
	{parse_connection(event, game);	continue;}
      if (strcmp(event->event, "ClientDisconnect")==0)
	{parse_disconnection(event, game);	continue;}
      if (strcmp(event->event, "ClientBegin")==0)
	{parse_begin(event, game); continue;}
      if (strcmp(event->event, "ClientUserinfoChanged")==0)
	{parse_uinfochanged(event, game); continue;}
      if (strcmp(event->event, "red")==0)
	{parse_teamscore(event, game);continue;}
      if (strcmp(event->event, "score")==0)
	{parse_score(event, game); continue;}

      if (strcmp(event->event, "say")==0 || strcmp(event->event, "sayteam")==0)
	{parse_say(event, game); continue;}

      fprintf(stderr, "Unknown Key-Word : %s\n", event->event);
    }
  event=del_event(event);
  return game;
}


int parse_log_file(char *fname)
{
  int      i=0, j;
  long int sum;
  t_game **game;
  FILE    *fp=fopen(fname, "rb");

  if (fp==NULL)
    {
      fprintf(stderr, "failed to open '%s'\n", fname);
      return 0;
    }
  game=(t_game **)malloc(sizeof(t_game *) * MAXGAMES);
  while (!feof(fp) && i<MAXGAMES)
    {
#if (DEBUG_LEVEL > 0)
      fprintf(stderr, "parsing game ");
#endif
      game[i]=parse_game(fp);
      if (game[i]==NULL)
	break;
#if (DEBUG_LEVEL > 0)
      if (game[i]->complete==1)
	fprintf(stderr, "game finished\n");
      else
	{
	  fprintf(stderr, "game aborted\n");
#else
      if (game[i]->complete==1)
	fprintf(stderr, "%02i ", i);
      else
	{
#endif
	  if (show_all==0) {
	    game[i]=del_game(game[i]);
	    i--;
	  }
	  else fprintf(stderr, " %02i ", i);
	}
      i++;
      //getchar();
    }
  fprintf(stderr, "\n  parsed %i games\n", i);
  fclose(fp);

  sum=0;
  for (j=0; j<i; j++)
    sum+=size_game(game[j]);
  fprintf(stderr, "  using %li MB %06li bytes of memory\n",\
	  sum/1000000, sum%1000000);

  fprintf(stderr, "writing HTML-code\n");
  generate_HTML_TPL(game, i, outdir, "longtime.log", templdir);
  fprintf(stderr, "\ndone\n");

  for (j=0; j<i; j++)
    if (game[j]!=NULL) game[j]=del_game(game[j]);
  free(game);
  game=NULL;
  return 1;
}







/*
 *
 *
 Main-stuff, mainly created by LCC-Win32 (great Compiler !)
 *
 *
 */
void Usage(char *programName)
{
  char *t;
#ifndef GNU_C
  t=strrchr(programName, '\\');
#else
  t=strrchr(programName, '/');
#endif
  if (t==NULL)
    t=strdup("q3_loggen");
  else t++;
  fprintf(stderr,"usage: %s [-a] [-o path] [-t path] [-v] <file>\n", t);

  /* Modify here to add your usage message when the program is
     called without arguments */
  fprintf(stderr, "  -a     - enables HTML-generation for *all* games\n");
  fprintf(stderr, "  -f     - turns fun-name colors off\n");
  fprintf(stderr, "  -o     - output directory (must exist, pix-dir too)\n");
  fprintf(stderr, "  -r     - replaces \" \" with \"_\" (player-names)\n");
  fprintf(stderr, "  -t     - sets the template-directory\n");
  fprintf(stderr, "  -v     - displays the version\n");
  fprintf(stderr, "  <file> - complete path to the \"games.log\" - file\n");
  fprintf(stderr, "           (e.g. C:\\Quake3\\baseq3\\games.log)\n");
#ifndef GNU_C
  getchar();
#endif
  if (t!=NULL) free(t);
}



/* returns the index of the first argument that is not an option; i.e.
   does not start with a dash or a slash*/
int HandleOptions(int argc,char *argv[])
{
  int i,firstnonoption=0;
  
  for (i=1; i< argc;i++) {
    if (argv[i][0] == '-') {
      switch (argv[i][1]) {
        /* An argument -? means help is requested */
      case '?':
        Usage(argv[0]);
        return 0;
      case 'o':
      case 'O':
	outdir=strdup(argv[++i]);
	break;
      case 't':
      case 'T':
	templdir=strdup(argv[++i]);
	break;
      case 'f':
      case 'F':
	b_funname=0;
	break;
      case 'r':
      case 'R':
	b_remove_strange=1;
	break;
      case 'h':
      case 'H':
          Usage(argv[0]);
          return 0;
      case 'v':
      case 'V':
	  fprintf(stderr, "Version %s\n", Q3L_MAIN_VERSION);
	  return 0;
      case 'a':
      case 'A':
	show_all=1;
	break;
      default:
        fprintf(stderr,"unknown option %s\n",argv[i]);
        return 0;
      }
    }
    else firstnonoption = i;
  }
  return firstnonoption;
}


int main(int argc,char *argv[])
{
  int  pos=0;

#if (DEBUG_LEVEL>2)
  mtrace();
#endif

  if (argc < 2)
    Usage(argv[0]);

  /* handle the program options, get the position of the path-string */
  pos=HandleOptions(argc,argv);

  if (pos>0)
    {
      if (templdir==NULL)
	templdir=strdup("Templates/framed");
      if (outdir==NULL)
	outdir=strdup("Html_log");
      
      if (pos<argc) parse_log_file(argv[pos]);
#ifndef GNU_C
      getchar();
#endif
    }

#if (DEBUG_LEVEL>0)
  /* Size of some used structs :*/
  fprintf(stderr, "t_player : %i\nt_game   : %i\n",
	  sizeof(t_player),sizeof(t_game));
#endif

  if (templdir!=NULL) free(templdir);
  if (outdir!=NULL) free(outdir);
  return 0;
}
