/*
  This is the file containing the *long-time* stats for players
  and played games.
  Later I will add here some stats-add/load/save/merge-functions !!

  $Id: lt_stats.h,v 1.3 2000/01/03 16:04:02 jacobs Exp jacobs $

  $Log: lt_stats.h,v $
  Revision 1.3  2000/01/03 16:04:02  jacobs
  *** empty log message ***

  Revision 1.2  1999/12/31 02:21:41  jacobs
  *** empty log message ***

  Revision 1.1  1999/12/30 01:26:21  jacobs
  Initial revision


*/

#ifndef __LONG_TIME_STATS_H__
#define __LONG_TIME_STATS_H__

#define MAX_LT_PLAYER 1024


#include "game.h"


typedef struct {
  char *name;

  int   secs, skill;
  int   nof_frags, nof_kills, nof_suicides, nof_tkills, nof_deaths;
  int   nof_says, nof_items;
  
  int   items[NOF_ITEMS];
  int   weaps[NOF_WEAPS], wsui[NOF_WEAPS], wtkill[NOF_WEAPS];
}t_lt_player, t_ltp;


typedef struct {
  int    nof_players, secs;
  int    nof_games, nof_kills, nof_tkills, nof_suicides;
  int    nof_items, nof_frags, nof_deaths;

  int   items[NOF_ITEMS];
  int   weaps[NOF_WEAPS], wsui[NOF_WEAPS], wtkill[NOF_WEAPS];

  t_ltp *ltplayers[MAX_LT_PLAYER];
}t_lt_stats, t_lts;


/* extern we just want to create whole stats, players are handled
   just intern*/
t_lts *new_ltStat(void);
t_lts *del_ltStat(t_lts *lts);

/* And a simple function for adding a whole game to the stats */
int add_game(t_lts *lts, t_game *game);

/* Save and Load-function for the all-time stats */
t_lts *load_stats(char *fname);
int    save_stats(char *fname, t_lts *lts);

/* Loads another dat-file for adding to the currently locked games*/
int    merge_stats(char *fname, t_lts *lts);

#endif
