/*
  Implementation of the long-time statistics.

  $Id: lt_stats.c,v 1.4 2000/01/09 02:32:17 jacobs Exp jacobs $

  $Log: lt_stats.c,v $
  Revision 1.4  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.3  2000/01/03 16:04:02  jacobs
  *** empty log message ***

  Revision 1.2  1999/12/31 02:21:41  jacobs
  *** empty log message ***

  Revision 1.1  1999/12/30 01:26:21  jacobs
  Initial revision


*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "lt_stats.h"



/*
 *
 *
 Functions for handling lt_players
 *
 *
 */
t_ltp *new_ltPlayer(void)
{
  t_ltp *ltp=(t_ltp *)malloc(sizeof(t_ltp));
  if (ltp==NULL)
    return 0;
  memset (ltp, 0, sizeof(t_ltp));
  return ltp;
}


t_ltp *del_ltPlayer(t_lt_player *ltp)
{
  if (ltp==NULL) return NULL;
  if (ltp->name) free(ltp->name);
  free(ltp);
  return NULL;
}


/*
 *
 *
 BASIC functions for lt_stats
 *
 *
 */
t_lts *new_ltStat(void)
{
  t_lts *lts=(t_lts *)malloc(sizeof(t_lts));
  if (lts==NULL) return NULL;
  memset(lts, 0, sizeof(t_lts));
  return lts;
}


t_lts *load_stats(char *fname)
{
  t_lts *lts=new_ltStat();
  return lts;
}


t_lts *del_ltStat(t_lts *lts)
{
  int i;

  if (lts==NULL) return NULL;

  for (i=0; i<lts->nof_players; i++)
    del_ltPlayer(lts->ltplayers[i]);
  free(lts);
  return NULL;
}



/*
 *
 *
 "higher" functions for the lt_stats
 *
 *
 */
int add_game(t_lts *lts, t_game *game)
{
  int    i, j;
  char   known;
  t_ltp *ltp;

  if (lts==NULL || game==NULL) return -1;

  lts->nof_games++;
  lts->nof_kills+=game->nof_kills;
  lts->nof_deaths+=game->nof_deaths;
  lts->nof_items+=game->nof_items;
  lts->nof_suicides+=game->nof_suicides;  
  lts->secs+=game->secs;

  /* for each player we look for a lt_player with the same name */
  for (i=0; i<game->nof_players; i++)
    {
      known=0;
      for(j=0; j<lts->nof_players; j++)
	if (strcmp(game->player[i]->name, lts->ltplayers[j]->name)==0)
	  {known=1;break;}

      if (!known)
	{
	  lts->ltplayers[lts->nof_players]=new_ltPlayer();
	  lts->ltplayers[lts->nof_players]->name=strdup(game->player[i]->name);
	  lts->nof_players++;
	}
      lts->nof_frags+=game->player[i]->nof_frags;

      ltp=lts->ltplayers[j];

      ltp->skill=game->player[i]->skill;
      ltp->nof_kills+=game->player[i]->nof_kills;
      ltp->nof_suicides+=game->player[i]->nof_suicides;
      ltp->nof_tkills+=game->player[i]->nof_tkills;
      ltp->nof_frags+=game->player[i]->nof_frags;
      ltp->nof_deaths+=game->player[i]->nof_deaths;
      ltp->nof_items+=game->player[i]->nof_items;
      ltp->nof_says+=game->player[i]->nof_says;
      ltp->secs+=game->player[i]->secs;
      for (j=0; j<NOF_WEAPS; j++)
	{
	  ltp->weaps[j]+=game->player[i]->weaps[j];
	  ltp->wtkill[j]+=game->player[i]->wtkill[j];
	  ltp->wsui[j]+=game->player[i]->wsui[j];

	  lts->weaps[j]+=game->player[i]->weaps[j];
	  lts->wtkill[j]+=game->player[i]->wtkill[j];
	  lts->wsui[j]+=game->player[i]->wsui[j];
	}
      for (j=0; j<NOF_ITEMS; j++)
	{
	  ltp->items[j]+=game->player[i]->lst_items[j];
	  lts->items[j]+=game->player[i]->lst_items[j];
	}
    }

  return 1;
}


/* Save the stats to the file */
int save_stats(char *fname, t_lts *lts)
{
  FILE *fp=fopen(fname, "wb");
  if (fp==NULL) return -1;

  fprintf(fp,"q3lgd");
  fwrite(lts, sizeof(t_lts), 1, fp);
  fclose(fp);
  return 1;
}
