/*
  Simple functions, used for putting the desired info to a HTML-file.

  $Id: html_writers.h,v 1.4 2000/01/09 02:32:17 jacobs Exp jacobs $

  $Log: html_writers.h,v $
  Revision 1.4  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.3  2000/01/07 13:43:42  jacobs
  *** empty log message ***

  Revision 1.2  2000/01/05 03:43:25  jacobs
  *** empty log message ***

  Revision 1.1  2000/01/03 16:04:02  jacobs
  Initial revision


*/
#ifndef __HTML_WRITERS__
#define __HTML_WRITERS__

#include <stdio.h>
#include "game.h"
#include "lt_stats.h"


/*
 *
 *
 Single-game statistics
 *
 *
 */
void write_sg_table(FILE *fp, t_game **games, int nof_games,\
		    char **todo, char **todo_t, char **todo_p, int *sp,\
		    int cols, int gametype);
void write_sg_stats(FILE *fp, t_game *game);
void write_sg_stats_all(FILE *fp, t_game *game, char *hc);

/* Team-based scores for a Single Game*/
void write_sg_teamwinner(FILE *fp, t_game *game);
void write_sg_teamtimeline(FILE *fp, t_game *game, int gid, char *rc, char *bc, char *bgc);
void write_sg_teamstats(FILE *fp, t_game *game, char *rc, char *bc, char *hc);
void write_sg_ctftimeline(FILE *fp, t_game *game, int gid, char *rc, char *bc, char *bgc);
void write_sg_ctfstats(FILE *fp, t_game *game, char *rc, char *bc, char *hc);


/* Kill-stats */
void write_sg_playertimeline(FILE *fp, t_game *game, int gid, char *rc, char *bc, char *bgc);
void write_sg_ranks(FILE *fp, t_game *game, int gid,\
		    char **todo, char **todo_t, char **todo_p, int *sp,\
		    char *bc, char *rc, char *nc, char *hc);

void write_sg_killtab(FILE *fp, t_game *game,
		      char *bc, char *rc, char *nc, char *sc);


/*
 *
 *
 Single Game - single player
 *
 *
 */
void write_sp_playername(FILE *fp, t_game *game, int pid);
void write_sp_killtable(FILE *fp, t_game *game, int pid, char *rc,\
			char *bc, char *nc, char *hc);



/*
 *
 *
 All time stats
 *
 *
 */
void write_ag_stats(FILE *fp, t_game **games, int nof_games, char *hc);
void write_ag_weapons(FILE *fp, t_game **games, int nof_games,int cols, int a);
void write_ag_teamkillweapons(FILE *fp, t_game **games,
			     int nof_games, int cols, int a);
void write_ag_suicideweapons(FILE *fp, t_game **games,
			     int nof_games, int cols, int a);
void write_ag_pickups(FILE *fp, t_game **game, int nof_games, int cols, int a);

void write_agp_allstats(FILE *fp, t_lts *lts, char *hc,\
		    char **todo, char **todo_t, char **todo_p, int *sp);


void write_any_weapons(FILE *fp, int *weaps, int cols, int a);
void write_any_items(FILE *fp, int *items, int cols, int a);

/*
 *
 *
 commonly used statistics
 *
 *
 */
void write_HPJ(FILE *fp);

/* date and time */
void write_date(FILE *fp);
void write_time(FILE *fp);

/* Writes the frag-counter */
void write_counter(FILE *fp, int counter);
void write_counter_gfx(FILE *fp, int counter, char *pre, char *post);

#endif
