/*
  The functions within this file can be used for writing the
  statistics to a HTML-file.
  There is no formating used in within the functions !!

  $Id: html_writers.c,v 1.5 2000/01/09 23:09:44 jacobs Exp jacobs $

  $Log: html_writers.c,v $
  Revision 1.5  2000/01/09 23:09:44  jacobs
  new option "-r"

  Revision 1.4  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.3  2000/01/07 13:43:42  jacobs
  *** empty log message ***

  Revision 1.2  2000/01/05 03:43:25  jacobs
  *** empty log message ***

  Revision 1.1  2000/01/03 16:04:02  jacobs
  Initial revision


*/

#ifndef MAXDIRLENGTH
#define MAXDIRLENGTH 2048
#endif

#ifdef GNU_C
 #include <sys/stat.h>
 #include <sys/types.h>
 #include <fcntl.h>
 #include <unistd.h>
#else
 #include <direct.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "html_writers.h"
#include "tool.h"
#include "lt_stats.h"







/*
 *
 *
 write simple infos
 *
 *
 */
/* a nice message, so all know who did this peace of .... and who to blame*/
void write_HPJ(FILE *fp)
{
  fprintf(fp, "\n\n\n<br><br><br>\n");
  fprintf(fp, "<small><small><center>Q3_LogGen (%s), <a href=\"mailto:hanspete@cs.tu-berlin.de\">Hans-Peter Jacobs</a>, <a href=\"http://www.cs.tu-berlin.de/~hanspete/\">WWW</a></center></small></small><br>\n", Q3L_MAIN_VERSION);
}

void write_date(FILE *fp)
{
  struct tm *s_tm;
  time_t     s_time;

  s_time=time(NULL);
  s_tm=localtime(&s_time);
  fprintf(fp, "%02i.%02i.%s%02i", s_tm->tm_mday,
	  s_tm->tm_mon+1, (s_tm->tm_year>99)?"20":"19", s_tm->tm_year%100);
  //if (s_tm!=NULL) free(s_tm);
}

void write_time(FILE *fp)
{
  struct tm *s_tm;
  time_t     s_time;
  s_time=time(&s_time);
  s_tm=localtime(&s_time);
  fprintf(fp, "%02i:%02i:%02i", s_tm->tm_hour, s_tm->tm_min, s_tm->tm_sec);
  //if (s_tm!=NULL) free(s_tm);
}

void write_counter_gfx(FILE *fp, int frags, char *pre, char *post)
{
  int i, j, k, t;

  /* now we sum the frags, then we display them with a image-counter */
  i=frags;
  for (j=8; j>=0; j--)
    {
      t=pow(10,j);
      k=i/t;
      if ( ((k<10) && (t<=frags)) || (frags==0 && j==0)) 
	{
	  fprintf(fp, "<img src=\"pix/%s%i.%s\">",(pre==NULL)?(""):(pre),k,\
		  (post==NULL)?("jpg"):(post));
	  i-=k*t;
	}
    }
}

void write_counter(FILE *fp, int frags)
{
  fprintf(fp, "%i", frags);
}














/*
 *
 *
 *
 *
 *
 *
 FUNCTIONS for a single game
 *
 *
 */
void write_sg_table(FILE *fp, t_game **games, int nof_games,
		    char   **todo, char **todo_t, char **todo_p, int *sp,
		    int cols, int gt)
{
  char *fname;
  int   i, c, w;

  fname=(char *)malloc(MAXDIRLENGTH);
  c=cols;
  if (cols<0) cols=3;
  if (cols>0) w=100/cols;
  for (i=0; i<nof_games; i++)
    {
      fprintf(stderr, "%02i ", i);
      sprintf(fname, "game_%03i.html", i);
      if (cols>0) fprintf(fp,"<td width=%i%%>", w);
      fprintf(fp, "<a href=\"%s\">Game %i</a> on %s",
	      fname, i, games[i]->mapname);

      if (gt) fprintf(fp, " (%s)", c_gamemodes_s[(int)games[i]->type]);
      if (cols>0) fprintf(fp,"</td>");
      else fprintf(fp,"<br>");
      fprintf(fp, "\n");

      //fprintf(stderr,"  added %s\n", fname);
      todo  [*sp]=strdup("sg_game.html");
      todo_t[*sp]=strdup(fname);
      sprintf(fname, "GAMEID=%04i", i);
      todo_p[*sp]=strdup(fname);
      sp[0]++;
      
      //write_sg_html(fname, games[i], i);
      c--;
      if (c<1) {
	c=cols;
	if (cols>0) fprintf(fp, "</tr>\n<tr>\n");
      }
    }
  if (cols>0) fprintf(fp, "</tr>\n");
  free(fname);
}



/* writes the initial table with a overview of the game*/
void write_sg_stats(FILE *fp, t_game *game)
{
  fprintf(fp, "<tr><td>Host-Name</td><td>%s</td></tr>\n", game->servername);
  fprintf(fp, "<tr><td>Map-Name</td><td>%s</td></tr>\n", game->mapname);
  fprintf(fp, "<tr><td>Game-Type</td><td>%s</td></tr>\n",
	  c_gamemodes[(int)game->type]);
  fprintf(fp, "<tr><td>Duration</td><td>%i min %i sec</td></tr>\n",
	  game->secs/60, game->secs%60);
  fprintf(fp, "<tr><td>Time-Limit</td><td>%i</td></tr>\n", game->timelimit);
  fprintf(fp, "<tr><td>Frag-Limit</td><td>%i</td></tr>\n", game->fraglimit);
  if (game->type==4)
    fprintf(fp, "<tr><td>Capture-Limit</td><td>%i</td></tr>\n",
	    game->capturelimit);
}



/* writes the stats for all players in the game*/
void write_sg_stats_all(FILE *fp, t_game *game, char *hc)
{
  double fph;
  fph=(3600.0/game->secs) * (double)game->nof_frags;
  if (hc!=NULL) fprintf(fp, "<tr bgcolor=%s>", hc);
  else fprintf(fp, "<tr>");

  fprintf(fp, "<th>Players</th><th>Kills</th>");
  if (game->type>2) fprintf(fp, "<th>TKills</th>");
  fprintf(fp, "<th>Suicides</th><th>Frags</th><th>FPH</th>");
  fprintf(fp, "<th>Pickups</th><th>Talks</th>\n</tr><tr>\n");

  fprintf(fp, "<td align=center>%i</td>", game->nof_players);
  fprintf(fp, "<td align=center>%i</td>", game->nof_kills);
  if (game->type>2) fprintf(fp,"<td align=center>%i</td>", game->nof_tkills);
  fprintf(fp, "<td align=center>%i</td>", game->nof_suicides);
  fprintf(fp, "<td align=center>%i</td>", game->nof_frags);
  fprintf(fp, "<td align=center>%2.2f</td>", fph);
  fprintf(fp, "<td align=center>%i</td>", game->nof_items);
  fprintf(fp, "<td align=center>%i</td>\n", game->nof_says);
  fprintf(fp, "</tr>\n");
}


void write_sg_teamwinner(FILE *fp, t_game *game)
{
  if (game->team_score[1]>game->team_score[2])
    {
      fprintf(fp, "Red Team wins %i to %i",
	      game->team_score[1], game->team_score[2]);
    } else {
      fprintf(fp, "Blue Team wins %i to %i",
	      game->team_score[2], game->team_score[1]);
    }
}

/* If teamplay is on, the stats for the teams will be displayed*/
void write_sg_teamstats(FILE *fp, t_game *game, char *rc, char *bc, char *hc)
{
  int   i, start, add, ende;
  char *bgc;

  /* Header an win-info*/
  if (game->team_score[1]>game->team_score[2])
    {start=1;add=1; ende=3;}
  else
    {start=2;add=-1; ende=0;}


  if (hc!=NULL) fprintf(fp, "<tr bgcolor=%s>", hc);
  else fprintf(fp, "<tr>");
  fprintf(fp, "<th width=100>Team</th><th>Kills</th><th>Team-Kills</th><th>Suicides</th>");
  if (game->type==4) fprintf(fp, "<th width=60>Frags</th>");
  fprintf(fp, "<th width=60>Score</th></tr>\n");

  for (i=start; i!=ende; i+=add)
    {
      if (i==2) bgc=bc;
      else bgc=rc;

      if (bgc!=NULL) fprintf(fp, "<tr bgcolor=\"%s\">", bgc);
      else fprintf(fp, "<tr>");
      fprintf(fp, "<td valign=top>%s</td><td align=center valign=top>%i</td><td align=center valign=top>%i</td><td align=center valign=top>%i</td>", team_name[i], game->team_kills[i], game->team_tkills[i],
	      game->team_suic[i]);
      if (game->type==4)
	fprintf(fp, "<td align=center valign=top>%i</th>",game->team_frags[i]);
      fprintf(fp, "<td align=center valign=top>%i</td></tr>\n",
	      game->team_score[i]);
    }
  fprintf(fp,"</tr>\n");
}

/* CTF-results (if CTF played at all)*/
void write_sg_ctfstats(FILE *fp, t_game *game, char *rc, char *bc, char *hc)
{
  int   i, add, start, ende;
  char *bgc;

  /* Table - header */
  if (hc!=NULL) fprintf(fp, "<tr bgcolor=\"%s\">\n", hc);
  else fprintf(fp, "<tr>\n");
  fprintf(fp, "<th width=14%%>Team</th><th width=14%%>Captures</th>");
  fprintf(fp, "<th width=14%%>Steals</th>");
  fprintf(fp, "<th width=14%%>Loss</th><th width=14%%>Pickups</th>");
  fprintf(fp, "<th width=14%%>FlagKills</th><th width=14%%>Returns</th>");
  fprintf(fp, "</tr>\n");

  /* Sort for results */
  if (game->team_score[1] > game->team_score[2])
    {add=1;start=1;ende=3;} else {add=-1; start=2;ende=0;}

  for (i=start; i!=ende; i+=add)
    {
      if (i==1) bgc=rc;
      else bgc=bc;

      if (bgc) fprintf(fp, "<tr bgcolor=\"%s\">", bgc);
      else fprintf(fp, "<tr>");
      fprintf(fp, "<td>%s</td><td align=center>%i</td>",
	      team_name[i], game->ctf_captures[i]);
      fprintf(fp, "<td align=center>%i</td><td align=center>%i</td>",
	      game->ctf_steals[i], game->ctf_loss[i]);
      fprintf(fp, "<td align=center>%i</td>",
	      game->ctf_pickups[i]);
      fprintf(fp, "<td align=center>%i</td><td align=center>%i</td></tr>\n",
	      game->ctf_fkills[i], game->ctf_returns[i]);
    }
}


/*
 *
 *
 TIMELINES for 3 different counters
 *
 *
 */
/* creates an image with the timeline and writes this to a gif*/
void write_sg_ctftimeline(FILE *fp, t_game *game, int gid, char *rc, char *bc, char *bgc)
{
  int   width=2, height=2, i, j;
  char  fname[1024];
  unsigned char *pal, *data;
  FILE *fp_l;

  return ;
  /* example for writing out the stats (can be used with gnuplot) */
  for (i=1; i<3; i++)
    {
      sprintf(fname, "%02i_%02i_ct.txt", gid,i);
      fp_l=fopen(fname, "wt");
      for(j=0; j<game->ctf_captures[i]; j++)
	{
	  fprintf(fp_l, "%i %i\n", game->tl_ctfsec[i][j],game->tl_ctf[i][j]);
	}
      fclose(fp_l);
    }

  return;
  data=(unsigned char *)malloc(width*height);
  pal=(unsigned char *)malloc(768);
  if (data==NULL || pal==NULL) return;
  memset(data,0,width*height);
  memset(pal,0,768);
  pal[ 0]=255;
  pal[ 1]=255;
  pal[ 2]=0;
  pal[ 3]=255;
  pal[ 4]=0;
  pal[ 5]=0;
  pal[ 6]=0;
  pal[ 7]=255;
  pal[ 8]=0;
  pal[ 9]=0;
  pal[10]=0;
  pal[11]=255;
  sprintf(fname, "%02i_ctftimeline.jpg", gid);
  fprintf(fp, "<img src=\"%s\" width=%i height=%i>\n",
	  fname,width,height);
  fprintf(stderr, "wrote %s\n", fname);
  free(data);
}

/* creates an image with the timeline and writes this to a gif*/
void write_sg_teamtimeline(FILE *fp, t_game *game, int gid, char *rc, char *bc, char *bgc)
{
  int   width=2, height=2,i,j;
  char *data, fname[1024];
  unsigned char *pal;
  FILE *fp_l;

  return ;
  /* example for writing out the stats (can be used with gnuplot) */
  for (i=1; i<3; i++)
    {
      sprintf(fname, "%02i_%02i_tt.txt", gid,i);
      fp_l=fopen(fname, "wt");
      for(j=0; j<game->teamkillcounter[i]; j++)
	{
	  fprintf(fp_l, "%i %i\n", game->tl_teamsec[i][j],game->tl_team[i][j]);
	}
      fclose(fp_l);
    }

  return;
  data=(char *)malloc(width*height);
  pal=(unsigned char *)malloc(768);
  if (data==NULL || pal==NULL) return;
  memset(data,0,width*height);
  memset(pal,0,768);
  pal[ 0]=255;
  pal[ 1]=255;
  pal[ 2]=0;
  pal[ 3]=255;
  pal[ 4]=0;
  pal[ 5]=0;
  pal[ 6]=0;
  pal[ 7]=255;
  pal[ 8]=0;
  pal[ 9]=0;
  pal[10]=0;
  pal[11]=255;
  sprintf(fname, "%02i_teamtimeline.jpg", gid);
  fprintf(fp, "<img src=\"%s\" width=%i height=%i>\n",
	  fname,width,height);
  //write_img(fname, data, width, height, pal);
  fprintf(stderr, "wrote %s\n", fname);
  free(data);
}

/* creates an image with the timeline and writes this to a gif*/
void write_sg_playertimeline(FILE *fp, t_game *game, int gid, char *rc, char *bc, char *bgc)
{
  int   width=2, height=2, i, j;
  char *data, fname[1024];
  unsigned char *pal;
  FILE *fp_l;

  return ;
  /* example for writing out the stats (can be used with gnuplot) */
  for (i=0; i<game->nof_players; i++)
    {
      sprintf(fname, "%02i_%02i_pt.txt", gid, i);
      fp_l=fopen(fname, "wt");
      for(j=0; j<game->player[i]->killcounter; j++)
	{
	  fprintf(fp_l, "%i %i\n", game->player[i]->tl_fragsec[j],\
		  game->player[i]->tl_frags[j]);
	}
      fclose(fp_l);
    }
  return;
  data=(char *)malloc(width*height);
  pal=(unsigned char *)malloc(768);
  if (data==NULL || pal==NULL) return;
  memset(data,0,width*height);
  memset(pal,0,768);
  pal[ 0]=255;
  pal[ 1]=255;
  pal[ 2]=0;
  pal[ 3]=255;
  pal[ 4]=0;
  pal[ 5]=0;
  pal[ 6]=0;
  pal[ 7]=255;
  pal[ 8]=0;
  pal[ 9]=0;
  pal[10]=0;
  pal[11]=255;
  sprintf(fname, "%02i_playertimeline.jpg", gid);
  fprintf(fp, "<img src=\"%s\" width=%i height=%i>\n",
	  fname,width,height);
  //write_img(fname, data, width, height, pal);
  fprintf(stderr, "wrote %s\n", fname);
  free(data);
}






/* Writes the ranks, depending on the number of frags*/
void write_sg_ranks(FILE *fp, t_game *game, int gid,
		    char **todo, char **todo_t, char **todo_p, int *sp,
		    char *rc, char *bc, char *nc, char *hc)
{
  int     i, j, k, *sort, color;
  char   *fname;
  double  fph, ttl;
  char   *bgc=NULL;

  fname=(char *)malloc(MAXDIRLENGTH);
  sort=(int *)malloc(sizeof(int) * game->nof_players);

  /* prepare sorting the players */
  for (i=0; i<game->nof_players; i++)
    sort[i]=i;
  j=1;
  while(j)
    {
      j=0;
      for (i=0; i<game->nof_players-1; i++)
	if (game->player[sort[i]]->nof_frags < game->player[sort[i+1]]->nof_frags) {
	  j++;
	  k=sort[i];
	  sort[i]=sort[i+1];
	  sort[i+1]=k;
	}
    }

  if (hc!=NULL) fprintf(fp, "<tr bgcolor=\"%s\">", hc);
  else fprintf(fp, "<tr>");
  fprintf(fp, "<th>Name</th><th>Handicap</th><th>Ping</th><th>Time</th><th>Kills</th>");

  /* check for team-game */
  if (game->type>2) fprintf(fp, "<th>T-Kills</th>");
  fprintf(fp, "<th>Deaths</th><th>Suicide</th><th>Pickups</th><th>FPH</th><th>TTL</th><th>Frags</th>");

  /* check for CTF -> because Frag differs from Score */
  if (game->type==4)
    fprintf(fp, "<th>Score</th>\n");
  fprintf(fp, "</tr>\n");

  for (j=0; j<game->nof_players; j++)
    {
      i=sort[j];
      fph=(3600.0/game->player[i]->secs) * (double)game->player[i]->nof_frags;
      if (game->player[i]->nof_deaths)
	ttl=(double)game->player[i]->secs/(double)game->player[i]->nof_deaths;
      else ttl=game->player[i]->secs;
      sprintf(fname, "%02i_%02i.html", gid, j);

      /* Now we set the bgcolor according to the team of the player*/
      if (game->type>2)
	{
	  color=2*game->player[i]->b_blue;
	  color+=game->player[i]->b_red;

	  if (color==1) bgc=rc;
	  if (color==2) bgc=bc;
	  if (color>2) bgc=nc;

	  if (bgc) fprintf(fp, "<tr bgcolor=\"%s\">", bgc);
	  else fprintf(fp, "<tr>");
	}else{
	  if (nc) fprintf(fp, "<tr bgcolor=\"%s\">\n", nc);
	  else fprintf(fp, "<tr>");
	}

      fprintf(fp, "<td align=center><a href=\"%s\">%s</a></td>\n",
	      fname, make_funname(game->player[i]->name));
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->handicap);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->ping);
      fprintf(fp, "<td align=center>%i:%02i</td>\n",
	      game->player[i]->secs/60, game->player[i]->secs%60);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_kills);
      if (game->type>2)
	fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_tkills);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_deaths);
      fprintf(fp, "<td align=center>%i</td>", game->player[i]->nof_suicides);
      fprintf(fp, "<td align=center>%i</td><td align=center>%2.2f</td>\n",
	      game->player[i]->nof_items, fph);
      fprintf(fp, "<td align=center>%2.2f</td>\n", ttl);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_frags);
      if (game->type==4)
	fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->score);
      fprintf(fp, "</tr>\n");

      //fprintf(stderr, "adding (%i)  player %s  with ", *sp, fname);
      todo  [*sp]=strdup("sp_player.html");
      todo_t[*sp]=strdup(fname);
      memset(fname, 0,1024);
      sprintf(fname, "<GAMEID=%04i PLAYERID=%03i>", gid, i);
      todo_p[*sp]=strdup(fname);
      *sp=sp[0]+1;
    }
  free(sort);
  free(fname);
}



/* Kill-table for direct compares with the opponents
   If playing team-games the team-color will be used as the background.*/
void write_sg_killtab(FILE *fp, t_game *game, char *rc, char *bc,\
		      char *nc, char *sc)
{
  int   i, j, k, color, w, *sort;
  char *bgc;

  sort=(int *)malloc(sizeof(int) * game->nof_players);
  for (i=0; i<game->nof_players; i++)
    sort[i]=i;
  j=1;
  while(j)
    {
      j=0;
      for (i=0; i<game->nof_players-1; i++)
	if (game->player[sort[i]]->nof_frags < game->player[sort[i+1]]->nof_frags) {
	  j++;
	  k=sort[i];
	  sort[i]=sort[i+1];
	  sort[i+1]=k;
	}
    }

  fprintf(fp, "<td> </td>\n");
  w=100/(game->nof_players+1);
  for (i=0; i<game->nof_players; i++)
    {
      color=2*game->player[i]->b_blue;
      color+=game->player[i]->b_red;
      if (color==1)
	bgc=rc;
      else if (color==2)
	bgc=bc;
      else bgc=nc;
      fprintf(fp, "<td valign=bottom align=center width=%i%%", w);
      if (bgc)
	fprintf(fp, " bgcolor=\"%s\">\n", bgc);
      else fprintf(fp, ">\n");

      fprintf(fp, "<small><small>%s</small></small>",\
	      make_funname(game->player[sort[i]]->name));
      fprintf(fp, "</td>");
    }
  for (i=0; i<game->nof_players; i++)
    {
      color=2*game->player[sort[i]]->b_blue;
      color+=game->player[sort[i]]->b_red;
      if (color==1)
	bgc=rc;
      else if (color==2)
	bgc=bc;
      else bgc=nc;
      fprintf(fp, "</tr><tr><td align=right height=30");
      if (bgc)
	fprintf(fp, " bgcolor=\"%s\">\n", bgc);
      else fprintf(fp, ">\n");

      fprintf(fp, "<small>%s</small></td>",\
	      make_funname(game->player[sort[i]]->name));
      for (j=0; j<game->nof_players; j++)
	{
	  if (i==j)
	    fprintf(fp, "<td align=center bgcolor=\"%s\">%i</td>",
		    sc, game->player[sort[i]]->lst_kills[sort[j]]);
	  else
	    fprintf(fp, "<td align=center>%i</td>",
		    game->player[sort[i]]->lst_kills[sort[j]]);
	}
    }
  free(sort);
  fprintf(fp, "</tr>\n");
}

/* writes the pickup-table into the file*/
void write_sg_pickups(FILE *fp, t_game *game, int cols)
{
  int i,j,c,w, sort[NOF_ITEMS], items[NOF_ITEMS];

  for (i=0; i<NOF_ITEMS; i++)
    {
      items[i]=0;
      for(j=0; j<game->nof_players; j++)
	items[i]+=game->player[j]->lst_items[i];
    }
  
  sort_items(items, sort);
  if (items[sort[0]]<1)
    {
      fprintf(fp, "No pickups during battle");
      return ;
    }
  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  for (i=0; i<NOF_ITEMS; i++)
    {
      if (items[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5, c_items_nice[sort[i]], 5, items[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}


















/*
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 FUNCTIONS for SINGLE-GAME_PLAYER
 *
 *
 */
void write_sp_playername(FILE *fp, t_game *game, int pid)
{
  fprintf(fp, "%s", make_funname(game->player[pid]->name));
}

void write_sp_killtable(FILE *fp, t_game *game, int pid, char *rc,\
			char *bc, char *nc, char *hc)
{
  int       i,j,k,sum, color, *sort;
  char     *bgc=NULL;
  t_player *pl;

  sort=(int *)malloc(sizeof(int) * game->nof_players);
  for (i=0; i<game->nof_players; i++)
    sort[i]=i;
  j=1;
  while(j)
    {
      j=0;
      for (i=0; i<game->nof_players-1; i++)
	if (game->player[sort[i]]->nof_frags < game->player[sort[i+1]]->nof_frags) {
	  j++;
	  k=sort[i];
	  sort[i]=sort[i+1];
	  sort[i+1]=k;
	}
    }


  if (hc) fprintf(fp, "<tr bgcolor=\"%s\">", hc);
  else fprintf(fp, "<tr>\n");

  fprintf(fp, "<td> </td>");
  for (i=1; i<14; i++)
    if (i!=5 && i!=7 && i!=9 && i!=13) fprintf(fp, "<td>%s</td>", c_weaps[i]);

  fprintf(fp, "</tr><tr>\n");
  pl=game->player[pid];
  for (i=0; i<game->nof_players; i++)
    {
      color=2*game->player[i]->b_blue;
      color+=game->player[i]->b_red;
      if (color==1)
	bgc=rc;
      else if (color==2)
	bgc=bc;
      else bgc=nc;
      if (bgc) fprintf(fp, "<tr bgcolor=\"%s\">\n", bgc);
      fprintf(fp,"<tr>\n");
      if (hc) fprintf(fp, "<td bgcolor=\"%s\" align=right>", hc);
      else fprintf(fp, "<td align=right>");
      fprintf(fp, "%s</td>", make_funname(game->player[sort[i]]->name));
      for(j=1; j<14; j++)
	{
	  sum=0;
	  for(k=0; k<pl->killcounter; k++)
	    {
	      if (pl->tl_whom[k]==sort[i])
		{
		  if (pl->tl_weaps[k]==j)
		    sum++;
		  else if ((j==4 || j==6 || j==8 || j==12) 
			    && (pl->tl_weaps[k]==j+1) )
		    sum++;
		}
	    }
	  if (j==4 || j==6 || j==8 || j==12) j++;
	  fprintf(fp, "<td>%i</td>", sum);
	}
      fprintf(fp,"</tr>");
    }
  free(sort);
}









/*
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 FUNCTIONS for ALL-GAMES - stuff
 *
 *
 */
void write_ag_weapons(FILE *fp, t_game **games, int nof_games, int cols, int a)
{
  int i, j, c, w;
  int     sort[NOF_WEAPS], weaps[NOF_WEAPS];

  for (i=0; i<NOF_WEAPS; i++)
    {
      weaps[i]=0;
      for(j=0; j<nof_games; j++)
	weaps[i]+=games[j]->weaps[i];
    }

  sort_weaps(weaps, sort);
  //sort_things(weaps, sort, (char **)c_weaps, NOF_WEAPS);

  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  /* display the sorted list */
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (a==0 && weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5, c_weaps[sort[i]], 5, weaps[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}


/* TEAM-KILL weapons */
void write_ag_teamkillweapons(FILE *fp, t_game **games,
			      int nof_games, int cols, int a)
{
  int i, j, c, w;
  int     sort[NOF_WEAPS], weaps[NOF_WEAPS];

  for (i=0; i<NOF_WEAPS; i++)
    {
      weaps[i]=0;
      for(j=0; j<nof_games; j++)
	weaps[i]+=games[j]->wtkill[i];
    }

  sort_weaps(weaps, sort);
  //sort_things(weaps, sort, (char **)c_weaps, NOF_WEAPS);

  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  /* display the sorted list */
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (a==0 && weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5, c_weaps[sort[i]], 5, weaps[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}


/* SUICIDE weapons */
void write_ag_suicideweapons(FILE *fp, t_game **games,
			     int nof_games, int cols, int a)
{
  int i, j, c, w;
  int     sort[NOF_WEAPS], weaps[NOF_WEAPS];

  for (i=0; i<NOF_WEAPS; i++)
    {
      weaps[i]=0;
      for(j=0; j<nof_games; j++)
	weaps[i]+=games[j]->wsui[i];
    }

  sort_weaps(weaps, sort);
  //sort_things(weaps, sort, (char **)c_weaps, NOF_WEAPS);

  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  /* display the sorted list */
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (a==0 && weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5, c_weaps[sort[i]], 5, weaps[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}


void write_ag_pickups(FILE *fp, t_game **game, int nof_games, int cols, int a)
{
  int i,j,k, c, w;
  int sort[NOF_ITEMS], items[NOF_ITEMS];

  for (i=0; i<NOF_ITEMS; i++)
    {
      items[i]=0;
      for(j=0; j<nof_games; j++)
	for(k=0; k<game[j]->nof_players; k++)
	  items[i]+=game[j]->player[k]->lst_items[i];
    }

  sort_items(items, sort);

  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;

  /* display the stuff */
  for (i=0; i<NOF_ITEMS; i++)
    {
      if (a==0 && items[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5, c_items_nice[sort[i]], 5, items[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr>\n<tr>");
      }
    }
  fprintf(fp, "</tr>\n");
}


/* results for ALL GAMES in queue */
void write_ag_stats(FILE *fp, t_game **games, int nof_games, char *hc)
{
  int    i, kills=0, tkills=0, frags=0, deaths=0, suicides=0;
  int    items=0, sec=0, says=0;
  double fph;

  for(i=0; i<nof_games; i++) {
    frags+=games[i]->nof_frags;
    kills+=games[i]->nof_kills;
    tkills+=games[i]->nof_tkills;
    deaths+=games[i]->nof_deaths;
    suicides+=games[i]->nof_suicides;
    items+=games[i]->nof_items;
    sec+=games[i]->secs;
    says+=games[i]->nof_says;
  }
  fph=3600.0/sec * frags;
  if (hc) fprintf(fp, "<tr bgcolor=%s>\n", hc);
  else fprintf(fp, "<tr>");
  fprintf(fp, "<th>Time played</th><th>Kills</th><th>Team-Kills</th><th>Suicides</th><th>Frags</th><th>FPH</th><th>Deaths</th><th>Pickups</th><th>Says</th></tr>\n<tr>");
  fprintf(fp, "<td align=center>%02i:%02i:%02i</td>\n<td align=center>%i</td>",
	  sec/3600, (sec%3600)/60, sec%60, kills);
  fprintf(fp, "<td align=center>%i</td>", tkills);
  fprintf(fp, "<td align=center>%i</td>\n<td align=center>%i</td>\n<td align=center>%2.2f</td>", suicides, frags, fph);
  fprintf(fp, "<td align=center>%i</td>\n", deaths);
  fprintf(fp, "<td align=center>%i</td>\n", items);
  fprintf(fp, "<td align=center>%i</td>\n", says);
  fprintf(fp, "</tr>\n");
}





/*
 *
 *
 FUNCTIONS FOR WRITING THE ALL-TIME PLAYER-STATS
 *
 *
 */
/* writes all-time (single) player info */
void write_any_weapons(FILE *fp, int *weaps, int cols, int a)
{
  int   i, c, w, sort[NOF_WEAPS];

  sort_weaps(weaps, sort);
  if (weaps[sort[0]]<1)
    {
      fprintf(fp, "no weapon used");
      return;
    }
  /* normal weapon-use*/
  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (a==0 && weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-8,c_weaps[sort[i]], 8, weaps[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}


/* writes the pickup-table into the file*/
void write_any_items(FILE *fp, int *items, int cols, int a)
{
  int i,c,w, sort[NOF_ITEMS];

  sort_items(items, sort);
  if (items[sort[0]]<1)
    {
      fprintf(fp, "No pickups during battle");
      return ;
    }

  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  for (i=0; i<NOF_ITEMS; i++)
    {
      if (a==0 && items[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-8, c_items_nice[sort[i]], 8, items[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}



/* Write all-player info to file */
void write_agp_allstats(FILE *fp, t_lts *lts, char *hc, char **todo,
		     char **todo_t, char **todo_p, int *sp)
{
  int     i, j, sort[MAX_LT_PLAYER], b_todo;
  char    fname[1024];
  double  fph, ttl;
  t_ltp  *ltp;

  for (i=0; i<lts->nof_players; i++)
    sort[i]=i;

  b_todo=1;
  while(b_todo)
    {
      b_todo=0;
      for (i=0; i<lts->nof_players-1; i++)
	{
	  if (lts->ltplayers[sort[i]]->nof_frags <
	      lts->ltplayers[sort[i+1]]->nof_frags)
	    {
	      j=sort[i];
	      sort[i]=sort[i+1];
	      sort[i+1]=j;
	      b_todo=1;
	    }
	}
    }

  if (hc) fprintf(fp, "<tr bgcolor=\"%s\">", hc);
  else fprintf(fp, "<tr>");
  fprintf(fp, "<th>Name</th>");
  fprintf(fp, "<th>Time</th>");
  fprintf(fp, "<th>Kills</th>");
  fprintf(fp, "<th>Suicides</th><th>Teamkills</th>");
  fprintf(fp," <th>Deaths</th><th>Frags</th>");
  fprintf(fp, "<th>FPH</th><th>TTL</th>\n");
  fprintf(fp, "<th>Items</th><th>Talks</th><th>SOS</th><tr>\n");
  for (i=0; i<lts->nof_players; i++)
    {
      ltp=lts->ltplayers[sort[i]];
      fph=(3600.0/ltp->secs) * (double)ltp->nof_frags;
      if (ltp->nof_deaths)
	ttl=(double)ltp->secs/ltp->nof_deaths;
      else ttl=ltp->secs;

      sprintf(fname, "PLAYERID=%03i", sort[i]);
      todo  [*sp]=strdup("ap_player.html");
      todo_p[*sp]=strdup(fname);
      sprintf(fname, "all_%s.html", ltp->name);
      todo_t[*sp]=strdup(fname);
      sp[0]++;

      //fprintf(stderr, "writing %s\n", fname);

      fprintf(fp, "\n<tr>");
      fprintf(fp, "<td align=right><a href=\"%s\">%s</a></td>",
	      fname, make_funname(ltp->name));
      fprintf(fp, "<td align=center>%i:%02i:%02i</td>",
	      ltp->secs/3600, (ltp->secs%3600)/60, ltp->secs%60);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_kills);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_suicides);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_tkills);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_deaths);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_frags);
      fprintf(fp, "<td align=center>%2.2f</td>", fph);
      fprintf(fp, "<td align=center>%2.2f</td>", ttl);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_items);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_says);
      fprintf(fp, "<td align=center>%2.0f</td>",
	      (ltp->nof_says)?((double)ltp->secs/ltp->nof_says):(ltp->secs));
      fprintf(fp, "</tr>\n");
    }
}
