/*
  Lets see if it gets a little bit more readable.
  Starting with a given filename, the HTML_creator runs with a stack
  of "Todo"-files.

  $Id: html_creator_tpl.c,v 1.5 2000/01/09 23:09:44 jacobs Exp jacobs $

  $Log: html_creator_tpl.c,v $
  Revision 1.5  2000/01/09 23:09:44  jacobs
  new option "-r"

  Revision 1.4  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.3  2000/01/07 13:43:42  jacobs
  *** empty log message ***

  Revision 1.2  2000/01/05 03:43:25  jacobs
  *** empty log message ***

  Revision 1.1  2000/01/03 16:04:02  jacobs
  Initial revision


*/

#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef GNU_C
#include <unistd.h>
#else
#include <direct.h>
#endif

#include "lt_stats.h"
#include "html_creator_tpl.h"
#include "html_writers.h"
#include "tool.h"


#ifndef MAXIFCOND
#define MAXIFCOND 128
#endif


const char html_weaps[NOF_WEAPS][20]={
  "0", "SHOTGUN", "GAUNTLET", "MACHINEGUN",
  "GRENADE", "GRENADESPLASH",
  "ROCKET", "ROCKETSPLASH", "PLASMA",
  "PLASMASPLASH", "RAILGUN", "LIGHTNING",
  "BFG", "BFGSPLASH", "14", "15", "LAVA",
  "CRUSH", "TELEFRAG", "FALLING", "SUICIDE", "21", "TRIGGERHURT"};


const char html_items[NOF_ITEMS][30]={
  "BULLETS", "SHELLS", "ROCKETS",
  "CELLS", "SLUGS", "GRENADES",
  "LIGHT_AMMO", "BFG_AMMO", "RAILGUN",
  "ROCKETLAUNCHER", "GRENADELAUNCHER", //10
  "SHOTGUN", "PLASMAGUN", "LIGHTNING_GUN",
  "BFG2K", "HEALTH_SMALL", "HEALTH",
  "HEALTH_LARGE", "HEALTH_MEGA", "ARMOR_SHARD", //19
  "ARMOR_BODY", "ARMOR_COMBAT", "HASTE",
  "REGENERATION", "QUAD_DAMAGE", "INVISIBILITY", //25
  "HOLDABLE_MEDIKIT", "HOLDABLE_TELEPORTER"};


/*
 *
 *
 File - tools
 *
 *
 */
int read_to_next_tag(FILE *fp, char *mem, int maxlen)
{
  unsigned char c;
  int           pos;

  c=32;
  pos=0;
  while(c!='<' && pos<maxlen && !feof(fp))
    {
      fread(&c,1,1,fp);
      mem[pos]=c;
      pos++;
    }
  if (c=='<')
    {
      pos--;
      fseek(fp,-1,1);
    }
  mem[pos]=0;
  return pos;
}


int read_tag(FILE *fp, char *mem, int maxlen)
{
  unsigned char c;
  int pos;

  pos=0;
  c=32;
  while(c!='>' && !feof(fp) && pos<maxlen)
    {
      fread(&c,1,1,fp);
      mem[pos]=c;
      pos++;
    }
  mem[pos]=0;
  if (c!='>')
    {
      fprintf(stderr, "tag-error (not closed or to long)\n");
      fprintf(stderr, "%s\n", mem);
      exit(-1);
    }
  return pos;
}






/*
 *
 *
 Tag - tools (get params from tags)
 *
 *
 */
int get_param_int(char *mem, char *string)
{
  int   p;
  char *t;

  t=strstr(mem, string);
  if (t==NULL) return -1;
  while(*t!=0 && (*t<'0' || *t>'9'))
    t++;
  if (*t==0) return -1;

  p=0;
  while (*t>='0' && *t<='9')
    {
      p*=10;
      p+=*t-'0';
      t++;
    }
  //fprintf(stderr, "PARAMETER : %s -> %i\n", mem, p);
  return p;
}


char *get_param_string(char *mem, char *string)
{
  int   s, e;
  char *t;

  t=strstr(mem, string);
  if (t==NULL) return NULL;
  s=t-mem;
  s+=strlen(string)+1;
  e=s;
  while(mem[e]!='>' && mem[e]!=32 && mem[e]!=0)
    e++;
  if (mem[e]==0) return NULL;
  t=my_strndup(&mem[s], e-s);
  return t;
}








/*
 *
 *
 Main-stuff
 *
 *
 */

/*
 *
 *
 Simple vars - i.e. just writing a number, called from "write_q3tag"
 *
 *
 */
int check_var(FILE *fp, char *tag, int cg, int cp, t_game **games,\
	      int nof_games, t_lts *lts)
{
  int  *weaps=NULL, *items=NULL;
  int   i, sum=-100;
  char *s,*e, *t=NULL, *u=NULL;

  /* Weapons */
  if (strstr(tag, "_VW_")!=NULL)
    {
      if (strstr(tag, "_AG_")!=NULL)
	weaps=lts->weaps;
      if (strstr(tag, "_AP_")!=NULL && cp>=0)
	weaps=lts->ltplayers[cp]->weaps;
      if ((strstr(tag, "_SG_")!=NULL) && cg>=0)
	weaps=games[cg]->weaps;
      if ((strstr(tag, "_SP_")!=NULL) && cg>=0 && cp>=0)
	weaps=games[cg]->player[cp]->weaps;

      if (strstr(tag, "_AGT_")!=NULL)
	weaps=lts->wtkill;
      if (strstr(tag, "_APT_")!=NULL && cp>=0)
	weaps=lts->ltplayers[cp]->wtkill;
      if ((strstr(tag, "_SGT_")!=NULL) && cg>=0)
	weaps=games[cg]->wtkill;
      if ((strstr(tag, "_SPT_")!=NULL) && cg>=0 && cp>=0)
	weaps=games[cg]->player[cp]->wtkill;

      if (strstr(tag, "_AGS_")!=NULL)
	weaps=lts->wsui;
      if (strstr(tag, "_APS_")!=NULL && cp>=0)
	weaps=lts->ltplayers[cp]->wsui;
      if ((strstr(tag, "_SGS_")!=NULL) && cg>=0)
	weaps=games[cg]->wsui;
      if ((strstr(tag, "_SPS_")!=NULL) && cg>=0 && cp>=0)
	weaps=games[cg]->player[cp]->wsui;

      if (weaps==NULL) return 0;

      s=strstr(tag, "_VW_");
      s+=4;
      e=s;
      while(*e!='>' && *e!=32 && *e!=0)
	e++;

      if (e-s > 20) return 0;
      t=(char *)malloc(1+e-s);
      memset(t,0,1+e-s);
      strncpy(t, s, e-s);

      //fprintf(stderr, "------>%s\n", t);
      /* special case -> splash */
      if (strcmp(t, "SPLASH")==0)
	{
	  sum=weaps[5]+weaps[7]+weaps[9]+weaps[13];
	} else {
	  for (i=0; i<NOF_WEAPS; i++)
	    if (strcmp(t, html_weaps[i])==0)
	      break;
	  if (i==NOF_WEAPS) return 0;
	  sum=weaps[i];
	  if ((strstr(tag, "ALL")!=NULL) && (i==4 || i==6 || i==8 || i==12))
	    sum+=weaps[i+1];
	}

      if (t!=NULL) free(t);
      t=NULL;
    }

  /* ITEMS picked up */
  if (strstr(tag, "_VI_")!=NULL)
    {
      if (strstr(tag, "_AG_")!=NULL)
	items=lts->items;
      if (strstr(tag, "_AP_")!=NULL && cp>=0)
	items=lts->ltplayers[cp]->items;
      if ((strstr(tag, "_SG_")!=NULL) && cg>=0)
	items=games[cg]->lst_items;
      if ((strstr(tag, "_SP_")!=NULL) && cg>=0 && cp>=0)
	items=games[cg]->player[cp]->lst_items;

      if (items==NULL) return 0;

      s=strstr(tag, "_VI_");
      s+=4;
      e=s;
      while(*e!='>' && *e!=32 && *e!=0)
	e++;

      if (e-s > 20) return 0;
      t=(char *)malloc(1+e-s);
      memset(t,0,1+e-s);
      strncpy(t, s, e-s);

      //fprintf(stderr, "------>%s\n", t);      
      if (strcmp(t, "ALL_AMMO")==0)
	sum=items[0]+items[1]+items[2]+items[3]+items[4]+\
	  items[5]+items[6]+items[7];
      if (strcmp(t, "ALL_WEAPONS")==0)
	sum=items[8]+items[9]+items[10]+items[11]+items[12]+\
	  items[13]+items[14];
      if (strcmp(t, "ALL_HEALTH")==0)
	sum=items[15]+items[16]+items[17]+items[18];
      if (strcmp(t, "ALL_ARMOR")==0)
	sum=items[19]+items[20]+items[21];
      if (strcmp(t, "ALL_POWERUPS")==0)
	sum=items[22]+items[23]+items[24]+items[25];

      if (sum<0)
	{
	  for (i=0; i<NOF_ITEMS; i++)
	    if (strcmp(t, html_items[i])==0)
	  break;
	  if (i==NOF_ITEMS) return 0;
	  
	  sum=items[i];
	}
      if (t!=NULL) free(t);
      t=NULL;
    }

  /* General Vars */
  if (strstr(tag, "_VG_")!=NULL)
    {
      if (strstr(tag, "_FRAGCOUNTER")!=NULL)
	{
	  if ((strstr(tag, "_AG_")!=NULL) ||\
	      (strstr(tag, "_AP_")!=NULL))
	    sum=lts->nof_frags;
	  if (strstr(tag, "_SG_")!=NULL)
	    if (cg>=0) sum=games[cg]->nof_frags;
	  if (strstr(tag, "_SP_")!=NULL)
	    if (cg>=0 && cp>=0) sum=games[cg]->player[cp]->nof_frags;
	}

      if (strstr(tag, "_FRAGMASTERCOUNT")!=NULL)
	{
	  if ((strstr(tag, "_SG_")!=NULL) ||\
	      (strstr(tag, "_SP_")!=NULL))
	    {
	      sum=0;
	      for(i=1; i<games[cg]->nof_players; i++)
		if (games[cg]->player[i]->nof_frags>sum)
		  sum=games[cg]->player[i]->nof_frags;
	    }
	  if ((strstr(tag, "_AG_")!=NULL) ||\
	      (strstr(tag, "_AP_")!=NULL))
	    {
	      sum=0;
	      for(i=1; i<lts->nof_players; i++)
		if (lts->ltplayers[i]->nof_frags>sum)
		  sum=lts->ltplayers[i]->nof_frags;
	    }
	}

      if (strstr(tag, "_IDIOTCOUNT")!=NULL)
	{
	  if ((strstr(tag, "_SG_")!=NULL) ||\
	      (strstr(tag, "_SP_")!=NULL))
	    {
	      sum=0;
	      for(i=1; i<games[cg]->nof_players; i++)
		if (games[cg]->player[i]->nof_suicides>sum)
		  sum=games[cg]->player[i]->nof_suicides;
	    }
	  if ((strstr(tag, "_AG_")!=NULL) ||\
	      (strstr(tag, "_AP_")!=NULL))
	    {
	      sum=0;
	      for(i=1; i<lts->nof_players; i++)
		if (lts->ltplayers[i]->nof_suicides>sum)
		  sum=lts->ltplayers[i]->nof_suicides;
	    }
	}

      if (strstr(tag, "_EASYPREYCOUNT")!=NULL)
	{
	  if ((strstr(tag, "_SG_")!=NULL) ||\
	      (strstr(tag, "_SP_")!=NULL))
	    {
	      sum=0;
	      for(i=1; i<games[cg]->nof_players; i++)
		if (games[cg]->player[i]->nof_deaths<sum)
		  sum=games[cg]->player[i]->nof_deaths;
	    }
	  if ((strstr(tag, "_AG_")!=NULL) ||\
	      (strstr(tag, "_AP_")!=NULL))
	    {
	      sum=0;
	      for(i=1; i<lts->nof_players; i++)
		if (lts->ltplayers[i]->nof_deaths>sum)
		  sum=lts->ltplayers[i]->nof_deaths;
	    }
	}

    }

  if (sum<-100) return 0;
  if (strstr(tag, " GFX")==NULL)
    fprintf(fp, "%i", sum);
  else {
    s=strstr(tag, " PRE=");
    if (s!=NULL)
      {
	s+=5;
	e=s;
	while(*e!='>' && *e!=32 && *e!=0)
	  e++;
	t=(char *)malloc(1+e-s);
	memset(t,0,1+e-s);
	strncpy(t, s, e-s);
      }
    s=strstr(tag, " POST=");
    if (s!=NULL)
      {
	s+=6;
	e=s;
	while(*e!='>' && *e!=32 && *e!=0)
	  e++;
	u=(char *)malloc(1+e-s);
	memset(u,0,1+e-s);
	strncpy(u, s, e-s);
      }
    
    write_counter_gfx(fp, sum, t, u);
    
    if (t!=NULL) free(t);
    if (u!=NULL) free(u);
  }
  return 1;
}










/*
 *
 *
 Tags (more complicated)
 *
 *
 */
void write_q3tag(FILE    *fp, char *tag,
		 t_game **games, int nof_games, char *t, char *t_p,
		 char   **todo, char **todo_t, char **todo_p, int *sp,
		 t_lts   *lts)
{
  int  p1, p2, exist, i, j, cg=-1, cp=-1;
  char *c1=NULL, *c2=NULL, *c3=NULL, *c4=NULL, b_done=0;

  if (t_p!=NULL)
    {
      cg=get_param_int(t_p, "GAMEID");
      cp=get_param_int(t_p, "PLAYERID");
    }

  /* single-game tags */
  if (cg>=0)
    {
      //printf("%s\n", tag);
      /* Single-game stats */
      if (strstr(tag, "Q3L_SG_STATS")!=NULL)
	{
	  b_done=1;
	  if (strstr(tag, "ALL")==NULL)
	    write_sg_stats(fp, games[cg]);
	  else
	    {
	      c1=get_param_string(tag, "HEADC");
	      write_sg_stats_all(fp, games[cg], c1);
	    }
	}

      /* Timeline for CTF - events */
      if (strstr(tag, "Q3L_CTFTIMELINE")!=NULL)
	{
	  c1=get_param_string(tag, "REDC");
	  c2=get_param_string(tag, "BLUEC");
	  c3=get_param_string(tag, "BACKCOLOR");
	  write_sg_ctftimeline(fp, games[cg], cg, c1, c2, c3);
	  b_done=1;
	}

      /* Team-results within a game */
      if (strstr(tag, "Q3L_SG_CTFSTATS")!=NULL)
	{
	  c1=get_param_string(tag, "REDC");
	  c2=get_param_string(tag, "BLUEC");
	  c3=get_param_string(tag, "HEADC");
	  write_sg_ctfstats(fp, games[cg], c1, c2, c3);
	  b_done=1;
	}

      /* Timeline for Team - events */
      if (strstr(tag, "Q3L_TEAMTIMELINE")!=NULL)
	{
	  c1=get_param_string(tag, "REDC");
	  c2=get_param_string(tag, "BLUEC");
	  c3=get_param_string(tag, "BACKCOLOR");
	  write_sg_teamtimeline(fp, games[cg], cg, c1, c2, c3);
	  b_done=1;
	}

      /* Team-results within a game */
      if (strstr(tag, "Q3L_SG_TEAMSTATS")!=NULL)
	{
	  c1=get_param_string(tag, "REDC");
	  c2=get_param_string(tag, "BLUEC");
	  c3=get_param_string(tag, "HEADC");
	  write_sg_teamstats(fp, games[cg], c1, c2, c3);
	  b_done=1;
	}

      /* Timeline for Kill - events */
      if (strstr(tag, "Q3L_TIMELINE")!=NULL)
	{
	  c1=get_param_string(tag, "REDC");
	  c2=get_param_string(tag, "BLUEC");
	  c3=get_param_string(tag, "BACKCOLOR");
	  write_sg_playertimeline(fp, games[cg], cg, c1, c2, c3);
	  b_done=1;
	}
      
      /* All player-stats within a game */
      if (strstr(tag, "Q3L_SG_RANKS")!=NULL)
	{
	  c1=get_param_string(tag, "REDC");
	  c2=get_param_string(tag, "BLUEC");
	  c3=get_param_string(tag, "NEUTRALC");
	  c4=get_param_string(tag, "HEADC");
	  //fprintf(stderr, "PARAMS: %s %s %s %s\n", c1,c2,c3,c4);
	  write_sg_ranks(fp, games[cg], cg, todo, todo_t, todo_p, sp, c1, c2, c3, c4);
	  b_done=1;
	}

      /* who killed who */
      if (strstr(tag, "Q3L_SG_KILLTABLE")!=NULL)
	{
	  c1=get_param_string(tag, "REDC");
	  c2=get_param_string(tag, "BLUEC");
	  c3=get_param_string(tag, "NEUTRALC");
	  c4=get_param_string(tag, "SUICIDEC");
	  write_sg_killtab(fp, games[cg], c1, c2, c3, c4);
	  b_done=1;
	}

      /* Weapons used */
      if (strstr(tag, "Q3L_SG_WEAPONS")!=NULL)
	{
	  p1=get_param_int(tag, "COLS");
	  if (strstr(tag, "SHOWALL")!=NULL)
	    p2=1; else p2=0;
	  write_any_weapons(fp, games[cg]->weaps,p1,p2);
	  b_done=1;
	}

      /* Single Game Suicides */
      if (strstr(tag, "Q3L_SG_SUICIDEWEAPONS")!=NULL)
	{
	  p1=get_param_int(tag, "COLS");
	  if (strstr(tag, "SHOWALL")!=NULL)
	    p2=1; else p2=0;
	  write_any_weapons(fp, games[cg]->wsui,p1,p2);
	  b_done=1;
	}

      /* Single Game TeamKills */
      if (strstr(tag, "Q3L_SG_TEAMKILLWEAPONS")!=NULL)
	{
	  p1=get_param_int(tag, "COLS");
	  if (strstr(tag, "SHOWALL")!=NULL)
	    p2=1; else p2=0;
	  write_any_weapons(fp, games[cg]->wtkill,p1,p2);
	  b_done=1;
	}

      /* Items used */
      if (strstr(tag, "Q3L_SG_ITEMS")!=NULL)
	{
	  p1=get_param_int(tag, "COLS");
	  if (strstr(tag, "SHOWALL")!=NULL)
	    p2=1; else p2=0;
	  write_any_items(fp, games[cg]->lst_items, p1, p2);
	  b_done=1;
	}

      if (strstr(tag, "Q3L_SG_MAPNAME")!=NULL)
	{
	  fprintf(fp, "%s", games[cg]->mapname);
	  b_done=1;
	}
      if (strstr(tag, "Q3L_SG_SERVERNAME")!=NULL)
	{
	  fprintf(fp, "%s", games[cg]->servername);
	  b_done=1;
	}

      if (strstr(tag, "Q3L_SG_FRAGMASTERNAME")!=NULL)
	{
	  j=0;
	  for(i=1; i<games[cg]->nof_players; i++)
	    if (games[cg]->player[i]->nof_frags>
		games[cg]->player[j]->nof_frags)
	      j=i;
	  b_done=1;
	  fprintf(fp,"%s", make_funname(games[cg]->player[j]->name));
	}

      if (strstr(tag, "Q3L_SG_EASYPREYNAME")!=NULL)
	{
	  j=0;
	  for(i=1; i<games[cg]->nof_players; i++)
	    if (games[cg]->player[i]->nof_deaths>
		games[cg]->player[j]->nof_deaths)
	      j=i;
	  b_done=1;
	  fprintf(fp,"%s", make_funname(games[cg]->player[j]->name));
	}
      if (strstr(tag, "Q3L_SG_IDIOTNAME")!=NULL)
	{
	  j=0;
	  for(i=1; i<games[cg]->nof_players; i++)
	    if (games[cg]->player[i]->nof_suicides>
		games[cg]->player[j]->nof_suicides)
	      j=i;
	  b_done=1;
	  fprintf(fp,"%s", make_funname(games[cg]->player[j]->name));
	}


      /*
       *
       *
       the stats for player in single-game follow
       *
       *
       */
      if (cp>=0)
	{
	  if (strstr(tag, "Q3L_SP_PLAYERNAME")!=NULL)
	    {
	      write_sp_playername(fp, games[cg], cp);
	      b_done=1;
	    }

	  if (strstr(tag, "Q3L_SP_WEAPON")!=NULL)
	    {
	      p1=get_param_int(tag, "COLS");
	      if (strstr(tag, "SHOWALL")!=NULL)
		p2=1; else p2=0;
	      write_any_weapons(fp, games[cg]->player[cp]->weaps, p1, p2);
	      b_done=1;
	    }

	  if (strstr(tag, "Q3L_SP_TEAMKILLWEAPON")!=NULL)
	    {
	      p1=get_param_int(tag, "COLS");
	      if (strstr(tag, "SHOWALL")!=NULL)
		p2=1; else p2=0;
	      write_any_weapons(fp, games[cg]->player[cp]->wtkill, p1, p2);
	      b_done=1;
	    }

	  if (strstr(tag, "Q3L_SP_SUICIDEWEAPON")!=NULL)
	    {
	      p1=get_param_int(tag, "COLS");
	      if (strstr(tag, "SHOWALL")!=NULL)
		p2=1; else p2=0;
	      write_any_weapons(fp, games[cg]->player[cp]->wsui, p1, p2);
	      b_done=1;
	    }

	  if (strstr(tag, "Q3L_SP_ITEMS")!=NULL)
	    {
	      p1=get_param_int(tag, "COLS");
	      if (strstr(tag, "SHOWALL")!=NULL)
		p2=1; else p2=0;
	      write_any_items(fp, games[cg]->player[cp]->lst_items, p1, p2);
	      b_done=1;
	    }

	  if (strstr(tag, "Q3L_SP_KILLTABLE")!=NULL)
	    {
	      c1=get_param_string(tag, "REDC");
	      c2=get_param_string(tag, "BLUEC");
	      c3=get_param_string(tag, "NEUTRALC");
	      c4=get_param_string(tag, "HEADC");
	      write_sp_killtable(fp, games[cg], cp, c1, c2, c3, c4);
	      b_done=1;
	    }

	}
      if (b_done)
	{
	  if (c1!=NULL) free(c1);
	  if (c2!=NULL) free(c2);
	  if (c3!=NULL) free(c3);
	  if (c4!=NULL) free(c4);
	  return;
	}
    }



  /*
   *
   *
   all-time tags
   *
   *
   */
  if (strstr(tag, "Q3L_GAMETABLE")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (p1<0) p1=3;
      if (strstr(tag, "NOGAMETYP")!=NULL)
	p2=0;
      else p2=1;
      write_sg_table(fp, games, nof_games, todo, todo_t, todo_p, sp, p1, p2);
      b_done=1;
    }



  /*
   *
   *
   All-game stats
   *
   *
   */
  /* General stats for all game played */
  if (strstr(tag, "Q3L_AG_STATS")!=NULL)
    {
      c1=get_param_string(tag, "HEADC");
      write_ag_stats(fp, games, nof_games, c1);
      b_done=1;
    }

  /* Weapons used */
  if (strstr(tag, "Q3L_AG_WEAPONS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_ag_weapons(fp, games, nof_games, p1, p2);
      b_done=1;
    }

  /* Weapons used TEAMKILL*/
  if (strstr(tag, "Q3L_AG_TEAMKILLWEAPONS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_ag_teamkillweapons(fp, games, nof_games, p1, p2);
      b_done=1;
    }

  /* Weapons used SUICIDE*/
  if (strstr(tag, "Q3L_AG_SUICIDEWEAPONS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_ag_suicideweapons(fp, games, nof_games, p1, p2);
      b_done=1;
    }

  /* Items taken */
  if (strstr(tag, "Q3L_AG_ITEMS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_ag_pickups(fp, games, nof_games, p1, p2);
      b_done=1;
    }
  if (b_done)
    {
      if (c1!=NULL) free(c1);
      if (c2!=NULL) free(c2);
      if (c3!=NULL) free(c3);
      if (c4!=NULL) free(c4);
      return;
    }
  if (strstr(tag, "Q3L_AG_FRAGMASTERNAME")!=NULL)
    {
      j=0;
      for(i=1; i<lts->nof_players; i++)
	if (lts->ltplayers[j]->nof_frags<lts->ltplayers[i]->nof_frags)
	  j=i;
      fprintf(fp,"%s", make_funname(lts->ltplayers[j]->name));
      b_done=1;
    }
  if (strstr(tag, "Q3L_AG_EASYPREYNAME")!=NULL)
    {
      j=0;
      for(i=1; i<lts->nof_players; i++)
	if (lts->ltplayers[j]->nof_deaths<lts->ltplayers[i]->nof_deaths)
	  j=i;
      fprintf(fp,"%s", make_funname(lts->ltplayers[j]->name));
      b_done=1;
    }
  if (strstr(tag, "Q3L_AG_IDIOTNAME")!=NULL)
    {
      j=0;
      for(i=1; i<lts->nof_players; i++)
	if (lts->ltplayers[j]->nof_suicides<lts->ltplayers[i]->nof_suicides)
	  j=i;
      fprintf(fp,"%s", make_funname(lts->ltplayers[j]->name));
      b_done=1;
    }



  /*
   *
   *
   All Game - Player
   *
   *
   */
  if (strstr(tag, "Q3L_AP_ALLSTATS")!=NULL)
    {
      c1=get_param_string(tag, "HEADC");
      write_agp_allstats(fp, lts, c1, todo, todo_t, todo_p, sp);
      b_done=1;
    }


  if (strstr(tag,"Q3L_AP_PLAYERNAME")!=NULL)
    {
      fprintf(fp, "%s", make_funname(lts->ltplayers[cp]->name));
      b_done=1;
    }

  /* All Game - Single Player - Weapons */
  if (strstr(tag, "Q3L_AP_WEAPONS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_any_weapons(fp, lts->ltplayers[cp]->weaps, p1, p2);
      b_done=1;
    }

  /* All Game Player - Single Player - Suicides */
  if (strstr(tag, "Q3L_AP_SUICIDEWEAPONS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_any_weapons(fp, lts->ltplayers[cp]->wsui, p1, p2);
      b_done=1;
    }
  
  /* All Game Player - Single Player - TeamKills */
  if (strstr(tag, "Q3L_AP_TEAMKILLWEAPONS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_any_weapons(fp, lts->ltplayers[cp]->wtkill, p1, p2);
      b_done=1;
    }

  /* All Game Player - Single Player - Items */
  if (strstr(tag, "Q3L_AP_ITEMS")!=NULL)
    {
      p1=get_param_int(tag, "COLS");
      if (strstr(tag, "SHOWALL")!=NULL)
	p2=1; else p2=0;
      write_any_items(fp, lts->ltplayers[cp]->items, p1, p2);
      b_done=1;
    }

  /*
   *
   *
   SPECIAL TAGS
   *
   *
   */
  if (strstr(tag, "Q3L_DATE")!=NULL){
    write_date(fp);
    b_done=1;}
  if (strstr(tag, "Q3L_TIME")!=NULL){
    write_time(fp);
    b_done=1;}
  if (strstr(tag, "Q3L_IF")!=NULL)
    b_done=1; // parsed especially
  if (strstr(tag, "Q3L_ENDIF")!=NULL)
    b_done=1; // parsed especially

  /* special tag for linking files */
  if (strstr(tag, "Q3L_HTML")!=NULL)
    {
      c1=get_param_string(tag, "FILE");
      if (c1==NULL)
	return;
      exist=0;
      for(i=0; i<*sp; i++)
	if (strcmp(todo[i], c1)==0)
	  exist=1;
      if (!exist)
	{
	  todo[*sp]=strdup(c1);
	  todo_t[*sp]=strdup(c1);
	  todo_p[*sp]=strdup(tag);
	  (*sp)++;
	}
      b_done=1;
    }

  if ((strstr(tag, "_VW_")!=NULL) || (strstr(tag, "_VI_")!=NULL) ||\
      (strstr(tag, "_VG_")!=NULL))
    {
      b_done=check_var(fp, tag, cg, cp, games, nof_games, lts);
    }

  if (c1!=NULL) free(c1);
  if (c2!=NULL) free(c2);
  if (c3!=NULL) free(c3);
  if (c4!=NULL) free(c4);
  if (!b_done)
    fprintf(stderr, "Unknown Q3L-Tag -> %s\n", tag);
}








/*
 *
 *
 simple BOOLean operation
 *
 *
 */
int check_if(char *source, char *key, t_game **games, int nof_games, char *t_p)
{
  char *s, *e, t_key[MAXIFCOND], b_true;
  int   cg=-1, cp=-1;
  char  b_done=0;

  if (t_p!=NULL)
    {
      cg=get_param_int(t_p, "GAMEID");
      cp=get_param_int(t_p, "PLAYERID");
    }
  //if (strstr(source, "<Q3L_ENDIF");
  s=strstr(source, "<Q3L_");
  while(*s!=32)
    s++;
  while(*s==32)
    s++;
  e=s;
  while(*e!=32 && *e!='>' && *e!=0)
    e++;
  *e=0;
  b_true=0;
  memset(t_key,0,MAXIFCOND);
  strncpy(t_key, s, e-s);
  //printf("--> IF - %s   (last : %s)\n",source, key);
  if (strstr(source, "Q3L_IF")!=NULL)
    {
      if (cg>=0)
	{
	  if (strstr(t_key, "SG_TEAMGAME")!=NULL)
	    {b_done=1; if (games[cg]->type>2) b_true=1;}
	  if (strstr(t_key, "SG_SINGLEGAME")!=NULL)
	    {b_done=1; if (games[cg]->type==0) b_true=1;}
	  if (strstr(t_key, "SG_SUICIDE")!=NULL)
	    {b_done=1; if (cg>=0 && games[cg]->nof_suicides) b_true=1;}
	  if (strstr(t_key, "SG_CTF")!=NULL)
	    {b_done=1; if (games[cg]->type==4) b_true=1;}
	  if (strstr(t_key, "SG_TEAMDEATHMATCH")!=NULL)
	    {b_done=1; if (games[cg]->type==3) b_true=1;}

	  if (cp>=0)
	    {
	      if (strstr(t_key, "SP_SUICIDE")!=NULL)
		{b_done=1; if (games[cg]->player[cp]->nof_suicides) b_true=1;}
	      if (strstr(t_key, "SP_TEAMKILL")!=NULL)
		{b_done=1; if (games[cg]->player[cp]->nof_tkills) b_true=1;}
	    }
	} 
      if (!b_done)
	{fprintf(stderr,"Unknown tag : %s (game:%i, player:%i)\n",\
		 source,cg,cp); return 1;}
      
      if (!b_true)
	{
	  memset(key,0,MAXIFCOND);
	  strcpy(key, t_key);
	  return 0;
	} else {
	  memset(key,0,MAXIFCOND);
	  return 1;
	}
    }
  /* IF - branch already returned 0 or 1, so just ENDIF left */
  if (strcmp(t_key, key)==0)
    {
      memset(key,0,MAXIFCOND);
      return 1;
    }
  return 0;
}





int generate_HTML_TPL(t_game **games, int nof_games,
		      char *dir, char *sfile, char *tdir)
{
  char   fname[MAXDIRLENGTH], mem[MAXLINELENGTH], s_if[MAXIFCOND];
  char  *t=NULL, *t_t=NULL, *t_p=NULL, b_write, b_hpjw=0, *tmp;
  int    len, sp, dsp, i, sp_act, b_todo;

  FILE  *fp_i=NULL, *fp_o=NULL;
  t_lts *lts;

  /* todo - filename (template), todo_t - filename (target), todo_p params*/
  char **todo, **todo_t, **todo_p, **done;


  lts=load_stats(sfile);
  if (lts==NULL)
    lts=new_ltStat();

  for (i=0; i<nof_games; i++)
    add_game(lts, games[i]);

  todo=(char **)malloc(sizeof(char *)*MAXHTML);
  memset(todo,0,sizeof(char *)*MAXHTML);
  todo_t=(char **)malloc(sizeof(char *)*MAXHTML);
  memset(todo_t,0,sizeof(char *)*MAXHTML);
  todo_p=(char **)malloc(sizeof(char *)*MAXHTML);
  memset(todo_p,0,sizeof(char *)*MAXHTML);
  done=(char **)malloc(sizeof(char *)*MAXHTML);
  memset(done,0,sizeof(char *)*MAXHTML);

  dsp=0;
  sp=1;
  b_write=1;
  s_if[0]=0;
  todo[0]=strdup("index.html");  
  todo_t[0]=strdup("index.html");  
  todo_p[0]=NULL;
  done[0]=NULL;
  while(sp>0)
    {
      /* expand stack, if subroutines added something,
	 take current file from stack, reduce SP */
      while(todo[sp]!=NULL)
	sp++;
      b_todo=0;
      sp--;
      sp_act=sp;
      if (sp_act<0) break;

      tmp=strdup(todo_t[sp_act]);
      done[dsp]=tmp;
      t=todo[sp_act];
      todo[sp_act]=NULL;
      t_t=todo_t[sp_act];
      todo_t[sp_act]=NULL;
      t_p=todo_p[sp_act];
      todo_p[sp_act]=NULL;
      b_todo=1;
      dsp++;
      if (dsp>=MAXHTML)
	{
	  fprintf(stderr, "MAXHTML exceeded, to many written files\n");
	  dsp--;
	}

      if (t==NULL || sp<0) break;

#ifdef GNU_C
      sprintf(fname, "%s/%s", tdir, t);
#else
      sprintf(fname, "%s\\%s", tdir, t);
#endif
      fp_i=fopen(fname, "rb");
      if (fp_i==NULL)
	{
	  fprintf(stderr, "ERROR opening template-file \"%s\" -> %s, %s\n",\
		  fname, t, t_p);
	  return -1;
	}
#ifdef GNU_C
      sprintf(fname, "%s/%s", dir, t_t);
#else
      sprintf(fname, "%s\\%s", dir, t_t);
#endif
      fp_o=fopen(fname, "wb");
      if (fp_o==NULL)
	{
	  fprintf(stderr, "ERROR opening file \"%s\" -> %s, %s\n",\
		  fname, t, t_p);
	  return -1;
	}

      //fprintf(stderr, "\n  writing \"%s\" -> \"%s\"\n", t, t_t);
      while (!feof(fp_i))
	{
	  len=read_to_next_tag(fp_i, mem, MAXLINELENGTH);
	  if (len && b_write)
	    fwrite(mem,1,len,fp_o);
	  if (len<MAXLINELENGTH && !feof(fp_i))
	    {
	      len=read_tag(fp_i, mem, MAXLINELENGTH);
	      if (strstr(mem, "</body>")!=NULL || strstr(mem,"</BODY>")!=NULL)
		{write_HPJ(fp_o); b_hpjw=1;}
	      if (b_write)
		{
		  if (strstr(mem, "<Q3L_IF")!=NULL)
		    b_write=check_if(mem, s_if, games, nof_games, t_p);
		  else
		    {
		      if (strstr(mem, "<Q3L_")!=NULL)
			{
			  //fprintf(stderr, "\n  found a q3-tag : %s\n", mem);
			  write_q3tag(fp_o, mem, games, nof_games, t, t_p,
				      todo,todo_t,todo_p,
				      &sp,lts);
			} else {
			  fwrite(mem,1,len,fp_o);
			}
		    }
		} else {
		  if ((strstr(mem, "<Q3L_ENDIF")!=NULL))
		      //|| (strstr(mem,"<Q3L_IF")!=NULL))
		    b_write=check_if(mem, s_if, games, nof_games, t_p);
		}
	    } 
	}

      if (t_p) free(t_p);
      t_p=NULL;
      if (t_t) free(t_t);
      t_t=NULL;
      if (t) free(t);
      t=NULL;

      if (!b_hpjw)
	write_HPJ(fp_o);
      fclose(fp_i);
      fclose(fp_o);
    }


  if (todo)   free(todo);
  if (todo_t) free(todo_t);
  if (todo_p) free(todo_p);

  for (i=0; i<MAXHTML; i++)
    if (done[i]!=NULL)
      free(done[i]);
  free(done);

  del_ltStat(lts);
  return 1;
}
