/*
  Here are all the structs for games and players are stored.

  $Id: game.h,v 1.8 2000/01/09 23:09:44 jacobs Exp jacobs $

  $Log: game.h,v $
  Revision 1.8  2000/01/09 23:09:44  jacobs
  new option "-r"

  Revision 1.7  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.6  2000/01/07 13:43:42  jacobs
  *** empty log message ***

  Revision 1.5  2000/01/05 03:43:25  jacobs
  *** empty log message ***

  Revision 1.4  2000/01/03 16:04:02  jacobs
  *** empty log message ***

  Revision 1.3  1999/12/31 02:21:41  jacobs
  *** empty log message ***

  Revision 1.2  1999/12/30 01:26:21  jacobs
  *** empty log message ***

  Revision 1.1  1999/12/28 22:34:38  jacobs
  Initial revision


*/

#ifndef __GAME_H__
#define __GAME_H__


#ifndef DEBUG_LEVEL
#define DEBUG_LEVEL   0
#endif

#define Q3L_MAIN_VERSION "1.8"
//$Revision: 1.8 $"
#define MAXGAMES      1024
#define MAXPLAYER     64 //per game :-)
#define MAXLINELENGTH 4096
/*1024*/
#define MAXKILLS      256
#define MAXTEAMKILLS  512
#define MAXCTFEVENTS  32

#define CTF_BASE      -2
#define CTF_LEVEL     -1

#define NOF_ITEMS     30
#define NOF_WEAPS     23
#define NOF_GAMEMODES 5

extern const char c_items[NOF_ITEMS][30];
extern const char c_items_nice[NOF_ITEMS][30];
extern const char c_weaps[NOF_WEAPS][30];
extern const char c_gamemodes[NOF_GAMEMODES][30];
extern const char c_gamemodes_s[NOF_GAMEMODES][4];

/*
  I call an event a single line in the Q3 - "games.log"
*/
typedef struct {
  int   time;
  char *event, *text;
}t_event;


/* Here we go -> main-struct for a player */
typedef struct {
  char *name;   //internal-name, changed for bots "killer" -> "killer_[3]"
  char *i_name; //id-name , used in-game
  char  b_red, b_blue;

  int   c_id;
  int   startsec, secs, max_tal, avg_ttl, handicap, team, skill, ping, score;
  int   nof_kills, nof_suicides, nof_frags, nof_items, nof_says, nof_deaths;
  int   nof_tkills;
  int   lst_kills[MAXPLAYER], lst_weapon[MAXPLAYER];
  int   lst_items[NOF_ITEMS];
  int   weaps[NOF_WEAPS], wsui[NOF_WEAPS], wtkill[NOF_WEAPS];

  int   tl_weaps[MAXKILLS], tl_whom[MAXKILLS];
  int   tl_frags[MAXKILLS], tl_fragsec[MAXKILLS],killcounter;
}t_player;


/*
  A game consists of several player.
  "Complete" games are games with the "Exit" - event,
  i.e. a limit was hit (capture, frag, time).
*/
typedef struct {
  char      *mapname, *servername;
  char       type, complete;// flagstate[3];

  int        secs, startsec, timelimit, fraglimit, capturelimit;
  int        nof_kills, nof_suicides, nof_frags, nof_items, nof_deaths;
  int        nof_players, nof_says, nof_tkills;

  int        flag_carrier[3];
  int        ctf_captures[3], ctf_fkills[3], ctf_loss[3];
  int        ctf_pickups[3], ctf_returns[3], ctf_steals[3];

  int        team_score[3], team_tkills[3], team_kills[3];
  int        team_suic[3], team_frags[3];

  int        weaps[NOF_WEAPS], wsui[NOF_WEAPS], wtkill[NOF_WEAPS];
  int        tl_ctf[3][MAXCTFEVENTS], tl_ctfsec[3][MAXCTFEVENTS];
  int        tl_team[3][MAXTEAMKILLS], tl_teamsec[3][MAXTEAMKILLS];
  int        teamkillcounter[3];
  int        lst_items[NOF_ITEMS];
  t_player **player;
}t_game;



/*
 *
 *
 now we export some functions
 *
 *
 */
/* creates a t_event - struct, returns the pointer to it,
   all vars will be set to zero*/
t_event  *new_event(void);
// frees the allocated memory, returns a NULL-pointer
t_event  *del_event(t_event *event);

// creates a t_player - struct, returns the pointer to it, all vars set to zero
t_player *new_player(void);
// frees the allocated memory, returns a NULL-pointer
t_player *del_player(t_player *player);
long int  size_player(t_player *player);

t_game   *new_game(void);
t_game   *del_game(t_game *game);
long int  size_game(t_game *game);
int       getPlayerID(t_game *game, int client_id);

#endif
