/*
  This file contains the constants and some functions for
  handling the structs.

  $Id: game.c,v 1.1 1999/12/28 22:34:38 jacobs Exp jacobs 

  $Log: game.c,v $
  Revision 1.5  2000/01/09 23:09:44  jacobs
  new option "-r"

  Revision 1.4  2000/01/09 02:32:17  jacobs
  *** empty log message ***

  Revision 1.3  2000/01/07 13:43:42  jacobs
  *** empty log message ***

  Revision 1.2  1999/12/30 01:26:21  jacobs
  *** empty log message ***

  Revision 1.1  1999/12/28 22:34:38  jacobs
  Initial revision


*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tool.h"
#include "game.h"


const char c_items[NOF_ITEMS][30]={
  "ammo_bullets", "ammo_shells", "ammo_rockets",
  "ammo_cells", "ammo_slugs", "ammo_grenades",
  "ammo_lightning", "ammo_bfg", "weapon_railgun",
  "weapon_rocketlauncher", "weapon_grenadelauncher",
  "weapon_shotgun", "weapon_plasmagun", "weapon_lightning",
  "weapon_bfg", "item_health_small", "item_health",
  "item_health_large", "item_health_mega", "item_armor_shard",
  "item_armor_body", "item_armor_combat", "item_haste",
  "item_regen", "item_quad", "item_invis", "item_enviro",
  "item_flight",
  "holdable_medkit", "holdable_teleporter"};

const char c_items_nice[NOF_ITEMS][30]={
  "Bullets", "Shells", "Rockets",
  "Cells", "Slugs", "Grenades",
  "Light-ammo", "BFG-Ammo", "Railgun",
  "RocketLauncher", "GrenadeLauncher", //11
  "Shotgun", "Plasmagun", "Lightning Gun",
  "BFG 2K", "Health small", "Health",
  "Health large", "Health Mega", "Armor shard",
  "Body Armor", "Combat Armor", "Haste", //23
  "Regeneration", "Quad-Damage", "Invisibility", "Enviro Suit",
  "Flight-Item",
  "Holdable Medikit", "Holdable TPorter"};

const char c_weaps[NOF_WEAPS][30]={
  "0", "Shotgun", "Gauntlet", "Machinegun",
  "Grenade", "Grenade Splash", //5
  "Rocket", "Rocket Splash", "Plasma",
  "Plasma Splash", "Railgun", "Lightning",
  "BFG", "BFG Splash", "14", "15", "Lava",
  "Crush", "Telefrag", "Falling", "Suicide", "21", "Trigger_Hurt"};

const char c_gamemodes[NOF_GAMEMODES][30]={
  "Death Match", "Tournament", "Unknown", "Team Deathmatch",
  "Capture the flag"};
const char c_gamemodes_s[NOF_GAMEMODES][4]={
  "dm", "tou", "??", "tdm", "ctf"};




/*
 *
 *
 Event - stuff
 *
 *
 */
t_event  *new_event(void)
{
  t_event *event=(t_event *)malloc(sizeof(t_event));
  if (event==NULL) exit_error("Malloc failed\n");
  memset(event, 0, sizeof(event));
  return event;
}


t_event  *del_event(t_event *event)
{
  if (event!=NULL)
    {
      if (event->event != NULL) free(event->event);
      if (event->text != NULL) free(event->text);
      free(event);
    }
  return NULL;
}



/*
 *
 *
 Player - stuff
 *
 *
 */
t_player *new_player(void)
{
  t_player *player=(t_player *)malloc(sizeof(t_player));
  if (player==NULL) exit_error("Malloc failed\n");
  memset(player, 0, sizeof(t_player));
  return player;
}

t_player *del_player(t_player *player)
{
  if (player!=NULL)
    {
      if (player->name !=NULL)free(player->name);
      if (player->i_name!=NULL) free(player->i_name);
      //free(player->lst_suicide);
    }
  free(player);
  return NULL;
}

long int size_player(t_player *player)
{
  int sum=0;
  sum=sizeof(t_player);
  sum+=strlen(player->name)+1;
  sum+=strlen(player->i_name)+1;
  return sum;
}



/*
 *
 *
 Game - stuff
 *
 *
 */
t_game   *new_game(void)
{
  t_game *game=(t_game *)malloc(sizeof(t_game));
  if (game==NULL) exit_error("Malloc failed\n");
  memset(game, 0, sizeof(t_game));
  return game;
}

t_game   *del_game(t_game *game)
{
  int i;

  if (game!=NULL)
    {
      free(game->mapname);
      free(game->servername);
      for (i=0; i<game->nof_players; i++)
	if (game->player[i]!=NULL) 
	  game->player[i]=del_player(game->player[i]);
      free(game->player);
    }
  free(game);
  return NULL;
}

long int size_game(t_game *game)
{
  long int sum=0, i;

  sum=sizeof(t_game);
  sum+=strlen(game->mapname)+1;
  sum+=strlen(game->servername)+1;
  sum+=sizeof(t_player **)*game->nof_players;
  for (i=0; i<game->nof_players; i++)
    sum+=size_player(game->player[i]);
  return sum;
}





int getPlayerID(t_game *game, int client_id)
{
  int i;
  for (i=0; i<game->nof_players; i++)
    {
      if (game->player[i]->c_id==client_id)
	return i;
    }
  return -1;
}
