/* The functions within this file write all current games to
   HTML.

   $Id: w_html.c,v 1.3 1999/12/31 02:21:41 jacobs Exp jacobs $

   $Log: w_html.c,v $
   Revision 1.3  1999/12/31 02:21:41  jacobs
   *** empty log message ***

   Revision 1.2  1999/12/30 01:26:21  jacobs
   *** empty log message ***

   Revision 1.1  1999/12/28 22:34:38  jacobs
   Initial revision


*/
#ifdef DEF_LINUX
 #include <sys/stat.h>
 #include <sys/types.h>
 #include <fcntl.h>
 #include <unistd.h>
#else
 #include <direct.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "w_html.h"
#include "tool.h"
#include "lt_stats.h"
#include "gif.h"

char team_color[3][8]={"#550055", "#550000", "#000055"};
char team_name[3][10]={"Both Teams", "Red Team", "Blue Team"};
char color_suicide[8]="#440044";

char color_bgt_items[8]="#442200";
char color_bgt_weaps[8]="#442200";
char color_bgt_stats[8]="#000022";
char color_bgt_heads[8]="#000000";

char color_bgt_allweaps[8]="#000022";

char color_bg_index[8]="#000000";
char color_text_index[8]="#FFFFBB";
char color_link_index[8]="#FFFFAA";
char color_vlink_index[8]="#DDDDAA";

char color_bg_game[8]="#000000";
char color_text_game[8]="#DDDD99";
char color_bg_allgame[8]="#000000";
char color_text_allgame[8]="#DDDD99";
char color_bg_allplayers[8]="#000000";
char color_text_allplayers[8]="#DDDD99";

char color_bg_killtable[8]="#222222";


/*
 *
 *
  SOME usefull functions first
 *
 *
 */
/* a nice message, so all know who did this peace of .... and who to blame*/
void write_HPJ(FILE *fp)
{
  fprintf(fp, "<br><br><br><br>\n");
  fprintf(fp, "<center>generated with Q3_LogGen, ");
  fprintf(fp, "written by <a href=\"mailto:hanspete@cs.tu-berlin.de\">");
  fprintf(fp, "Hans-Peter Jacobs</a></center>\n");
#ifdef DEF_LINUX
  fprintf(fp, "\n\n<br>\n<center><font color=#444444>");
  fprintf(fp, "($Date: 1999/12/31 02:21:41 $)");
  fprintf(fp, "</font>\n<br>\n</center>\n");
#endif
}








/*
 *
 *
 FUNCTIONS for a single game
 *
 *
 */
/* writes the initial table with a overview of the game*/
void write_SGStats(FILE *fp, t_game *game)
{
  fprintf(fp, "<b><center><table cellpadding=0 cellspacing=0 width=300>\n");
  fprintf(fp, "<tr><td>Host-Name</td><td>%s</td></tr>\n", game->servername);
  fprintf(fp, "<tr><td>Game-Type</td><td>%s</td></tr>\n",
	  c_gamemodes[(int)game->type]);
  fprintf(fp, "<tr><td>Duration</td><td>%i min %i sec</td></tr>\n",
	  game->secs/60, game->secs%60);
  fprintf(fp, "<tr><td>Time-Limit</td><td>%i</td></tr>\n", game->timelimit);
  fprintf(fp, "<tr><td>Frag-Limit</td><td>%i</td></tr>\n", game->fraglimit);
  if (game->type==4)
    fprintf(fp, "<tr><td>Capture-Limit</td><td>%i</td></tr>\n",
	    game->capturelimit);
  fprintf(fp, "</table></center></b><br>\n");
}



/* writes the stats for all players in the game*/
void write_SGStatsAll(FILE *fp, t_game *game)
{
  double fph;
  fph=(3600.0/game->secs) * (double)game->nof_frags;
  fprintf(fp, "<br><center><h3>Overall statistics</h3></center>\n");
  fprintf(fp, "<center><table width=50%% border=1 bgcolor=%s>\n",
	  color_bgt_stats);
  fprintf(fp, "<tr bgcolor=%s>\n", color_bgt_heads);

  fprintf(fp, "<th>Players</th><th>Kills</th>");
  if (game->type>2) fprintf(fp, "<th>TKills</th>");
  fprintf(fp, "<th>Suicides</th><th>Frags</th><th>FPH</th>");
  fprintf(fp, "<th>Pickups</th><th>Talks</th>\n</tr><tr>\n");

  fprintf(fp, "<td align=center>%i</td>", game->nof_players);
  fprintf(fp, "<td align=center>%i</td>", game->nof_kills);
  if (game->type>2) fprintf(fp,"<td align=center>%i</td>", game->nof_tkills);
  fprintf(fp, "<td align=center>%i</td>", game->nof_suicides);
  fprintf(fp, "<td align=center>%i</td><td align=center>%2.2f</td><td align=center>%i</td><td align=center>%i</td>\n",game->nof_frags, fph, game->nof_items, game->nof_says);
  fprintf(fp, "</tr></table></center><br><br>\n");
}


/* If teamplay is on, the stats for the teams will be displayed*/
void write_SGTeamScore(FILE *fp, t_game *game)
{
  int i, start, add, ende;

  /* Header an win-info*/
  fprintf(fp, "<br><center><h3>Team results</h3></center>\n");
  if (game->team_score[1]>game->team_score[2])
    {
      fprintf(fp, "<center>Red Team wins %i to %i</center>\n",
	      game->team_score[1], game->team_score[2]);
      start=1;add=1; ende=3;
    } else {
      fprintf(fp, "<center>Blue Team wins %i to %i</center>\n",
	      game->team_score[2], game->team_score[1]);
      start=2;add=-1; ende=0;
    }


  /* Table-header*/
  fprintf(fp, "<center><table width=600 border=1><tr bgcolor=%s><th width=100>Team</th><th>Kills</th><th>Team-Kills</th><th>Suicides</th>", color_bgt_heads);
  if (game->type==4) fprintf(fp, "<th width=60>Frags</th>");
  fprintf(fp, "<th width=60>Score</th></tr>\n");

  for (i=start; i!=ende; i+=add)
    {
      fprintf(fp, "<tr bgcolor=%s><td valign=top>%s</td><td align=center valign=top>%i</td><td align=center valign=top>%i</td><td align=center valign=top>%i</td>", team_color[i], team_name[i], game->team_kills[i], game->team_tkills[i],
	      game->team_suic[i]);
      if (game->type==4)
	fprintf(fp, "<td align=center valign=top>%i</th>",
		game->team_kills[i]-game->team_suic[i]-game->team_tkills[i]);
      fprintf(fp, "<td align=center valign=top>%i</td></tr>\n",
	      game->team_score[i]);
    }
  fprintf(fp,"</tr></table></center><br><br>\n\n");
}

/* CTF-results (if CTF played at all)*/
void write_SGCTF(FILE *fp, t_game *game)
{
  int  i, add, start, ende;

  fprintf(fp, "<br><center><h3>CTF - Events</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=#000 border=1 width=600><tr bgcolor=%s>\n", color_bgt_heads);
  /* Table - header */
  fprintf(fp, "<th width=14%%>Team</th><th width=14%%>Captures</th>");
  fprintf(fp, "<th width=14%%>Steals</th>");
  fprintf(fp, "<th width=14%%>Loss</th><th width=14%%>Pickups</th>");
  fprintf(fp, "<th width=14%%>FlagKills</th><th width=14%%>Returns</th>");
  fprintf(fp, "</tr>\n");

  /* Sort for results */
  if (game->team_score[1] > game->team_score[2])
    {add=1;start=1;ende=3;} else {add=-1; start=2;ende=0;}

  for (i=start; i!=ende; i+=add)
    {
      fprintf(fp, "<tr bgcolor=%s><td>%s</td><td align=center>%i</td>",
	      team_color[i], team_name[i], game->ctf_captures[i]);
      fprintf(fp, "<td align=center>%i</td><td align=center>%i</td>",
	      game->ctf_steals[i], game->ctf_loss[i]);
      fprintf(fp, "<td align=center>%i</td>",
	      game->ctf_pickups[i]);
      fprintf(fp, "<td align=center>%i</td><td align=center>%i</td></tr>\n",
	      game->ctf_fkills[i], game->ctf_returns[i]);
    }
  fprintf(fp, "\n</table>\n\n");
}



/* Writes the stats of a single player into the given file*/
void write_SGPlayer(char *filename, t_player *player, int gid)
{
  int   i, cols=3, sort[NOF_WEAPS], isort[NOF_ITEMS];
  FILE *fp=fopen(filename, "wt");
  if (fp==NULL) {fprintf(stderr, "failure writing to \"%s\"",filename);return;}

  fprintf(fp,"<html>\n<head><title>%s - Single-game statistics</title></head>\n",
	  player->name);
  fprintf(fp, "<body bgcolor=%s text=%s>\n", "#000", "#DDDD99");
  fprintf(fp, "<br><br><center><h1>%s</h1></center>\n", player->name);
  fprintf(fp, "<center>performance in fight %i</center><br><br>\n", gid);


  /* normal weapon-use*/
  cols=3;
  fprintf(fp, "<br><center><h3>Weapons used</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(player->weaps, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (player->weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], player->weaps[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  /* Suicide-weaps*/
  if (player->nof_suicides)
    {
      cols=3;
      fprintf(fp,"<br><center><h3>Weapons, best suicide</h3></center>\n");
      fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
      sort_weaps(player->wsui, sort);
      for (i=0; i<NOF_WEAPS; i++)
	{
	  if (player->wsui[sort[i]]<1) break;
	  fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
		  c_weaps[sort[i]], player->wsui[sort[i]]);
	  cols--;
	  if (cols<1) {
	    cols=3;
	    fprintf(fp, "</tr><tr>\n");
	  }
	}
      fprintf(fp, "</tr></table></center>\n");
    }

  /* Team-Kill-Weaps*/
  if (player->nof_tkills)
    {
      cols=3;
      fprintf(fp, "<br><center><h3>Weapons, teammates were killed with</h3></center>\n");
      fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
      sort_weaps(player->wtkill, sort);
      for (i=0; i<NOF_WEAPS; i++)
	{
	  if (player->wtkill[sort[i]]<1) break;
	  fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
		  c_weaps[sort[i]], player->wtkill[sort[i]]);
	  cols--;
	  if (cols<1) {
	    cols=3;
	    fprintf(fp, "</tr><tr>\n");
	  }
	}
      fprintf(fp, "</tr></table></center>\n");
    }

  /* Pickups */
  cols=3;
  fprintf(fp, "<br><center><h3>Items picked up</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_items);
  sort_items(player->lst_items, isort);
  for (i=0; i<NOF_ITEMS; i++)
    {
      if (player->lst_items[isort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_items_nice[isort[i]], player->lst_items[isort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  fprintf(fp, "</body>\n</html>\n");
  fclose(fp);
}


/* creates an image with the timeline and writes this to a gif*/
void write_timeline(FILE *fp, t_game *game, int gid)
{
  int   width=20, height=4;
  char *data, fname[1024], pal[768];

  data=(char *)malloc(width*height);
  if (data==NULL) return;
  memset(data,1,width*height);
  //memset(pal,0,768);
  pal[ 0]=255;
  pal[ 1]=128;
  pal[ 2]=255;
  pal[ 3]=255;
  pal[ 4]=0;
  pal[ 5]=0;
  pal[ 6]=0;
  pal[ 7]=255;
  pal[ 8]=0;
  pal[ 9]=0;
  pal[10]=0;
  pal[11]=255;
  sprintf(fname, "%02i_timeline.gif", gid);
  fprintf(fp, "<br><center><h3>Timeline</h3>\n");
  fprintf(fp, "<img src=\"%s\" width=%i height=%i></center>\n",
	  fname,width,height);
  write_img(fname, data, width, height, pal);
  free(data);
}


/* Writes the ranks, depending on the number of frags*/
void write_SGRanks(FILE *fp, t_game *game, int gid)
{
  int    i, j, k, sort[MAXPLAYER], color;
  char   fname[1024];
  double fph, ttl;

  fprintf(fp, "<br><br><center><h3>Ranking</h3></center>\n");

  for (i=0; i<game->nof_players; i++)
    sort[i]=i;
  j=1;
  while(j)
    {
      j=0;
      for (i=0; i<game->nof_players-1; i++)
	if (game->player[sort[i]]->nof_frags < game->player[sort[i+1]]->nof_frags) {
	  j++;
	  k=sort[i];
	  sort[i]=sort[i+1];
	  sort[i+1]=k;
	}
    }
  fprintf(fp, "<center><table width=100%% border=1 bgcolor=#000>\n");
  fprintf(fp, "<tr bgcolor=%s><th>Name</th><th>Handicap</th><th>Ping</th><th>Time</th><th>Kills</th>", color_bgt_heads);

  /* check for team-game */
  if (game->type>2) fprintf(fp, "<th>T-Kills</th>");
  fprintf(fp, "<th>Deaths</th><th>Suicide</th><th>Pickups</th><th>FPH</th><th>TTL</th><th>Frags</th>");

  /* check for CTF -> because Frag differs from Score */
  if (game->type==4)
    fprintf(fp, "<th>Score</th></tr>\n");
  else fprintf(fp, "</tr>\n");

  for (j=0; j<game->nof_players; j++)
    {
      i=sort[j];
      fph=(3600.0/game->player[i]->secs) * (double)game->player[i]->nof_frags;
      if (game->player[i]->nof_deaths)
	ttl=(double)game->player[i]->secs/(double)game->player[i]->nof_deaths;
      else ttl=game->player[i]->secs;
      sprintf(fname, "%02i_%s.html", gid, game->player[i]->name);
      write_SGPlayer(fname, game->player[i], gid);

      /* Now we set the bgcolor according to the team of the player*/
      if (game->type>2)
	{
	  color=2*game->player[i]->b_blue;
	  color+=game->player[i]->b_red;
	  fprintf(fp, "<tr bgcolor=%s>\n",
		  (color<3)?(team_color[color]):(team_color[0]));

	}else{
	  fprintf(fp, "<tr bgcolor=#222222>\n");
	}
      fprintf(fp, "<td align=center><a href=\"%s\">%s</a></td>\n",
	      fname, game->player[i]->name);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->handicap);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->ping);
      fprintf(fp, "<td align=center>%i:%02i</td>\n",
	      game->player[i]->secs/60, game->player[i]->secs%60);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_kills);
      if (game->type>2)
	fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_tkills);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_deaths);
      fprintf(fp, "<td align=center>%i</td>", game->player[i]->nof_suicides);
      fprintf(fp, "<td align=center>%i</td><td align=center>%2.2f</td>\n",
	      game->player[i]->nof_items, fph);
      fprintf(fp, "<td align=center>%2.2f</td>\n", ttl);
      fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->nof_frags);
      if (game->type==4)
	fprintf(fp, "<td align=center>%i</td>\n", game->player[i]->score);
      fprintf(fp, "</tr>\n");
    }
  fprintf(fp, "</table></center><br><br>\n");
}


/* Kill-table for direct compares with the opponents
   If playing team-games the team-color will be used as the background.*/
void write_SGKillTable(FILE *fp, t_game *game)
{
  int i, j, color;

  fprintf(fp, "<center><h3>Kill-Stats for the individual players</h3></center>\n");
  fprintf(fp, "<center><table bgcolor=%s border=0 cellpadding=0 cellspacing=0 bordercolor=#000>\n<tr bgcolor=%s>\n", color_bg_killtable, color_bgt_heads);
  fprintf(fp, "<td bgcolor=#000000></td>\n");
  for (i=0; i<game->nof_players; i++) {
    fprintf(fp, "<td valign=bottom align=center bgcolor=#000 width=30>");
    for (j=0; j<strlen(game->player[i]->name); j++)
      fprintf(fp, "%c", game->player[i]->name[j]);
    fprintf(fp, "</td>");
  }
  fprintf(fp, "</tr>\n");
  for (i=0; i<game->nof_players; i++)
    {
      color=2*game->player[i]->b_blue;
      color+=game->player[i]->b_red;

      fprintf(fp,"</tr><tr><td align=right height=30 ");
      fprintf(fp, "bgcolor=%s>%s</td>\n",
	      (color<3)?(team_color[color]):(team_color[0]),
	      game->player[i]->name);
      for (j=0; j<game->nof_players; j++)
	{
	  if (i==j)
	    fprintf(fp, "<td align=center bgcolor=%s>%i</td>",
		    color_suicide, game->player[i]->lst_kills[j]);
	  else
	    fprintf(fp, "<td align=center>%i</td>",
		    game->player[i]->lst_kills[j]);
	}
    }
  fprintf(fp, "</tr></table></center><br><br><br>\n");
}


/* writes the weapon-table into the file*/
void write_SGWeapons(FILE *fp, t_game *game)
{
  int i, cols=3, sort[NOF_WEAPS];
  
  fprintf(fp, "<br><center><h3>The most deadly weapons</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(game->weaps, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (game->weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], game->weaps[sort[i]]);
       cols--;
       if (cols<1) {
	 cols=3;
	 fprintf(fp, "</tr><tr>\n");
       }
    }
  fprintf(fp, "</tr></table></center>\n");
}

/* writes the suicide weapons-table into the file*/
void write_SGSuicWeapons(FILE *fp, t_game *game)
{
  int i, cols=3, sort[NOF_WEAPS];

  fprintf(fp, "<br><center><h3>The most self-killing weapons</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(game->wsui, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (game->wsui[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], game->wsui[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");
}

/* writes the tkill-weapons-table into the file*/
void write_SGTKillWeapons(FILE *fp, t_game *game)
{
  int i, cols=3, sort[NOF_WEAPS];

  fprintf(fp, "<br><center><h3>The most teammate-killing weapons</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(game->wtkill, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (game->wtkill[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], game->wtkill[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");
}

/* writes the pickup-table into the file*/
void write_SGPickups(FILE *fp, t_game *game)
{
  int i,j,cols=3, sort[NOF_ITEMS], items[NOF_ITEMS];
  
  fprintf(fp, "<br><br><center><h3>Pickup Statistics</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_items);
  
  for (i=0; i<NOF_ITEMS; i++)
    {
      items[i]=0;
      for(j=0; j<game->nof_players; j++)
	items[i]+=game->player[j]->lst_items[i];
    }
  
  sort_items(items, sort);
  
  for (i=0; i<NOF_ITEMS; i++)
    {
      if (items[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_items_nice[sort[i]], items[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");
}



/*
 writes a SINGLE GAME into one HTML-file
*/
int write_SGHTML(char *filename, t_game *game, int gid)
{
  FILE   *fp=fopen(filename, "wt");

  /* simple Header */
  if (fp==NULL) exit_error("Cant open file for writing");
  fprintf(fp, "<html><head><title>Quake 3 - %s</title></head>\n",
	  game->mapname);
  fprintf(fp, "<body bgcolor=%s text=%s link=%s vlink=%s>\n",
	  color_bg_game, color_text_game, color_text_game, color_text_game);
  fprintf(fp, "<center><h1>Map %s</h1></center>\n", game->mapname);

  write_SGStats(fp, game);
  write_SGStatsAll(fp, game);
  if (game->type==3 || game->type==4)
    write_SGTeamScore(fp, game);
  if (game->type==4)
    write_SGCTF(fp, game);

  write_timeline(fp, game, gid);
  write_SGRanks(fp, game, gid);
  write_SGKillTable(fp, game);
  if (game->nof_kills)
    write_SGWeapons(fp, game);
  if (game->nof_suicides)
    write_SGSuicWeapons(fp, game);
  if (game->nof_tkills)
    write_SGTKillWeapons(fp, game);
  write_SGPickups(fp, game);

  write_HPJ(fp);
  fprintf(fp, "</body></html>\n");
  fclose(fp);
  return 1;
}




















/*
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 FUNCTIONS for ALL-GAMES - stuff
 *
 *
 */
void write_AGWeapons(FILE *fp, t_game **games, int nof_games)
{
  int i, j, cols=3;
  int     sort[NOF_WEAPS], weaps[NOF_WEAPS];

  /* some header-code, then count together all ever used weapons */
  fprintf(fp, "<center><h3>used weapons for kills</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 bordercolor=#333333 width=600><tr>\n", color_bgt_allweaps);
  for (i=0; i<NOF_WEAPS; i++)
    {
      weaps[i]=0;
      for(j=0; j<nof_games; j++)
	weaps[i]+=games[j]->weaps[i];
    }

  sort_weaps(weaps, sort);
  //sort_things(weaps, sort, (char **)c_weaps, NOF_WEAPS);

  /* display the sorted list */
  for (i=0; i<NOF_WEAPS; i++)
    {
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]],weaps[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");
}

void write_AGPickups(FILE *fp, t_game **game, int nof_games)
{
  int i,j,k, cols=3;
  int sort[NOF_ITEMS], items[NOF_ITEMS];

  /* show the header, then sum up the items */
  fprintf(fp, "<center><h3>Pickup Statistics</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=#000033 border=1 bordercolor=#333333 width=600><tr>\n");
  for (i=0; i<NOF_ITEMS; i++)
    {
      items[i]=0;
      for(j=0; j<nof_games; j++)
	for(k=0; k<game[j]->nof_players; k++)
	  items[i]+=game[j]->player[k]->lst_items[i];
    }

  sort_items(items, sort);

  /* display the stuff */
  for (i=0; i<NOF_ITEMS; i++)
    {
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_items_nice[sort[i]], items[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");
}


/* results for ALL GAMES in queue */
void write_AGHTML(t_game **games, int nof_games)
{
  int     i, kills=0, frags=0, deaths=0, suicides=0, items=0, sec=0, says=0;
  double  fph;
  FILE   *fp=fopen("all_games.html", "wt");
  if (fp==NULL) exit_error("all_games.html could not be opened for writing\n");

  fprintf(fp, "<html><head><title>Q3 - All-time statistics</title></head>\n");
  fprintf(fp, "<body bgcolor=%s text=%s>\n",
	  color_bg_allgame, color_text_allgame);
  fprintf(fp, "<center><h1>All-time stats</h1></center><br><br>\n");

  for(i=0; i<nof_games; i++) {
    frags+=games[i]->nof_frags;
    kills+=games[i]->nof_kills;
    deaths+=games[i]->nof_deaths;
    suicides+=games[i]->nof_suicides;
    items+=games[i]->nof_items;
    sec+=games[i]->secs;
    says+=games[i]->nof_says;
  }
  fph=3600.0/sec * frags;
  fprintf(fp, "<center><table bgcolor=000033 border=1 width=100%%>\n<tr>\n");
  fprintf(fp, "<th>Time played</th><th>Kills</th><th>Suicides</th><th>Frags</th><th>FPH</th><th>Deaths</th><th>Pickups</th><th>Says</th></tr>\n");
  fprintf(fp, "<td align=center>%02i:%02i:%02i</td>\n<td align=center>%i</td>",
	  sec/3600, (sec%3600)/60, sec%60, kills);
  fprintf(fp, "<td align=center>%i</td>\n<td align=center>%i</td>\n<td align=center>%2.2f</td>", suicides, frags, fph);
  fprintf(fp, "<td align=center>%i</td>\n", deaths);
  fprintf(fp, "<td align=center>%i</td>\n", items);
  fprintf(fp, "<td align=center>%i</td>\n", says);
  fprintf(fp, "</tr></table><br><br><br>");

  write_AGWeapons(fp, games, nof_games);
  write_AGPickups(fp, games, nof_games);

  write_HPJ(fp);
  fprintf(fp, "</body></html>");
  fclose(fp);
}





/*
 *
 *
 FUNCTIONS FOR WRITING THE ALL-TIME PLAYER-STATS
 *
 *
 */
/* writes all-time player info */
void write_ATPlayer(char *filename, t_ltp *ltp)
{
  int   i, cols=3, sort[NOF_WEAPS], isort[NOF_ITEMS];
  FILE *fp=fopen(filename, "wt");
  if (fp==NULL) {fprintf(stderr, "failure writing to \"%s\"",filename);return;}

  fprintf(fp,"<html>\n<head><title>%s - all-time statistics</title></head>\n",
	  ltp->name);
  fprintf(fp, "<body bgcolor=%s text=%s>\n", "#000", "#DDDD99");
  fprintf(fp, "<br><br><center><h1>%s</h1></center>\n", ltp->name);


  /* normal weapon-use*/
  cols=3;
  fprintf(fp, "<br><center><h3>Weapons used</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(ltp->weaps, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (ltp->weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], ltp->weaps[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  /* Suicide-weaps*/
  cols=3;
  fprintf(fp,"<br><center><h3>Weapons, best for self-killing</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(ltp->wsui, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (ltp->wsui[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], ltp->wsui[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  /* Team-Kill-Weaps*/
  cols=3;
  fprintf(fp, "<br><center><h3>Weapons, teammates were killed with</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(ltp->wtkill, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (ltp->wtkill[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], ltp->wtkill[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  /* Pickups */
  cols=3;
  fprintf(fp, "<br><center><h3>Items picked up</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_items);
  sort_items(ltp->items, isort);
  for (i=0; i<NOF_ITEMS; i++)
    {
      if (ltp->items[isort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_items_nice[isort[i]], ltp->items[isort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  fprintf(fp, "</body>\n</html>\n");
  fclose(fp);
}

/* Write all-player info to file */
void write_APHTML(t_game **games, int nof_games)
{
  int     i, j, sort[MAX_LT_PLAYER], todo;
  char    fname[1024];
  double  fph, ttl;
  t_lts  *lts=new_ltStat();
  t_ltp  *ltp;

  FILE *fp=fopen("all_players.html", "wt");
  if (fp==NULL)
    {
      fprintf(stderr, "cannot open \"all_players.html\" for writing\n");
      return;
    }

  for (i=0; i<nof_games; i++)
    add_game(lts, games[i]);

  for (i=0; i<lts->nof_players; i++)
    sort[i]=i;

  todo=1;
  while(todo)
    {
      todo=0;
      for (i=0; i<lts->nof_players-1; i++)
	{
	  if (lts->ltplayers[sort[i]]->nof_frags <
	      lts->ltplayers[sort[i+1]]->nof_frags)
	    {
	      j=sort[i];
	      sort[i]=sort[i+1];
	      sort[i+1]=j;
	      todo=1;
	    }
	}
    }
  
  fprintf(fp, "<html>\n<head>\n");
  fprintf(fp, "<title>Quake 3 - All-time players stats</title>");
  fprintf(fp, "</head>\n\n<body bgcolor=%s text=%s>",
	  color_bg_allplayers, color_text_allplayers);
  fprintf(fp, "<center><h1>All players ever logged</h1></center><br>\n");

  fprintf(fp, "<table width=100%% bgcolor=#000033 border=1 bordercolor=#330000>");
  fprintf(fp, "\n<tr><th>Name</th>");
  fprintf(fp, "<th>Time</th>");
  fprintf(fp, "<th>Kills</th>");
  fprintf(fp, "<th>Suicides</th><th>Teamkills</th><th>Frags</th>");
  fprintf(fp, "<th>FPH</th><th>TTL</th>\n");
  fprintf(fp, "<th>Items</th><th>Talks</th><th>SOS</th>\n");
  for (i=0; i<lts->nof_players; i++)
    {
      ltp=lts->ltplayers[sort[i]];
      fph=(3600.0/ltp->secs) * (double)ltp->nof_frags;
      if (ltp->nof_deaths)
	ttl=(double)ltp->secs/ltp->nof_deaths;
      else ttl=ltp->secs;
      sprintf(fname, "all_%s.html", ltp->name);
      write_ATPlayer(fname, ltp);

      fprintf(fp, "\n<tr>");
      fprintf(fp, "<td align=right><a href=\"%s\">%s</a></td>",
	      fname, ltp->name);
      fprintf(fp, "<td align=center>%i:%02i:%02i</td>",
	      ltp->secs/3600, (ltp->secs%3600)/60, ltp->secs%60);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_kills);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_suicides);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_tkills);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_frags);
      fprintf(fp, "<td align=center>%2.2f</td>", fph);
      fprintf(fp, "<td align=center>%2.2f</td>", ttl);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_items);
      fprintf(fp, "<td align=center>%i</td>", ltp->nof_says);
      fprintf(fp, "<td align=center>%2.0f</td>",
	      (ltp->nof_says)?((double)ltp->secs/ltp->nof_says):(0));
      fprintf(fp, "</tr>\n");
    }
  fprintf(fp, "</table>\n");
  write_HPJ(fp);
  fprintf(fp, "</body>\n</html>");
  fclose(fp);

  save_stats("alltime.q3l", lts);
}











/*
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 READ COLORS FROM THE "colors.ini"
 *
 *
 */
void read_colors(void)
{
  char  line[128], color[128];
  FILE *fp=fopen("colors.ini", "rt");
  if (fp==NULL) return;

  while(!feof(fp))
    {
      fscanf(fp, "%s", line);
      if (feof(fp)) break;
      /* filter some comments */
      if (strcmp(line, "//")==0)
	while(!feof(fp) && strcmp(line, "//")==0)
	  fscanf(fp, "%s", line);

      fscanf(fp, "%s", color);

      if (strcmp(line, "bg_index")==0)
	strncpy(color_bg_index, color, 7);
      if (strcmp(line, "text_index")==0)
	strncpy(color_text_index, color, 7);
      if (strcmp(line, "link_index")==0)
	strncpy(color_link_index, color, 7);
      if (strcmp(line, "vlink_index")==0)
	strncpy(color_vlink_index, color, 7);

      if (strcmp(line, "suicide")==0)
	strncpy(color_suicide, color, 7);

      if (strcmp(line, "red_team")==0)
	strncpy(team_color[1], color, 7);
      if (strcmp(line, "blue_team")==0)
	strncpy(team_color[2], color, 7);

      if (strcmp(line, "bg_allgame")==0)
	strncpy(color_bg_allgame, color, 7);
      if (strcmp(line, "text_allgame")==0)
	strncpy(color_text_allgame, color, 7);

      if (strcmp(line, "bg_allplayer")==0)
	strncpy(color_bg_allplayers, color, 7);
      if (strcmp(line, "text_allplayer")==0)
	strncpy(color_text_allplayers, color, 7);

      if (strcmp(line, "bg_game")==0)
	strncpy(color_bg_game, color, 7);
      if (strcmp(line, "text_game")==0)
	strncpy(color_text_game, color, 7);

      if (strcmp(line, "bgt_items")==0)
	strncpy(color_bgt_items, color, 7);
      if (strcmp(line, "bgt_weapons")==0)
	strncpy(color_bgt_weaps, color, 7);

      if (strcmp(line, "bgt_stats")==0)
	strncpy(color_bgt_stats, color, 7);
      if (strcmp(line, "tableheads")==0)
	strncpy(color_bgt_heads, color, 7);


    }
  fclose(fp);
  fprintf(stderr, "using colors from \"colors.ini\"\n");
}




/*
 *
 *
 MAIN - FUNCTION (and the only exported function)
 *
 *
 */
int write_html(t_game **game, int nof_games)
{
  int        i, j, k, cols=3, sum, t;
  char       fname[256];
  struct tm *s_tm;
  time_t     s_time;
  FILE      *fp;

  read_colors();

  if (chdir("Html_log")==-1)
    {
      fprintf(stderr, "failed to change to \"Html_log\"\n");
      return 0;
    }

  /* write the header and the simple HeadLine*/
  fp=fopen("index.html", "wt");
  fprintf(fp, "<html><head><title>Quake 3 - Logs</title></head>\n");
  fprintf(fp, "<body bgcolor=%s text=%s link=%s vlink=%s>\n",
	  color_bg_index, color_text_index, color_link_index,
	  color_vlink_index);
  fprintf(fp, "<center><h1>Quake 3 - Logs</h1></center><br><br><br>\n");

  /* now we sum the frags, then we display them with a GIF-counter*/
  sum=0;
  for(i=0; i<nof_games; i++)
    sum+=game[i]->nof_frags;
  fprintf(fp, "<center><table><tr>\n<td>");
  fprintf(fp, "<img src=\"pix/frame1_l.jpg\" align=left width=200></td><td align=center>\n");
  i=sum;
  for (j=8; j>=0; j--)
    {
      t=pow(10,j);
      if (t>i)
	{
	  if (t<=sum) fprintf(fp, "<img src=\"pix/0.gif\">");
	  continue;
	}
      k=9;
      while (k*t > i)
	k--;
      i-=k*t;
      fprintf(fp, "<img src=\"pix/%i.gif\">", k);
    }
  fprintf(fp, "<br><a href=\"all_games.html\"><img src=\"pix/skull.jpg\" align=center border=0></a><br>\n");
#if (DEBUG_LEVEL>0)
  fprintf(stderr, "\n*%i frags*\n", sum);
#endif
  fprintf(fp, "and still counting ...<br>");
  s_time=time(&s_time);
  s_tm=localtime(&s_time);
  fprintf(fp, "last update %02i.%02i.%s%02i - %02i:%02i:%02i</td><td>", s_tm->tm_mday, s_tm->tm_mon+1, (s_tm->tm_year>99)?"20":"19", s_tm->tm_year%100,s_tm->tm_hour, s_tm->tm_min, s_tm->tm_sec);

  fprintf(fp, "<img src=\"pix/frame1_r.jpg\" align=right width=200></td></tr></table></center><br>\n");

  /* now we add the link to all-time players */
  fprintf(fp, "<center><table width=50%%><tr>");
  fprintf(fp, "<td width=33%% align=right><a href=\"all_players.html\">All-time players</a></td>");
  fprintf(fp, "<td width=33%% align=center><a href=\"pix/help.html\">Help</a></td>\n");
  fprintf(fp, "<td width=33%% align=left><a href=\"all_games.html\">All-time games</a></td>");
  fprintf(fp, "</tr></table></center><br>\n");

  /* a short overview of the games currently available for viewing
     Watch out !! While writing this to index.html there is
     a second file open (with the currently parsed game) !!*/
  fprintf(fp, "<center><table width=80%% border=1 bgcolor=#000033 bordercolor=#000>\n<tr>\n");
  for (i=0; i<nof_games; i++)
    {
      fprintf(stderr, "%02i ", i);
      sprintf(fname, "g_%03i.html", i);
      fprintf(fp,"<td width=33%%><a href=\"%s\">Game %i</a> on %s (%s)</td>\n",
	      fname, i, game[i]->mapname, c_gamemodes_s[(int)game[i]->type]);
      write_SGHTML(fname, game[i], i);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr>\n<tr>\n");
      }
    }
  fprintf(stderr,"\n");
  fprintf(fp, "</tr></table></center>\n<br><br>\n");

  write_HPJ(fp);
  fprintf(fp, "</body></html>\n");
  fclose(fp);

  /* write the ALL-TIME stats */
  write_AGHTML(game, nof_games);
  write_APHTML(game, nof_games);
  return 1;
}
