/* writes the weapon-table into the file*/
void write_sg_weapons(FILE *fp, t_game *game, int cols)
{
  int i, c,w, sort[NOF_WEAPS];
  
  sort_weaps(game->weaps, sort);
  if (game->weaps[sort[0]]<1)
    {
      fprintf(fp, "No kill");
      return ;
    }
  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (game->weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5, c_weaps[sort[i]], 5, game->weaps[sort[i]]);
       c--;
       if (c<1) {
	 c=cols;
	 fprintf(fp, "</tr><tr>\n");
       }
    }
  fprintf(fp, "</tr>\n");
}

/* writes the suicide weapons-table into the file*/
void write_sg_suicweapons(FILE *fp, t_game *game, int cols)
{
  int i, c, w,sort[NOF_WEAPS];

  sort_weaps(game->wsui, sort);
  if (game->wsui[sort[0]]<1)
    {
      fprintf(fp, "No suicides at this map.");
      return ;
    }
  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (game->wsui[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5,c_weaps[sort[i]], 5,game->wsui[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}

/* writes the tkill-weapons-table into the file*/
void write_sg_tkillweapons(FILE *fp, t_game *game, int cols)
{
  int i, c,w, sort[NOF_WEAPS];

  sort_weaps(game->wtkill, sort);
  if (game->wtkill[sort[0]]<1)
    {
      fprintf(fp, "No team-members killed.");
      return ;
    }
  if (cols<0) cols=3;
  c=cols;
  if (cols) w=100/cols;
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (game->wtkill[sort[i]]<1) break;
      fprintf(fp, "<td width=%i%%>%s</td><td width=%i%%>%i</td>\n",
	      w-5,c_weaps[sort[i]], 5,game->wtkill[sort[i]]);
      c--;
      if (c<1) {
	c=cols;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr>\n");
}
