/*
  Lets see if it gets a little bit more readable.

  $Id: html_creator.c,v 1.1 2000/01/03 16:04:02 jacobs Exp $

  $Log: html_creator.c,v $
  Revision 1.1  2000/01/03 16:04:02  jacobs
  Initial revision


*/

#include <string.h>
#include <time.h>
#include <unistd.h>
#include "lt_stats.h"
#include "html_creator.h"
#include "html_writers.h"
#include "tool.h"




/*
 *
 *
 READS THE COLORS from the "colors.ini".
 This is just used for non-template-output.
 *
 *
 */
void read_colors(void)
{
  char  line[128], color[128];
  FILE *fp=fopen("colors.ini", "rt");
  if (fp==NULL) return;

  while(!feof(fp))
    {
      fscanf(fp, "%s", line);
      if (feof(fp)) break;
      /* filter some comments */
      if (strcmp(line, "//")==0)
	while(!feof(fp) && strcmp(line, "//")==0)
	  fscanf(fp, "%s", line);

      fscanf(fp, "%s", color);

      if (strcmp(line, "bg_index")==0)
	strncpy(color_bg_index, color, 7);
      if (strcmp(line, "text_index")==0)
	strncpy(color_text_index, color, 7);
      if (strcmp(line, "link_index")==0)
	strncpy(color_link_index, color, 7);
      if (strcmp(line, "vlink_index")==0)
	strncpy(color_vlink_index, color, 7);

      if (strcmp(line, "suicide")==0)
	strncpy(color_suicide, color, 7);

      if (strcmp(line, "red_team")==0)
	strncpy(team_color[1], color, 7);
      if (strcmp(line, "blue_team")==0)
	strncpy(team_color[2], color, 7);

      if (strcmp(line, "bg_allgame")==0)
	strncpy(color_bg_allgame, color, 7);
      if (strcmp(line, "text_allgame")==0)
	strncpy(color_text_allgame, color, 7);

      if (strcmp(line, "bg_allplayer")==0)
	strncpy(color_bg_allplayers, color, 7);
      if (strcmp(line, "text_allplayer")==0)
	strncpy(color_text_allplayers, color, 7);

      if (strcmp(line, "bg_game")==0)
	strncpy(color_bg_game, color, 7);
      if (strcmp(line, "text_game")==0)
	strncpy(color_text_game, color, 7);

      if (strcmp(line, "bgt_items")==0)
	strncpy(color_bgt_items, color, 7);
      if (strcmp(line, "bgt_weapons")==0)
	strncpy(color_bgt_weaps, color, 7);

      if (strcmp(line, "bgt_stats")==0)
	strncpy(color_bgt_stats, color, 7);
      if (strcmp(line, "tableheads")==0)
	strncpy(color_bgt_heads, color, 7);


    }
  fclose(fp);
  fprintf(stderr, "using colors from \"colors.ini\"\n");
}


/* Writes the stats of a single player into the given file*/
void write_SGPlayer(char *filename, t_player *player, int gid)
{
  int   i, cols=3, sort[NOF_WEAPS], isort[NOF_ITEMS];
  FILE *fp=fopen(filename, "wt");
  if (fp==NULL) {fprintf(stderr, "failure writing to \"%s\"",filename);return;}

  fprintf(fp,"<html>\n<head><title>%s - Single-game statistics</title></head>\n",
	  player->name);
  fprintf(fp, "<body bgcolor=%s text=%s>\n", "#000", "#DDDD99");
  fprintf(fp, "<br><br><center><h1>%s</h1></center>\n", player->name);
  fprintf(fp, "<center>performance in fight %i</center><br><br>\n", gid);


  /* normal weapon-use*/
  cols=3;
  fprintf(fp, "<br><center><h3>Weapons used</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
  sort_weaps(player->weaps, sort);
  for (i=0; i<NOF_WEAPS; i++)
    {
      if (player->weaps[sort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_weaps[sort[i]], player->weaps[sort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  /* Suicide-weaps*/
  if (player->nof_suicides)
    {
      cols=3;
      fprintf(fp,"<br><center><h3>Weapons, best suicide</h3></center>\n");
      fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
      sort_weaps(player->wsui, sort);
      for (i=0; i<NOF_WEAPS; i++)
	{
	  if (player->wsui[sort[i]]<1) break;
	  fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
		  c_weaps[sort[i]], player->wsui[sort[i]]);
	  cols--;
	  if (cols<1) {
	    cols=3;
	    fprintf(fp, "</tr><tr>\n");
	  }
	}
      fprintf(fp, "</tr></table></center>\n");
    }

  /* Team-Kill-Weaps*/
  if (player->nof_tkills)
    {
      cols=3;
      fprintf(fp, "<br><center><h3>Weapons, teammates were killed with</h3></center>\n");
      fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_weaps);
      sort_weaps(player->wtkill, sort);
      for (i=0; i<NOF_WEAPS; i++)
	{
	  if (player->wtkill[sort[i]]<1) break;
	  fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
		  c_weaps[sort[i]], player->wtkill[sort[i]]);
	  cols--;
	  if (cols<1) {
	    cols=3;
	    fprintf(fp, "</tr><tr>\n");
	  }
	}
      fprintf(fp, "</tr></table></center>\n");
    }

  /* Pickups */
  cols=3;
  fprintf(fp, "<br><center><h3>Items picked up</h3></center>\n");
  fprintf(fp, "<center><table cellspacing=0 cellpadding=1 bgcolor=%s border=1 width=600><tr>\n", color_bgt_items);
  sort_items(player->lst_items, isort);
  for (i=0; i<NOF_ITEMS; i++)
    {
      if (player->lst_items[isort[i]]<1) break;
      fprintf(fp, "<td width=25%%>%s</td><td width=8%%>%i</td>\n",
	      c_items_nice[isort[i]], player->lst_items[isort[i]]);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr><tr>\n");
      }
    }
  fprintf(fp, "</tr></table></center>\n");

  fprintf(fp, "</body>\n</html>\n");
  fclose(fp);
}



/*
 writes a SINGLE GAME into one HTML-file
*/
int write_SGHTML(char *fname, t_game *game, int gid)
{
  FILE *fp=fopen(fname, "wt");
  /* simple Header */
  fprintf(fp, "<html><head><title>Quake 3 - %s</title></head>\n",
	  game->mapname);
  fprintf(fp, "<body bgcolor=%s text=%s link=%s vlink=%s>\n",
	  color_bg_game, color_text_game, color_text_game, color_text_game);
  fprintf(fp, "<center><h1>Map %s</h1></center>\n", game->mapname);

  write_sg_stats(fp, game);
  write_sg_stats_all(fp, game, NULL);
  if (game->type==3 || game->type==4)
    write_sg_teamstats(fp, game, NULL, NULL, NULL);
  if (game->type==4)
    write_sg_ctfstats(fp, game, NULL, NULL, NULL);

  write_sg_ctftimeline(fp, game, gid,NULL, NULL, NULL);
  //write_sg_ranks(fp, game, gid, NULL, NULL, NULL);
  write_sg_killtab(fp, game, NULL, NULL, NULL);
  if (game->nof_kills)
    write_any_weapons(fp, game->weaps, 3, 1);
  if (game->nof_suicides)
    write_any_weapons(fp, game->wsui, 3, 1);
  if (game->nof_tkills)
    write_any_weapons(fp, game->wtkill, 3, 1);
  write_any_items(fp, game->lst_items, 3, 1);

  write_HPJ(fp);
  fprintf(fp, "</body></html>\n");
  return 1;
}








int generate_HTML(t_game **games, int nof_games, char *dir, char *sfile)
{
  int        i, cols=3, sum;
  char       fname[256];
  struct tm *s_tm;
  time_t     s_time;
  FILE      *fp;
  t_lts     *lts;

  read_colors();
  lts=load_stats(sfile);

  if (chdir(dir)==-1)
    {
      fprintf(stderr, "failed to change to \"%s\"\n", dir);
      return 0;
    }

  /* write the header and the simple HeadLine*/
  fp=fopen("index.html", "wt");
  fprintf(fp, "<html><head><title>Quake 3 - Logs</title></head>\n");
  fprintf(fp, "<body bgcolor=%s text=%s link=%s vlink=%s>\n",
	  color_bg_index, color_text_index, color_link_index,
	  color_vlink_index);
  fprintf(fp, "<center><h1>Quake 3 - Logs</h1></center><br><br><br>\n");

  /* now we sum the frags, then we display them with a GIF-counter*/
  sum=0;
  for(i=0; i<nof_games; i++)
    sum+=games[i]->nof_frags;
  fprintf(fp, "<center><table><tr>\n<td>");
  fprintf(fp, "<img src=\"pix/frame1_l.jpg\" align=left width=200></td><td align=center>\n");

  write_counter_gfx(fp, sum);

  fprintf(fp, "<br><a href=\"all_games.html\"><img src=\"pix/skull.jpg\" align=center border=0></a><br>\n");
#if (DEBUG_LEVEL>0)
  fprintf(stderr, "\n*%i frags*\n", sum);
#endif
  fprintf(fp, "and still counting ...<br>");
  s_time=time(&s_time);
  s_tm=localtime(&s_time);
  fprintf(fp, "last update %02i.%02i.%s%02i - %02i:%02i:%02i</td><td>", s_tm->tm_mday, s_tm->tm_mon+1, (s_tm->tm_year>99)?"20":"19", s_tm->tm_year%100,s_tm->tm_hour, s_tm->tm_min, s_tm->tm_sec);

  fprintf(fp, "<img src=\"pix/frame1_r.jpg\" align=right width=200></td></tr></table></center><br>\n");

  /* now we add the link to all-time players */
  fprintf(fp, "<center><table width=50%%><tr>");
  fprintf(fp, "<td width=33%% align=right><a href=\"all_players.html\">All-time players</a></td>");
  fprintf(fp, "<td width=33%% align=center><a href=\"pix/help.html\">Help</a></td>\n");
  fprintf(fp, "<td width=33%% align=left><a href=\"all_games.html\">All-time games</a></td>");
  fprintf(fp, "</tr></table></center><br>\n");

  /* a short overview of the games currently available for viewing
     Watch out !! While writing this to index.html there is
     a second file open (with the currently parsed game) !!*/
  fprintf(fp, "<center><table width=80%% border=1 bgcolor=#000033 bordercolor=#000>\n<tr>\n");
  for (i=0; i<nof_games; i++)
    {
      fprintf(stderr, "%02i ", i);
      sprintf(fname, "g_%03i.html", i);
      fprintf(fp,"<td width=33%%><a href=\"%s\">Game %i</a> on %s (%s)</td>\n",
	      fname, i, games[i]->mapname, c_gamemodes_s[(int)games[i]->type]);
      write_SGHTML(fname, games[i], i);
      cols--;
      if (cols<1) {
	cols=3;
	fprintf(fp, "</tr>\n<tr>\n");
      }
    }
  fprintf(stderr,"\n");
  fprintf(fp, "</tr></table></center>\n<br><br>\n");

  write_HPJ(fp);
  fprintf(fp, "</body></html>\n");
  fclose(fp);

  /* write the ALL-TIME stats
  write_AGHTML(game, nof_games);
  write_APHTML(game, nof_games);*/
  return 1;
}
