/*
  Starting with writing a image to HD.

  $Id: gif.c,v 1.1 2000/01/03 16:04:02 jacobs Exp jacobs $

  $Log: gif.c,v $
  Revision 1.1  2000/01/03 16:04:02  jacobs
  Initial revision


*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "gif.h"
#include "bitstream.h"

#define LZW_LOOKUP 4096
#define LZW_STRLEN 4096


int isInList(char **list, int *len, char *string, int s_len)
{
  int i;

  for (i=0; i<LZW_LOOKUP; i++)
    {
      if ((list[i]==NULL) && (i!=256) && (i!=257)) return -1;
      else
	if ((s_len==len[i]) && (memcmp(list[i], string, s_len)==0))
	  return i;
    }
  return -1;
}

int listLen(char **list)
{
  int i, summe=0;
  for(i=0;i<LZW_LOOKUP; i++)
    if (list[i]!=NULL) summe++;
  return summe;
}

int resetList(char **list, int *len)
{
  int  i;
  char tmp[LZW_STRLEN];

  for (i=0; i<LZW_LOOKUP; i++)
    {
      if (list[i]!=NULL) free(list[i]);
      list[i]=NULL;
      len[i]=0;
      if (i<256)
	{
	  sprintf(tmp, "%c", i);
	  list[i]=strdup(tmp);
	  len[i]=1;
	}
    }
  return 1;
}


int getFirstFreePos(char **lookup)
{
  int i;
  for (i=0; i<LZW_LOOKUP; i++)
    if (lookup[i]==NULL && i!=256 && i!=257)
      return i;
  return -1;
}



int write_lzw(char *fname, char *mem, int mem_len)
{
  char  *lookup[LZW_LOOKUP];
  char  *string;
  int    opos,strpos, bitlen, i, bytes, bcounter;
  unsigned long lastpos;
  int    listindex, oldindex;
  int    len[LZW_LOOKUP];
  t_bs  *bs=new_bitstream();

  string=(char *)malloc(sizeof (char) * LZW_STRLEN);
  if (string==NULL) return -1;

  openOutS(bs, fname, "r+b");
  bs_seek(bs, 0, 2);

  memset(lookup,0,sizeof(char *)*LZW_LOOKUP);
  memset(len,0,sizeof(int)*LZW_LOOKUP);
  resetList(lookup, len);
  fprintf(stderr, "reset at 0x%02x\n", (unsigned int)ftell(bs->fout));
  lastpos=ftell(bs->fout);
  fprintf(bs->fout, "%c", 0);
  fprintf(stderr, "running coding at 0x%02x, lastpos=0x%02x\n",
	  (unsigned int)ftell(bs->fout), (unsigned int)lastpos);
  memset(string,0, LZW_STRLEN);

  bcounter=0;
  bitlen=9;
  opos=0;
  strpos=0;
  //putBits(bs, 256, 9);
  putBits(bs, 0, 9);
  putBits(bs, 258, 9);
  putBits(bs, 0, 9);
  putBits(bs, 257, 9);
  bs_flush(bs);
  fseek(bs->fout, lastpos,0);
  bytes=5;
  fwrite(&bytes,1,1,bs->fout);
  fseek(bs->fout,0,2);
  closeOutS(bs);
  del_bitstream(bs);
  return 1;

  /*  string[0]=mem[0];
  opos=1;
  strpos=1;
  oldindex=mem[0];*/
  while (opos<mem_len)
    {
      string[strpos]=mem[opos];
      listindex=isInList(lookup, len, string, strpos+1);
      while(listindex>=0) //-2 ? -1
	{
	  opos++;
	  strpos++;
	  //fprintf(stderr, "* ");
	  string[strpos]=mem[opos];
	  oldindex=listindex;
	  listindex=isInList(lookup, len, string, strpos+1);
	  if (opos==mem_len-1) break;
	}
      if (opos>=mem_len-1 && listindex>=0)
	{
	  /* This is the end, my only friends, the end.*/
	  fprintf(stderr, "final index : %i (%i pixels)\n",
		  oldindex, len[oldindex]);
	  bcounter+=len[oldindex];
	  putBits(bs, oldindex, bitlen);
	  break;
	}
      /*fprintf(stderr, "%i-%i,  strlen %i,  index %i -> %i strings in list\n",
	opos,mem_len,strpos+1,oldindex,listLen(lookup));*/

      /* create new entry */
      listindex=getFirstFreePos(lookup);
      if (listindex<0)
	{
	  /* table full, reset the damn thing */
	  fprintf(stderr, "reset table\n");
	  resetList(lookup, len);
	  opos-=strlen(string)-1;
	  memset(string,0,LZW_STRLEN);
	  string[0]=mem[opos++];
	  oldindex=isInList(lookup, len, string, strpos);
	  string[1]=mem[opos];
	  listindex=257;
	  putBits(bs, 256, bitlen);
	  bitlen=9;
	} else {
	  //fprintf(stderr, "B");
	  for(i=9; i<12; i++)
	    {
	      //fprintf(stderr, "%i <-> %i\n", (int)pow(2,i),listindex);
	      if ((int)pow(2,i)==listindex)
		{
		  fprintf(stderr, "bitlen changed\n");
		  bitlen=i+1;
		}
	    }
	}
      for (i=0; i<len[oldindex];i++)
	fprintf(stderr, "%i ", lookup[oldindex][i]);
      fprintf(stderr, "\n");
      printf("putting %i to file (%i pixel), adding %i (%i pixel) - opos:%i\n",
	     oldindex, len[oldindex], listindex, len[listindex], opos);
      bcounter+=len[oldindex];
      putBits(bs, oldindex, bitlen);
      if (bs->bwritten>252)
	{
	  /* flush it to disk */
	  bs_flush(bs);
	  fseek(bs->fout, lastpos,0);
	  bytes=bs->bwritten;
	  fprintf(stderr, "%i bytes written to LZW-block @ 0x%02x\n",
		  bytes, (unsigned int)lastpos);
	  fprintf(bs->fout, "%c", bytes);
	  fseek(bs->fout,0,2);
	  lastpos=ftell(bs->fout);
	  fprintf(bs->fout, "%c", 0);
	}
      lookup[listindex]=(char *)malloc(strpos+1);
      memcpy(lookup[listindex], string, strpos+1);
      len[listindex]=strpos+1;
      strpos=0;
    }

  putBits(bs, 257, bitlen);
  bs_flush(bs);
  fseek(bs->fout, lastpos,0);
  bytes=bs->bwritten;
  fprintf(stderr, "%i bytes (%i/%i pixel) written to final block @ 0x%02x\n",
	  bytes, bcounter, mem_len,(unsigned int)lastpos);
  fprintf(bs->fout, "%c", bytes);
  fseek(bs->fout,0,2);
  closeOutS(bs);
  bs=del_bitstream(bs);
  for (i=0; i<LZW_LOOKUP; i++)
    if (lookup[i]!=NULL) free(lookup[i]);
  free(string);
  return 1;
}


int write_img(char *fname, char *mem, short w, short h, char *pal)
{
  short  bla=75;
  FILE  *fp=fopen(fname, "wb");
  if (fp==NULL) return -1;

  /* ID  6 */
  fwrite("GIF87a", 6, 1, fp);
  /* LDB - logical screen descriptor 7 */
  fwrite(&w,2,1,fp);
  fwrite(&h,2,1,fp);
  fprintf(fp, "%c%c%c", 0xf7,0,0);
  /* PAL  768 */
  //fprintf(stderr, "%02x", (unsigned int) ftell(fp));
  fwrite(pal, 1, 768, fp);
  /* IDB - image descriptor 10 */
  bla=0;
  fwrite(",", 1,1,fp);
  fwrite(&bla,2,1,fp); //links
  fwrite(&bla,2,1,fp); //oben
  fwrite(&w,2,1,fp);   //breite
  fwrite(&h,2,1,fp);   //hoehe
  fprintf(fp,"%c",0);

  /* write image-data */
  fprintf(fp, "%c", 8); //code-size
  //fprintf(stderr, "lzw-data starts @ 0x%02x\n", (unsigned int) ftell(fp));
  fclose(fp);

  //return 1;
  write_lzw(fname, mem, w*h);

  /* close GIF-file */
  fp=fopen(fname, "a+b");
  fseek(fp, 0,2);
  fprintf(fp, "%c;",0);
  fclose(fp);
  return 1;
}





int read_gif(char *fname)
{
  unsigned char mem[1024], l;
  short         w, h;

  FILE *fp=fopen(fname, "rb");
  if (fp==NULL)
    return -1;

  fread(mem,6,1,fp);
  mem[6]=0;
  printf("ID   : %s\n", mem);
  /* LDB */
  fread(mem,7,1,fp);
  w=mem[1]*256+mem[0];
  h=mem[3]*256+mem[2];
  printf("Flag : %i  (%i x %i)\n", (unsigned int)mem[4],w,h);
  printf("BpP  : %i, %i\n", (mem[4]&7)+1 , ((mem[4]&112)>>4)+1);
  if (mem[4] >127)
    {
      fread(mem,768,1,fp);
      printf("PAL  : global\n");
    }

  fread(&mem[0],1,1,fp);
  while (mem[0]!=0x2c)
    {
      printf("%c --> ", mem[0]);
      getchar();
      if (mem[0]=='!')
	{
	  fread(&mem[1],1,1,fp);
	  w=1;
	  while(w>0)
	    {
	      fread(&w,1,1,fp);
	      printf("Ext  : '%c' (code %i), len=%i\n", mem[0],mem[1],w);
	      fread(&mem[1],w,1,fp);
	      //printf("%s\n", mem);
	    }
	}
      fread(&mem[0],1,1,fp);
    }

  /* IDB */
  printf("IDB found\n");
  fread(&w,2,1,fp); //links
  fread(&h,2,1,fp); //oben
  printf("Offs : %i, %i\n", w,h);
  fread(mem,2,1,fp);   //breite
  w=mem[1]*256 + mem[0];
  fread(mem,2,1,fp);   //hoehe
  h=mem[1]*256 + mem[0];
  fread(mem,1,1,fp);
  printf("Size ; %i x %i\n", w, h);

  /* LZW - DATA */
  fread(mem,1,1,fp);
  printf("BpP  : %i\n", mem[0]);

  fread(&l,1,1,fp);
  while (l!=0)
    {
      printf(" %i", l);
      fread(mem, l,1,fp);
      fread(&l,1,1,fp);
    }
  fread(mem,1,1,fp);
  printf(" -> %c\n", mem[0]);
  fclose(fp);
  return 1;
}

