/* This file provides a simple bitstream from/to a file.

   converted from C++

   $Id: bitstream.h,v 1.1 2000/01/03 16:04:02 jacobs Exp jacobs $

   $Log: bitstream.h,v $
   Revision 1.1  2000/01/03 16:04:02  jacobs
   Initial revision

*/
#ifndef __BIT_STREAM_H__
#define __BIT_STREAM_H__

#include <stdio.h>

typedef struct {
  FILE *fin, *fout;
  char  inchar, inpos;
  char  outchar, outpos;
  int   bwritten;
}t_bitstream, t_bs;


/* create a clean struct and remove it */
t_bs *new_bitstream(void);
t_bs *del_bitstream(t_bs *bs);

int   openOutS(t_bs *bs, char *filename, char *format);
int   openInS(t_bs *bs, char *filename);
int   closeOutS(t_bs *bs);
int   closeInS(t_bs *bs);

int   putBits(t_bs *bs, long int code, long int counter);
long  getBits(t_bs *bs, long int counter);

int   bs_flush(t_bs *bs);
int   bs_seek(t_bs *bs, int pos, int rel);
#endif
