/* This file was converted from C++.
   Historically I wrote first the C++-class, the converted it back to C
   because of the Q3_LogGen - Project (lcc-win32 just compiled C, so for
   compatibility .. 

   $Id: bitstream.c,v 1.1 2000/01/03 16:04:02 jacobs Exp jacobs $

   $Log: bitstream.c,v $
   Revision 1.1  2000/01/03 16:04:02  jacobs
   Initial revision


*/
#include <stdio.h>
#include <stdlib.h>
#include "bitstream.h"


/* little helper for nasty exp-function */
long exp(long int bit) {
  long int ret=1;
  while (bit-->0) ret=ret<<1;
  return ret;
}

/* looks like OOP ?? Well.. its a constructor !!*/
t_bs *new_bitstream(void )
{
  t_bs *bs=(t_bs *)malloc(sizeof(t_bs));
  if (bs==NULL) return NULL;
  bs->fin=NULL;
  bs->fout=0;
  return bs;
}

t_bs *del_bitstream(t_bs *bs)
{
  if (bs==NULL) return NULL;
  closeOutS(bs);
  closeInS(bs);
  free(bs);
  return NULL;
}



/* File-functions, open, close for Out-Streams, flush is just for OutStreams */
int openOutS(t_bs *bs, char *filename, char *format) {
  bs->fout=fopen(filename, format);
  if (bs->fout==NULL) return -1;
  bs->outchar=0;
  bs->outpos=7;
  bs->bwritten=0;
  return 0;
}

int closeOutS(t_bs *bs) {
  if (bs->fout==NULL) return -1;
  if (bs->outpos!=7)
    fputc(bs->outchar,bs->fout);
  fclose(bs->fout);
  bs->fout=NULL;
  return 0;
}

int bs_flush(t_bs *bs) {
  if (bs->outpos==7) return 0;
  fwrite(&bs->outchar, 1,1,bs->fout);
  fprintf(stderr, "%i ",(unsigned char)bs->outchar);
  bs->outchar=0;
  bs->outpos=7;
  bs->bwritten++;
  return 0;
}

int bs_seek(t_bs *bs, int pos, int rel)
{
  if (bs==NULL || bs->fout==NULL) return -1;
  fseek(bs->fout, pos, rel);
  return 1;
}

/* File-functions, open, close for Out-Streams */
int openInS(t_bs *bs, char *filename) {
  bs->fin=fopen(filename, "rb");
  if (bs->fin==NULL) return -1;
  bs->inchar=0;
  bs->inpos=0;
  return 0;
}

int closeInS(t_bs *bs) {
  if (bs->fin==NULL) return -1;
  fclose(bs->fin);
  bs->fin=NULL;
  return 0;
}




/* Write some bits to the file */
int putBits(t_bs *bs, long int code, long int counter) {
  //int i=0;
  counter--;
  while (counter>=0) {
    if (code&exp(counter))
      bs->outchar|=exp(bs->outpos);
    bs->outpos--;
    fprintf(stderr, "%i ", (int)counter);
    if (bs->outpos<0) {
      fwrite(&bs->outchar,1,1,bs->fout);
      fprintf(stderr, "(%i -> %i) ",(int)code,(unsigned char)bs->outchar);
      bs->outpos=7;
      bs->outchar=0;
      bs->bwritten++;
    }
    counter--;
  }
  fprintf(stderr, "\n");
  return 0;
}

/* Get the bits from the file */
long getBits(t_bs *bs, long int counter) {
  long int ret=0;
  if (feof(bs->fin)) {fprintf(stderr, "FEOF!\n");return -1;}
  while (counter>0) {
    counter--;
    bs->inpos--;
    if (bs->inpos<0) {
      bs->inpos=7;
      bs->inchar=(char)fgetc(bs->fin);
      if (feof(bs->fin)) return -1;
    }
    if (bs->inchar&exp(bs->inpos)) ret|=exp(counter);
  }
  return ret;
}
