#include "newproject.h"

/*
============
va

does a varargs printf into a temp buffer, so I don't need to have
varargs versions of all text functions.
FIXME: make this buffer size safe someday
============

Ripped from Quake2 source... I use this function in all my projects!
I did make one slight modification, I added an array of buffers, rather than one buffer.
*/
typedef char astring[1024];
#define VA_BUFFER_SIZE 20
char *va(char *format, ...)
{
	va_list		argptr;
  static int counter;
	static astring buffer[VA_BUFFER_SIZE];
	
	counter = (counter + 1) % VA_BUFFER_SIZE;

  va_start (argptr, format);
	vsprintf (buffer[counter], format,argptr);
	va_end (argptr);

  return buffer[counter];	
}

//generic print function..
void msg (char *text)
{
  printf("%s\n", text);
}

/*======
returns a 1 if a path exists
======*/
int direxists(char *path)
{
  char dir[1024];
  int retval;

  getcwd(dir, 1024);

  retval = chdir(path);
  
  //return to previous directory
  chdir(dir);

  return retval == 0;
}

//returns a 1 if a directory exists in a given path
int subdirexists(char *dir, char *path)
{
  return direxists(va("%s\\%s", path, dir));
}

//attempts to create a new directory
int createdir (const char *path)
{
  char *dir;
  char *pattern = "\\/"; //match \ and /
  char buffer[1024];
  char currentdir[1024];
  char newpath[1024];
  int once = 1;
  int retval;

  getcwd(currentdir, 1024);

  memset(buffer, 0, sizeof(buffer));
  memset(newpath, 0, sizeof(newpath));

  strcpy(buffer, path);

  do
  {
    if (once)
      dir = strtok(buffer, pattern);
    else
      dir = strtok(NULL, pattern);
    
    if (dir == NULL || strlen(dir) == 0)
      break;

    if (once)
      strcpy(newpath, dir);
    else
      strcpy(newpath, va("%s\\%s", newpath, dir));
    
    if (!direxists(newpath))
      mkdir(newpath);

    retval = chdir(newpath);
    
    if (retval)
      break;
    if (once)
      once = 0;
  } while (1);

  chdir(currentdir);
  return retval == 0;
}

//attempts to create a new directory in a given path
int createsubdir (const char *dir, const char *path)
{
  return createdir(va("%s\\%s", path, dir));
}


//returns the current working directory
void getbasepath (char *path, int length)
{
  getcwd(path, length);
}

//returns the path to the executable rather than the current working directory
void getexecutablepath (char *prog, char *path, int length)
{
  int size = strlen(prog);
  char *curr = prog;
  int i;
  static char errorpath[512] = "";
  static int error = 0;

  if (error)
  {
    strncpy(path, errorpath, size); //return the errorpath
    return;
  }
  
  if (strchr(prog, '\\') == NULL)
  {
    char drive;
    FILE *fp;

    msg(va("Error: \"%s\" is not a valid path", prog));
    msg("Please enter the drive letter newmod.exe that is installed on:");
    drive = getch();
    msg(va("Looking for newmod.exe in %c\\quake3\\bin_nt...", drive));

    if (direxists(va("%c:\\quake3\\bin_nt", drive)))
    {
      fp = fopen(va("%c:\\quake3\\bin_nt\\newmod.exe", drive), "r");
      if (fp == NULL)
      {
        msg(va("Error: %c:\\quake3\\bin_nt\\newmod.exe not found", drive));
        exit(1);
      }
      fclose(fp);

      msg(va("%c:\\quake3\\bin_nt\\newmod.exe found successfully", drive));
      strcpy(errorpath, va("%c:\\quake3\\bin_nt", drive));
      strncpy(path, errorpath, size); //return the errorpath
    } else {
      msg(va("Error: %c:\\quake3\\bin_nt not found", drive));
      exit(1);
    }
    
    error = 1;
    return;
    //exit(1); //this shouldn't happen...
  }
  
  for (i = 0; i < size && i < length - 1; i++)
    curr++;
  
  while (*curr != '\\')
  {
    curr--;
    size--;
  }

  strncpy(path, prog, size);

  curr = path;
  for (i = 0; i < size; i++)
    curr++;
  
  *curr = '\0';
}

typedef char oneline[512];

typedef struct {
  int lines;
  char **text;
} file_t;

void readfile (file_t *file, char *filename)
{
  FILE *fp;
  oneline buffer;
  int i = 0;

  memset(file, 0, sizeof(file_t));

  fp = fopen(filename, "r");

  while (fgets (buffer, sizeof(char) * sizeof(buffer), fp) != NULL)
    file->lines++;
  
  file->text = (char **) malloc(sizeof(char *) * file->lines);
  for (i = 0; i < file->lines; i++)
    file->text[i] = (char *) malloc(sizeof(char) * sizeof(oneline));

  //start at the beginning of the file
  fseek (fp, (long) 0, 0);

  i = 0;
  while (fgets (buffer, sizeof(char) * sizeof(buffer), fp) != NULL)
    strcpy((*file).text[i++], buffer);

  fclose(fp);
}

void savefile (file_t *file, char *filename)
{
  FILE *fp;
  int i;

  fp = fopen(filename, "w+");
  
  if (fp == NULL)
  {
    msg(va("couldn't open %s!?", filename));
    return;
  }

  for (i = 0; i < file->lines; i++)
  {
    if (file->text[i] != NULL && strlen(file->text[i]) > 0)
      fputs(file->text[i], fp);
  }

  fclose(fp);
}

int updatedefinition (char *filename_temp, char *definition, char *newvalue_temp)
{
  file_t file;
  int i;
  int found = 0;
  oneline filename;
  oneline newvalue;

  strcpy (filename, filename_temp);
  strcpy (newvalue, newvalue_temp);

  readfile (&file, filename);

  for (i = 0; i < file.lines; i++)
  {
    if (strncmp(file.text[i], va("#define %s ", definition), strlen(va("#define %s ", definition))) == 0 || //space, space
        strncmp(file.text[i], va("#define\t%s\t", definition), strlen(va("#define\t%s\t", definition))) == 0 || //tab, tab
        strncmp(file.text[i], va("#define\t%s ", definition), strlen(va("#define\t%s ", definition))) == 0 ||  //tab, space
        strncmp(file.text[i], va("#define %s\t", definition), strlen(va("#define %s\t", definition))) == 0)  //space, tab
    { //found a #define... time to update it
      strcpy(file.text[i], va("#define\t%s\t\"%s\"\n", definition, newvalue));
      found = 1;
      break; //assuming it is #define'ed only once
    }
  }

  savefile (&file, filename);

  return found;
}

