#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <time.h>
#include <stdarg.h>

typedef unsigned char 		byte;
#ifndef __cplusplus
typedef enum {false, true}	qboolean;
#else
typedef int qboolean;
#endif

#define MIP32_VERSION	4
#define PAL_SIZE		256
#define	MIPLEVELS		16

typedef struct miptex32_s
{
	int			version;
	char		name[128];
	char		altname[128];			// texture substitution
	char		animname[128];			// next frame in animation chain
	char		damagename[128];		// image that should be shown when damaged
	unsigned	width[MIPLEVELS], height[MIPLEVELS];
	unsigned	offsets[MIPLEVELS];		
	int			flags;
	int			contents;
	int			value;
	float		scale_x, scale_y;
	int			mip_scale;

	// detail texturing info
	char		dt_name[128];		// detailed texture name
	float		dt_scale_x, dt_scale_y;
	float		dt_u, dt_v;
	float		dt_alpha;
	int			dt_src_blend_mode, dt_dst_blend_mode;

	int			flags2;
	float		damage_health;

	int			unused[18];				// future expansion to maintain compatibility with h2
} miptex32_t;


typedef struct _TargaHeader
{
	unsigned char 	id_length, colormap_type, image_type;
	unsigned short	colormap_index, colormap_length;
	unsigned char	colormap_size;
	unsigned short	x_origin, y_origin, width, height;
	unsigned char	pixel_size, attributes;
} TargaHeader;


int Cmd_Load (char *name);
char BigBit(int value);
char LilBit(int value);
void LoadM32(char *name, byte **pixels, int *width, int *height);
int  LoadAnyImage (char *pname, unsigned int **pixels, int *width, int *height);
void *SafeMalloc(size_t n, char *desc);
void ExtractFileExtension (char *path, char *dest);

unsigned 	*longimage;
int				longimagewidth, longimageheight;
int				size = 0;

/*
=============
LoadM32
=============
*/

void LoadM32(char *name, byte **pixels, int *width, int *height)
{
    int             columns, rows, numPixels = 0;
    int             column, row, rowOffset;
    int             i;
    FILE            *fin;
	byte			*pixbuf;
	byte			*rowBuf;
    byte            *pixel_rgba;
	unsigned char	red, green, blue, alphabyte;

    // Load our file

    fin = fopen(name, "rb");
    if (!fin)
    {
        // Leave if it fucks up
        printf("Couldn't read %s", name);
        return;
    }

	for (i=0; i<516; i++)
	{
		fscanf(fin, "%c");
	}
	*width = fgetLittleShort(fin);

	for (i=0; i<62; i++)
	{
		fscanf(fin, "%c");
	}
	*height = fgetLittleShort(fin);

	for (i=0; i<386; i++)
	{
		fscanf(fin, "%c");
	}


	columns = *width;
	rows = *height;

	if(!pixels)
		return;

	numPixels = (*width)*(*height);

	pixel_rgba = SafeMalloc(numPixels * 3, "m32 pixel data");
	*pixels = pixel_rgba;



/*	if (flip)
    {
		pixbuf = pixel_rgba + ((rows - 1) * columns * 3);
		rowOffset = -columns * 3;

	}
	else
	{
		pixbuf = pixel_rgba;
		rowOffset = columns * 3;
	}*/

    pixbuf = pixel_rgba + ((rows - 1) * columns * 3);
	rowOffset = -columns * 3;

	//pixbuf = pixel_rgba;
	//rowOffset = columns * 3;

    for (row = 0; row < rows; row++)
    {
        rowBuf = pixbuf;
    	
        for(column = 0; column < columns; column++)
		{

        	blue = getc(fin);
			green = getc(fin);
			red = getc(fin);
			alphabyte = getc(fin);
			rowBuf[0] = red;
			rowBuf[1] = green;
			rowBuf[2] = blue;
//			rowBuf[3] = alphabyte;  // Need to step down from 32 bit
                                    // so ignore this line

			rowBuf += 3;
        }
		pixbuf += rowOffset;
    }

  fclose (fin);
}

/*
=============
CreateTGA
=============
*/

TargaHeader *CreateTGA(unsigned *pixels, int width, int height)
{
//	int				columns, rows;
//	byte			*pixbuf;
//	byte			*rowBuf;
	byte			*pos;
//	FILE			*fin;
	TargaHeader		*targa_header;
//	unsigned char	red, green, blue, alphabyte;
//	unsigned char	packetHeader, j;
//	int				flip;
//	int				mirror;
//	int				pixDirection;

    // Create some space in memory for our file
	size = sizeof(*targa_header) + (width*height*3);
	targa_header = (TargaHeader *)SafeMalloc(size, "TGA data");
	memset(targa_header,0,size);

    // Set a pointer to the end of the header file.
	pos = (byte *)(targa_header + 1);

    // I'm only going to export the image to one specific
    // TGA type.  If this upsets you re-write it.  This thing is 
    // open source after all. (No, I wont do it for you)

    // As it is a specific file type we can fill out the header
    // with specific static info.    

/*	targa_header->id_length = 0;  // Number of characters in description
	targa_header->colormap_type = 0; // What sort of colour map is used
	targa_header->image_type = 2; // Targa type
	
	targa_header->colormap_index = 0; // Starting colour
	targa_header->colormap_length = 0; // Number of colours
	targa_header->colormap_size = 0; // Depth of colours
	targa_header->x_origin = 0; // Location of something
	targa_header->y_origin = 0; // Location of something
	targa_header->width = width; // Width of image
	targa_header->height = height; // Height of image
	targa_header->pixel_size = 24; // Number of colours per pixel
	targa_header->attributes = 0; // Whether mirrored or flipped (etc)
*/
  sprintf (targa_header, "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
                             0,0,2,0,0,0,0,0,0,0,0,0,
                             BigBit(width),LilBit(width),
                             BigBit(height),LilBit(height),
                             24,0);

    /* sprintf (targa_header, "%c", 0);    // chars in ID field 
    sprintf (targa_header, "%c", 0);    // color map type 
    sprintf (targa_header, "%c", 2);    // image type (2=uncompressed RGB) 
    sprintf (targa_header, "%c", 0);    // colormap origin (int) 
    sprintf (targa_header, "%c", 0);    // colormap origin (int) 
    sprintf (targa_header, "%c", 0);    // num colormap entries (int) 
    sprintf (targa_header, "%c", 0);    // num colormap entries (int) 
    sprintf (targa_header, "%c", 0);    // colormap entry size (in bits) 
    sprintf (targa_header, "%c", 0);    // X origin of image (lower left corner) (int) 
    sprintf (targa_header, "%c", 0);    // X origin of image (lower left corner) (int) 
    sprintf (targa_header, "%c", 0);    // Y origin of image (lower left corner) (int) 
    sprintf (targa_header, "%c", 0);    // Y origin of image (lower left corner) (int) 
    sprintf (targa_header, "%c", BigBit(width));   // pixel width of image (int) 
    sprintf (targa_header, "%c", LilBit(width));   // pixel width of image (int) 
    sprintf (targa_header, "%c", BigBit(height));  // pixel height of image (int) 
    sprintf (targa_header, "%c", LilBit(height));  // pixel height of image (int) 
    sprintf (targa_header, "%c", 24);   // number of bits per pixel 
    sprintf (targa_header, "%c", 0);    // image descriptor */


/*    fputc(0, targa_header);  // chars in ID field 
    fputc(0, targa_header);  // color map type 
    fputc(2, targa_header);  // image type (2=uncompressed RGB) 
    fputc(0, targa_header);  // colormap origin (int) 
    fputc(0, targa_header);  // colormap origin (int) 
    fputc(0, targa_header);  // num colormap entries (int) 
    fputc(0, targa_header);  // num colormap entries (int) 
    fputc(0, targa_header); // colormap entry size (in bits) 
    fputc(0, targa_header);  // X origin of image (lower left corner) (int) 
    fputc(0, targa_header);  // X origin of image (lower left corner) (int) 
    fputc(0, targa_header);  // Y origin of image (lower left corner) (int) 
    fputc(0, targa_header);  // Y origin of image (lower left corner) (int) 
    fputc((char)(width & 0x00ff), targa_header);          // pixel width of image (int) 
    fputc((char)((height & 0xff00) >> 8), targa_header);   // pixel width of image (int) 
    fputc((char)(width & 0x00ff), targa_header);          // pixel height of image (int) 
    fputc((char)((height & 0xff00) >> 8), targa_header);   // pixel height of image (int) 
    fputc(24, targa_header);  // number of bits per pixel 
    fputc(0, targa_header);  // image descriptor */


    // Then all we need to do is bung the data from the m32 onto the end.
    // The m32 is basically TGA format with a different header and loads of
    // mipmaps stored as well, so just pasting the first mipmap works nicely :P

    // Copy the data to pos (which is located at the end of the header)
    // For info TGA images read from bottom left to top right unless 
    // specified in the flags (weird)
    memcpy (pos-2, pixels, width*height*3);

    // Now we have created our data..
    return targa_header;
}

/*
===============
Cmd_Load
===============
*/
int Cmd_Load (char *name)
{

	// load the image
	printf ("loading %s  - ", name);
	if(!LoadAnyImage (name, &longimage, &longimagewidth, &longimageheight))
	{
		printf ("Texture must be true colour\n");
		return 0;
	}



	return 1;
}

/*
==============
LoadAnyImage

Return Value:
	false: paletted texture
	true:  true color RGBA image (no palette)
==============
*/
int  LoadAnyImage (char *pname, unsigned int **pixels, int *width, int *height)
{
	char	ext[128];

	ExtractFileExtension (pname, ext);

	if(strcmp (ext, "m32") == 0)
	{
		LoadM32(pname, (byte **)pixels, width, height);
		return 1;
	}
	else
	{
		printf ("%s doesn't have a known image extension\n", pname);
	}

	return 0;
}


void *SafeMalloc(size_t n, char *desc)
{
	void *p;

	if((p = malloc(n)) == NULL)
	{
		printf("Failed to allocate %d bytes for '%s'.\n", n, desc);
	}
	memset(p, 0, n);
	return p;
}


void ExtractFileExtension (char *path, char *dest)
{
	char    *src;

	src = path + strlen(path) - 1;

//
// back up until a . or the start
//
	while (src != path && *(src-1) != '.')
		src--;
	if (src == path)
	{
		*dest = 0;	// no extension
		return;
	}

	strcpy (dest,src);
}

void SafeWrite (FILE *f, void *buffer, int count)
{
	if (fwrite (buffer, 1, count, f) != (size_t)count)
		printf ("File write failure\n");
}

FILE *SafeOpenWrite (char *filename)
{
	FILE	*f;

	f = fopen(filename, "wb");

	if (!f)
		printf ("Error opening %s: %s\n",filename,strerror(errno));

	return f;
}

int fgetLittleShort (FILE *f)
{
	byte	b1, b2;

	b1 = fgetc(f);
	b2 = fgetc(f);

	return((short)(b1 + (b2 << 8)));
}

char BigBit(int value)
{
    return ((char)(value & 0x00ff)); 
}

char LilBit(int value)
{
    return ((char)(value & 0xff00) >>8);
}


/*
==============
SaveFile
==============
*/
void    SaveFile (char *filename, void *buffer, int count)
{
	FILE	*f;

	strlwr(filename);
	f = SafeOpenWrite (filename);
	SafeWrite (f, buffer, count);
	fclose (f);
}

int main(int argc, char *argv[])
{
	char *name;
    char *newname;    
    char filename[200];
	char tempname[200];
	int  iReturn = 0;

	TargaHeader  *tgafile;

	strcpy(name, argv[1]);
	strcpy(tempname, argv[1]);

	iReturn = Cmd_Load(name);

	if (iReturn == 1)
   	{
		tgafile = CreateTGA(longimage, longimagewidth, longimageheight);
		newname = strtok(tempname, ".");
		
		strcpy (filename, newname);
		strcat(filename, ".tga");

		printf ("Writing %s... ", filename);
		SaveFile (filename, (byte *)tgafile, size);
		printf ("Done!\n");
	}
	else
	{
		printf ("Error!\n");
		return 1;
	}

    return 0;
}
