/*
 * netcode.c
 * Barry Alcock <alcockba@educk.globalnet.co.uk>
 * 18/Jul/2000
 *
 * This software is distributed under the GPL V2 and comes with no warranty what
 * so ever.
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <syslog.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "hldsfw.h"

void handle_requests (void)
{
	int sd;
	struct sockaddr_in saddr;
	struct sockaddr_in caddr;
	char *clnt_qry;

	char req[] = {
		0xFF, 0xFF, 0xFF, 0xFF,
		0x64, 0x65, 0x74, 0x61,
		0x69, 0x6C, 0x73, 0x00
	};

	if (g_debug) fprintf (stderr, "handle_requests: entered\n");

	if ( (sd = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
		if (g_debug) fprintf (stderr, "handle_requests: socket failed\n");
		if (g_syslog) syslog (LOG_ERR, "socket() failed - %s", strerror (errno));
		exit (-1);
	}

	memset (&saddr, 0, sizeof (struct sockaddr_in));
	saddr.sin_family = AF_INET;
	inet_aton ("255.255.255.255", &saddr.sin_addr);
	saddr.sin_port = htons (27015);

	if ( (bind (sd, (struct sockaddr *)&saddr, sizeof (struct sockaddr_in))) < 0) {
		if (g_debug) fprintf (stderr, "handle_requests: bind failed\n");
		if (g_syslog) syslog (LOG_ERR, "bind() failed - %s", strerror (errno));
		exit (-1);
	}

	g_started = time (NULL);
	if (g_syslog) syslog (LOG_INFO, "daemon ready");

	while (1) {
		if (get_client_bcast (sd, &clnt_qry, &caddr)) continue;
		if (memcmp (req, clnt_qry, 12)) continue;
		send_replies (sd, &caddr);
	}
}

int get_client_bcast (int sd, char **qbuff, struct sockaddr_in *caddr)
{
	static char buff[64];
	int clen;
	int qlen;

	if (g_debug) fprintf (stderr, "get_client_bcast: entered\n");

	clen = sizeof (struct sockaddr_in);
	if ( (qlen = recvfrom (sd, buff, 64, 0, caddr, &clen)) < 0) return -1;
	if (qlen != 12) return -1;

	*qbuff = buff;
	g_requests++;
	return 0;
}

int send_replies (int sd, struct sockaddr_in *caddr)
{
	struct hlds_data *c;
	int ds;

	if (g_debug) fprintf (stderr, "send_replies: entered\n");

	c = (struct hlds_data *)g_servers.next;
	do {
		ds = sendto (sd, c->hd_reply, c->hd_reply_len, 0,
			     (struct sockaddr *)caddr, sizeof (struct sockaddr_in));

		g_replies++;

		if (ds < c->hd_reply_len) {
			if (g_syslog) syslog (LOG_ERR, "invalid broadcast from %s",
					      inet_ntoa (caddr->sin_addr));
		}

		c = (struct hlds_data *)c->hd_list.next;
	} while (c != (struct hlds_data *)g_servers.next);

	return 0;
}

int dns_lookup (char *host, struct in_addr *addr)
{
	struct hostent *he;

	if (g_debug) fprintf (stderr, "dns_lookup: entered\n");

	if (inet_aton (host, addr)) {
		// already an ip address, job done
		return 0;
	} else {
		// hostname so do lookup
		if ( (he = gethostbyname (host))) {
			addr->s_addr = ( (unsigned long int *)he->h_addr_list[0])[0];
			return 0;
		}
	}

	return -1;
}

