/*
 * hldsfw.h
 * Barry Alcock <alcockba@educk.globalnet.co.uk>
 * 12/Jul/2000
 *
 * This software is distributed under the GPL V2 and comes with no warranty what
 * so ever.
 */

#ifndef HLDSFW_H
#define HLDSFW_H

#include <sys/types.h>
#include <netinet/in.h>

#define VERSION "v2.00"
#define CONFIG_FILE "/usr/local/halflife/hldsfw.conf"
#define HLDS_HOME "/usr/local/halflife"
#define LOG_DIR "/tmp/hlds"

#define TOK_IDENT 256
#define TOK_NUM 257
#define TOK_STRING 258

struct list {
	struct list *prev;
	struct list *next;
};

struct hlds_svr {
	char *hs_ident;
	char *hs_game;
	char *hs_host;
	char *hs_startmap;
	int hs_maxplayers;
	int hs_port;
};

struct hlds_data {
	struct list hd_list;	
	struct hlds_svr hd_svr;

	char *hd_reply;
	int hd_reply_len;
	struct in_addr hd_ipaddr;

	pid_t hd_pid;
	time_t hd_lastexec;
	int hd_crashes;
};

struct func_param {
	int fp_token;
	void *fp_data;
};

typedef union {
	char *string;
	int number;
} YYSTYPE;

extern YYSTYPE yylval;

int yylex (void);

#define ASSIGN_NUM_VAR(tok, var)                                \
        {                                                       \
	    if (!strcmp (id, (tok))) {                       \
                if (g_debug) fprintf (stderr, "Assigning num var %s\n", tok); \
                (var) = v;                                        \
                return 0;                                       \
            }                                                   \
        }

#define ASSIGN_STR_VAR(tok, var)                                \
        {                                                       \
	    if (!strcmp (id, (tok))) {                       \
                if (g_debug) fprintf (stderr, "Assigning str var %s\n", tok); \
                if ((var)) free ((var));                        \
                (var) = (char *)calloc (1, strlen (v) - 1);     \
                memcpy ( (var), v + 1, strlen (v) - 2);              \
                return 0;                                       \
            }                                                   \
        }

#define HANDLE_CFG_FUNC(tok, func)                            \
        {                                                     \
	    if (!strcmp (id, (tok))) {                     \
                return func();                                \
            }                                                 \
        }

/* main/misc functions */
void init_globals (void);
void sig_handler (int);

/* netcode functions */
void handle_requests (void);
int dns_lookup (char *, struct in_addr *);
int get_client_bcast (int, char **, struct sockaddr_in *);
int send_replies (int, struct sockaddr_in *);

/* config functions */
int parse_cmdline (int, char **);
int parse_config (void);
int assign_numeric (char *, int);
int assign_text (char *, char *); 
int handle_function (char *);
int collect_params (struct func_param *);
int cfg_server (void);
int add_server (struct hlds_svr *);
void remove_server (struct hlds_data *);
void free_svr_mem (struct hlds_data *);
void dump_servers (void);

/* global vars */
extern char *g_config_file;
extern int g_debug;

extern int g_syslog;

extern struct list g_servers;
extern int g_config_line;
extern int g_requests;
extern int g_replies;
extern time_t g_started;

#endif
