%{
/*
 * cfg.flex
 * Barry Alcock <alcockba@educk.globalnet.co.uk
 * 12/Jul/2000
 *
 * This software is distributed under the GPL V2 and comes with no warranty what
 * so ever.
 */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "hldsfw.h"

extern int g_debug;
extern int g_config_line;
YYSTYPE yylval;

#undef YY_INPUT
#define YY_INPUT(b,r,s)						\
	{							\
		int c = getchar ();				\
                if (c == '\n') g_config_line++;                 \
		r = ( (c == 0) ? YY_NULL : (b[0] = c, 1));	\
	}

#define YY_NO_UNPUT
%}
%option noyywrap

%s S_COMMENT

comment_l        "//"[^\n]*
comment_s        "/*"
comment_e        "*/"
space		[\ \t\r\n]+
number          [0-9]+
ident           [a-zA-Z][a-zA-Z0-9\-_]*
string          \"[^\"]*\"

%%

<INITIAL>{comment_l} {
	if (g_debug) fprintf (stderr, "Lex: 1 line comment\n%s\n", yytext);
}

<INITIAL>{comment_s} {
	if (g_debug) fprintf (stderr, "Lex: Started multi-line comment\n/*");
	BEGIN S_COMMENT;
}

<S_COMMENT>{comment_e} {
	if (g_debug) fprintf (stderr, "*/\nLex: Ended multi-line comment\n");
	BEGIN INITIAL;
}

<S_COMMENT>.|\n {
	if (g_debug) fprintf (stderr, "%c", yytext[0]);
}

<INITIAL>{space} {/* Ignore whitespace */}

<INITIAL>{ident} {
	if (g_debug) fprintf (stderr, "Lex: ident = %s\n", yytext);
	yylval.string = strdup (yytext);
	return TOK_IDENT;
}

<INITIAL>{number} {
	if (g_debug) fprintf (stderr, "Lex: number = %s\n", yytext);
	yylval.number = atol (yytext);
	return TOK_NUM;
}

<INITIAL>{string} {
	if (g_debug) fprintf (stderr, "Lex: string = %s\n", yytext);
	yylval.string = strdup (yytext);
	return TOK_STRING;
}

<INITIAL>. {
	if (g_debug) fprintf (stderr, "Lex: Unmatched char: 0x%02X, '%c'\n", yytext[0], isprint (yytext[0]) ? yytext[0] : '.');
	return yytext[0];
}

%%
