#!/usr/bin/perl
use POSIX qw(strftime);

################################################################################
# csserverstat.cgi - A server info and log parser for Half-Life Counter-Strike #
# servers (reported to work with other mods too). http://www.amateur-hour.net  #
################################################################################
# http://www.amateur-hour.net/csserverstat                                     #
################################################################################

### Stuff you can play with ###
# Default number of seconds between automatic browser refreshes.
 $defrefresh= "30";
# Minimum number of seconds between automatic browser refreshes.
 $minrefresh= "30";
# Default number of events to display.
 $defevents	= "25";
# Maximum number of events to display.
 $maxevents	= "100";
# Normal text color.
 $textcl	= "#000000";
# Reversed text color.
 $rtextcl	= "#FFFFFF";
# Normal link color.
 $linkcl	= "#004477";
# Hover link color (MSIE only).
 $hlinkcl	= "#0000FF";
# Top and bottom image/table border color.
 $bordercl	= "#606060";
# Background for page.
 $pagebg	= "#000000";
# Background for info display.
 $infobg	= "#D0D0D0";
# Background for chat messages.
 $chatbg	= "#BFD9BF";
# Background for kill messages.
 $killbg	= "#EEEED2";
# Background for server activities.
 $eventbg_s	= "#DAC4DA";
# Background for Terrorist activities.
 $eventbg_t	= "#FFC0C0";
# Background for Counter-Terrorist activities.
 $eventbg_ct= "#C1C2D7";
# TCP/IP address and port of your game server.
 $serverip	= "127.0.0.1:27015";
# URL location of this script.
 $cgiloc	= "http://www.yourwebsite.com/cgi-bin/csserverstat.cgi";
# Path to the directory where QStat is installed. Remember to use forward slashes like /, even if you are using Windows.
 $qstatpath	= "/usr/local/bin";
# Path to your server log file, the one written by cslog.pl.
 $logdir	= "/usr/local/games/hlds_l";
# Name of your logfile, the one written by cslog.pl.
 $logfile	= "127.0.0.1";
# Path to your image directory. Remember to use forward slashes like /, even if you are using Windows.
 $imagepath	= "/home/httpd/html/images";
# URL to your image directory.
 $imageurl	= "/images";

# This doesn't work under Windows but is fine for Linux. The formatting is nice.
 $now = strftime "%A, %B %e, %Y at %r (%Z)", localtime;
# This works fine under Windows but isn't as pretty. If you are using Windows, commount out the line above and uncomment the line below. FYI, # indicates a comment in case you hadn't already figured that out. I should probably fix this.
# $now = localtime;

# Set to "1" if you want to see the raw log messages.
# WARNING! Will also show team chat messages. It's also ugly as hell.
 $debug      = "0";

### Stuff that shouldn't be played with ###
# Grab any parameters that were entered into the URL.
$ENV{'REQUEST_METHOD'} =~ tr/a-z/A-Z/;
if ($ENV{'REQUEST_METHOD'} eq "POST") {
 read(STDIN, $in, $ENV{'CONTENT_LENGTH'});
 } else {
 $in = $ENV{'QUERY_STRING'};
}

# Set variables according to URL parameters, if any.
@pairs = split(/&/, $in);
foreach my $pair (@pairs) {
 ($setting, $value) = split(/=/, $pair);
 $value =~ tr/+/ /;
 $value =~ s/%(..)/pack("C", hex($1))/eg;
 if ($setting eq "events") { $numevents = $value; }
 if ($setting eq "refresh") { $refresh = $value; }
}

# Zero player and rule line counters.
$count1 = 0; $count2 = 0;

# Grab the log file, grep it for interesting stuff, and cram it into an array.
open(LOGFILE,"$logdir/$logfile");
@logdata = grep (//|/" killed "/|/touched a hostage/|/rescued a hostage/|/planted the bomb/|/defused the bomb/|/Target successfully bombed!/|/Bomb successfully defused!/|/VIP has escaped/|/VIP has been assassinated/|/connected/|/WIN/,<LOGFILE>);
close(LOGFILE);

# Don't go outside our allowable range for refresh and event display.
if ($refresh < $minrefresh) { $refresh = $minrefresh; }
else { $refresh = $defrefresh unless $refresh; }
if ($numevents > $maxevents) { $numevents = $maxevents; }
else { $numevents = $defevents unless $numevents; }

# Grab general server, player, and rule information from QStat.
$qstat = `$qstatpath/qstat -R -P -tc -raw , -hls $serverip`;
@qstatlines = split(/\n/, $qstat); $serverinfo = shift(@qstatlines); $ruleslist = shift(@qstatlines); @playerlines = (@qstatlines); ($type,$ip,$servername,$map,$maxplayers,$curplayers,$ping,$timeout) = split(/,/,$serverinfo);
$servername = "Unable to contact server! Check \$qstatpath." unless $servername;
if (!-f "$imagepath\/$map.jpg") { $mapimage = "default.jpg"; } else { $mapimage = "$map.jpg"; }

# Start spitting out some HTML.
print <<EOF;
Content-type: text/html

<html>
<head>
<title>Half-Life Counter-Strike Server Live Status</title>
<meta http-equiv="refresh" content="$refresh">
<meta http-equiv="pragma" content="no-cache">
</head>
<style>
BODY { background-color: $pagebg; padding: 0 0 0 0; margin: 5 5 5 5 }
A:link,A:visited { text-decoration: none; color: $linkcl }
A:hover { text-decoration: none; color: $hlinkcl }
IMG.map {border-style: solid none solid none; border-width: 3; border-color: $bordercl }

</style>

<body text="$textcl">
<font face="Verdana,Arial,Helvetica" size="2">

<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr><td align="right" nowrap><font size="5" color="$rtextcl"><b>$servername</b></font><br><font size="1" color="$rtextcl">Page generated on <font color="#C1C2D7">$now</font><br>There are <font color="#C1C2D7">$curplayers</font> out of <font color="#C1C2D7">$maxplayers</font> players active on map <font color="#C1C2D7">$map</font><br>Displaying the last <font color="#C1C2D7">$numevents</font> events every <font color="#C1C2D7">$refresh</font> seconds</font></td></tr>
</table>

<br>

<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr><td align="center" valign="middle" width="100%"><img class="map" src="$imageurl/$mapimage" width="212" height="160" alt="Current map is $map."><br><font size="1" color="$rtextcl">$map</font></td>
<td width="5"><img src="$imageurl/trans.gif" width="5"></td>
<td align="right" valign="top">
<table border="0" cellspacing="0" cellpadding="0">
<tr><td><font size="1" color="$rtextcl"><b>&nbsp;Player</b></font></td><td align="right"><font size="1" color="$rtextcl"><b>&nbsp;Kills&nbsp;</b></font></td><td align="right"><font size="1" color="$rtextcl"><b>Time&nbsp;</b></font></td></tr>
<tr><td bgcolor="$bordercl" colspan="3"><img src="$imageurl/trans.gif" height="3"></td></tr>
EOF

# Print the player list.
while ($_ = shift @playerlines) {
 $count1 = $count1 + 1;
 ($playername,$frags,$timeonserver) = split(/,/);
 print "<tr><td bgcolor=\"$infobg\" nowrap><font size=\"1\">&nbsp;$playername</font></td><td bgcolor=\"$infobg\" align=\"right\"><font size=\"1\">&nbsp;$frags&nbsp;</font></td><td bgcolor=\"$infobg\" align=\"right\" nowrap><font size=\"1\">$timeonserver&nbsp;</font></td></tr>\n";
}
# Create blank lines up to the server's maxplayer setting.
while ($count1 < $maxplayers) {
 $count1 = $count1 + 1;
 print "<tr><td bgcolor=\"$infobg\" colspan=\"3\"><font size=\"1\">&nbsp;</td></tr>\n";
}

print <<EOF;
<tr><td bgcolor="$bordercl" colspan="3"><img src="$imageurl/trans.gif" height="3"></td></tr>
</table>
</td><td width="5"><img src="$imageurl/trans.gif" width="5"></td><td align="right" valign="top" width="50%">
<table border="0" cellspacing="0" cellpadding="0">
<tr><td><font size="1" color="$rtextcl"><b>&nbsp;Setting</b></font></td><td align="right"><font size="1" color="$rtextcl"><b>&nbsp;Value</b></font></td></tr>
<tr><td bgcolor="$bordercl" colspan="2"><img src="$imageurl/trans.gif" height="3"></td></tr>
EOF

# Print the rules list.
foreach (split /,/, $ruleslist) {
 ($rule,$value) = split(/=/);
 if ($value eq 0) { $value = "<font color=\"#CC0000\">off</font>"; }
 elsif ($value eq 1) { $value = "<font color=\"#008800\">on</font>"; }
 if ($rule eq "sv_contact") { $value = "<a href=\"mailto:$value\">$value</a>"; }
 if ($rule eq "mp_mapvoteratio") { $value = $value*100; $value = "$value%"; }
 if (/mp_mapvoteratio/ or /mp_forcechasecam/ or /mp_tkpunish/ or /mp_autoteambalance/ or /mp_limitteams/ or /mp_autokick/ or /mp_c4timer/ or /mp_freezetime/ or /mp_roundtime/ or /mp_flashlight/ or /mp_friendlyfire/ or /mp_timelimit/ or /sv_maxrate/ or /sv_minrate/ or /sv_cheats/ or /sv_aim/ or /mp_hostagepenalty/ or /mp_footsteps/ or /gamename/ or /sv_contact/) {
  $count2 = $count2 + 1; 
  print "<tr><td bgcolor=\"$infobg\"><font size=\"1\">&nbsp;$rule</font></td><td bgcolor=\"$infobg\" align=\"right\" nowrap><font size=\"1\">$value&nbsp;</font></td></tr>\n";
 }
}
# Make the rules list at least as big as the player list if it isn't already. Totally unnecessary, really, but looks kind of nice.
while ($count2 < $count1) {
 $count2 = $count2 + 1;
 print "<tr><td bgcolor=\"$infobg\" colspan=\"3\"><font size=\"1\">&nbsp;</td></tr>\n";
}

print <<EOF;
<tr><td bgcolor="$bordercl" colspan="2"><img src="$imageurl/trans.gif" height="3"></td></tr>
</table>
</td></tr>
</table>

<p>

<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr><td width="16"><img src="$imageurl/trans.gif" width="16" height="16"></td><td width="25%"><font size="1" color="$rtextcl"><b>&nbsp;Player</b></font></td><td><font size="1" color="$rtextcl">&nbsp;<b>Event</b></font></td><td align="right"><font size="1" color="$rtextcl"><b>Number of lines to display:</b> <a href="$cgiloc?refresh=$refresh&events=5"><font color="#C1C2D7">5</font></a> <b>|</b> <a href="$cgiloc?refresh=$refresh&events=10"><font color="#C1C2D7">10</font></a> <b>|</b> <a href="$cgiloc?refresh=$refresh&events=25"><font color="#C1C2D7">25</font></a> <b>|</b> <a href="$cgiloc?refresh=$refresh&events=50"><font color="#C1C2D7">50</font></a> <b>|</b> <a href="$cgiloc?refresh=$refresh&events=75"><font color="#C1C2D7">75</font></a> <b>|</b> <a href="$cgiloc?refresh=$refresh&events=100"><font color="#C1C2D7">100</font></a></tr>
<tr><td bgcolor="$bordercl" colspan="4"><img src="$imageurl/trans.gif" height="3"></td></tr>
</table>
<table border="0" cellspacing="0" cellpadding="1" width="100%">
EOF

# Begin the logfile output section.
# Grab the last x events according to what $numevents is set to.
while ($popcount < $numevents) { $popcount = $popcount + 1; $tmp = pop @logdata; push @tmp,$tmp; }
@logdata = reverse (@tmp);

foreach $_ (@logdata) {
 $rawevent = ($_);
# Print player chat messages.
 if (//) {
  ($garbage,$_) = split(//);
  ($player,$message) = split(/ : /);
  print "<tr><td width=\"16\" bgcolor=\"$chatbg\"><img src=\"$imageurl/chat.gif\" width=\"16\" height=\"16\" alt=\"Message from $player\"></td>";
  if (/\(Terrorist\)/ or /\(CT\)/ or /\(Counter-Terrorist\)/) {
   $player = "<font color=\"#606060\">$player</font>";
   $message = "<font color=\"#606060\" size=\"1\">Team messages are not displayed</font>";
  }
  elsif (/\*DEAD\*/) { $player = "<font color=\"#606060\">$player</font>"; }
  print "<td width=\"25%\" bgcolor=\"$chatbg\" valign=\"top\" nowrap><font size=\"1\">$player&nbsp;&nbsp;</font></td>";
  print "<td width=\"75%\" bgcolor=\"$chatbg\" width=\"100%\"><font size=\"2\">$message</font></td></tr>\n";
 }
# Print kill messages.
 if (/\" killed \"/) {
  ($garbage,$_) = split(/L.*: \"/);
  ($killer,$_) = split(/\<.*\>\" killed \".*[]] /);
  ($killed,$weapon) = split(/\<.*\>\" with /);
  print "<tr><td width=\"16\" bgcolor=\"$killbg\"><img src=\"$imageurl/kill.gif\" width=\"16\" height=\"16\" alt=\"$killer killed $killed\"></td>";
  print "<td width=\"25%\" bgcolor=\"$killbg\" nowrap><font size=\"1\">$killer&nbsp;&nbsp;</font></td>";
  print "<td width=\"75%\" bgcolor=\"$killbg\"><font size=\"2\">killed $killed with $weapon</font></td></tr>\n";
 }
# Print hostage touch messages.
 if (/touched a hostage/) {
  ($garbage,$_) = split(/L.*: /);
  ($groper) = split(/ touched/);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_ct\"><img src=\"$imageurl/hostage.gif\" width=\"16\" height=\"16\" alt=\"$groper touched a hostage\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_ct\" nowrap><font size=\"1\">$groper</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_ct\"><font size=\"2\">Touched a hostage</font></td></tr>\n";
 }
# Print hostage rescue messages.
 if (/rescued a hostage/) {
  ($garbage,$_) = split(/L.*: /);
  ($rescuer) = split(/ has rescued/);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_ct\"><img src=\"$imageurl/hostage.gif\" width=\"16\" height=\"16\" alt=\"$rescuer rescued a hostage\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_ct\" nowrap><font size=\"1\">$rescuer</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_ct\"><font size=\"2\">Rescued a hostage</font></td></tr>\n";
 }
# Print bomb plant messages.
 if (/planted the bomb/) {
  ($garbage,$_) = split(/L.*: /);
  ($planter) = split(/ planted/);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_t\"><img src=\"$imageurl/bomb.gif\" width=\"16\" height=\"16\" alt=\"$planter planted the bomb\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_t\" nowrap><font size=\"1\">$planter</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_t\"><font size=\"2\">Planted the bomb</font></td></tr>\n";
 }
# Print bomb defuse messages.
 if (/defused the bomb/) {
  ($garbage,$_) = split(/L.*: /);
  ($defuser) = split(/ has defused/);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_ct\"><img src=\"$imageurl/bomb.gif\" width=\"16\" height=\"16\" alt=\"$defuser defused the bomb\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_ct\" nowrap><font size=\"1\">$defuser</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_ct\"><font size=\"2\">Defused the bomb</font></td></tr>\n";
 }
# Print target successfully bombed messages.
 if (/Target successfully bombed!/) {
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_t\"><img src=\"$imageurl/bomb.gif\" width=\"16\" height=\"16\" alt=\"Target successfully bombed\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_t\"><font size=\"1\">&nbsp;</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_t\"><font size=\"2\">Target successfully bombed</font></td></tr>\n";
 }
# Print bomb sucessfully defused messages.
 if (/Bomb successfully defused!/) {
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_ct\"><img src=\"$imageurl/bomb.gif\" width=\"16\" height=\"16\" alt=\"Bomb successfully defused\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_ct\"><font size=\"1\">&nbsp;</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_ct\"><font size=\"2\">Bomb successfully defused</font></td></tr>\n";
 }
# Print VIP escape messages.
 if (/VIP has escaped!/) {
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_ct\"><img src=\"$imageurl/vip.gif\" width=\"16\" height=\"16\" alt=\"VIP Escaped\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_ct\"><font size=\"1\">VIP</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_ct\"><font size=\"2\">VIP escaped</font></td></tr>\n";
 }
# Print VIP assassination messages.
 if (/VIP has been assassinated/) {
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_t\"><img src=\"$imageurl/vip.gif\" width=\"16\" height=\"16\" alt=\"VIP Assassinated\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_t\"><font size=\"1\">VIP</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_t\"><font size=\"2\">VIP assassinated</font></td></tr>\n";
 }
# Print player connect messages.
 if (/ connected/) {
  ($garbage,$_) = split(/L.*: \"/);
  ($player,$_) = split(/\</);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_s\"><img src=\"$imageurl/conn.gif\" width=\"16\" height=\"16\" alt=\"$player connected\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_s\"><font size=\"1\">$player</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_s\"><font size=\"2\">connect</font></td></tr>\n";
 }
# Print player disconnect messages.
 if (/ disconnected/) {
  ($garbage,$_) = split(/L.*: \"/);
  ($player,$_) = split(/\</);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_s\"><img src=\"$imageurl/disconn.gif\" width=\"16\" height=\"16\" alt=\"$player disconnected\"></td>";
  print "<td width=\"25%\" bgcolor=\"$eventbg_s\"><font size=\"1\">$player</font></td>";
  print "<td width=\"75%\" bgcolor=\"$eventbg_s\"><font size=\"2\">disconnect</font></tr>\n";
 }
# Print CT wins.
 if (/Counter-Terrorists WIN/) {
  ($garbage,$_) = split(/L.*: \"/);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_ct\"><img src=\"$imageurl/trans.gif\" width=\"16\" height=\"16\" alt=\"Counter-Terrorists Win\"></td>";
  print "<td width=\"100%\" bgcolor=\"$eventbg_ct\" colspan=\"2\"><font size=\"1\"><b>Counter-Terrorists Win</b></font></tr>\n";
 }
# Print Terrorist wins.
 if (/Terrorists WIN/) {
  ($garbage,$_) = split(/L.*: \"/);
  print "<tr><td width=\"16\" bgcolor=\"$eventbg_t\"><img src=\"$imageurl/trans.gif\" width=\"16\" height=\"16\" alt=\"Terrorists Win\"></td>";
  print "<td width=\"100%\" bgcolor=\"$eventbg_t\" colspan=\"3\"><font size=\"1\"><b>Terrorists Win</b></font></tr>\n";
 }
# If debug is on, print the raw log file message.
 if ($debug == 1) {
  print "<tr><td colspan=\"3\" bgcolor=\"#00CCCC\"><font size=\"1\">$rawevent</font></td></tr>";
 }
}
#}

print <<EOF;
</table>

<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr><td bgcolor="$bordercl" width="100%"><img src="$imageurl/trans.gif" height="3"></td></tr>
</table>

<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr><td bgcolor="$pagebg" colspan="3" align="right"><font size="1" color="$rtextcl">generated by <a href="http://www.amateur-hour.net/csserverstat"><font color="#C1C2D7">csserverstat</font></a></font></td></tr>
</table>

</font>
</body>
</html>
EOF

exit;
