#!/usr/bin/perl
use IO::Socket;

################################################################################
# cslog.pl - A Half-Life remote logging tool that works in conjunction with    #
# Half-Life server "logaddress" command.                                       #
################################################################################
# http://www.amateur-hour.net/csserverstat                                     #
################################################################################

# Put the game server's IP below. Do not put the port number, just the IP address.
$remote_address = "127.0.0.1";
# Put the UDP port you want cslog.pl to listen on below.
$local_port = 2000;
# Put the directory you want the log file written to below. Remember to use forward slashes like /, even if you are using Windows.
$logpath = "/usr/local/games/hlds_l";

# Don't modify anything below this line. Or if you do, don't come crying to me if it doesn't work. Of course, if it does work and it's cool, please let me know.
$MAXLEN=1024;
$sock_log = IO::Socket::INET->new(Proto=>"udp", PeerAddr=>$remote_address, LocalPort=>$local_port, Type=>SOCK_DGRAM) or die "Can't open socket for incoming data...\n" or die "socket: $@" ;

while ($sock_log->recv($msgIn,$MAXLEN)){
	$msgIn =~ s/\000//i;
	open(OUTF,">>$logpath/$remote_address");
	print OUTF substr($msgIn,index($msgIn,"L"));
	close(OUTF);}
close $sock_log;
